/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import ivorius.ivtoolkit.math.IvBytePacker;
import ivorius.ivtoolkit.tools.MCRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.potion.PotionEffect;

public class IvNBTHelper {
    public static byte readByte(NBTTagCompound compound, String key, byte defaultValue) {
        return compound != null && compound.func_150297_b(key, 1) ? compound.func_74771_c(key) : defaultValue;
    }

    public static byte[] readByteArray(NBTTagCompound compound, String key, byte[] defaultValue) {
        return compound != null && compound.func_150297_b(key, 7) ? compound.func_74770_j(key) : defaultValue;
    }

    public static double readDouble(NBTTagCompound compound, String key, double defaultValue) {
        return compound != null && compound.func_150297_b(key, 6) ? compound.func_74769_h(key) : defaultValue;
    }

    public static float readFloat(NBTTagCompound compound, String key, float defaultValue) {
        return compound != null && compound.func_150297_b(key, 5) ? compound.func_74760_g(key) : defaultValue;
    }

    public static int readInt(NBTTagCompound compound, String key, int defaultValue) {
        return compound != null && compound.func_150297_b(key, 3) ? compound.func_74762_e(key) : defaultValue;
    }

    public static int[] readIntArray(NBTTagCompound compound, String key, int[] defaultValue) {
        return compound != null && compound.func_150297_b(key, 11) ? compound.func_74759_k(key) : defaultValue;
    }

    public static long readLong(NBTTagCompound compound, String key, long defaultValue) {
        return compound != null && compound.func_150297_b(key, 4) ? compound.func_74763_f(key) : defaultValue;
    }

    public static short readShort(NBTTagCompound compound, String key, short defaultValue) {
        return compound != null && compound.func_150297_b(key, 2) ? compound.func_74765_d(key) : defaultValue;
    }

    public static String readString(NBTTagCompound compound, String key, String defaultValue) {
        return compound != null && compound.func_150297_b(key, 8) ? compound.func_74779_i(key) : defaultValue;
    }

    public static double[] readDoubleArray(String key, NBTTagCompound compound) {
        if (compound.func_74764_b(key)) {
            NBTTagList list = compound.func_150295_c(key, 6);
            double[] array = new double[list.func_74745_c()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = list.func_150309_d(i);
            }
            return array;
        }
        return null;
    }

    public static void writeDoubleArray(String key, double[] array, NBTTagCompound compound) {
        if (array != null) {
            NBTTagList list = new NBTTagList();
            for (double d : array) {
                list.func_74742_a((NBTBase)new NBTTagDouble(d));
            }
            compound.func_74782_a(key, (NBTBase)list);
        }
    }

    public static String[] readNBTStrings(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 8);
            String[] strings = new String[nbtTagList.func_74745_c()];
            for (int i = 0; i < strings.length; ++i) {
                strings[i] = nbtTagList.func_150307_f(i);
            }
            return strings;
        }
        return null;
    }

    public static void writeNBTStrings(String id, String[] strings, NBTTagCompound compound) {
        if (strings != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (String s : strings) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagString(s));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static ItemStack[] readNBTStacks(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 10);
            ItemStack[] itemStacks = new ItemStack[nbtTagList.func_74745_c()];
            for (int i = 0; i < itemStacks.length; ++i) {
                itemStacks[i] = ItemStack.func_77949_a((NBTTagCompound)nbtTagList.func_150305_b(i));
            }
            return itemStacks;
        }
        return null;
    }

    public static void writeNBTStacks(String id, ItemStack[] stacks, NBTTagCompound compound) {
        if (stacks != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (ItemStack stack : stacks) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                stack.func_77955_b(tagCompound);
                nbtTagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static Block[] readNBTBlocks(String id, NBTTagCompound compound, MCRegistry registry) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 8);
            Block[] blocks = new Block[nbtTagList.func_74745_c()];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = registry.blockFromID(nbtTagList.func_150307_f(i));
            }
            return blocks;
        }
        return null;
    }

    public static void writeNBTBlocks(String id, Block[] blocks, NBTTagCompound compound) {
        if (blocks != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (Block b : blocks) {
                nbtTagList.func_74742_a((NBTBase)new NBTTagString(Block.field_149771_c.func_148750_c((Object)b)));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static long[] readNBTLongs(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            ByteBuf bytes = Unpooled.copiedBuffer((byte[])compound.func_74770_j(id));
            long[] longs = new long[bytes.capacity() / 8];
            for (int i = 0; i < longs.length; ++i) {
                longs[i] = bytes.readLong();
            }
            return longs;
        }
        return null;
    }

    public static void writeNBTLongs(String id, long[] longs, NBTTagCompound compound) {
        if (longs != null) {
            ByteBuf bytes = Unpooled.buffer((int)(longs.length * 8));
            for (long aLong : longs) {
                bytes.writeLong(aLong);
            }
            compound.func_74773_a(id, bytes.array());
        }
    }

    public static PotionEffect[] readNBTPotions(String id, NBTTagCompound compound) {
        if (compound.func_74764_b(id)) {
            NBTTagList nbtTagList = compound.func_150295_c(id, 8);
            PotionEffect[] potions = new PotionEffect[nbtTagList.func_74745_c()];
            for (int i = 0; i < potions.length; ++i) {
                potions[i] = PotionEffect.func_82722_b((NBTTagCompound)nbtTagList.func_150305_b(i));
            }
            return potions;
        }
        return null;
    }

    public static void writeNBTPotions(String id, PotionEffect[] potions, NBTTagCompound compound) {
        if (potions != null) {
            NBTTagList nbtTagList = new NBTTagList();
            for (PotionEffect p : potions) {
                nbtTagList.func_74742_a((NBTBase)p.func_82719_a(new NBTTagCompound()));
            }
            compound.func_74782_a(id, (NBTBase)nbtTagList);
        }
    }

    public static int[] readIntArrayFixedSize(String id, int length, NBTTagCompound compound) {
        int[] array = compound.func_74759_k(id);
        return array.length != length ? new int[length] : array;
    }

    public static void writeCompressed(String idBase, int[] intArray, int maxValueInArray, NBTTagCompound compound) {
        byte bitLength = IvBytePacker.getRequiredBitLength(maxValueInArray);
        byte[] bytes = IvBytePacker.packValues(intArray, bitLength);
        compound.func_74773_a(idBase + "_bytes", bytes);
        compound.func_74774_a(idBase + "_bitLength", bitLength);
        compound.func_74768_a(idBase + "_length", intArray.length);
    }

    public static int[] readCompressed(String idBase, NBTTagCompound compound) {
        byte[] bytes = compound.func_74770_j(idBase + "_bytes");
        byte bitLength = compound.func_74771_c(idBase + "_bitLength");
        int intArrayLength = compound.func_74762_e(idBase + "_length");
        return IvBytePacker.unpackValues(bytes, bitLength, intArrayLength);
    }
}

