/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import ivorius.ivtoolkit.tools.Ranges;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;

public class NBTTagLists {
    public static List<NBTTagCompound> compoundsFrom(NBTTagCompound compound, String key) {
        return NBTTagLists.compounds(compound.func_150295_c(key, 10));
    }

    public static List<NBTTagCompound> compounds(NBTTagList list) {
        return Lists.transform(Ranges.rangeList(0, list.func_74745_c()), input -> list.func_150305_b(input.intValue()));
    }

    public static void writeCompoundsTo(NBTTagCompound compound, String key, List<NBTTagCompound> list) {
        compound.func_74782_a(key, (NBTBase)NBTTagLists.writeCompounds(list));
    }

    public static NBTTagList writeCompounds(List<NBTTagCompound> list) {
        NBTTagList tagList = new NBTTagList();
        list.forEach(arg_0 -> ((NBTTagList)tagList).func_74742_a(arg_0));
        return tagList;
    }

    public static List<int[]> intArraysFrom(NBTTagCompound compound, String key) {
        return NBTTagLists.intArrays(compound.func_150295_c(key, 11));
    }

    public static List<int[]> intArrays(NBTTagList list) {
        return Lists.transform(Ranges.rangeList(0, list.func_74745_c()), input -> list.func_150306_c(input.intValue()));
    }

    public static void writeIntArraysTo(NBTTagCompound compound, String key, List<int[]> list) {
        compound.func_74782_a(key, (NBTBase)NBTTagLists.writeIntArrays(list));
    }

    public static NBTTagList writeIntArrays(List<int[]> list) {
        NBTTagList tagList = new NBTTagList();
        for (int[] array : list) {
            tagList.func_74742_a((NBTBase)new NBTTagIntArray(array));
        }
        return tagList;
    }

    public static List<NBTBase> nbtBases(NBTTagList nbt) {
        ImmutableList.Builder list = new ImmutableList.Builder();
        NBTTagList copy = (NBTTagList)nbt.func_74737_b();
        while (copy.func_74745_c() > 0) {
            list.add((Object)copy.func_74744_a(0));
        }
        return list.build();
    }

    public static List<NBTTagList> listsFrom(NBTTagCompound compound, String key) {
        return NBTTagLists.lists(compound.func_150295_c(key, 9));
    }

    public static List<NBTTagList> lists(NBTTagList nbt) {
        if (nbt.func_150303_d() != 9) {
            throw new IllegalArgumentException();
        }
        ImmutableList.Builder list = new ImmutableList.Builder();
        NBTTagList copy = (NBTTagList)nbt.func_74737_b();
        while (copy.func_74745_c() > 0) {
            list.add((Object)((NBTTagList)copy.func_74744_a(0)));
        }
        return list.build();
    }

    public static void writeTo(NBTTagCompound compound, String key, List<NBTTagList> lists) {
        compound.func_74782_a(key, (NBTBase)NBTTagLists.write(lists));
    }

    public static NBTTagList write(List<NBTTagList> lists) {
        NBTTagList list = new NBTTagList();
        lists.forEach(arg_0 -> ((NBTTagList)list).func_74742_a(arg_0));
        return list;
    }
}

