/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import mrtjp.projectred.core.libmc.OpenGLLib;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Mouse;

public class DirectionalRayTracer {
    private final double negX;
    private final double negY;
    private final double negZ;
    private final double posX;
    private final double posY;
    private final double posZ;

    public DirectionalRayTracer(double negX, double negY, double negZ, double posX, double posY, double posZ) {
        this.negX = negX;
        this.negY = negY;
        this.negZ = negZ;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public DirectionalRayTracer(double halfSize) {
        this.negY = this.negZ = -halfSize;
        this.negX = this.negZ;
        this.posY = this.posZ = halfSize;
        this.posX = this.posZ;
    }

    private static Vec3 getMouseVector(float z) {
        return OpenGLLib.unproject(Mouse.getX(), Mouse.getY(), z);
    }

    private Vec3 calculateXPoint(Vec3 near, Vec3 diff, double x) {
        double p = (x - near.field_72450_a) / diff.field_72450_a;
        double y = near.field_72448_b + diff.field_72448_b * p;
        double z = near.field_72449_c + diff.field_72449_c * p;
        if (this.negY <= y && y <= this.posY && this.negZ <= z && z <= this.posZ) {
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    private Vec3 calculateYPoint(Vec3 near, Vec3 diff, double y) {
        double p = (y - near.field_72448_b) / diff.field_72448_b;
        double x = near.field_72450_a + diff.field_72450_a * p;
        double z = near.field_72449_c + diff.field_72449_c * p;
        if (this.negX <= x && x <= this.posX && this.negZ <= z && z <= this.posZ) {
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    private Vec3 calculateZPoint(Vec3 near, Vec3 diff, double z) {
        double p = (z - near.field_72449_c) / diff.field_72449_c;
        double x = near.field_72450_a + diff.field_72450_a * p;
        double y = near.field_72448_b + diff.field_72448_b * p;
        if (this.negX <= x && x <= this.posX && this.negY <= y && y <= this.posY) {
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    private static void addPoint(Map<ForgeDirection, Vec3> map, ForgeDirection side, Vec3 value) {
        if (value != null) {
            map.put(side, value);
        }
    }

    private Map<ForgeDirection, Vec3> calculateHitPoints(Vec3 near, Vec3 far) {
        Vec3 diff = far.func_72444_a(near);
        EnumMap result = Maps.newEnumMap(ForgeDirection.class);
        DirectionalRayTracer.addPoint(result, ForgeDirection.WEST, this.calculateXPoint(near, diff, this.negX));
        DirectionalRayTracer.addPoint(result, ForgeDirection.EAST, this.calculateXPoint(near, diff, this.posX));
        DirectionalRayTracer.addPoint(result, ForgeDirection.DOWN, this.calculateYPoint(near, diff, this.negY));
        DirectionalRayTracer.addPoint(result, ForgeDirection.UP, this.calculateYPoint(near, diff, this.posY));
        DirectionalRayTracer.addPoint(result, ForgeDirection.NORTH, this.calculateZPoint(near, diff, this.negZ));
        DirectionalRayTracer.addPoint(result, ForgeDirection.SOUTH, this.calculateZPoint(near, diff, this.posZ));
        return result;
    }

    public Map<ForgeDirection, Vec3> calculateMouseHits() {
        OpenGLLib.updateMatrices();
        Vec3 near = DirectionalRayTracer.getMouseVector(0.0f);
        Vec3 far = DirectionalRayTracer.getMouseVector(1.0f);
        return this.calculateHitPoints(near, far);
    }

    public HitCoord getNearestHit() {
        OpenGLLib.updateMatrices();
        Vec3 near = DirectionalRayTracer.getMouseVector(0.0f);
        Vec3 far = DirectionalRayTracer.getMouseVector(1.0f);
        Map<ForgeDirection, Vec3> hits = this.calculateHitPoints(near, far);
        if (hits.isEmpty()) {
            return null;
        }
        ForgeDirection minForgeDirection = null;
        double minDist = Double.MAX_VALUE;
        for (Map.Entry<ForgeDirection, Vec3> e : hits.entrySet()) {
            double dist = e.getValue().func_72444_a(near).func_72433_c();
            if (!(dist < minDist)) continue;
            minDist = dist;
            minForgeDirection = e.getKey();
        }
        if (minForgeDirection == null) {
            return null;
        }
        return new HitCoord(minForgeDirection, hits.get(minForgeDirection));
    }

    public static class HitCoord {
        public final ForgeDirection side;
        public final Vec3 coord;

        public HitCoord(ForgeDirection side, Vec3 coord) {
            this.side = side;
            this.coord = coord;
        }
    }
}

