/*
 * Decompiled with CFR 0.152.
 */
package panda.endblocks.init;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import panda.endblocks.blocks.BlockDoubleEndSlab;
import panda.endblocks.blocks.BlockEndSlab;
import panda.endblocks.blocks.BlockEndStairs;
import panda.endblocks.blocks.BlockHalfEndSlab;

public abstract class EndBlocks {
    public static Block End_Bricks_Chorus;
    public static Block End_Stone_Smooth;
    public static Block End_Bricks_Carved;
    public static Block End_Stone_Carved;
    public static Block End_Bricks_Cracked;
    public static Block Purpur_Smooth;
    public static Block Purpur_Tiles;
    public static Block Purpur_Carved;
    public static Block Purpur_Cobble;
    public static Block Purpur_Prismatic;
    protected static BlockSlab End_Bricks_Slab;
    protected static BlockSlab Double_End_Bricks_Slab;
    protected static BlockSlab Smooth_End_Stone_Slab;
    protected static BlockSlab Double_Smooth_End_Stone_Slab;
    protected static Block End_Bricks_Stairs;
    protected static Block Smooth_End_Stone_Stairs;
    private static boolean initDone;
    private static Map<Block, String> allBlocks;
    private static final Map<String, Block> blockRegistry;

    public static Block getBlockByName(String name) {
        return blockRegistry.get(name);
    }

    public static String getNameOfItem(Block b) {
        return allBlocks.get(b);
    }

    public static void init() {
        if (initDone) {
            return;
        }
        End_Bricks_Chorus = new Block(Material.field_151576_e).func_149711_c(0.8f);
        EndBlocks.addBlock(End_Bricks_Chorus, "end_brick_chorus");
        End_Stone_Smooth = new Block(Material.field_151576_e).func_149711_c(0.8f);
        EndBlocks.addBlock(End_Stone_Smooth, "smooth_end_stone");
        End_Bricks_Carved = new Block(Material.field_151576_e).func_149711_c(0.8f);
        EndBlocks.addBlock(End_Bricks_Carved, "end_brick_carved");
        End_Stone_Carved = new Block(Material.field_151576_e).func_149711_c(0.8f);
        EndBlocks.addBlock(End_Stone_Carved, "end_stone_carved");
        End_Bricks_Cracked = new Block(Material.field_151576_e).func_149711_c(0.8f);
        EndBlocks.addBlock(End_Bricks_Cracked, "end_brick_cracked");
        Purpur_Smooth = new Block(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f);
        EndBlocks.addBlock(Purpur_Smooth, "purpur_smooth");
        Purpur_Tiles = new Block(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f);
        EndBlocks.addBlock(Purpur_Tiles, "purpur_tiles");
        Purpur_Carved = new Block(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f);
        EndBlocks.addBlock(Purpur_Carved, "purpur_carved");
        Purpur_Cobble = new Block(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f);
        EndBlocks.addBlock(Purpur_Cobble, "purpur_cobble");
        Purpur_Prismatic = new Block(Material.field_151576_e).func_149711_c(1.5f).func_149752_b(10.0f);
        EndBlocks.addBlock(Purpur_Prismatic, "purpur_prismatic");
        End_Bricks_Slab = EndBlocks.createSlab("end_brick");
        Double_End_Bricks_Slab = EndBlocks.createDoubleSlab("double_end_brick");
        Smooth_End_Stone_Slab = EndBlocks.createSlab("smooth_end_stone");
        Double_Smooth_End_Stone_Slab = EndBlocks.createDoubleSlab("double_smooth_end_stone");
        End_Bricks_Stairs = EndBlocks.createStairs(Blocks.field_185772_cY, "end_brick");
        Smooth_End_Stone_Stairs = EndBlocks.createStairs(End_Stone_Smooth, "smooth_end_stone");
        initDone = true;
    }

    private static Block addBlock(Block block, String name) {
        block.setRegistryName(name);
        block.func_149663_c(block.getRegistryName().func_110624_b() + "." + name);
        GameRegistry.register((IForgeRegistryEntry)block);
        blockRegistry.put(name, block);
        allBlocks.put(block, name);
        if (!(block instanceof BlockEndSlab)) {
            ItemBlock itemBlock = new ItemBlock(block);
            itemBlock.setRegistryName(name);
            itemBlock.func_77655_b(block.getRegistryName().func_110624_b() + "." + name);
            GameRegistry.register((IForgeRegistryEntry)itemBlock);
        }
        block.func_149647_a(CreativeTabs.field_78030_b);
        return block;
    }

    private static BlockSlab createSlab(String name) {
        return (BlockSlab)EndBlocks.addBlock((Block)new BlockHalfEndSlab(name), name + "_slab");
    }

    private static BlockSlab createDoubleSlab(String name) {
        return (BlockSlab)EndBlocks.addBlock((Block)new BlockDoubleEndSlab(name), name + "_slab");
    }

    private static Block createStairs(Block model, String name) {
        return EndBlocks.addBlock((Block)new BlockEndStairs(model), name + "_stairs");
    }

    public static Map<String, Block> getBlockRegistry() {
        return blockRegistry;
    }

    static {
        initDone = false;
        allBlocks = new HashMap<Block, String>();
        blockRegistry = new HashMap<String, Block>();
    }
}

