/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.machines;

import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;

public class SimpleEnderTableRecipe
implements IEnderTableRecipe {
    protected final List<ItemStack> enchant;
    protected final List<ItemStack> material;
    protected final ItemStack output;
    protected final int expCost;
    protected final int matCost;
    protected final float ePower;
    protected final String tooltip;
    protected final boolean obfuscate;

    public SimpleEnderTableRecipe(ItemStack result, Object inputEnchant, Object inputMaterial, int materialCost, int experienceCost, float enchantPower, String tooltip, boolean obfuscate) {
        this.output = result.func_77946_l();
        this.enchant = this.processInput(inputEnchant);
        this.material = this.processInput(inputMaterial);
        this.matCost = materialCost;
        this.expCost = Math.max(0, experienceCost);
        this.ePower = enchantPower;
        this.tooltip = tooltip;
        this.obfuscate = obfuscate;
        if (this.enchant == null || this.material == null && inputMaterial != null) {
            String ret = "Invalid simple EnderTable recipe: " + inputEnchant + ", " + inputMaterial + ", " + this.output;
            throw new RuntimeException(ret);
        }
    }

    private List<ItemStack> processInput(Object input) {
        if (input instanceof String) {
            return OreDictionary.getOres((String)((String)input));
        }
        ItemStack stack = null;
        if (input instanceof ItemStack) {
            stack = ((ItemStack)input).func_77946_l();
        } else if (input instanceof Item) {
            stack = new ItemStack((Item)input, 1, Short.MAX_VALUE);
        } else if (input instanceof Block) {
            stack = new ItemStack((Block)input, 1, Short.MAX_VALUE);
        }
        return stack != null ? Collections.singletonList(stack) : OreDictionary.EMPTY_LIST;
    }

    @Override
    public boolean matches(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        return enchantPower >= this.ePower && option == IEnderTableRecipe.EnumOption.SECOND && this.checkMatch(this.enchant, enchantStack, false) && this.checkMatch(this.material, materialStack, true);
    }

    private boolean checkMatch(List<ItemStack> target, ItemStack tableItem, boolean checksize) {
        if (target == OreDictionary.EMPTY_LIST) {
            return tableItem == null;
        }
        if (checksize && (tableItem == null || tableItem.field_77994_a < this.matCost)) {
            return false;
        }
        for (ItemStack stack : target) {
            if (stack == null || !OreDictionary.itemMatches((ItemStack)stack, (ItemStack)tableItem, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Pair<List<ItemStack>, List<ItemStack>> getInput(IEnderTableRecipe.EnumOption option) {
        if (option == IEnderTableRecipe.EnumOption.SECOND) {
            return Pair.of(this.enchant, this.material);
        }
        return Pair.of(Collections.singletonList(null), Collections.singletonList(null));
    }

    @Override
    public ItemStack getResult(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.output.func_77946_l() : null;
    }

    @Override
    public int getExpCost(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.expCost : 0;
    }

    @Override
    public int getMaterialCost(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return option == IEnderTableRecipe.EnumOption.SECOND ? this.matCost : 0;
    }

    @Override
    public String getTooltip(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return this.tooltip;
    }

    @Override
    public boolean obfuscateTooltip(ItemStack enchantStack, ItemStack materialStack, IEnderTableRecipe.EnumOption option) {
        return this.obfuscate;
    }

    @Override
    public void doneEnchant(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
    }
}

