/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.BlockCloudBase;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.tileentity.TileEntityCloudCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCloudFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftBench;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCrafting;
import shetiphian.terraqueous.common.tileentity.TileEntitySFController;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;

public class BlockCrafting
extends BlockCloudBase
implements IColored {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final AxisAlignedBB AABB_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);

    public BlockCrafting() {
        super((Material)MaterialImmovable.OPAQUE);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149752_b(10.0f);
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            this.setHarvestLevel(BlockCrafting.getEnumType(state).isCloud() ? "shovel" : "pickaxe", 1, state);
        }
        this.field_149783_u = true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH);
    }

    public int func_176201_c(IBlockState state) {
        return BlockCrafting.getEnumType(state).getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCloudFurnace) {
            state = state.func_177226_a(VARIANT, (Comparable)((Object)(((TileEntityCloudFurnace)tile).isSmelting ? EnumType.CLOUD_FURNACE_ON : EnumType.CLOUD_FURNACE)));
            state = state.func_177226_a((IProperty)FACING, (Comparable)((TileEntityCloudFurnace)tile).getFacing());
        } else if (tile instanceof TileEntityCraftFurnace) {
            state = this.isCloudBlock(state, world, pos) ? state.func_177226_a(VARIANT, (Comparable)((Object)(((TileEntityCraftFurnace)tile).isSmelting ? EnumType.CLOUD_CRAFTFURNACE_ON : EnumType.CLOUD_CRAFTFURNACE))) : state.func_177226_a(VARIANT, (Comparable)((Object)(((TileEntityCraftFurnace)tile).isSmelting ? EnumType.EARTH_CRAFTFURNACE_ON : EnumType.EARTH_CRAFTFURNACE)));
            state = state.func_177226_a((IProperty)FACING, (Comparable)((TileEntityCraftFurnace)tile).getFacing());
        } else if (tile instanceof TileEntityCraftBench) {
            state = state.func_177226_a((IProperty)FACING, (Comparable)((TileEntityCraftBench)tile).getFacing());
        } else if (tile instanceof TileEntitySFStatic) {
            state = ((TileEntitySFStatic)tile).getForgeBlock();
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return BlockCrafting.getEnumType(state) != EnumType.CLOUD_WORKBENCH;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (BlockCrafting.getEnumType(state)) {
            case CLOUD_FURNACE: 
            case CLOUD_FURNACE_ON: {
                return new TileEntityCloudFurnace();
            }
            case CLOUD_CRAFTBENCH: {
                return new TileEntityCraftBench(true);
            }
            case CLOUD_CRAFTFURNACE: 
            case CLOUD_CRAFTFURNACE_ON: {
                return new TileEntityCloudCraftFurnace();
            }
            case EARTH_CRAFTBENCH: {
                return new TileEntityCraftBench(false);
            }
            case EARTH_CRAFTFURNACE: 
            case EARTH_CRAFTFURNACE_ON: {
                return new TileEntityCraftFurnace();
            }
            case SF_ALTER: {
                return new TileEntitySFController();
            }
        }
        return new TileEntitySFStatic();
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public Material func_149688_o(IBlockState state) {
        EnumType type = BlockCrafting.getEnumType(state);
        return type.isCloud() ? CloudAPI.materialCloud : (type.getValue() == 12 || type.func_176610_l().contains("peak") ? MaterialImmovable.TRANSLUCENT : MaterialImmovable.OPAQUE);
    }

    public boolean func_185481_k(IBlockState state) {
        EnumType type = BlockCrafting.getEnumType(state);
        return !type.isCloud();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        EnumType type = BlockCrafting.getEnumType(state);
        return type.isCloud() ? 2.0f : (type.getValue() > 11 ? -1.0f : 5.0f);
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        IBlockState sfBlock;
        EnumType type = BlockCrafting.getEnumType(state);
        Item item = type.getValue() >= 12 && type.getValue() <= 14 ? ((sfBlock = StormForgeHelper.getSFBlockByName((type = BlockCrafting.getEnumType(this.func_176221_a(state, (IBlockAccess)world, pos))).func_176610_l()).getSourceBlock()).func_177230_c().func_149739_a().contains("water") ? Items.field_151131_as : Item.func_150898_a((Block)sfBlock.func_177230_c())) : this.func_180660_a(state, world.field_73012_v, 0);
        return new ItemStack(item, 1, this.getDamageValue(state, world, pos));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        EnumType type = BlockCrafting.getEnumType(state);
        if (type.getValue() < 7 || type == EnumType.SF_ALTER) {
            return Item.func_150898_a((Block)this);
        }
        return null;
    }

    public int getDamageValue(IBlockState state, World world, BlockPos pos) {
        EnumType type = BlockCrafting.getEnumType(state);
        if (type.getValue() == 13 || type.getValue() == 14) {
            type = BlockCrafting.getEnumType(this.func_176221_a(state, (IBlockAccess)world, pos));
            IBlockState sfBlock = StormForgeHelper.getSFBlockByName(type.func_176610_l()).getSourceBlock();
            if (sfBlock.func_177230_c().func_149739_a().contains("water")) {
                return 0;
            }
            return sfBlock.func_177230_c().func_180651_a(sfBlock);
        }
        return this.func_180651_a(state);
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = BlockCrafting.getEnumType(state);
        return type.getValue() < 7 ? type.getValue() : (type == EnumType.SF_ALTER ? 3 : -1);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return 255;
        }
        return this.isCloudBlock(state, world, pos) ? 191 : 255;
    }

    @Override
    public boolean isCloudBlock(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockCrafting.getEnumType(state);
        return type.isCloud();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return !this.isCloudBlock(state, world, pos);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType eType;
        if (state.func_177230_c() == this && (eType = BlockCrafting.getEnumType(state = this.func_176221_a(state, world, pos))) == EnumType.SF_BROKEN_LOWPEAK) {
            return AABB_HALF;
        }
        return Block.field_185505_j;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (BlockCrafting.getEnumType(state) == EnumType.CLOUD_WORKBENCH) {
            return this.openGui(0, player, world, pos);
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileEntityCloudFurnace) {
            return this.openGui(1, player, world, pos);
        }
        if (tile instanceof TileEntityCraftBench) {
            return this.openGui(2, player, world, pos);
        }
        if (tile instanceof TileEntityCraftFurnace) {
            return this.openGui(3, player, world, pos);
        }
        if (tile instanceof TileEntitySFController) {
            return this.openGui(4, player, world, pos);
        }
        return false;
    }

    private boolean openGui(int guiId, EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)Terraqueous.INSTANCE, guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity == null) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrafting) {
            ((TileEntityCrafting)tile).setFacing(entity.func_174811_aO().func_176734_d());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        BlockPos posAlter;
        TileEntity tile;
        EnumType type = BlockCrafting.getEnumType(state);
        if ((type.getValue() == 14 || type.getValue() == 12 && !type.func_176610_l().contains("broken")) && (tile = world.func_175625_s(pos)) instanceof TileEntitySFStatic && (posAlter = ((TileEntitySFStatic)tile).getAlterPos()) != null && world.func_175625_s(posAlter) instanceof TileEntitySFController) {
            Function.syncTile((TileEntity)tile);
            return false;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCloudFurnace) {
            ((TileEntityCloudFurnace)tile).dropItems();
        }
        if (tile instanceof TileEntityCraftBench) {
            ((TileEntityCraftBench)tile).dropItems();
        }
        if (tile instanceof TileEntityCraftFurnace) {
            ((TileEntityCraftFurnace)tile).dropItems();
        }
        if (tile instanceof TileEntitySFController) {
            ((TileEntitySFController)tile).dropItems();
            StormForgeHelper.removeStormForge(world, pos);
        }
        super.func_180663_b(world, pos, state);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCloudFurnace || tile instanceof TileEntityCraftFurnace) {
            boolean isSmelting;
            boolean bl = isSmelting = tile instanceof TileEntityCraftFurnace ? ((TileEntityCraftFurnace)tile).isSmelting : ((TileEntityCloudFurnace)tile).isSmelting;
            if (isSmelting) {
                return 13;
            }
        }
        return 0;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityCrafting && ((TileEntityCrafting)tile).rotateBlock(axis);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || (layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT) && this.func_176201_c(state) == 12;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            state = this.func_176221_a(state, world, pos);
            String type = BlockCrafting.getEnumType(state).func_176610_l();
            if (side != EnumFacing.DOWN && (type.contains("base_center") || type.contains("platform"))) {
                return true;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index == 1 && data.world != null && data.pos != null) {
            return BiomeColorHelper.func_180288_c((IBlockAccess)data.world, (BlockPos)data.pos);
        }
        return 0xFFFFFF;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.CLOUD_WORKBENCH;
            Terraqueous.errorPropertyNotFound("BlockCrafting.VARIANT", "CLOUD_WORKBENCH", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        CLOUD_WORKBENCH(0, true),
        CLOUD_FURNACE(1, true),
        CLOUD_FURNACE_ON(1, true),
        CLOUD_CRAFTBENCH(2, true),
        CLOUD_CRAFTFURNACE(3, true),
        CLOUD_CRAFTFURNACE_ON(3, true),
        EARTH_CRAFTBENCH(5, false),
        EARTH_CRAFTFURNACE(6, false),
        EARTH_CRAFTFURNACE_ON(6, false),
        SF_BROKEN_PLATFORM_AQUA(12, false),
        SF_BROKEN_AQUADUCT(12, false),
        SF_BROKEN_AQUADUCT_T(12, false),
        SF_BROKEN_BASE_CENTER(12, false),
        SF_PLATFORM_AQUA(12, false),
        SF_AQUADUCT(12, false),
        SF_AQUADUCT_T(12, false),
        SF_BASE_CENTER(12, false),
        SF_BROKEN_MONOLITH_SMOOTH(13, false),
        SF_BROKEN_MONOLITH(13, false),
        SF_BROKEN_LOWPEAK(13, false),
        SF_BROKEN_HIGHPEAK(13, false),
        SF_BROKEN_PLATFORM_CORNER(13, false),
        SF_BROKEN_PLATFORM_EDGE(13, false),
        SF_BROKEN_BASE_EDGE(13, false),
        SF_BROKEN_BASE_FILL(13, false),
        SF_BROKEN_ALTER(13, false),
        SF_MONOLITH_SMOOTH(14, false),
        SF_MONOLITH(14, false),
        SF_LOWPEAK(14, false),
        SF_HIGHPEAK(14, false),
        SF_PLATFORM_CORNER(14, false),
        SF_PLATFORM_EDGE(14, false),
        SF_BASE_EDGE(14, false),
        SF_BASE_FILL(14, false),
        SF_ALTER(15, false);

        private static final EnumType[] array;
        private final byte value;
        private final boolean cloud;

        private EnumType(int value, boolean cloud) {
            this.value = (byte)value;
            this.cloud = cloud;
        }

        public byte getValue() {
            return this.value;
        }

        public boolean isCloud() {
            return this.cloud;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? CLOUD_WORKBENCH : type;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            for (EnumType value : EnumType.values()) {
                if (array[value.getValue()] != null) continue;
                EnumType.array[value.getValue()] = value;
            }
        }
    }
}

