/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.core.common.Function;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.core.forgefixes.DummyState;
import shetiphian.core.forgefixes.OBJModel;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.tileentity.TileEntityDoodad;

public class BlockDoodad
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static List<ItemStack> cacheDust = null;
    private static final AxisAlignedBB AABB_ENDIMIUM = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB AABB_BURNIUM = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.75, 0.75);
    private static final AxisAlignedBB AABB_FLAT = new AxisAlignedBB(0.05, 0.0, 0.05, 0.95, 0.15, 0.95);

    public BlockDoodad() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185851_d);
        for (IBlockState state : this.func_176194_O().func_177619_a()) {
            EnumType type = BlockDoodad.getEnumType(state);
            this.setHarvestLevel(type.getTool(), type.getToolLevel(), state);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{VARIANT}, new IUnlistedProperty[]{OBJModel.OBJProperty.INSTANCE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockDoodad.getEnumType(state).getValue();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        OBJModel.OBJState newState;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDoodad && state.func_177230_c() == this) {
            EnumType type = BlockDoodad.getEnumType(state);
            List<String> group = ((TileEntityDoodad)tile).getGroup(type.getPrefix(), type == EnumType.GLASSSHARDS ? 1 : 5);
            newState = new OBJModel.OBJState(group, (IModelState)new DummyState(((TileEntityDoodad)tile).getTransform()));
        } else {
            newState = new OBJModel.OBJState();
        }
        return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE, (Object)newState);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityDoodad();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        EnumType type = BlockDoodad.getEnumType(state);
        return type == EnumType.BONE || type == EnumType.GLASSSHARDS ? 0.25f : 0.75f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockDoodad.getEnumType(state);
        if (type == EnumType.ENDIMIUM) {
            return AABB_ENDIMIUM;
        }
        if (type == EnumType.BURNIUM) {
            return AABB_BURNIUM;
        }
        return AABB_FLAT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176214_u() {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor) {
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false)) {
            this.func_176226_b(world, pos, state, 0);
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)true);
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = BlockDoodad.getEnumType(state);
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        switch (type) {
            case BRANCH: {
                dropList.add(new ItemStack(Items.field_151055_y, Function.random.nextInt(4) + 1 + fortune));
                break;
            }
            case STONE: 
            case SANDSTONE: 
            case REDSANDSTONE: {
                ItemStack base;
                if (Values.itemMain != null && Settings.INSTANCE.dropLumps && (base = Values.stacks.get(type == EnumType.REDSANDSTONE ? "redsandstone_lump" : (type == EnumType.SANDSTONE ? "sandstone_lump" : "gravel_lump"), new int[0])) != null) {
                    base.field_77994_a = Function.random.nextInt(2) + 1;
                    dropList.add(base);
                }
                if (cacheDust == null || Settings.INSTANCE.rebuildDustList) {
                    cacheDust = BlockDoodad.generateDustList("TinyEndimium", "Endimium", "TinyBurnium", "Burnium");
                    Settings.INSTANCE.rebuildDustList = false;
                }
                if (cacheDust.isEmpty()) break;
                byte stop = (byte)(1 + Function.random.nextInt(fortune < 1 ? 1 : fortune));
                for (byte drop = 0; drop < stop; drop = (byte)(drop + 1)) {
                    ItemStack extra = cacheDust.get(Function.random.nextInt(cacheDust.size()));
                    if (extra == null) continue;
                    dropList.add(extra.func_77946_l());
                }
                break;
            }
            case BONE: {
                dropList.add(new ItemStack(Items.field_151100_aR, Function.random.nextInt(3) + 1 + fortune, 15));
                if (!Function.random.nextBoolean()) break;
                dropList.add(new ItemStack(Items.field_151103_aS, Function.random.nextInt(2) + 1));
                break;
            }
            case ENDIMIUM: {
                Function.attemptAdd(dropList, (ItemStack)Function.getOre((String)"gemEndimium", (int[])new int[]{1 + Function.random.nextInt(2)}));
                Function.attemptAdd(dropList, (ItemStack)Function.getOre((String)"dustEndimium", (int[])new int[]{Function.random.nextInt(2 + fortune)}));
                Function.attemptAdd(dropList, (ItemStack)Function.getOre((String)"dustTinyEndimium", (int[])new int[]{Function.random.nextInt(4 + fortune)}));
                break;
            }
            case BURNIUM: {
                Function.attemptAdd(dropList, (ItemStack)Function.getOre((String)"gemBurnium", (int[])new int[]{1 + Function.random.nextInt(2)}));
                Function.attemptAdd(dropList, (ItemStack)Function.getOre((String)"dustBurnium", (int[])new int[]{Function.random.nextInt(2 + fortune)}));
                Function.attemptAdd(dropList, (ItemStack)Function.getOre((String)"dustTinyBurnium", (int[])new int[]{Function.random.nextInt(4 + fortune)}));
                break;
            }
            case GLASSSHARDS: {
                dropList.add(new ItemStack((Block)this, 1, 6));
            }
        }
        return dropList;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        EnumType type = BlockDoodad.getEnumType(state);
        if (entity instanceof EntityDragon && type == EnumType.ENDIMIUM) {
            return false;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        boolean hasBoots;
        EnumType type = BlockDoodad.getEnumType(state);
        boolean bl = hasBoots = entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.FEET) != null;
        if (type == EnumType.ENDIMIUM || type == EnumType.BURNIUM || type == EnumType.GLASSSHARDS && !hasBoots) {
            entity.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float f) {
        boolean hasBoots;
        EnumType type = BlockDoodad.getEnumType(world.func_180495_p(pos));
        boolean bl = hasBoots = entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_184582_a(EntityEquipmentSlot.FEET) != null;
        if (type == EnumType.ENDIMIUM || type == EnumType.BURNIUM || type == EnumType.GLASSSHARDS) {
            entity.func_70097_a(DamageSource.field_76377_j, type == EnumType.GLASSSHARDS && hasBoots ? 1.0f : 2.5f);
        }
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = BlockDoodad.getEnumType(state);
        return type.value;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockDoodad.getEnumType(state);
        return type == EnumType.ENDIMIUM ? 6 : (type == EnumType.BURNIUM ? 10 : 0);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    private static List<ItemStack> generateDustList(String ... excludeList) {
        boolean hasWhiteList = Settings.INSTANCE.dustWhiteList != null && Settings.INSTANCE.dustWhiteList.length > 0;
        boolean hasBlackList = Settings.INSTANCE.dustBlackList != null && Settings.INSTANCE.dustBlackList.length > 0;
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<ItemStack> listDust = new ArrayList<ItemStack>();
        if (hasWhiteList) {
            for (String include : Settings.INSTANCE.dustWhiteList) {
                Item item;
                if (include.startsWith("ore")) {
                    categories.add(include.substring(4));
                    continue;
                }
                Pair<ResourceLocation, Integer> data = BlockDoodad.getItemData(include, false);
                if (data == null || (item = (Item)Item.field_150901_e.func_82594_a(data.getKey())) == null) continue;
                listDust.add(new ItemStack(item, 1, (Integer)data.getValue() == Short.MAX_VALUE ? 0 : (Integer)data.getValue()));
            }
        } else {
            String[] names = OreDictionary.getOreNames();
            String[] stringArray = names;
            int n = stringArray.length;
            for (int include = 0; include < n; ++include) {
                String name = stringArray[include];
                if (Strings.isNullOrEmpty((String)name) || !name.toLowerCase().startsWith("dust")) continue;
                categories.add(name);
            }
        }
        if (hasBlackList) {
            for (String exclude : Settings.INSTANCE.dustBlackList) {
                if (!exclude.startsWith("ore")) continue;
                categories.remove(exclude.substring(4));
            }
        }
        if (excludeList != null && excludeList.length > 0) {
            for (String exclude : excludeList) {
                categories.remove("dust" + (String)exclude);
            }
        }
        for (String name : categories) {
            List odList = OreDictionary.getOres((String)name);
            if (odList.isEmpty()) continue;
            listDust.add((ItemStack)odList.get(0));
        }
        ArrayList<ItemStack> listRemove = new ArrayList<ItemStack>();
        if (hasBlackList) {
            for (String exclude : Settings.INSTANCE.dustBlackList) {
                Pair<ResourceLocation, Integer> data;
                if (exclude.startsWith("ore") || (data = BlockDoodad.getItemData(exclude, true)) == null) continue;
                for (ItemStack stack : listDust) {
                    if (!stack.func_77973_b().getRegistryName().equals(data.getKey()) || (Integer)data.getValue() != Short.MAX_VALUE && ((Integer)data.getValue()).intValue() != stack.func_77952_i()) continue;
                    listRemove.add(stack);
                }
            }
        }
        if (!listRemove.isEmpty()) {
            listDust.removeAll(listRemove);
        }
        return listDust;
    }

    private static Pair<ResourceLocation, Integer> getItemData(String data, boolean defaultWild) {
        if (!Strings.isNullOrEmpty((String)data)) {
            int meta;
            String name = data;
            int n = meta = defaultWild ? Short.MAX_VALUE : 0;
            if (data.contains("@")) {
                String[] split = data.split("@");
                name = split[0];
                try {
                    meta = Integer.parseInt(split[1]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (meta < 0) {
                    meta = Short.MAX_VALUE;
                }
            }
            ResourceLocation resource = null;
            try {
                resource = new ResourceLocation(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resource != null) {
                return Pair.of((Object)resource, (Object)meta);
            }
        }
        return null;
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.BRANCH;
            Terraqueous.errorPropertyNotFound("BlockDoodad.VARIANT", "BRANCH", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        BRANCH(0, "axe", 0, SoundType.field_185848_a),
        STONE(1, "pickaxe", 0, SoundType.field_185851_d),
        BONE(2, "shovel", 0, SoundType.field_185851_d),
        SANDSTONE(3, "pickaxe", 0, SoundType.field_185851_d),
        ENDIMIUM(4, "pickaxe", 2, SoundType.field_185853_f),
        BURNIUM(5, "pickaxe", 1, SoundType.field_185853_f),
        GLASSSHARDS(6, "shovel", 0, SoundType.field_185853_f),
        REDSANDSTONE(7, "pickaxe", 0, SoundType.field_185851_d);

        private static final EnumType[] array;
        private final byte value;
        private final String tool;
        private final byte toolLevel;
        private final SoundType soundType;

        private EnumType(int value, String tool, int toolLevel, SoundType soundType) {
            this.value = (byte)value;
            this.tool = tool;
            this.toolLevel = (byte)toolLevel;
            this.soundType = soundType;
        }

        public byte getValue() {
            return this.value;
        }

        public String getTool() {
            return this.tool;
        }

        public byte getToolLevel() {
            return this.toolLevel;
        }

        public SoundType getSoundType() {
            return this.soundType;
        }

        public IBlockState state() {
            if (Values.blockDoodad != null) {
                return Values.blockDoodad.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            return null;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? BRANCH : type;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        public String getPrefix() {
            return this.func_176610_l().replace("branch", "stick").replace("redsandstone", "sandstone").replace("glassshards", "shards");
        }

        static {
            array = new EnumType[8];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

