/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockTreeFoliage
extends BlockLeaves
implements IGrowable,
IColored {
    private static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    static final PropertyBool FASTMODE = PropertyBool.func_177716_a((String)"fastmode");
    private PropertyEnum<PlantAPI.TreeType> TREE;
    private final int index;
    private final BlockStateContainer blockState;

    public BlockTreeFoliage(int index) {
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.index = index;
        if (index >= 0) {
            this.setBlockState();
        }
        this.blockState = this.func_180661_e();
        this.func_180632_j(this.blockState.func_177621_b().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)));
    }

    private void setBlockState() {
        this.TREE = PropertyEnum.func_177708_a((String)"treevariant", PlantAPI.TreeType.class, (Predicate)new Predicate<PlantAPI.TreeType>(){

            public boolean apply(PlantAPI.TreeType treeType) {
                int base = BlockTreeFoliage.this.index * 2;
                byte id = treeType.getID();
                return id >= base && id < base + 2;
            }
        });
    }

    protected BlockStateContainer func_180661_e() {
        return this.TREE == null ? super.func_180661_e() : new BlockStateContainer((Block)this, new IProperty[]{VARIANT, this.TREE, FASTMODE, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
    }

    public BlockStateContainer func_176194_O() {
        return this.blockState;
    }

    public IBlockState func_176203_a(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)15);
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(meta > 7));
        state = state.func_177226_a(this.TREE, (Comparable)((Object)PlantAPI.TreeType.byID((meta %= 8) / 4 + this.index * 2)));
        return state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta % 4))).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)FASTMODE, (Comparable)Boolean.valueOf(!Terraqueous.proxy.fancyGraphics())).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
    }

    public int func_176201_c(IBlockState state) {
        return this.getEnumType(state).getValue() + 4 * (this.getTreeType(state).getID() % 2) + ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b) != false ? 8 : 0);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)Values.blockSapling);
    }

    public int func_180651_a(IBlockState state) {
        return this.getTreeType(state).getID();
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        PlantAPI.TreeType tree;
        List list = super.getDrops(world, pos, state, fortune);
        if (this.getEnumType(state) == EnumType.FRUIT && ((tree = this.getTreeType(state)) == PlantAPI.TreeType.APPLE || Values.itemMultiFood != null)) {
            ItemStack fruit = tree == PlantAPI.TreeType.APPLE ? new ItemStack(Items.field_151034_e) : new ItemStack(Values.itemMultiFood, 1, tree.getID() - 1);
            list.add(fruit);
        }
        return list;
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        PlantAPI.TreeType tree;
        if (world.field_72995_K) {
            return;
        }
        if (Values.blockSapling != null && PlantFunctions.dropSapling((IBlockAccess)world, pos, tree = this.getTreeType(state)) && fortune > -100) {
            Function.dropItem((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Values.blockSapling, 1, (int)tree.getID()));
        }
        this.dropFruit(world, pos, state, null, false);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.dropFruit(world, pos, state, player, true);
    }

    public boolean dropFruit(World world, BlockPos pos, IBlockState state, EntityPlayer player, boolean changeLeaves) {
        ItemStack fruit;
        if (this.getEnumType(state) != EnumType.FRUIT) {
            return false;
        }
        PlantAPI.TreeType tree = this.getTreeType(state);
        if (tree != PlantAPI.TreeType.APPLE && Values.itemMultiFood == null) {
            return false;
        }
        ItemStack itemStack = fruit = tree == PlantAPI.TreeType.APPLE ? new ItemStack(Items.field_151034_e) : new ItemStack(Values.itemMultiFood, 1, tree.getID() - 1);
        if (player != null) {
            Function.giveItem((EntityPlayer)player, (ItemStack)fruit);
        } else {
            Function.dropItem((World)world, (BlockPos)pos, (ItemStack)fruit);
        }
        if (changeLeaves) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)), (boolean)true);
        }
        return true;
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((Block)this, 1, 4 * (this.getTreeType(world.func_180495_p(pos)).getID() % 2)));
        return list;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        switch (this.getEnumType(state)) {
            case NORMAL: {
                return this.airCheck(world, pos);
            }
            case FLOWER: {
                return true;
            }
            case FRUIT: {
                return false;
            }
        }
        return false;
    }

    private boolean airCheck(World world, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!world.func_175623_d(pos.func_177972_a(facing))) continue;
            return true;
        }
        return false;
    }

    public boolean func_180670_a(World world, Random random, BlockPos pos, IBlockState state) {
        return random.nextFloat() < 0.45f;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        switch (this.getEnumType(state)) {
            case NORMAL: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.FLOWER)), (boolean)true);
                break;
            }
            case FLOWER: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.FRUIT)), (boolean)true);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)), rand);
        if (!world.func_175623_d(pos) && this.func_176473_a(world, pos, state, world.field_72995_K)) {
            switch (this.getEnumType(state)) {
                case NORMAL: {
                    if (!PlantFunctions.growFruitFlower((IBlockAccess)world, pos, this.getTreeType(state))) break;
                    this.func_176474_b(world, rand, pos, state);
                    break;
                }
                case FLOWER: {
                    if (!PlantFunctions.growFruit((IBlockAccess)world, pos, this.getTreeType(state))) break;
                    this.func_176474_b(world, rand, pos, state);
                }
            }
        } else if (this.getEnumType(state) == EnumType.FRUIT && PlantFunctions.dropFruit((IBlockAccess)world, pos, this.getTreeType(state))) {
            this.func_180653_a(world, pos, state, 0.0f, -100);
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)), (boolean)true);
        }
    }

    void passthroughUpdateTick(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)), rand);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        this.field_185686_c = Terraqueous.proxy.fancyGraphics();
        return super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (data.state != null) {
            if (data.world != null && data.pos != null) {
                return FoliageColor.getBiomeColor(data.world, data.pos, FoliageColor.EnumFoliage.getFoliage(this.getTreeType(data.state)));
            }
            FoliageColor.getRenderColor(FoliageColor.EnumFoliage.getFoliage(this.getTreeType(data.state)));
        }
        return 0xFFFFFF;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int metadata = this.func_176201_c(state) % 8;
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return new ItemStack((Block)this, 1, metadata);
        }
        return new ItemStack((Block)this, 1, metadata / 4 * 4);
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    public PlantAPI.TreeType getTreeType(IBlockState state) {
        PlantAPI.TreeType type;
        try {
            type = (PlantAPI.TreeType)((Object)state.func_177229_b(this.TREE));
        }
        catch (Exception e) {
            type = PlantAPI.TreeType.byID(this.index * 2);
            PlantAPI.errorPropertyNotFound("BlockTreeFoliage.TREE", type.func_176610_l().toUpperCase(), state.toString());
        }
        return type;
    }

    private EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.NORMAL;
            Terraqueous.errorPropertyNotFound("BlockTreeFoliage.VARIANT", "NORMAL", state.toString());
        }
        return type;
    }

    private static enum EnumType implements IStringSerializable
    {
        NORMAL(0),
        FLOWER(1),
        FRUIT(2);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[3];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

