/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class BlockTreeTrunk
extends BlockLog {
    private static final PropertyEnum<EnumAxis> ROTATION = PropertyEnum.func_177709_a((String)"axis", EnumAxis.class);
    private PropertyEnum<PlantAPI.TreeType> TREE;
    private final int index;
    protected final BlockStateContainer field_176227_L;

    public BlockTreeTrunk(int index) {
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.index = index;
        this.setBlockState();
        this.field_176227_L = this.func_180661_e();
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.setHarvestLevel("axe", 0);
    }

    private void setBlockState() {
        this.TREE = PropertyEnum.func_177708_a((String)"treevariant", PlantAPI.TreeType.class, (Predicate)new Predicate<PlantAPI.TreeType>(){

            public boolean apply(PlantAPI.TreeType treeType) {
                int base = BlockTreeTrunk.this.index * 5;
                byte id = treeType.getID();
                return id >= base && id < base + 5;
            }
        });
    }

    protected BlockStateContainer func_180661_e() {
        return this.TREE == null ? super.func_180661_e() : new BlockStateContainer((Block)this, new IProperty[]{ROTATION, this.TREE});
    }

    public BlockStateContainer func_176194_O() {
        return this.field_176227_L;
    }

    public IBlockState func_176203_a(int meta) {
        meta = MathHelper.func_76125_a((int)meta, (int)0, (int)14);
        IBlockState state = this.func_176223_P().func_177226_a(this.TREE, (Comparable)((Object)PlantAPI.TreeType.byID(meta / 3 + this.index * 5)));
        state = state.func_177226_a(ROTATION, (Comparable)((Object)this.getAxis(meta % 3)));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return this.getIndex((EnumAxis)((Object)state.func_177229_b(ROTATION))) + 3 * (this.getTreeType(state).getID() % 5);
    }

    private EnumAxis getAxis(int value) {
        return value == 1 ? EnumAxis.Z : (value == 2 ? EnumAxis.X : EnumAxis.Y);
    }

    private int getIndex(EnumAxis axis) {
        return axis == EnumAxis.Z ? 1 : (axis == EnumAxis.X ? 2 : 0);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public int func_180651_a(IBlockState state) {
        return this.getTreeType(state).getID() % 5;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta).func_177226_a(ROTATION, (Comparable)((Object)EnumAxis.fromFacingAxis(facing.func_176740_k())));
    }

    public PlantAPI.TreeType getTreeType(IBlockState state) {
        PlantAPI.TreeType type;
        try {
            type = (PlantAPI.TreeType)((Object)state.func_177229_b(this.TREE));
        }
        catch (Exception e) {
            type = PlantAPI.TreeType.byID(this.index * 2);
            PlantAPI.errorPropertyNotFound("BlockTreeTrunk.TREE", type.func_176610_l().toUpperCase(), state.toString());
        }
        return type;
    }

    private static enum EnumAxis implements IStringSerializable
    {
        X("x"),
        Y("y"),
        Z("z");

        private final String name;

        private EnumAxis(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis fromFacingAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Y: {
                    return Y;
                }
                case Z: {
                    return Z;
                }
            }
            return Y;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

