/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

public class ItemBlockFlowerPot
extends ItemBlockMulti
implements IRGB16_Item,
IColored {
    public ItemBlockFlowerPot(Block block) {
        super(block, "BlockFlowerPot", Values.nameMapper);
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List<ItemStack> list) {
        ItemStack small = new ItemStack((Item)this, 1, 0);
        ItemStack large = new ItemStack((Item)this, 1, 1);
        list.add(small);
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            list.add(RGB16StackHelper.setRGB16((ItemStack)small.func_77946_l(), (String)dye.func_176610_l()));
        }
        list.add(large);
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            list.add(RGB16StackHelper.setRGB16((ItemStack)large.func_77946_l(), (String)dye.func_176610_l()));
        }
    }

    public String func_77667_c(ItemStack itemstack) {
        return itemstack.func_77952_i() == 0 ? Items.field_151162_bE.func_77658_a() : this.func_77658_a() + ".planter";
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!this.func_179223_d().func_176196_c(world, pos)) {
            return false;
        }
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)newState, (boolean)false)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityFlowerPot) {
            ((TileEntityFlowerPot)tile).setRGB16(this.getRGB16(stack), null);
            Function.syncTile((TileEntity)tile);
            world.func_175685_c(pos, newState.func_177230_c());
            return true;
        }
        Function.removeBlock((World)world, (BlockPos)pos, (boolean)false);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        return data.stack != null ? RGB16Helper.getColor((short)this.getRGB16(data.stack)) : RGB16Helper.getColor((short)RGB16Helper.getIndexFor((int)10, (int)5, (int)4));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        tooltip.add(RGB16Helper.getTooltip((short)this.getRGB16(stack)));
    }

    public short getRGB16(ItemStack stack) {
        return RGB16StackHelper.readColorTag((ItemStack)stack, (short)RGB16Helper.getIndexFor((int)10, (int)5, (int)4));
    }

    public boolean setRGB16(ItemStack stack, short rgbIndex) {
        return RGB16StackHelper.writeColorTags((ItemStack)stack, (short)rgbIndex);
    }

    protected void addToNameMap() {
        this.add(0, "planter/", "flowerpot", "pot");
        this.add(1, "planter/", "planterpot", "planter");
    }
}

