/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockHay;
import shetiphian.terraqueous.common.misc.HayHelper;

public class ItemBlockHay
extends ItemBlockMulti
implements IColored {
    public ItemBlockHay(Block block) {
        super(block, "BlockHay", Values.nameMapper);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (int metadata = 0; metadata < 16; metadata = (int)((byte)(metadata + 1))) {
            list.add(new ItemStack((Item)this, 1, metadata));
        }
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        int dmg = stack.func_77952_i();
        if (dmg > 4) {
            if (side != EnumFacing.UP || !world.isSideSolid(pos, EnumFacing.UP)) {
                return false;
            }
            if (dmg < 6) {
                return true;
            }
            int tickrate = HayHelper.getTickRate(world, pos);
            if (tickrate > 0) {
                world.func_175684_a(pos, this.field_150939_a, tickrate);
                return true;
            }
            return false;
        }
        return super.func_179222_a(world, pos, side, player, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (data.stack != null) {
            IBlockState state = this.field_150939_a.func_176203_a(data.stack.func_77960_j());
            if (this.field_150939_a instanceof BlockHay) {
                return ((BlockHay)this.field_150939_a).getRenderColor(state);
            }
        }
        return 0xFFFFFF;
    }

    protected void addToNameMap() {
        this.add(0, "hay/", "hay_block", "block");
        this.add(1, "hay/", "lg_haypile", "pile.large");
        this.add(2, "hay/", "haypile", "pile");
        this.add(3, "hay/", "sm_haypile", "pile.small");
        this.add(4, "hay/", "thresh", "thresh");
        this.add(5, "hay/", "drying", "loosehay");
        for (int damage = 6; damage < 15; damage = (int)((byte)(damage + 1))) {
            this.add(damage, "hay/", "drying", "drying" + (15 - damage) + "0");
        }
        this.add(15, "hay/", "drying", "loosegrass");
    }
}

