/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.FuelHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.block.BlockTypeCloud;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeColored;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeDoor;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFence;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeGate;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeSlab;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeStairs;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeTrapdoor;

public class ItemBlockType
extends ItemBlockMulti
implements FuelHelper.IFuel,
IRGB16_Item,
IColored {
    public ItemBlockType(Block block) {
        super(block, "BlockType" + (block.func_149739_a().toLowerCase().contains("cloud") ? "Cloud" : "Earth"), Values.nameMapper);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        int index;
        int max = this.field_150939_a instanceof BlockTypeCloud ? CloudAPI.CloudType.values().length : PlantAPI.TreeType.values().length;
        for (index = 0; index < max; index = (int)((byte)(index + 1))) {
            list.add(new ItemStack(item, 1, index));
        }
        for (index = 0; index < max; index = (int)((byte)(index + 1))) {
            list.add(new ItemStack(item, 1, index + 10));
        }
        for (index = 0; index < max; index = (int)((byte)(index + 1))) {
            list.add(new ItemStack(item, 1, index + 20));
        }
        for (index = 0; index < max; index = (int)((byte)(index + 1))) {
            list.add(new ItemStack(item, 1, index + 30));
        }
        for (index = 0; index < max; index = (int)((byte)(index + 1))) {
            list.add(new ItemStack(item, 1, index + 40));
        }
        for (index = 0; index < max; index = (int)((byte)(index + 1))) {
            list.add(new ItemStack(item, 1, index + 50));
        }
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            list.add(RGB16StackHelper.setRGB16((ItemStack)new ItemStack(item, 1, 110), (String)dye.func_176610_l()));
        }
        for (EnumDyeColor dye : EnumDyeColor.values()) {
            list.add(RGB16StackHelper.setRGB16((ItemStack)new ItemStack(item, 1, 120), (String)dye.func_176610_l()));
        }
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        IBlockState state;
        Block sBlock;
        if (side == EnumFacing.DOWN || side == EnumFacing.UP) {
            if (stack.func_77952_i() / 10 == 1) {
                return false;
            }
            if (this.canStackSlab(world, pos, side, stack)) {
                return true;
            }
        }
        if ((sBlock = (state = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150431_aC && (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
            side = EnumFacing.UP;
        } else if (!sBlock.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (this.canStackSlab(world, pos, side == EnumFacing.DOWN || side == EnumFacing.UP ? side.func_176734_d() : side, stack)) {
            return true;
        }
        return world.func_175716_a(this.field_150939_a, pos, false, side, null, stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (stack == null || stack.field_77994_a == 0) {
            return EnumActionResult.PASS;
        }
        if (facing.func_176745_a() < 2 && this.doStackSlab(world, pos, facing, stack)) {
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == Blocks.field_150431_aC && (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) < 1) {
            facing = EnumFacing.UP;
        } else if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (this.doStackSlab(world, pos, facing == EnumFacing.DOWN || facing == EnumFacing.UP ? facing.func_176734_d() : (hitY > 0.5f ? EnumFacing.UP : EnumFacing.DOWN), stack)) {
            return EnumActionResult.SUCCESS;
        }
        if (stack.func_77952_i() / 10 == 0) {
            if (pos.func_177956_o() >= world.func_72800_K() - 2 || !player.func_175151_a(pos, facing, stack) || !player.func_175151_a(pos.func_177984_a(), facing, stack)) {
                return EnumActionResult.FAIL;
            }
            if (!this.canPlaceDoorAt(world, pos, this.func_179223_d() instanceof BlockTypeCloud)) {
                return EnumActionResult.FAIL;
            }
            if (!block.func_176196_c(world, pos) || !block.func_176196_c(world, pos.func_177984_a())) {
                return EnumActionResult.FAIL;
            }
        } else {
            if (pos.func_177956_o() >= world.func_72800_K() - 1 || !player.func_175151_a(pos, facing, stack)) {
                return EnumActionResult.FAIL;
            }
            if (this.func_179223_d() instanceof BlockTypeCloud && !CloudPresets.canPlaceAt(world, pos)) {
                return EnumActionResult.FAIL;
            }
            if (!this.func_179223_d().func_176196_c(world, pos)) {
                return EnumActionResult.FAIL;
            }
        }
        if (this.placeBlockAt(stack, player, world, pos, facing, hitX, hitY, hitZ, state = this.func_179223_d().func_180642_a(world, pos, facing, hitX, hitY, hitZ, stack.func_77952_i(), (EntityLivingBase)player))) {
            SoundType soundtype = this.field_150939_a.func_185467_w();
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            --stack.field_77994_a;
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean canPlaceDoorAt(World world, BlockPos pos, boolean isCloud) {
        if (!isCloud && !world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            return false;
        }
        for (int pass = 0; pass < 2; ++pass) {
            for (EnumFacing dir : EnumFacing.values()) {
                BlockPos sPos = pos.func_177972_a(dir);
                IBlockState sState = world.func_180495_p(sPos);
                if ((!isCloud || CloudAPI.canBlockTouchClouds(sState, world, sPos)) && (isCloud || !CloudAPI.isCloud(sState, (IBlockAccess)world, sPos))) continue;
                return false;
            }
            pos = pos.func_177984_a();
        }
        return true;
    }

    private boolean canStackSlab(World world, BlockPos pos, EnumFacing side, ItemStack stack) {
        TileEntity tile;
        if (stack == null || stack.func_77952_i() / 10 != 5) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockTypeBase && (tile = world.func_175625_s(pos)) instanceof TileEntityTypeSlab) {
            TileEntityTypeSlab slab = (TileEntityTypeSlab)tile;
            if (side != EnumFacing.UP && slab.styleBottom == -1 || side != EnumFacing.DOWN && slab.styleTop == -1) {
                return true;
            }
        }
        return false;
    }

    private boolean doStackSlab(World world, BlockPos pos, EnumFacing side, ItemStack stack) {
        TileEntity tile;
        if (stack == null || stack.func_77952_i() / 10 != 5) {
            return false;
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockTypeBase && (tile = world.func_175625_s(pos)) instanceof TileEntityTypeSlab) {
            TileEntityTypeSlab slab = (TileEntityTypeSlab)tile;
            if (side == EnumFacing.DOWN && slab.styleBottom == -1) {
                slab.styleBottom = (byte)(stack.func_77952_i() % 10);
                --stack.field_77994_a;
                Function.syncTile((TileEntity)slab);
                return true;
            }
            if (side == EnumFacing.UP && slab.styleTop == -1) {
                slab.styleTop = (byte)(stack.func_77952_i() % 10);
                --stack.field_77994_a;
                Function.syncTile((TileEntity)slab);
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        if (!this.func_179223_d().func_176196_c(world, pos)) {
            return false;
        }
        if (!Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false)) {
            return false;
        }
        if (stack.func_77952_i() / 10 == 0 && !Function.setBlock((World)world, (BlockPos)pos.func_177984_a(), (IBlockState)state, (boolean)false)) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityTypeDoor) {
            boolean zPlane;
            TileEntity tile2 = world.func_175625_s(pos.func_177984_a());
            if (!(tile2 instanceof TileEntityTypeDoor)) {
                Function.removeBlock((World)world, (BlockPos)pos, (boolean)false);
                Function.removeBlock((World)world, (BlockPos)pos.func_177984_a(), (boolean)false);
                return false;
            }
            TileEntityTypeDoor bottom = (TileEntityTypeDoor)tile;
            TileEntityTypeDoor top = (TileEntityTypeDoor)tile2;
            bottom.isTop = false;
            top.isTop = true;
            bottom.style = top.style = (byte)(stack.func_77952_i() % 10);
            EnumFacing facing = EnumFacing.NORTH;
            boolean flip = false;
            boolean bl = zPlane = (MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) % 2 == 0;
            if (hitX > 0.5f && hitZ > 0.5f) {
                facing = zPlane ? EnumFacing.NORTH : EnumFacing.WEST;
                flip = zPlane;
            } else if (hitX <= 0.5f && hitZ > 0.5f) {
                facing = zPlane ? EnumFacing.NORTH : EnumFacing.EAST;
                flip = !zPlane;
            } else if (hitX > 0.5f && hitZ <= 0.5f) {
                facing = zPlane ? EnumFacing.SOUTH : EnumFacing.WEST;
                flip = !zPlane;
            } else if (hitX <= 0.5f && hitZ <= 0.5f) {
                facing = zPlane ? EnumFacing.SOUTH : EnumFacing.EAST;
                flip = zPlane;
            }
            bottom.facing = top.facing = facing;
            bottom.inverted = top.inverted = flip;
            bottom.setDefaultStatus();
            top.setDefaultStatus();
            Function.syncTile((TileEntity)tile2);
            world.func_175695_a(pos.func_177984_a(), state.func_177230_c(), EnumFacing.DOWN);
        } else if (stack.func_77952_i() / 10 == 0) {
            Function.removeBlock((World)world, (BlockPos)pos, (boolean)false);
            Function.removeBlock((World)world, (BlockPos)pos.func_177984_a(), (boolean)false);
            return false;
        }
        if (tile instanceof TileEntityTypeTrapdoor) {
            TileEntityTypeTrapdoor door = (TileEntityTypeTrapdoor)tile;
            door.style = (byte)(stack.func_77952_i() % 10);
            door.facing = side;
            door.inverted = hitY > 0.5f;
            door.setDefaultStatus();
        }
        if (tile instanceof TileEntityTypeGate) {
            TileEntityTypeGate gate = (TileEntityTypeGate)tile;
            gate.gateStyle = (byte)(stack.func_77952_i() % 10);
            gate.gateFacing = player.func_174811_aO().func_176734_d();
            gate.setDefaultStatus();
        }
        if (tile instanceof TileEntityTypeFence) {
            TileEntityTypeFence fence = (TileEntityTypeFence)tile;
            fence.style = (byte)(stack.func_77952_i() % 10);
        }
        if (tile instanceof TileEntityTypeStairs) {
            TileEntityTypeStairs stairs = (TileEntityTypeStairs)tile;
            stairs.style = (byte)(stack.func_77952_i() % 10);
            stairs.facing = player.func_174811_aO();
            boolean bl = stairs.inverted = side == EnumFacing.DOWN || side != EnumFacing.UP && hitY > 0.5f;
        }
        if (tile instanceof TileEntityTypeSlab) {
            TileEntityTypeSlab slab = (TileEntityTypeSlab)tile;
            if (side == EnumFacing.DOWN || side != EnumFacing.UP && hitY > 0.5f) {
                slab.styleTop = (byte)(stack.func_77952_i() % 10);
            } else {
                slab.styleBottom = (byte)(stack.func_77952_i() % 10);
            }
        }
        if (tile instanceof TileEntityTypeColored) {
            ((TileEntityTypeColored)tile).setRGB16(this.getRGB16(stack), null);
        }
        if (tile != null) {
            Function.syncTile((TileEntity)tile);
        }
        world.func_175685_c(pos, state.func_177230_c());
        return true;
    }

    public float getItemsSmeltedPerFuel(ItemStack stack) {
        if (this.func_179223_d() instanceof BlockTypeCloud) {
            return 0.0f;
        }
        int damage = stack.func_77952_i();
        return damage / 10 > 10 ? 0.5f : (damage / 10 < 4 ? 1.5f : 0.75f);
    }

    public short getRGB16(ItemStack stack) {
        if (stack.func_77952_i() / 10 > 10) {
            String dyeName = this.func_179223_d() instanceof BlockTypeCloud ? "dyeBlue" : "dyeWhite";
            return RGB16StackHelper.readColorTag((ItemStack)stack, (short)RGB16Helper.getIndexFor((String)dyeName));
        }
        return -1;
    }

    public boolean setRGB16(ItemStack stack, short rgbIndex) {
        return stack.func_77952_i() / 10 > 10 && RGB16StackHelper.writeColorTags((ItemStack)stack, (short)rgbIndex);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        return index == 0 && data.stack != null && data.stack.func_77952_i() / 10 > 10 ? RGB16Helper.getColor((short)this.getRGB16(data.stack)) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer entityPlayer, List<String> list, boolean advancedTooltips) {
        if (stack.func_77952_i() / 10 > 10) {
            list.add(RGB16Helper.getTooltip((short)this.getRGB16(stack)));
        }
    }

    protected void addToNameMap() {
        String folder;
        ArrayList<String> types = new ArrayList<String>();
        if (this.nameId.toLowerCase().contains("cloud")) {
            folder = "typecloud";
            for (Enum enum_ : CloudAPI.CloudType.values()) {
                types.add(((CloudAPI.CloudType)enum_).func_176610_l());
            }
        } else {
            folder = "typeearth";
            for (Enum enum_ : PlantAPI.TreeType.values()) {
                types.add(((PlantAPI.TreeType)enum_).func_176610_l());
            }
        }
        int counter = 0;
        for (String type : types) {
            this.add(counter, folder + "/", "door_" + type, "door." + type);
            this.add(10 + counter, folder + "/", "trapdoor_" + type, "trapdoor." + type);
            this.add(20 + counter, folder + "/", "gate_" + type, "gate." + type);
            this.add(30 + counter, folder + "/", "fence_" + type, "fence." + type);
            this.add(40 + counter, folder + "/", "stairs_" + type, "stairs." + type);
            this.add(50 + counter, folder + "/", "slab_" + type, "slab." + type);
            ++counter;
        }
        if (this.nameId.toLowerCase().contains("cloud")) {
            this.add(110, folder + "/", "vapor", "vapor");
            this.add(120, folder + "/", "vapor_glow", "vapor.glow");
        } else {
            this.add(110, folder + "/", "paper", "paper");
            this.add(120, "", "item_glowpaper", "paper.glow");
        }
    }
}

