/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.FuelHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemMulti;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.entity.EntityCloudPainting;
import shetiphian.terraqueous.common.entity.EntityEarthPainting;
import shetiphian.terraqueous.common.entity.EntityPaintingBase;

public class ItemMain
extends ItemMulti
implements FuelHelper.IFuel {
    public ItemMain() {
        super("ItemMain", Values.nameMapper);
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        int count;
        for (count = 0; count < 6; ++count) {
            list.add(new ItemStack(item, 1, count));
        }
        for (count = 0; count < 2; ++count) {
            list.add(new ItemStack(item, 1, 50 + count));
        }
        for (count = 0; count < 10; ++count) {
            list.add(new ItemStack(item, 1, 100 + count));
        }
        for (count = 0; count < 17; ++count) {
            list.add(new ItemStack(item, 1, 200 + count));
        }
        for (count = 0; count < 4; ++count) {
            list.add(new ItemStack(item, 1, 250 + count));
        }
        if (Settings.INSTANCE.showTurtleColorizerUpgrade) {
            list.add(new ItemStack(item, 1, 1000));
        }
        if (Settings.INSTANCE.showRobotColorizerUpgrade) {
            list.add(new ItemStack(item, 1, 1002));
        }
    }

    public static void openScroll(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player == null) {
            return;
        }
        if (stack.func_77952_i() == 477) {
            if (Values.blockCrafting == null || Values.blockEarthOre == null) {
                Localization.addChat((EntityPlayer)player, (String)Localization.get((String)"info.terraqueous.missingblocks.txt"));
            } else {
                player.openGui((Object)Terraqueous.INSTANCE, 5, world, 0, 0, 0);
            }
            Terraqueous.proxy.resetEquippedProgress(hand);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player != null && stack.func_77952_i() == 477) {
            ItemMain.openScroll(stack, world, player, hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        switch (stack.func_77952_i()) {
            case 1: {
                return this.placePainting(stack, player, world, pos, facing, "CLOUD") ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            case 2: {
                return this.placePainting(stack, player, world, pos, facing, "EARTH") ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
            }
            case 109: {
                if (Values.blockEnderTable == null || world.func_180495_p(pos).func_177230_c() != Blocks.field_150381_bn) break;
                --stack.field_77994_a;
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockEnderTable.func_176223_P(), (boolean)true);
                Function.giveItem((EntityPlayer)player, (ItemStack)new ItemStack(Items.field_151122_aG));
                return EnumActionResult.SUCCESS;
            }
            case 477: {
                return EnumActionResult.FAIL;
            }
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    private boolean placePainting(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, String type) {
        EntityPaintingBase entity;
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        BlockPos placePos = pos.func_177972_a(side);
        if (!player.func_175151_a(placePos, side, stack)) {
            return false;
        }
        EntityPaintingBase entityPaintingBase = entity = type.equals("CLOUD") ? new EntityCloudPainting(world, placePos, side) : new EntityEarthPainting(world, placePos, side);
        if (entity.func_70518_d()) {
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entity);
            }
            --stack.field_77994_a;
            return true;
        }
        return false;
    }

    public boolean isBeaconPayment(ItemStack stack) {
        return stack.func_77952_i() == 50 || stack.func_77952_i() == 51;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return stack.func_77952_i() == 109 ? EnumRarity.UNCOMMON : super.func_77613_e(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        int damage = stack.func_77952_i();
        if (damage == 477) {
            tooltip.add(Localization.get((String)"info.terraqueous.stormscroll.txt"));
        } else if (damage == 1001) {
            Localization.multiLine((String)"info.terraqueous.turtleupgrade.visual.msg", tooltip);
        }
    }

    public float getItemsSmeltedPerFuel(ItemStack stack) {
        switch (stack.func_77952_i()) {
            case 50: {
                return 15.0f;
            }
            case 250: {
                return 3.5f;
            }
            case 251: {
                return 14.0f;
            }
            case 206: {
                return 2.0f;
            }
            case 207: {
                return 8.0f;
            }
        }
        return 0.0f;
    }

    protected void addToNameMap() {
        this.add(0, "main/", "paint_brush", "painting.brush");
        this.add(1, "main/", "painting_cloud", "painting.cloud");
        this.add(2, "main/", "painting_earth", "painting.earth");
        this.add(3, "main/", "talisman_cloud_unbaked", "talisman.cloud.unbaked");
        this.add(4, "main/", "talisman_cloud_baked", "talisman.cloud.baked");
        this.add(5, "main/", "talisman_cloud_assembled", "talisman.cloud.assembled");
        this.add(50, "main/", "gem_burnium", "gem.burnium");
        this.add(51, "main/", "gem_endimium", "gem.endimium");
        this.add(100, "main/", "leather_scraps", "leather.scraps");
        this.add(101, "main/", "leather_boot1", "leather.boot1");
        this.add(102, "main/", "leather_boot2", "leather.boot2");
        this.add(103, "main/", "leather_belt", "leather.belt");
        this.add(104, "main/", "dyepowder_black", "dye.black");
        this.add(105, "main/", "dyepowder_brown", "dye.brown");
        this.add(106, "main/", "dyepowder_blue", "dye.blue");
        this.add(107, "main/", "dyepowder_white", "dye.white");
        this.add(108, "main/", "glass_shard", "glass_shard");
        this.add(109, "main/", "ender_book", "enderbook");
        this.add(200, "main/", "dust_ender_tiny", "dust.tiny_ender");
        this.add(201, "main/", "dust_ender", "dust.ender");
        this.add(202, "main/", "dust_iron_tiny", "dust.tiny_iron");
        this.add(203, "main/", "dust_iron", "dust.iron");
        this.add(204, "main/", "dust_gold_tiny", "dust.tiny_gold");
        this.add(205, "main/", "dust_gold", "dust.gold");
        this.add(206, "main/", "dust_coal_tiny", "dust.tiny_coal");
        this.add(207, "main/", "dust_coal", "dust.coal");
        this.add(208, "main/", "dust_diamond_tiny", "dust.tiny_diamond");
        this.add(209, "main/", "dust_diamond", "dust.diamond");
        this.add(210, "main/", "dust_emerald_tiny", "dust.tiny_emerald");
        this.add(211, "main/", "dust_emerald", "dust.emerald");
        this.add(212, "main/", "dust_lapis_tiny", "dust.tiny_lapis");
        this.add(213, "main/", "dust_redstone_tiny", "dust.tiny_redstone");
        this.add(214, "main/", "lump_sandstone", "lump.sandstone");
        this.add(215, "main/", "lump_gravel", "lump.gravel");
        this.add(216, "main/", "lump_redsandstone", "lump.red_sandstone");
        this.add(250, "main/", "dust_burnium_tiny", "dust.tiny_burnium");
        this.add(251, "main/", "dust_burnium", "dust.burnium");
        this.add(252, "main/", "dust_endimium_tiny", "dust.tiny_endimium");
        this.add(253, "main/", "dust_endimium", "dust.endimium");
        this.add(477, "main/", "storm_scroll", "stormscroll");
        this.add(500, "main/", "storm_scroll", "waila.stormforge");
        this.add(1000, "main/", "turtle_colorizer_left", "turtle.colorizer");
        this.add(1001, "main/", "turtle_colorizer_right", "turtle.colorizer");
        this.add(1002, "main/", "robot_colorizer", "robot.colorizer");
    }
}

