/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.MyDamageSource;
import shetiphian.core.common.item.ItemToolWithDamageSource;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.item.IToolMode;

public class ItemMultiTool
extends ItemToolWithDamageSource
implements IToolMode {
    private static final Material[] needsShovel = new Material[]{Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B};
    private static final Material[] needsPick = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151574_g, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E};
    private static List<String> cacheIngot = new ArrayList<String>();
    private static HashMap<Integer, Integer> expMap = new HashMap();

    public ItemMultiTool() {
        super(3.0f, -1.0f, Item.ToolMaterial.IRON, Values.damageMultiTool);
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
        this.field_77777_bU = 1;
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{CreativeTabs.field_78040_i, Values.tabTerraqueous};
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add(ItemMultiTool.newTool(type));
        }
    }

    public static ItemStack newTool(EnumType type) {
        ItemStack itemStack = new ItemStack(Values.itemMultiTool);
        itemStack.func_77982_d(new NBTTagCompound());
        itemStack.func_77978_p().func_74778_a("tool", type.toString());
        return itemStack;
    }

    public static EnumType getEnumType(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74778_a("tool", EnumType.PICKAXE.toString());
        }
        return EnumType.byName(stack.func_77978_p().func_74779_i("tool"));
    }

    private ItemStack setType(ItemStack stack, EnumType type) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("tool", type.toString());
        return stack;
    }

    @Override
    public boolean changeMode(EntityPlayer player, ItemStack stack, boolean next) {
        EnumType type;
        if (stack != null && stack.func_77973_b() instanceof ItemMultiTool && (type = ItemMultiTool.getEnumType(stack)) != EnumType.BROKEN) {
            int value = type.getValue() + (next ? -1 : 1);
            this.setType(stack, EnumType.byValue(value));
            return true;
        }
        return false;
    }

    private static void setMakeSound(ItemStack stack, boolean sound) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74757_a("sound", sound);
    }

    private static boolean getMakeSound(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74757_a("sound", false);
        }
        return stack.func_77978_p().func_74767_n("sound");
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + ItemMultiTool.getEnumType(stack).toString();
    }

    private Item getToolTypeItem(ItemStack stack) {
        switch (ItemMultiTool.getEnumType(stack)) {
            case HOE: {
                return Items.field_151012_L;
            }
            case PICKAXE: {
                return Items.field_151046_w;
            }
            case SHOVEL: {
                return Items.field_151047_v;
            }
            case WEAPON: {
                return Items.field_151048_u;
            }
        }
        return Items.field_151055_y;
    }

    private ItemStack getToolTypeStack(ItemStack stack) {
        return new ItemStack(this.getToolTypeItem(stack));
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.getToolTypeItem(stack).func_150897_b(state);
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        ItemStack tool = this.getToolTypeStack(stack);
        return tool.func_77973_b().func_150893_a(tool, state) * 1.5f;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        ItemStack tool = this.getToolTypeStack(stack);
        return tool.func_77973_b().getToolClasses(tool);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        ItemStack tool = this.getToolTypeStack(stack);
        return tool.func_77973_b().getHarvestLevel(tool, toolClass);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumActionResult toolResult = EnumActionResult.PASS;
        ItemStack tool = this.getToolTypeStack(stack);
        if (player.func_70093_af()) {
            return tool.func_77973_b().func_180614_a(tool, player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        for (int sX = -1; sX < 2; sX = (int)((byte)(sX + 1))) {
            for (int sZ = -1; sZ < 2; sZ = (int)((byte)(sZ + 1))) {
                if (tool.func_77973_b().func_180614_a(tool, player, world, pos.func_177982_a(sX, 0, sZ), hand, facing, hitX, hitY, hitZ) != EnumActionResult.SUCCESS) continue;
                toolResult = EnumActionResult.SUCCESS;
            }
        }
        return toolResult;
    }

    public float getBreakSpeed(ItemStack stack, EntityPlayer player, IBlockState state, float original, BlockPos pos) {
        EnumType type = ItemMultiTool.getEnumType(stack);
        if (type == EnumType.PICKAXE || type == EnumType.SHOVEL) {
            if (player.func_70093_af() || !this.isToolEffective(player.field_70170_p, pos, player.field_70170_p.func_180495_p(pos), stack)) {
                return original;
            }
            List<BlockPos> blockPosList = this.getBlocksToHarvest(stack, player, pos);
            if (blockPosList.isEmpty()) {
                return original;
            }
            float baseHardness = state.func_185887_b(player.field_70170_p, pos);
            float blockSpeed = original;
            float blockHardness = baseHardness;
            for (BlockPos sPos : blockPosList) {
                IBlockState sState = player.field_70170_p.func_180495_p(sPos);
                blockSpeed += player.getDigSpeed(sState, sPos);
                blockHardness += sState.func_185887_b(player.field_70170_p, sPos);
            }
            return blockSpeed / blockHardness / ((float)blockPosList.size() - 0.75f) * baseHardness;
        }
        return original;
    }

    private List<BlockPos> getBlocksToHarvest(ItemStack stack, EntityPlayer player, BlockPos pos) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        RayTraceResult mop = this.func_77621_a(player.field_70170_p, player, false);
        if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            EnumFacing facing = mop.field_178784_b;
            for (int row = -1; row < 2; row = (int)((byte)(row + 1))) {
                block6: for (int col = -1; col < 2; col = (int)((byte)(col + 1))) {
                    BlockPos sPos;
                    if (row == 0 && col == 0) continue;
                    switch (facing) {
                        case DOWN: 
                        case UP: {
                            sPos = pos.func_177982_a(row, 0, col);
                            break;
                        }
                        case NORTH: 
                        case SOUTH: {
                            sPos = pos.func_177982_a(row, col, 0);
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            sPos = pos.func_177982_a(0, row, col);
                            break;
                        }
                        default: {
                            continue block6;
                        }
                    }
                    if (!player.func_175151_a(sPos, facing, stack) || player.field_70170_p.func_175623_d(sPos) || !this.isToolEffective(player.field_70170_p, sPos, player.field_70170_p.func_180495_p(sPos), stack)) continue;
                    blockPosList.add(sPos);
                }
            }
        }
        return blockPosList;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity) {
        EnumType type;
        EnumType preType = ItemMultiTool.getEnumType(stack);
        float baseHardness = state.func_177230_c().func_176195_g(state, world, pos);
        if ((double)baseHardness != 0.0) {
            stack.func_77972_a(1, entity);
        }
        if (preType != (type = ItemMultiTool.getEnumType(stack)) && type == EnumType.BROKEN) {
            entity.func_70669_a(stack);
        }
        if (type != EnumType.PICKAXE && type != EnumType.SHOVEL || world.field_72995_K || !(entity instanceof EntityPlayerMP)) {
            return true;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        if (!player.field_71075_bZ.field_75098_d) {
            ItemMultiTool.setMakeSound(stack, true);
        }
        if (player.func_70093_af() || !this.isToolEffective(world, pos, world.func_180495_p(pos), stack)) {
            return true;
        }
        List<BlockPos> blockPosList = this.getBlocksToHarvest(stack, (EntityPlayer)player, pos);
        if (!blockPosList.isEmpty()) {
            for (BlockPos sPos : blockPosList) {
                boolean flag1;
                int exp;
                IBlockState sState = world.func_180495_p(sPos);
                int sId = Block.func_176210_f((IBlockState)sState);
                if (expMap.containsKey(sId)) {
                    exp = expMap.get(sId);
                } else {
                    exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)sPos);
                    expMap.put(sId, exp);
                }
                if (exp == -1) continue;
                TileEntity sTile = world.func_175625_s(sPos);
                if (player.field_71075_bZ.field_75098_d) {
                    flag1 = this.removeBlock(world, sPos, (EntityPlayer)player, false);
                    player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, sPos));
                } else {
                    boolean flag = sState.func_177230_c().canHarvestBlock((IBlockAccess)world, sPos, (EntityPlayer)player);
                    flag1 = this.removeBlock(world, sPos, (EntityPlayer)player, flag);
                    if (flag1 && flag) {
                        sState.func_177230_c().func_180657_a(world, (EntityPlayer)player, sPos, sState, sTile, stack);
                    }
                }
                if (player.field_71075_bZ.field_75098_d || !flag1 || exp <= 0) continue;
                sState.func_177230_c().func_180637_b(world, sPos, exp);
            }
        }
        return true;
    }

    private boolean isToolEffective(World world, BlockPos pos, IBlockState state, ItemStack stack) {
        Block block = state.func_177230_c();
        state = block.func_176221_a(state, (IBlockAccess)world, pos);
        String tool = block.getHarvestTool(state);
        int level = block.getHarvestLevel(state);
        if (Strings.isNullOrEmpty((String)tool)) {
            level = 0;
            Material material = block.func_149688_o(state);
            for (Material sMatt : needsShovel) {
                if (material != sMatt) continue;
                tool = "shovel";
                break;
            }
            if (Strings.isNullOrEmpty((String)tool)) {
                for (Material pMatt : needsPick) {
                    if (material != pMatt) continue;
                    tool = "pickaxe";
                    break;
                }
            }
        }
        if (!Strings.isNullOrEmpty((String)tool)) {
            for (String type : this.getToolClasses(stack)) {
                if (!type.equals(tool) || this.getHarvestLevel(stack, tool) < level) continue;
                return true;
            }
        }
        return false;
    }

    private boolean removeBlock(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().func_176208_a(world, pos, state, player);
        boolean flag = state.func_177230_c().removedByPlayer(state, world, pos, player, canHarvest);
        if (flag) {
            state.func_177230_c().func_176206_d(world, pos, state);
        }
        return flag;
    }

    public static void handleDrops(ItemStack stack, EntityPlayer player, List<ItemStack> drops) {
        EnumType type = ItemMultiTool.getEnumType(stack);
        if (type == EnumType.BROKEN) {
            return;
        }
        boolean hasSilkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
        int fortuneBase = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
        boolean playsound = false;
        float exp = 0.0f;
        for (ItemStack drop : drops) {
            ItemStack smelted;
            if (!hasSilkTouch && type == EnumType.PICKAXE && drop != null && (smelted = FurnaceRecipes.func_77602_a().func_151395_a(drop)) != null) {
                ResourceLocation id;
                String smeltedId;
                drop = smelted.func_77946_l();
                exp += FurnaceRecipes.func_77602_a().func_151398_b(drop);
                if (cacheIngot.isEmpty()) {
                    ItemMultiTool.buildIngotCache();
                }
                if (cacheIngot.contains(smeltedId = (id = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)smelted.func_77973_b())).toString() + "@" + smelted.func_77952_i())) {
                    drop = smelted.func_77946_l();
                    int fortuneRemaining = fortuneBase;
                    int attempt = 0;
                    while ((double)attempt < Math.ceil(fortuneBase / 3)) {
                        int chance = (fortuneRemaining >= 3 ? 3 : fortuneRemaining) * 3;
                        if (chance > player.field_70170_p.field_73012_v.nextInt(10) + 1) {
                            drop.field_77994_a += smelted.field_77994_a;
                        }
                        fortuneRemaining -= 3;
                        ++attempt;
                    }
                }
            }
            if (!Function.giveItem((EntityPlayer)player, (ItemStack)drop, null) || playsound) continue;
            playsound = true;
        }
        if (playsound && ItemMultiTool.getMakeSound(stack)) {
            ItemMultiTool.setMakeSound(stack, false);
            player.func_184185_a(SoundEvents.field_187534_aX, 0.4f, (float)player.field_70170_p.field_73012_v.nextInt(3) / 10.0f + 0.4f);
        }
        if ((int)exp > 0) {
            player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, (int)exp));
        }
        drops.clear();
    }

    private static void buildIngotCache() {
        String[] names;
        for (String name : names = OreDictionary.getOreNames()) {
            if (Strings.isNullOrEmpty((String)name) || !name.startsWith("ingot")) continue;
            for (ItemStack stack : OreDictionary.getOres((String)name)) {
                ResourceLocation id = GameData.getItemRegistry().getNameForObject((IForgeRegistryEntry)stack.func_77973_b());
                String stackId = id.toString() + "@" + stack.func_77952_i();
                cacheIngot.add(stackId);
            }
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage < this.getDamage(stack) && ItemMultiTool.getEnumType(stack) == EnumType.BROKEN) {
            this.setType(stack, EnumType.PICKAXE);
        }
        if (damage > this.func_77612_l()) {
            damage = this.func_77612_l();
            this.setType(stack, EnumType.BROKEN);
        }
        super.setDamage(stack, damage);
    }

    protected float getBonusDamage(EntityPlayer player, Entity victim, MyDamageSource source, float damage, float bonusDamage) {
        ItemStack stack = player.func_184614_ca();
        return bonusDamage + (stack != null && stack.func_77973_b() == this && ItemMultiTool.getEnumType(stack) == EnumType.WEAPON ? damage / 3.0f : 0.0f);
    }

    protected void postHurtEntity(EntityPlayer player, Entity victim, MyDamageSource source) {
        EnumType type;
        ItemStack stack = player.func_184614_ca();
        if (stack != null && stack.func_77973_b() == this && ((type = ItemMultiTool.getEnumType(stack)) == EnumType.WEAPON || type == EnumType.PICKAXE)) {
            victim.func_70015_d(4);
        }
        super.postHurtEntity(player, victim, source);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        tooltip.add(Localization.get((String)"info.terraqueous.multitool.txt"));
    }

    public static enum EnumType {
        PICKAXE(0),
        SHOVEL(1),
        HOE(2),
        WEAPON(3),
        BROKEN(4);

        private static EnumType[] array;
        private static final Map<String, EnumType> map;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            return array[value < 0 ? 3 : (value > 3 ? 0 : value)];
        }

        public static EnumType byName(String name) {
            return map.containsKey(name = name.toLowerCase().trim()) ? map.get(name) : PICKAXE;
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            map = new HashMap<String, EnumType>();
            map.clear();
            array = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
                map.put(value.toString(), value);
            }
        }
    }
}

