/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.block.BlockHay;
import shetiphian.terraqueous.common.item.ItemBlockTreeTrunk;
import shetiphian.terraqueous.common.item.ItemMain;
import shetiphian.terraqueous.common.item.ItemMultiTool;
import shetiphian.terraqueous.common.item.ItemScythe;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;
import shetiphian.terraqueous.common.misc.CraftingHandler;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;
import shetiphian.terraqueous.common.misc.HayHelper;

public class EventHandler {
    private static LootEntryItem getEntry(ItemStack stack, int min, int max, int weight, String entryName) {
        if (stack == null) {
            stack = new ItemStack(Items.field_151155_ap);
        }
        LootCondition[] conditions = new LootCondition[]{};
        LootFunction[] functions = new LootFunction[stack.func_77942_o() ? 3 : 2];
        functions[0] = new SetMetadata(conditions, new RandomValueRange((float)stack.func_77952_i(), (float)stack.func_77952_i()));
        functions[1] = new SetCount(conditions, new RandomValueRange((float)min, (float)max));
        if (stack.func_77942_o()) {
            functions[2] = new SetNBT(conditions, stack.func_77978_p());
        }
        return new LootEntryItem(stack.func_77973_b(), weight, 0, functions, conditions, entryName);
    }

    private static LootEntryItem getToolEntry(ItemStack stack, float dmgMin, float dmgMax, int weight, String entryName) {
        if (stack == null) {
            stack = new ItemStack(Items.field_151055_y);
        }
        LootCondition[] conditions = new LootCondition[]{};
        LootFunction[] functions = new LootFunction[stack.func_77942_o() ? 2 : 1];
        functions[0] = new SetDamage(conditions, new RandomValueRange(dmgMin, dmgMax));
        if (stack.func_77942_o()) {
            functions[1] = new SetNBT(conditions, stack.func_77978_p());
        }
        return new LootEntryItem(stack.func_77973_b(), weight, 0, functions, conditions, entryName);
    }

    public static class ForgeEventBus {
        private boolean lastCloudTalismanCheck;
        private Map<String, String> mapHeadLookup = null;
        private List<UUID> breakCache = new ArrayList<UUID>();

        @SubscribeEvent
        public void entityConstructingEvent(EntityEvent.EntityConstructing event) {
            if (event.getEntity() instanceof EntityPlayer) {
                ((EntityPlayer)event.getEntity()).func_110140_aT().func_111150_b(DeathFruitHelper.dfAddiction);
                ((EntityPlayer)event.getEntity()).func_110140_aT().func_111150_b(DeathFruitHelper.dfTimer);
            }
        }

        @SubscribeEvent
        public void itemCraftedEvent(PlayerEvent.ItemCraftedEvent event) {
            CraftingHandler.INSTANCE.onCrafting(event.crafting, event.craftMatrix);
        }

        @SubscribeEvent
        public void onBlockBreakEvent(BlockEvent.BreakEvent event) {
            ItemStack stack;
            if (event.getPlayer().field_71075_bZ.field_75098_d && (stack = event.getPlayer().func_184614_ca()) != null && stack.func_77973_b() instanceof ItemScythe) {
                if (stack.func_77973_b().onBlockStartBreak(stack, event.getPos(), event.getPlayer())) {
                    return;
                }
                stack.func_179548_a(event.getWorld(), event.getWorld().func_180495_p(event.getPos()), event.getPos(), event.getPlayer());
            }
        }

        @SubscribeEvent
        public void harvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
            if (event.isSilkTouching() || event.getDrops() == null || event.getDrops().isEmpty()) {
                return;
            }
            Block eBlock = event.getState().func_177230_c();
            if (eBlock == Blocks.field_150398_cm) {
                ItemStack seed;
                if (Values.blockTallGrass != null && event.getState().func_177230_c().func_176201_c(event.getState()) == 2 && event.getWorld().field_73012_v.nextInt(8) == 0 && (seed = ForgeHooks.getGrassSeed((Random)event.getWorld().field_73012_v, (int)event.getFortuneLevel())) != null) {
                    event.getDrops().add(seed);
                }
                return;
            }
            if (Settings.INSTANCE.enableGlassShardDrops && Values.itemMain != null) {
                if (eBlock == Blocks.field_150359_w || eBlock == Blocks.field_150399_cn) {
                    event.getDrops().add(Values.stacks.get("glass_shard", new int[]{event.getWorld().field_73012_v.nextInt(2) + 3}));
                } else if (eBlock == Blocks.field_150410_aZ || eBlock == Blocks.field_150397_co) {
                    event.getDrops().add(Values.stacks.get("glass_shard", new int[0]));
                }
            }
            if (event.getHarvester() == null) {
                return;
            }
            EntityPlayer player = event.getHarvester();
            if (Values.itemMultiTool != null && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == Values.itemMultiTool) {
                ItemMultiTool.handleDrops(player.func_184614_ca(), player, event.getDrops());
            }
        }

        @SubscribeEvent
        public void livingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntityLiving().field_70170_p.field_72995_K) {
                if (Values.itemCloudTalisman != null && event.getEntityLiving() instanceof EntityPlayer) {
                    boolean hasTalisman;
                    EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                    ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
                    boolean bl = hasTalisman = chest != null && chest.func_77973_b() == Values.itemCloudTalisman;
                    if (hasTalisman && !this.lastCloudTalismanCheck) {
                        CloudAPI.grantCloudWalk(player, "Armor:CloudTalisman");
                        this.lastCloudTalismanCheck = true;
                    } else if (!hasTalisman && this.lastCloudTalismanCheck) {
                        CloudAPI.revokeCloudWalk(player, "Armor:CloudTalisman");
                        this.lastCloudTalismanCheck = false;
                    }
                }
                return;
            }
            if (event.getEntityLiving() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntityLiving();
                if (BlueFlowerHandler.INSTANCE.blueContains(Function.getEntityName((EntityLivingBase)player))) {
                    BlueFlowerHandler.INSTANCE.blueUpdate(player);
                }
                DeathFruitHelper.INSTANCE.onPlayerUpdate(player);
            } else if (event.getEntityLiving() instanceof EntityChicken) {
                if (!Settings.INSTANCE.enableMobDropTweaks) {
                    return;
                }
                EntityChicken chicken = (EntityChicken)event.getEntityLiving();
                if (chicken.field_70887_j == 12000 || chicken.field_70887_j == 9000 || chicken.field_70887_j == 6000 || chicken.field_70887_j == 3000) {
                    int chance = 12000;
                    switch (chicken.field_70887_j) {
                        case 12000: {
                            chance = event.getEntityLiving().field_70170_p.field_73012_v.nextInt(1);
                            break;
                        }
                        case 9000: {
                            chance = event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2);
                            break;
                        }
                        case 6000: {
                            chance = event.getEntityLiving().field_70170_p.field_73012_v.nextInt(4);
                            break;
                        }
                        case 3000: {
                            chance = event.getEntityLiving().field_70170_p.field_73012_v.nextInt(8);
                        }
                    }
                    if (chance == 0) {
                        chicken.func_145779_a(Items.field_151008_G, 1);
                    }
                }
            }
        }

        private Map<String, String> buildHeadLookup() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Creeper", "MHF_Creeper");
            map.put("Skeleton", "MHF_Skeleton");
            map.put("Spider", "MHF_Spider");
            map.put("Giant", "MHF_Zombie");
            map.put("Zombie", "MHF_Zombie");
            map.put("Slime", "MHF_Slime");
            map.put("Ghast", "MHF_Ghast");
            map.put("PigZombie", "MHF_PigZombie");
            map.put("Enderman", "MHF_Enderman");
            map.put("CaveSpider", "MHF_CaveSpider");
            map.put("Blaze", "MHF_Blaze");
            map.put("LavaSlime", "MHF_LavaSlime");
            map.put("EnderDragon", "MHF_EnderDragon");
            map.put("WitherBoss", "MHF_Wither");
            map.put("Witch", "MHF_Witch");
            map.put("Pig", "MHF_Pig");
            map.put("Sheep", "MHF_Sheep");
            map.put("Cow", "MHF_Cow");
            map.put("Chicken", "MHF_Chicken");
            map.put("Squid", "MHF_Squid");
            map.put("Wolf", "MHF_Wolf");
            map.put("MushroomCow", "MHF_MushroomCow");
            map.put("Ocelot", "MHF_Ocelot");
            map.put("VillagerGolem", "MHF_Golem");
            map.put("Villager", "MHF_Villager");
            return map;
        }

        private ItemStack getMobHead(String texture, String name) {
            ItemStack skull;
            if (texture.equals("MHF_Skeleton")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 0);
            } else if (texture.equals("MHF_WSkeleton")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 1);
            } else if (texture.equals("MHF_Zombie")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 2);
            } else if (texture.equals("MHF_Creeper")) {
                skull = new ItemStack(Items.field_151144_bL, 1, 4);
            } else {
                skull = new ItemStack(Items.field_151144_bL, 1, 3);
                String nbt = "{SkullOwner:" + texture;
                if (!Strings.isNullOrEmpty((String)name)) {
                    nbt = nbt + ", display:{Name:" + name + "}";
                }
                nbt = nbt + "}";
                NBTTagCompound nbtbase = null;
                try {
                    nbtbase = JsonToNBT.func_180713_a((String)nbt);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (nbtbase == null) {
                    skull = null;
                }
                if (skull != null) {
                    skull.func_77982_d(nbtbase);
                }
            }
            return skull;
        }

        @SubscribeEvent
        public void livingDeathEvent(LivingDeathEvent event) {
            if (event.getEntityLiving().field_70170_p.field_72995_K) {
                return;
            }
            Random rand = event.getEntityLiving().field_70170_p.field_73012_v;
            if (event.getSource() == Values.damageScythe) {
                ItemStack stack;
                ItemStack stack2;
                EntityLivingBase attacker = event.getEntityLiving().func_110144_aD();
                if (attacker.field_70163_u <= event.getEntityLiving().field_70163_u || attacker.field_70163_u - event.getEntityLiving().field_70163_u > 2.0) {
                    return;
                }
                int fortune = 0;
                if (attacker instanceof EntityPlayer && (stack2 = attacker.func_184614_ca()) != null && stack2.func_77973_b() instanceof ItemScythe && !ItemScythe.isSickle(stack2)) {
                    fortune = MathHelper.func_76125_a((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack2), (int)0, (int)5);
                }
                int chance = rand.nextInt(101 - fortune * 20);
                if (fortune < 1 || chance > 0) {
                    return;
                }
                if (this.mapHeadLookup == null) {
                    this.mapHeadLookup = this.buildHeadLookup();
                }
                if ((stack = event.getEntityLiving() instanceof EntityPlayer ? this.getMobHead(this.mapHeadLookup.get(Function.getEntityName((EntityLivingBase)event.getEntityLiving())), null) : this.getMobHead(this.mapHeadLookup.get(EntityList.func_75621_b((Entity)event.getEntityLiving())), Function.getEntityName((EntityLivingBase)event.getEntityLiving()) + " Head")) != null) {
                    Function.dropItem((World)event.getEntityLiving().field_70170_p, (BlockPos)new BlockPos(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v), (ItemStack)stack);
                }
            }
            if (Settings.INSTANCE.enableMobDropTweaks) {
                ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
                if (Values.itemMain != null) {
                    String[] itemsEnder;
                    ItemStack stack;
                    if (event.getEntityLiving() instanceof EntityBlaze || event.getEntityLiving() instanceof EntityMagmaCube || event.getEntityLiving() instanceof EntityPigZombie) {
                        String[] itemsNether;
                        ItemStack stack3;
                        if (event.getEntityLiving().field_70170_p.field_73012_v.nextInt(25) == 0 && (stack3 = Values.stacks.get((itemsNether = new String[]{"burnium_tinydust", "burnium_dust", "coal_tinydust", "coal_dust"})[rand.nextInt(4)], new int[0])) != null) {
                            drops.add(stack3);
                        }
                    } else if (event.getEntityLiving() instanceof EntityZombie) {
                        String[] itemsZombie = new String[]{"leather_boot1", "leather_boot2", "leather_belt"};
                        for (int item = 0; item < 3; item = (int)((byte)(item + 1))) {
                            ItemStack stack4;
                            if (rand.nextInt(3) != 0 || (stack4 = Values.stacks.get(itemsZombie[item], new int[0])) == null) continue;
                            drops.add(stack4);
                        }
                    } else if (event.getEntityLiving() instanceof EntityEnderman && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(25) == 0 && (stack = Values.stacks.get((itemsEnder = new String[]{"endimium_tinydust", "endimium_dust", "ender_tinydust", "ender_dust"})[rand.nextInt(4)], new int[0])) != null) {
                        drops.add(stack);
                    }
                } else if (event.getEntityLiving() instanceof EntitySkeleton && event.getEntityLiving().field_70170_p.field_73012_v.nextInt(200) == 0) {
                    drops.add(new ItemStack(Items.field_151153_ao));
                }
                if (!drops.isEmpty()) {
                    for (ItemStack item : drops) {
                        event.getEntityLiving().func_70099_a(item, 0.5f);
                    }
                }
            }
        }

        @SubscribeEvent
        public void useHoeEvent(UseHoeEvent event) {
            BlockFlowerPot.EnumType type;
            IBlockState state = event.getWorld().func_180495_p(event.getPos());
            if (state != null && state.func_177230_c() == Values.blockFlowerPot && (type = BlockFlowerPot.getEnumType(state)) == BlockFlowerPot.EnumType.PLANTER_DIRT) {
                Function.setBlock((World)event.getWorld(), (BlockPos)event.getPos(), (IBlockState)BlockFlowerPot.EnumType.PLANTER_FARM.state(), (boolean)true);
                event.getWorld().func_184133_a(event.getEntityPlayer(), event.getPos(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.setResult(Event.Result.ALLOW);
            }
        }

        @SubscribeEvent
        public void playerItemPickup(PlayerEvent.ItemPickupEvent event) {
            ItemStack stack;
            if (event.player != null && event.pickedUp != null && (stack = event.pickedUp.func_92059_d()) != null && stack.func_77973_b() instanceof ItemBlockTreeTrunk) {
                event.player.func_71029_a((StatBase)AchievementList.field_187983_g);
            }
        }

        @SubscribeEvent
        public void playerRightClickAir(PlayerInteractEvent.RightClickItem event) {
            int tickrate;
            Function.BlockInfo info;
            if (event.getEntityPlayer() == null || event.getItemStack() == null) {
                return;
            }
            if (Values.blockHay != null && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150329_H) && (info = Function.getBlockInfront((World)event.getEntityPlayer().field_70170_p, (EntityPlayer)event.getEntityPlayer(), (double)5.0)) != null && info.face == EnumFacing.UP && (tickrate = HayHelper.getTickRate(event.getEntityPlayer().field_70170_p, info.pos)) > 0) {
                Function.setBlock((World)event.getEntityPlayer().field_70170_p, (BlockPos)info.pos.func_177984_a(), (IBlockState)BlockHay.EnumType.LOOSE_GRASS.state(), (boolean)true);
                event.getEntityPlayer().field_70170_p.func_175684_a(info.pos.func_177984_a(), Values.blockHay, tickrate);
                event.getEntityPlayer().func_184609_a(event.getHand());
                if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                    --event.getItemStack().field_77994_a;
                }
            }
            if (Values.itemMain != null && event.getItemStack().func_77973_b() == Values.itemMain && event.getItemStack().func_77952_i() == 501) {
                ItemMain.openScroll(event.getItemStack(), event.getWorld(), event.getEntityPlayer(), event.getHand());
            }
        }

        @SubscribeEvent
        public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            if (event.getEntityPlayer() == null) {
                return;
            }
            IBlockState state = event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos());
            Block block = state.func_177230_c();
            if (event.getItemStack() == null) {
                return;
            }
            if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150329_H) && Values.blockTallGrass != null && event.getItemStack().func_77952_i() == 1 && Values.blockTallGrass.func_176196_c(event.getEntityPlayer().field_70170_p, event.getPos().func_177984_a()) && event.getEntityPlayer().field_70170_p.field_73012_v.nextBoolean()) {
                Function.setBlock((World)event.getEntityPlayer().field_70170_p, (BlockPos)event.getPos().func_177984_a(), (IBlockState)Values.blockTallGrass.func_176203_a(1), (boolean)true);
                if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                    --event.getItemStack().field_77994_a;
                }
                if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
                    event.setCanceled(true);
                }
                return;
            }
            if (!event.getEntityPlayer().func_70093_af()) {
                return;
            }
            Boolean activate = false;
            if (block == Values.blockEnderTable && event.getItemStack().func_77973_b() == Items.field_151122_aG) {
                activate = true;
            }
            if ((block == Values.blockFlowerPot || block == Values.blockTypeCloud || block == Values.blockTypeEarth) && CraftingHandler.INSTANCE.isDye(event.getItemStack())) {
                activate = true;
            }
            if (activate.booleanValue()) {
                block.func_180639_a(event.getEntityPlayer().field_70170_p, event.getPos(), state, event.getEntityPlayer(), event.getHand(), event.getItemStack(), event.getFace(), 0.5f, 0.5f, 0.5f);
            }
        }

        @SubscribeEvent
        public void prePopulateChunkEvent(PopulateChunkEvent.Pre event) {
            if (Values.blockTallGrass == null) {
                return;
            }
            Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
            for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
                if (storage == null) continue;
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            IBlockState state = storage.func_177485_a(x, y, z);
                            if (state.func_177230_c() != Blocks.field_150329_H || state.func_177230_c().func_176201_c(state) != 1 || !Function.random.nextBoolean()) continue;
                            storage.func_177484_a(x, y, z, Values.blockTallGrass.func_176223_P());
                        }
                    }
                }
            }
            chunk.func_177427_f(true);
        }

        @SubscribeEvent
        public void lootTableLoadEvent(LootTableLoadEvent event) {
            LootPool pool = event.getTable().getPool("main");
            if (pool == null) {
                return;
            }
            if (event.getName().equals((Object)LootTableList.field_186420_b)) {
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("lifefruit", new int[0]), 2, 3, 15, "terraqueous:lifefruit"));
            }
            if (event.getName().equals((Object)LootTableList.field_186424_f)) {
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("deathfruit", new int[0]), 2, 3, 15, "terraqueous:deathfruit"));
            }
            if (event.getName().equals((Object)LootTableList.field_186423_e) || event.getName().equals((Object)LootTableList.field_186422_d)) {
                pool.addEntry((LootEntry)EventHandler.getToolEntry(Values.stacks.get("colorizer", new int[0]), 0.0f, 1.0f, 5, "terraqueous:colorizer"));
            }
            if (event.getName().equals((Object)LootTableList.field_186426_h)) {
                pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "terraqueous");
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("scroll_strange", new int[0]), 1, 1, 85, "terraqueous:scroll_strange"));
                event.getTable().addPool(pool);
            }
            if (event.getName().equals((Object)LootTableList.field_186425_g)) {
                pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(0.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "terraqueous");
                pool.addEntry((LootEntry)EventHandler.getEntry(Values.stacks.get("scroll_strange", new int[0]), 1, 1, 5, "terraqueous:scroll_strange"));
                event.getTable().addPool(pool);
            }
        }

        @SubscribeEvent
        public void playerBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
            ItemStack stack;
            EntityPlayer player = event.getEntityPlayer();
            if (player != null && event.getPos().func_177956_o() > 0 && !this.breakCache.contains(player.func_110124_au()) && (stack = player.func_184614_ca()) != null && stack.func_77973_b() instanceof ItemMultiTool) {
                this.breakCache.add(player.func_110124_au());
                event.setNewSpeed(((ItemMultiTool)stack.func_77973_b()).getBreakSpeed(stack, player, event.getState(), event.getNewSpeed(), event.getPos()));
                this.breakCache.remove(player.func_110124_au());
            }
        }
    }

    public static class ForgeTerrainBus {
        @SubscribeEvent
        public void saplingGrowTreeEvent(SaplingGrowTreeEvent event) {
            if (event.getWorld().func_180495_p(event.getPos().func_177977_b()).func_177230_c() == Blocks.field_150457_bL) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

