/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.lang.reflect.Constructor;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import shetiphian.core.common.Function;

public abstract class FoodAction {
    public boolean doUseAction(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public ItemStack doFinishAction(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public static class FoodActionPotion
    extends FoodAction {
        private PotionEffect[] effects;

        public FoodActionPotion(PotionEffect ... effects) {
            this.effects = effects;
        }

        @Override
        public ItemStack doFinishAction(ItemStack stack, World world, EntityPlayer player) {
            if (player != null && this.effects != null) {
                for (PotionEffect effect : this.effects) {
                    player.func_70690_d(effect);
                }
            }
            return stack;
        }
    }

    public static class FoodActionPlaceBlock
    extends FoodAction {
        private IBlockState state;
        private EnumFacing facing;

        public FoodActionPlaceBlock(IBlockState state, EnumFacing ... facing) {
            this.state = state;
            if (facing != null && facing.length > 0) {
                this.facing = facing[0];
            }
        }

        @Override
        public boolean doUseAction(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
            if (this.state == null || this.facing != null && side != this.facing) {
                return false;
            }
            BlockPos place = pos.func_177972_a(side);
            if (world.func_175623_d(place) && player.func_175151_a(place, side.func_176734_d(), stack)) {
                Function.setBlock((World)world, (BlockPos)place, (IBlockState)this.state, (boolean)false);
                if (this.state.func_177230_c() instanceof IPlantable && !world.func_180495_p(pos).func_177230_c().canSustainPlant(this.state, (IBlockAccess)world, pos, side, (IPlantable)this.state.func_177230_c())) {
                    world.func_175698_g(place);
                    return false;
                }
                --stack.field_77994_a;
                Function.sync((World)world, (BlockPos)place, (IBlockState)this.state);
                return true;
            }
            return false;
        }
    }

    public static class FoodActionSpawnEntity
    extends FoodAction {
        private Constructor<Entity> constructor;

        public FoodActionSpawnEntity(Class<?> entity) {
            if (Entity.class.isAssignableFrom(entity)) {
                try {
                    this.constructor = entity.getDeclaredConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean doUseAction(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
            if (this.constructor == null || player != null && !player.func_70093_af()) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150431_aC || (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a) > 1) {
                pos = pos.func_177972_a(side);
            }
            Entity entity = null;
            try {
                entity = this.constructor.newInstance(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entity != null) {
                if (!world.field_72995_K) {
                    world.func_72838_d(entity);
                }
                --stack.field_77994_a;
                return true;
            }
            return false;
        }
    }
}

