/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.network;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.common.network.PacketPipeline;
import shetiphian.terraqueous.common.item.ItemColorizer;

public class PacketColorizer
extends PacketBase {
    private byte preset;
    private short rgbIndex;
    private String name;

    public PacketColorizer() {
    }

    public PacketColorizer(int preset, short rgbIndex, String name) {
        this.preset = (byte)preset;
        this.rgbIndex = rgbIndex;
        this.name = name;
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeByte((int)this.preset);
        buffer.writeShort((int)this.rgbIndex);
        this.writeString(buffer, this.name.substring(0, Math.min(this.name.length(), 32)));
    }

    public void fromBytes(PacketBuffer buffer) {
        this.preset = buffer.readByte();
        this.rgbIndex = buffer.readShort();
        this.name = this.readString(buffer);
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack != null && stack.func_77973_b() instanceof ItemColorizer) {
            ItemColorizer colorizer = (ItemColorizer)stack.func_77973_b();
            if (this.preset == -1) {
                colorizer.setRGB16(stack, this.rgbIndex);
            } else {
                colorizer.setRGB16Preset(stack, this.preset, this.rgbIndex, this.name);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketColorizer, IMessage> {
        public IMessage onMessage(PacketColorizer packet, MessageContext ctx) {
            PacketPipeline.onMessage((PacketBase)packet, (MessageContext)ctx);
            return null;
        }
    }
}

