/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.terraqueous.common.inventory.InventoryCloudFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntityCloudFurnace
extends TileEntityAutoCrafting {
    private int smeltTime;
    public boolean isSmelting;
    private boolean lastIsSmelting;
    private short finishTime = (short)500;

    public TileEntityCloudFurnace() {
        this.inventory = new InventoryCloudFurnace(this);
        InventoryCloudFurnace inv = (InventoryCloudFurnace)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(), inv.getWrapperInput(), inv.getWrapperOutput()});
        this.sidedWrapper.setLatency((int[][])new int[][]{inv.SLOTS_BASIC, inv.SLOTS_INPUT, inv.SLOTS_OUTPUT});
        this.sidedWrapper.setFaceIndex(EnumFacing.DOWN, 2);
        this.sidedWrapper.setFaceIndex(EnumFacing.UP, 1);
        this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 1);
        this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 1);
        this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 2);
        this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 1);
    }

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74778_a("facing", this.facing.func_176610_l());
        nbtTag.func_74757_a("isSmelting", this.isSmelting);
    }

    @Override
    protected void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.buildNBT_SaveOnly(nbtTag);
        nbtTag.func_74768_a("smeltTime", this.smeltTime);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.facing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
        this.isSmelting = nbtTag.func_74767_n("isSmelting");
    }

    @Override
    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        super.processNBT_SaveOnly(nbtTag);
        this.smeltTime = nbtTag.func_74762_e("smeltTime");
    }

    protected void processNBT_SyncOnly(NBTTagCompound nbtTag) {
        if (this.lastIsSmelting != this.isSmelting) {
            this.lastIsSmelting = this.isSmelting;
            Function.updateLighting((TileEntity)this);
        }
    }

    public void func_73660_a() {
        boolean inUse;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ItemStack stackInInput = this.inventory.func_70301_a(0);
        if (stackInInput != null) {
            ++this.smeltTime;
            if (this.func_145831_w().func_72896_J()) {
                ++this.smeltTime;
            }
            if (this.func_145831_w().func_72911_I()) {
                ++this.smeltTime;
            }
            if (this.smeltTime >= this.finishTime) {
                boolean isItemSmeltable = this.isItemSmeltable(stackInInput);
                ItemStack output = isItemSmeltable ? this.getSmelted(stackInInput) : stackInInput;
                ItemStack stackInOutput = this.inventory.func_70301_a(1);
                if (stackInOutput == null || this.canPlaceInSlot(stackInOutput, output, false)) {
                    if (stackInOutput != null) {
                        stackInOutput.field_77994_a += output.field_77994_a;
                    } else {
                        this.inventory.func_70299_a(1, output);
                    }
                    --stackInInput.field_77994_a;
                    if (stackInInput.field_77994_a < 1) {
                        this.inventory.func_70299_a(0, null);
                    }
                    if (isItemSmeltable) {
                        this.smeltTime = 0;
                    }
                    this.func_70296_d();
                }
            }
        }
        if (stackInInput == null && this.smeltTime > 0) {
            this.smeltTime = 0;
        }
        boolean bl = inUse = stackInInput != null && this.smeltTime < this.finishTime;
        if (this.isSmelting && !inUse || !this.isSmelting && inUse) {
            this.isSmelting = !this.isSmelting;
            Function.syncTile((TileEntity)this);
        }
    }

    public int getSmeltTime() {
        return this.smeltTime;
    }

    public void setSmeltTime(int value) {
        this.smeltTime = value;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int graphicWidth) {
        return this.smeltTime * graphicWidth / this.finishTime;
    }

    public void dropItems() {
        for (ItemStack itemStack : this.inventory.getContents()) {
            if (itemStack == null) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)itemStack);
        }
        this.isSmelting = false;
        Function.updateLighting((TileEntity)this);
    }
}

