/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.terraqueous.common.inventory.InventoryCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntityCraftFurnace
extends TileEntityAutoCrafting {
    private int[] smeltTime = new int[2];
    private int burnTime;
    private int burnValue;
    public boolean isCloud = false;
    public boolean isSmelting;
    private boolean lastIsSmelting;
    private short[] finishTime = new short[]{250, 600};

    public TileEntityCraftFurnace() {
        this.setupInventory();
    }

    void setupInventory() {
        this.inventory = new InventoryCraftFurnace(this);
        InventoryCraftFurnace inv = (InventoryCraftFurnace)this.inventory;
        if (this.isCloud) {
            this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(true), inv.getWrapperItems(), inv.getWrapperOutput(true)});
            this.sidedWrapper.setLatency((int[][])new int[][]{inv.CLOUD_SLOTS_BASIC, inv.SLOTS_ITEMS, inv.CLOUD_SLOTS_OUTPUT});
            this.sidedWrapper.setFaceIndex(EnumFacing.DOWN, 2);
            this.sidedWrapper.setFaceIndex(EnumFacing.UP, 1);
            this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 1);
            this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 0);
            this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 1);
            this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 2);
        } else {
            this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapperBasic(false), inv.getWrapperItems(), inv.getWrapperFuel(), inv.getWrapperInputs(), inv.getWrapperOutput(false)});
            this.sidedWrapper.setLatency((int[][])new int[][]{inv.SLOTS_BASIC, inv.SLOTS_ITEMS, inv.SLOTS_FUEL, inv.SLOTS_INPUTS, inv.SLOTS_OUTPUT});
            this.sidedWrapper.setFaceIndex(EnumFacing.DOWN, 4);
            this.sidedWrapper.setFaceIndex(EnumFacing.UP, 2);
            this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 2);
            this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 0);
            this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 1);
            this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 4);
        }
    }

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74757_a("isCloud", this.isCloud);
        nbtTag.func_74778_a("facing", this.facing.func_176610_l());
        nbtTag.func_74757_a("isSmelting", this.isSmelting);
    }

    @Override
    protected void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        nbtTag.func_74783_a("smeltTime", this.smeltTime);
        nbtTag.func_74768_a("burnTime", this.burnTime);
        nbtTag.func_74768_a("burnValue", this.burnValue);
        super.buildNBT_SaveOnly(nbtTag);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.isCloud = nbtTag.func_74767_n("isCloud");
        this.facing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
        this.isSmelting = nbtTag.func_74767_n("isSmelting");
    }

    @Override
    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        if (nbtTag.func_74764_b("smeltTime")) {
            this.smeltTime = nbtTag.func_74759_k("smeltTime");
        }
        this.burnTime = nbtTag.func_74762_e("burnTime");
        this.burnValue = nbtTag.func_74762_e("burnValue");
        if (nbtTag.func_74764_b("itemsFuel") || nbtTag.func_74764_b("itemsInput") || nbtTag.func_74764_b("itemsSmelt") || nbtTag.func_74764_b("itemsOutput")) {
            ItemStack[] itemsFuel = this.listReader(nbtTag.func_150295_c("itemsFuel", 10), 3);
            ItemStack[] itemsInput = this.listReader(nbtTag.func_150295_c("itemsInput", 10), 6);
            ItemStack[] itemsSmelt = this.listReader(nbtTag.func_150295_c("itemsSmelt", 10), 2);
            ItemStack[] itemsOutput = this.listReader(nbtTag.func_150295_c("itemsOutput", 10), 6);
            ItemStack[] contents = new ItemStack[17];
            System.arraycopy(itemsFuel, 0, contents, 0, 3);
            System.arraycopy(itemsInput, 0, contents, 3, 6);
            System.arraycopy(itemsSmelt, 0, contents, 9, 2);
            System.arraycopy(itemsOutput, 0, contents, 11, 6);
            ((InventoryCraftFurnace)this.inventory).setContents(contents);
        } else {
            super.processNBT_SaveOnly(nbtTag);
        }
    }

    protected void processNBT_SyncOnly(NBTTagCompound nbtTag) {
        if (this.lastIsSmelting != this.isSmelting) {
            this.lastIsSmelting = this.isSmelting;
            Function.updateLighting((TileEntity)this);
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean finalTick = false;
        if (this.burnTime > 0) {
            --this.burnTime;
            finalTick = this.burnTime == 0;
        }
        for (int slotSmelt = 0; slotSmelt < 2; slotSmelt = (int)((byte)(slotSmelt + 1))) {
            ItemStack smeltStack = this.inventory.func_70301_a(9 + slotSmelt);
            if (smeltStack != null) {
                if (this.burnTime > 0 || this.isCloud || finalTick) {
                    int n = slotSmelt;
                    this.smeltTime[n] = this.smeltTime[n] + 1;
                    if (this.isCloud && this.func_145831_w().func_72896_J()) {
                        int n2 = slotSmelt;
                        this.smeltTime[n2] = this.smeltTime[n2] + 1;
                    }
                    if (this.isCloud && this.func_145831_w().func_72911_I()) {
                        int n3 = slotSmelt;
                        this.smeltTime[n3] = this.smeltTime[n3] + 1;
                    }
                }
                if (this.smeltTime[slotSmelt] >= this.finishTime[this.isCloud ? 1 : 0]) {
                    boolean isItemSmeltable = this.isItemSmeltable(smeltStack);
                    ItemStack[] itemsOutput = new ItemStack[6];
                    System.arraycopy(this.inventory.getContents(), 11, itemsOutput, 0, 6);
                    byte outputSlot = this.getOutputSlot(itemsOutput, smeltStack, isItemSmeltable);
                    if (outputSlot > -1) {
                        ItemStack output = isItemSmeltable ? this.getSmelted(smeltStack) : smeltStack;
                        ItemStack stackInSlot = this.inventory.func_70301_a(11 + outputSlot);
                        if (stackInSlot != null) {
                            stackInSlot.field_77994_a += output.field_77994_a;
                        } else {
                            this.inventory.func_70299_a(11 + outputSlot, output);
                        }
                        this.inventory.func_70299_a(9 + slotSmelt, null);
                        this.smeltTime[slotSmelt] = 0;
                        this.getNextSmeltItem(slotSmelt);
                        smeltStack = this.inventory.func_70301_a(9 + slotSmelt);
                        this.func_70296_d();
                    }
                }
            }
            if (smeltStack != null || this.getNextSmeltItem(slotSmelt) || this.smeltTime[slotSmelt] <= 0) continue;
            this.smeltTime[slotSmelt] = 0;
        }
        boolean[] inUse = new boolean[2];
        for (int slotSmelt = 0; slotSmelt < 2; slotSmelt = (int)((byte)(slotSmelt + 1))) {
            inUse[slotSmelt] = this.inventory.func_70301_a(9 + slotSmelt) != null && this.smeltTime[slotSmelt] < this.finishTime[this.isCloud ? 1 : 0];
        }
        if (!this.isCloud && this.burnTime < 1 && (inUse[0] || inUse[1])) {
            for (int slotFuel = 0; slotFuel < 3; slotFuel = (int)((byte)(slotFuel + 1))) {
                int value;
                ItemStack stackFuel = this.inventory.func_70301_a(slotFuel);
                if (stackFuel == null || (value = TileEntityFurnace.func_145952_a((ItemStack)stackFuel)) <= 0) continue;
                this.burnTime = this.burnValue = value;
                --stackFuel.field_77994_a;
                if (stackFuel.field_77994_a < 1) {
                    this.inventory.func_70299_a(slotFuel, stackFuel.func_77973_b().getContainerItem(stackFuel));
                }
                this.func_70296_d();
                break;
            }
        }
        if (this.isSmelting) {
            if (!inUse[0] && !inUse[1] || !this.isCloud && this.burnTime < 1) {
                this.isSmelting = false;
                Function.syncTile((TileEntity)this);
            }
        } else if ((inUse[0] || inUse[1]) && (this.isCloud || !this.isCloud && this.burnTime > 0)) {
            this.isSmelting = true;
            Function.syncTile((TileEntity)this);
        }
    }

    private boolean getNextSmeltItem(int slotSmelt) {
        for (int slotInput = 0; slotInput < 6; slotInput = (int)((byte)(slotInput + 1))) {
            ItemStack stackInput = this.inventory.func_70301_a(3 + slotInput);
            if (stackInput == null) continue;
            if (this.isItemSmeltable(stackInput)) {
                this.inventory.func_70299_a(9 + slotSmelt, stackInput.func_77979_a(1));
                if (stackInput.field_77994_a < 1) {
                    this.inventory.func_70299_a(3 + slotInput, null);
                }
                this.smeltTime[slotSmelt] = 0;
                this.func_70296_d();
                return true;
            }
            boolean removed = false;
            int size = stackInput.field_77994_a;
            for (int count = 0; count < size; ++count) {
                ItemStack temp = stackInput.func_77946_l();
                temp.field_77994_a = 1;
                ItemStack[] itemsOutput = new ItemStack[6];
                System.arraycopy(this.inventory.getContents(), 11, itemsOutput, 0, 6);
                byte outputSlot = this.getOutputSlot(itemsOutput, temp, false);
                if (outputSlot <= -1) continue;
                ItemStack stackInSlot = this.inventory.func_70301_a(11 + outputSlot);
                if (stackInSlot != null) {
                    ++stackInSlot.field_77994_a;
                } else {
                    this.inventory.func_70299_a(11 + outputSlot, temp);
                }
                --stackInput.field_77994_a;
                if (stackInput.field_77994_a < 1) {
                    this.inventory.func_70299_a(3 + slotInput, null);
                }
                removed = true;
            }
            if (!removed) continue;
            this.func_70296_d();
        }
        return false;
    }

    public int getSmeltTime(int slot) {
        return slot < 2 ? this.smeltTime[slot] : 0;
    }

    public void setSmeltTime(int slot, int value) {
        if (slot > -1 && slot < 2) {
            this.smeltTime[slot] = value;
        }
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int value) {
        this.burnTime = value;
    }

    public int getBurnValue() {
        return this.burnValue;
    }

    public void setBurnValue(int value) {
        this.burnValue = value;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int item, int graphicWidth) {
        return this.smeltTime[item] == 0 ? 0 : this.smeltTime[item] * graphicWidth / this.finishTime[this.isCloud ? 1 : 0];
    }

    @SideOnly(value=Side.CLIENT)
    public int getFuelProgressScaled(int graphicWidth) {
        return this.burnTime == 0 || this.burnValue == 0 ? 0 : MathHelper.func_76125_a((int)(this.burnTime * graphicWidth / this.burnValue), (int)1, (int)graphicWidth);
    }

    public void dropItems() {
        for (ItemStack itemStack : this.inventory.getContents()) {
            if (itemStack == null) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)itemStack);
        }
        this.isSmelting = false;
        Function.updateLighting((TileEntity)this);
    }
}

