/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.tileentity.TileEntityBase;

public abstract class TileEntityCrafting
extends TileEntityBase
implements ISidedWrapper,
ISidedInventory {
    public InventoryInternal inventory;
    ISidedWrapper.SidedWrapper sidedWrapper;
    protected EnumFacing facing = EnumFacing.NORTH;

    protected void buildNBT(NBTTagCompound nbtTag) {
        this.sidedWrapper.writeToNBT(nbtTag);
    }

    protected void buildNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.writeToNBT(nbtTag, "items");
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.sidedWrapper.readFromNBT(nbtTag);
    }

    protected void processNBT_SaveOnly(NBTTagCompound nbtTag) {
        this.inventory.readFromNBT(nbtTag, nbtTag.func_74764_b("items") ? "items" : "inventoryItems");
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.sidedWrapper.getWrapper(this.facing, facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.sidedWrapper.getWrapper(this.facing, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public ISidedWrapper.SidedWrapper getSidedWrapper() {
        return this.sidedWrapper;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public boolean rotateBlock(EnumFacing axis) {
        this.facing = this.facing.func_176746_e();
        Function.syncTile((TileEntity)this);
        return true;
    }

    ItemStack itemReader(NBTTagCompound nbtTag, String name) {
        NBTBase compound = nbtTag.func_74781_a(name);
        return compound instanceof NBTTagCompound ? ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)compound)) : null;
    }

    ItemStack[] listReader(NBTTagList listStacks, int length) {
        ItemStack[] stacks = new ItemStack[length];
        for (int index = 0; index < listStacks.func_74745_c(); index = (int)((byte)(index + 1))) {
            NBTTagCompound entry = listStacks.func_150305_b(index);
            byte slot = entry.func_74771_c("slot");
            if (slot < 0 || slot >= length) continue;
            stacks[slot] = ItemStack.func_77949_a((NBTTagCompound)entry);
        }
        return stacks;
    }

    public byte getOutputSlot(ItemStack[] itemsOutput, ItemStack item, boolean smelted) {
        if (smelted) {
            item = this.getSmelted(item);
        }
        if (item != null) {
            boolean useFreeSlot = !item.func_77985_e();
            for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
                for (byte slot = 0; slot < itemsOutput.length; slot = (byte)(slot + 1)) {
                    if (!this.canPlaceInSlot(itemsOutput[slot], item, useFreeSlot)) continue;
                    return slot;
                }
                useFreeSlot = true;
            }
        }
        return -1;
    }

    boolean canPlaceInSlot(ItemStack output, ItemStack item, boolean useFreeSlot) {
        if (useFreeSlot) {
            return output == null;
        }
        return output != null && output.func_77969_a(item) && output.field_77994_a + item.field_77994_a <= item.func_77976_d();
    }

    public boolean isItemSmeltable(ItemStack input) {
        return this.getSmelted(input) != null;
    }

    ItemStack getSmelted(ItemStack input) {
        if (input == null) {
            return null;
        }
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(input);
        return smelted != null ? smelted.func_77946_l() : null;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        return this.inventory.func_70298_a(slotId, amount);
    }

    public ItemStack func_70304_b(int slotId) {
        return this.inventory.func_70304_b(slotId);
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        this.inventory.func_70299_a(slotId, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return this.inventory.func_94041_b(slotId, stack);
    }

    public int func_174887_a_(int id) {
        return this.inventory.func_174887_a_(id);
    }

    public void func_174885_b(int id, int value) {
        this.inventory.func_174885_b(id, value);
    }

    public int func_174890_g() {
        return this.inventory.func_174890_g();
    }

    public void func_174888_l() {
        this.inventory.func_174888_l();
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }

    public int[] func_180463_a(EnumFacing face) {
        return this.sidedWrapper.getLatency(this.facing, face);
    }

    public boolean func_180462_a(int slotId, ItemStack stack, EnumFacing face) {
        if (stack != null) {
            int[] latency = this.func_180463_a(face);
            for (int index = 0; index < latency.length; ++index) {
                InvWrapper wrapper;
                if (slotId != latency[index] || (wrapper = this.sidedWrapper.getWrapper(this.facing, face)) == null) continue;
                return wrapper.insertItem(index, stack, true) != stack;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slotId, ItemStack stack, EnumFacing face) {
        if (stack != null) {
            int[] latency = this.func_180463_a(face);
            for (int index = 0; index < latency.length; ++index) {
                InvWrapper wrapper;
                if (slotId != latency[index] || (wrapper = this.sidedWrapper.getWrapper(this.facing, face)) == null) continue;
                return wrapper.extractItem(index, stack.field_77994_a, true) != null;
            }
        }
        return false;
    }
}

