/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaBase;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaGate;

public class TileEntityPergolaWall
extends TileEntityPergolaBase {
    private BlockPergola.EnumStyle isPergolaBlock(EnumFacing facing) {
        BlockPos pos = this.func_174877_v().func_177972_a(facing);
        if (!this.func_145831_w().func_175623_d(pos)) {
            TileEntity tile = this.func_145831_w().func_175625_s(pos);
            if (tile instanceof TileEntityPergolaWall) {
                return BlockPergola.EnumStyle.NORMAL;
            }
            if (tile instanceof TileEntityPergolaGate) {
                TileEntityPergolaGate gate = (TileEntityPergolaGate)tile;
                if (this.isNorthOrSouth(facing) != this.isNorthOrSouth(gate.gateFacing)) {
                    return BlockPergola.EnumStyle.NORMAL;
                }
            }
        }
        return BlockPergola.EnumStyle.NONE;
    }

    private String getType(EnumFacing facing) {
        BlockPos pos = this.func_174877_v().func_177972_a(facing);
        if (!this.func_145831_w().func_175623_d(pos)) {
            TileEntity tile = this.func_145831_w().func_175625_s(pos);
            if (tile instanceof TileEntityPergolaWall) {
                return ((TileEntityPergolaWall)tile).getSavedType(false);
            }
            if (tile instanceof TileEntityPergolaGate) {
                TileEntityPergolaGate gate = (TileEntityPergolaGate)tile;
                return this.isNorthOrSouth(gate.gateFacing) ? "nd=none,sd=none" : "ed=none,wd=none";
            }
            return "block";
        }
        return "air";
    }

    @Override
    protected String getType() {
        IBlockState state;
        boolean ew;
        String type;
        boolean bDown;
        BlockPergola.EnumStyle north = this.isPergolaBlock(EnumFacing.NORTH);
        BlockPergola.EnumStyle east = this.isPergolaBlock(EnumFacing.EAST);
        BlockPergola.EnumStyle south = this.isPergolaBlock(EnumFacing.SOUTH);
        BlockPergola.EnumStyle west = this.isPergolaBlock(EnumFacing.WEST);
        BlockPergola.EnumStyle extra = BlockPergola.EnumStyle.NORMAL;
        String sUp = this.getType(EnumFacing.UP);
        String sDown = this.getType(EnumFacing.DOWN);
        boolean bUp = !Strings.isNullOrEmpty((String)sUp) && !sUp.equals("air") && !sUp.equals("block");
        boolean bl = bDown = !Strings.isNullOrEmpty((String)sDown) && !sDown.equals("air") && !sDown.equals("block");
        if (bUp || bDown) {
            boolean down;
            boolean up;
            if (north == BlockPergola.EnumStyle.NORMAL) {
                up = bUp && !sUp.contains("nd=none");
                boolean bl2 = down = bDown && !sDown.contains("nd=none");
                BlockPergola.EnumStyle enumStyle = up && down ? BlockPergola.EnumStyle.MIDDLE : (up ? BlockPergola.EnumStyle.BOTTOM : (north = down ? BlockPergola.EnumStyle.TOP : north));
            }
            if (south == BlockPergola.EnumStyle.NORMAL) {
                up = bUp && !sUp.contains("sd=none");
                boolean bl3 = down = bDown && !sDown.contains("sd=none");
                BlockPergola.EnumStyle enumStyle = up && down ? BlockPergola.EnumStyle.MIDDLE : (up ? BlockPergola.EnumStyle.BOTTOM : (south = down ? BlockPergola.EnumStyle.TOP : south));
            }
            if (east == BlockPergola.EnumStyle.NORMAL) {
                up = bUp && !sUp.contains("ed=none");
                boolean bl4 = down = bDown && !sDown.contains("ed=none");
                BlockPergola.EnumStyle enumStyle = up && down ? BlockPergola.EnumStyle.MIDDLE : (up ? BlockPergola.EnumStyle.BOTTOM : (east = down ? BlockPergola.EnumStyle.TOP : east));
            }
            if (west == BlockPergola.EnumStyle.NORMAL) {
                up = bUp && !sUp.contains("wd=none");
                boolean bl5 = down = bDown && !sDown.contains("wd=none");
                BlockPergola.EnumStyle enumStyle = up && down ? BlockPergola.EnumStyle.MIDDLE : (up ? BlockPergola.EnumStyle.BOTTOM : (west = down ? BlockPergola.EnumStyle.TOP : west));
            }
        }
        if (east == west && north == south && east != north && (east == BlockPergola.EnumStyle.NONE || north == BlockPergola.EnumStyle.NONE)) {
            extra = BlockPergola.EnumStyle.NONE;
        }
        boolean ns = (type = "ed=" + east.func_176610_l() + ",nd=" + north.func_176610_l() + ",sd=" + south.func_176610_l() + ",wd=" + west.func_176610_l()).contains("ed=none") && !type.contains("nd=none") && !type.contains("sd=none") && type.contains("wd=none");
        boolean bl6 = ew = !type.contains("ed=none") && type.contains("nd=none") && type.contains("sd=none") && !type.contains("wd=none");
        if (extra == BlockPergola.EnumStyle.NORMAL && type.contains("middle")) {
            extra = ns && !type.contains("nd=normal") && !type.contains("sd=normal") || ew && !type.contains("ed=normal") && !type.contains("wd=normal") ? (!type.contains("top") ? BlockPergola.EnumStyle.BOTTOM : (!type.contains("bottom") ? BlockPergola.EnumStyle.TOP : extra)) : BlockPergola.EnumStyle.MIDDLE;
        }
        if (extra == BlockPergola.EnumStyle.NONE) {
            boolean down;
            boolean up = !Strings.isNullOrEmpty((String)sUp) && sUp.contains("xd=normal");
            boolean bl7 = down = !Strings.isNullOrEmpty((String)sDown) && sDown.contains("xd=normal");
            if (up && !down) {
                extra = BlockPergola.EnumStyle.TOP;
            } else if (!up && down) {
                extra = BlockPergola.EnumStyle.BOTTOM;
            } else if (up) {
                extra = BlockPergola.EnumStyle.MIDDLE;
            }
        }
        if (!Strings.isNullOrEmpty((String)sUp) && sUp.equals("block") && (state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a())).func_177230_c() != Values.blockPergola) {
            extra = extra == BlockPergola.EnumStyle.NONE ? BlockPergola.EnumStyle.MIDDLE : (extra == BlockPergola.EnumStyle.BOTTOM ? BlockPergola.EnumStyle.NORMAL : extra);
        }
        return type + ",xd=" + extra.func_176610_l();
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        String type = this.getSavedType(true);
        if (!Strings.isNullOrEmpty((String)type)) {
            double minZ;
            double maxX;
            double minX;
            boolean noPost = type.contains("xd=none");
            double d = !type.contains("wd=none") ? 0.0 : (minX = noPost ? 0.4375 : 0.375);
            double d2 = !type.contains("ed=none") ? 1.0 : (maxX = noPost ? 0.5625 : 0.625);
            double d3 = !type.contains("nd=none") ? 0.0 : (minZ = noPost ? 0.4375 : 0.375);
            double maxZ = !type.contains("sd=none") ? 1.0 : (noPost ? 0.5625 : 0.625);
            boolean min = !noPost || type.contains("top") || type.contains("middle");
            boolean max = !noPost || type.contains("bottom") || type.contains("middle");
            double minY = min ? 0.0 : 0.125;
            double maxY = max ? 1.0 : 0.875;
            return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return Block.field_185505_j;
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        String type = this.getSavedType(true);
        if (!Strings.isNullOrEmpty((String)type)) {
            double maxY;
            boolean large = false;
            BlockPos upPos = this.func_174877_v().func_177984_a();
            if (!this.func_145831_w().func_175623_d(upPos)) {
                IBlockState upState = this.func_145831_w().func_180495_p(upPos);
                AxisAlignedBB aabb = upState.func_185900_c((IBlockAccess)this.func_145831_w(), upPos);
                large = aabb != null && aabb.field_72340_a <= 0.2 && aabb.field_72339_c <= 0.2 && aabb.field_72336_d >= 0.8 && aabb.field_72334_f >= 0.8;
            }
            double d = maxY = large ? 1.0 : 1.5;
            if (!type.contains("ed=none")) {
                boxes.add(new AxisAlignedBB(0.5, 0.0, 0.375, 1.0, maxY, 0.625));
            }
            if (!type.contains("nd=none")) {
                boxes.add(new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, maxY, 0.5));
            }
            if (!type.contains("sd=none")) {
                boxes.add(new AxisAlignedBB(0.375, 0.0, 0.5, 0.625, maxY, 1.0));
            }
            if (!type.contains("wd=none")) {
                boxes.add(new AxisAlignedBB(0.0, 0.0, 0.375, 0.5, maxY, 0.625));
            }
            if (!type.contains("xd=none")) {
                boxes.add(new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, maxY, 0.625));
            }
        } else {
            boxes.add(this.getBoxBounds());
        }
        return boxes;
    }
}

