/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.IStormForgeRepairHandler;
import shetiphian.terraqueous.api.machines.IStormForgeStackHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;
import shetiphian.terraqueous.common.inventory.InventoryStormForge;
import shetiphian.terraqueous.common.misc.StormForgeHelper;
import shetiphian.terraqueous.common.tileentity.TileEntityAutoCrafting;

public class TileEntitySFController
extends TileEntityAutoCrafting {
    public short delayTime;
    private boolean isWorking;
    public float renderRotation;

    public TileEntitySFController() {
        this.inventory = new InventoryStormForge((TileEntity)this);
        InventoryStormForge inv = (InventoryStormForge)this.inventory;
        this.sidedWrapper = new ISidedWrapper.SidedWrapper(-1, new InvWrapper[]{inv.getWrapper()});
        this.sidedWrapper.setLatency((int[][])new int[][]{inv.SLOTS_BASIC});
        this.sidedWrapper.setFaceIndex(EnumFacing.NORTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.SOUTH, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.WEST, 0);
        this.sidedWrapper.setFaceIndex(EnumFacing.EAST, 0);
    }

    @Override
    protected void buildNBT(NBTTagCompound nbtTag) {
        super.buildNBT(nbtTag);
        nbtTag.func_74777_a("delayTime", this.delayTime);
        nbtTag.func_74757_a("isWorking", this.isWorking);
    }

    @Override
    protected void processNBT(NBTTagCompound nbtTag) {
        super.processNBT(nbtTag);
        this.delayTime = nbtTag.func_74765_d("delayTime");
        this.isWorking = nbtTag.func_74767_n("isWorking");
    }

    @Override
    public boolean rotateBlock(EnumFacing axis) {
        return false;
    }

    public void func_73660_a() {
        ItemStack processStack;
        Block block;
        int lightningChance;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        boolean canBlockSeeSky = this.func_145831_w().func_175710_j(this.func_174877_v().func_177984_a());
        boolean wasStruck = false;
        boolean instantComplete = false;
        if (canBlockSeeSky && this.func_145831_w().func_72911_I() && this.func_145831_w().field_73012_v.nextInt(lightningChance = (int)(200.0f - this.func_145831_w().func_72819_i(1.0f) * 100.0f)) == 0) {
            wasStruck = true;
            this.func_145831_w().func_72942_c((Entity)new EntityLightningBolt(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), false));
            if (this.func_145831_w().field_73012_v.nextInt(lightningChance * 2) == 0) {
                instantComplete = true;
            }
            StormForgeHelper.moveFire(this.func_145831_w(), this.func_174877_v());
        }
        if ((block = this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a()).func_177230_c()) == Blocks.field_150480_ab || block instanceof BlockFire) {
            Function.removeBlock((World)this.func_145831_w(), (BlockPos)this.func_174877_v().func_177984_a(), (boolean)true);
        }
        if ((processStack = this.inventory.func_70301_a(6)) == null) {
            this.getNextItem(true);
        } else {
            boolean moveToOutput;
            boolean bl = moveToOutput = !this.isWorking;
            if (this.isWorking) {
                if (this.isSFStack(6)) {
                    this.delayTime = (short)(this.delayTime + 1);
                    IStormForgeStackHandler handler = (IStormForgeStackHandler)processStack.func_77973_b();
                    this.inventory.func_70299_a(6, handler.processStack(processStack, this.delayTime, wasStruck, this.func_145831_w(), this.func_174877_v()));
                    moveToOutput = handler.isFinished(processStack, this.delayTime, wasStruck, this.func_145831_w(), this.func_174877_v());
                    if (moveToOutput) {
                        this.delayTime = 0;
                    }
                } else {
                    boolean processed = false;
                    for (IStormForgeRechargeHandler iStormForgeRechargeHandler : StormForgeRegistry.getRechargeHandlers()) {
                        if (!iStormForgeRechargeHandler.handleStack(processStack)) continue;
                        processed = true;
                        boolean used = iStormForgeRechargeHandler.charge(processStack, this.getPower(iStormForgeRechargeHandler.multiplier(), wasStruck, !canBlockSeeSky), instantComplete);
                        moveToOutput = !used || iStormForgeRechargeHandler.isFull(processStack);
                        break;
                    }
                    if (!canBlockSeeSky && this.func_145831_w().field_73012_v.nextInt(10) < 4) {
                        return;
                    }
                    this.delayTime = (short)(this.delayTime + this.getValue(1, wasStruck, false));
                    if (!processed) {
                        for (IStormForgeRepairHandler iStormForgeRepairHandler : StormForgeRegistry.getRepairHandlers()) {
                            if (!iStormForgeRepairHandler.handleStack(processStack)) continue;
                            processed = true;
                            if (this.delayTime < Settings.INSTANCE.sfTicksPerRepairPoint && !instantComplete) break;
                            this.delayTime = 0;
                            iStormForgeRepairHandler.repair(processStack, instantComplete);
                            if (wasStruck && !instantComplete) {
                                iStormForgeRepairHandler.repair(processStack, false);
                            }
                            moveToOutput = iStormForgeRepairHandler.isRepaired(processStack);
                            break;
                        }
                    }
                    if (!processed && this.isSmeltable(6) && (this.delayTime >= Settings.INSTANCE.sfTicksToSmelt || instantComplete)) {
                        this.delayTime = 0;
                        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(processStack);
                        if (result != null) {
                            this.inventory.func_70299_a(6, result.func_77946_l());
                        }
                        moveToOutput = true;
                    }
                    if (!processed) {
                        moveToOutput = true;
                    }
                }
            }
            if (moveToOutput) {
                this.isWorking = false;
                processStack = this.inventory.func_70301_a(6);
                byte outputSlot = this.getOutputSlot(processStack, true);
                if (outputSlot > -1) {
                    ItemStack outputSlotStack = this.inventory.func_70301_a((int)outputSlot);
                    if (outputSlotStack != null) {
                        outputSlotStack.field_77994_a = outputSlotStack.field_77994_a + (processStack != null ? processStack.field_77994_a : 1);
                    } else {
                        this.inventory.func_70299_a((int)outputSlot, processStack);
                    }
                    this.inventory.func_70299_a(6, null);
                    this.getNextItem(false);
                    Function.syncTile((TileEntity)this);
                }
            }
        }
    }

    private void getNextItem(boolean syncOnMove) {
        for (int slot = 0; slot < 6; slot = (int)((byte)(slot + 1))) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slot);
            if (stackInSlot == null || this.getOutputSlot(stackInSlot, false) <= -1) continue;
            this.inventory.func_70299_a(6, stackInSlot.func_77979_a(1));
            this.isWorking = true;
            if (stackInSlot.field_77994_a < 1) {
                this.inventory.func_70299_a(slot, null);
            }
            this.delayTime = 0;
            if (syncOnMove) {
                Function.syncTile((TileEntity)this);
            }
            return;
        }
    }

    private double getPower(float multiplier, boolean wasStruck, boolean doReduction) {
        int base = this.getValue(Settings.INSTANCE.sfPowerPerTickBase, wasStruck, doReduction);
        return (float)base * multiplier;
    }

    private int getValue(int base, boolean wasStruck, boolean doReduction) {
        float value = (float)base + (0.5f * (float)base * this.func_145831_w().func_72867_j(1.0f) + 0.75f * (float)base * this.func_145831_w().func_72819_i(1.0f) * 3.0f);
        return MathHelper.func_76123_f((float)(value *= (wasStruck ? 2.0f : 1.0f) * (doReduction ? 0.25f : 1.0f)));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 3), (double)(this.func_174877_v().func_177956_o() - 1), (double)(this.func_174877_v().func_177952_p() - 3), (double)(this.func_174877_v().func_177958_n() + 4), (double)(this.func_174877_v().func_177956_o() + 4), (double)(this.func_174877_v().func_177952_p() + 4));
    }

    public void dropItems() {
        for (ItemStack itemStack : this.inventory.getContents()) {
            if (itemStack == null) continue;
            Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)itemStack);
        }
    }

    private byte getOutputSlot(ItemStack item, boolean currentItem) {
        ItemStack smelted;
        if (item == null) {
            return -1;
        }
        if (!currentItem && (smelted = FurnaceRecipes.func_77602_a().func_151395_a(item)) != null) {
            item = smelted.func_77946_l();
        }
        boolean useFreeSlot = !item.func_77985_e();
        for (int pass = 0; pass < 2; pass = (int)((byte)(pass + 1))) {
            for (byte slot = 7; slot < 13; slot = (byte)(slot + 1)) {
                int result;
                ItemStack stackInSlot;
                if (!(useFreeSlot ? this.inventory.func_70301_a((int)slot) == null : (stackInSlot = this.inventory.func_70301_a((int)slot)) != null && stackInSlot.func_77969_a(item) && (result = stackInSlot.field_77994_a + item.field_77994_a) <= this.inventory.func_70297_j_() && result <= item.func_77976_d())) continue;
                return slot;
            }
            useFreeSlot = true;
        }
        return -1;
    }

    private boolean isSFStack(int slotId) {
        Item item;
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (stackInSlot != null && (item = stackInSlot.func_77973_b()) instanceof IStormForgeStackHandler) {
            return ((IStormForgeStackHandler)item).handleStack(stackInSlot);
        }
        return false;
    }

    private boolean isChargeable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (stackInSlot != null) {
            for (IStormForgeRechargeHandler handler : StormForgeRegistry.getRechargeHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRepairable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        if (stackInSlot != null) {
            for (IStormForgeRepairHandler handler : StormForgeRegistry.getRepairHandlers()) {
                if (!handler.handleStack(stackInSlot)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSmeltable(int slotId) {
        ItemStack stackInSlot = this.inventory.func_70301_a(slotId);
        return stackInSlot != null && FurnaceRecipes.func_77602_a().func_151395_a(stackInSlot) != null;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getCenterItem() {
        ItemStack stackInSlot = this.inventory.func_70301_a(6);
        return stackInSlot != null && this.isWorking ? stackInSlot.func_77946_l() : null;
    }

    @SideOnly(value=Side.CLIENT)
    public short getProcessType(byte slotId) {
        if (this.inventory.func_70301_a((int)slotId) != null) {
            if (slotId == 6 && !this.isWorking) {
                return -1;
            }
            if (this.isSFStack(slotId)) {
                return 4;
            }
            if (this.isChargeable(slotId)) {
                return 1;
            }
            if (this.isRepairable(slotId)) {
                return 2;
            }
            if (this.isSmeltable(slotId)) {
                return 3;
            }
            return 0;
        }
        return -1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showBar() {
        if (this.isSFStack(6)) {
            ItemStack stackInSlot = this.inventory.func_70301_a(6);
            return stackInSlot != null && ((IStormForgeStackHandler)stackInSlot.func_77973_b()).showBar(stackInSlot);
        }
        return !this.isChargeable(6) && (this.isRepairable(6) || this.isSmeltable(6));
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgressScaled(int graphicWidth) {
        int base = this.delayTime * graphicWidth;
        if (this.isSFStack(6)) {
            ItemStack stackInSlot = this.inventory.func_70301_a(6);
            return stackInSlot != null ? base / ((IStormForgeStackHandler)stackInSlot.func_77973_b()).ticksToComplete(stackInSlot) : 0;
        }
        return this.isRepairable(6) ? base / Settings.INSTANCE.sfTicksPerRepairPoint : (this.isSmeltable(6) ? base / Settings.INSTANCE.sfTicksToSmelt : 0);
    }
}

