/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import org.apache.logging.log4j.core.helpers.Strings;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.terraqueous.common.block.BlockClouds;
import shetiphian.terraqueous.common.block.BlockTypeCloud;
import shetiphian.terraqueous.common.misc.CraftingHandler;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeBase;

public class TileEntityTypeColored
extends TileEntityTypeBase
implements IRGB16_Tile {
    private RGB16 rgb16;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74777_a("rgb16", this.getRGB16(null).getIndex());
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.loadRGB16(nbtTag.func_74765_d("rgb16"));
    }

    private boolean loadRGB16(short rgbIndex) {
        if (rgbIndex > -1 && rgbIndex < 4096 && (this.rgb16 == null || rgbIndex != this.rgb16.getIndex())) {
            this.rgb16 = new RGB16(rgbIndex);
            return true;
        }
        return false;
    }

    public RGB16 getRGB16(EntityPlayer player) {
        if (this.rgb16 == null) {
            this.rgb16 = this.func_145838_q() instanceof BlockTypeCloud ? new RGB16("dyeBlue") : new RGB16("dyeWhite");
        }
        return this.rgb16;
    }

    public boolean setRGB16(short rgbIndex, EntityPlayer player) {
        boolean result = this.loadRGB16(rgbIndex);
        if (result) {
            Function.syncTile((TileEntity)this);
        }
        return result;
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        return state;
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        return Block.field_185505_j;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, ItemStack heldItem) {
        if (player == null) {
            return false;
        }
        if (heldItem == null) {
            return false;
        }
        String dyeName = CraftingHandler.INSTANCE.getDyeName(heldItem);
        if (!Strings.isEmpty((CharSequence)dyeName)) {
            if (!this.func_145831_w().field_72995_K) {
                if (player.func_70093_af()) {
                    this.getRGB16(null).subtract(dyeName);
                } else {
                    this.getRGB16(null).add(dyeName);
                }
                Function.syncTile((TileEntity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.add(this.func_145838_q() instanceof BlockTypeCloud ? Block.field_185506_k : Block.field_185505_j);
        return boxes;
    }

    @Override
    public boolean isSideSolid(EnumFacing facing) {
        return !(this.func_145838_q() instanceof BlockTypeCloud);
    }

    @Override
    public int getLightValue() {
        return this.getDamageValue() == 120 ? 14 : 0;
    }

    @Override
    public int colorMultiplier(int tintIndex) {
        return this.rgb16 != null && tintIndex == 0 ? this.rgb16.getColor() : 0xFFFFFF;
    }

    @Override
    public boolean renderSide(EnumFacing facing, boolean original) {
        if (this.func_145838_q() instanceof BlockTypeCloud) {
            BlockPos sPos = this.func_174877_v().func_177972_a(facing);
            IBlockState sState = this.func_145831_w().func_180495_p(sPos);
            Block sBlock = sState.func_177230_c();
            sState = sBlock.func_176221_a(sState, (IBlockAccess)this.func_145831_w(), sPos);
            AxisAlignedBB aabb = sState.func_185900_c((IBlockAccess)this.func_145831_w(), sPos);
            if (!sBlock.func_149688_o(sState).func_76222_j()) {
                boolean fx = aabb.field_72340_a == 0.0 && aabb.field_72336_d == 1.0;
                boolean fy = aabb.field_72338_b == 0.0 && aabb.field_72337_e == 1.0;
                boolean fz = aabb.field_72339_c == 0.0 && aabb.field_72334_f == 1.0;
                boolean[] edge = new boolean[]{aabb.field_72337_e == 1.0, aabb.field_72338_b == 0.0, aabb.field_72334_f == 1.0, aabb.field_72339_c == 0.0, aabb.field_72336_d == 1.0, aabb.field_72340_a == 0.0};
                if (edge[facing.func_176745_a()]) {
                    switch (facing) {
                        case DOWN: 
                        case UP: {
                            return !fx || !fz;
                        }
                        case NORTH: 
                        case SOUTH: {
                            return !fx || !fy;
                        }
                        case EAST: 
                        case WEST: {
                            return !fy || !fz;
                        }
                    }
                }
                if (sBlock instanceof BlockClouds) {
                    return false;
                }
                TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(facing));
                if (tile instanceof TileEntityTypeColored) {
                    return false;
                }
            }
            return true;
        }
        return original;
    }

    @Override
    public ItemStack pickBlock(RayTraceResult target, EntityPlayer player) {
        ItemStack stack = new ItemStack(this.func_145838_q().func_180660_a(this.func_145831_w().func_180495_p(this.func_174877_v()), null, 0), 1, this.getDamageValue());
        if (stack.func_77973_b() instanceof IRGB16_Item) {
            ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, this.getRGB16(null).getIndex());
            return stack;
        }
        return null;
    }
}

