/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockCloudFancy;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyBase;

public class TileEntityTypeFancyArch
extends TileEntityTypeFancyBase {
    @Override
    public IBlockState getActualState(IBlockState state) {
        if (this.getSavedType() == null) {
            String name = "arch_" + this.cornerName() + this.facing.func_176610_l();
            this.setSavedType(BlockCloudFancy.EnumType.byName(name));
        }
        return state.func_177226_a(BlockCloudFancy.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    private String cornerName() {
        boolean[] drawBox = this.getBoxes();
        int counter = 0;
        boolean[] blArray = drawBox;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean value = blArray[i];
            if (!value.booleanValue()) continue;
            ++counter;
        }
        if (counter == 5 || counter == 7) {
            boolean outside = counter == 5;
            boolean[] boxes = new boolean[]{drawBox[0], drawBox[1], drawBox[2], drawBox[3]};
            switch (this.facing) {
                case NORTH: {
                    return outside ? (!boxes[1] ? "outside_left_" : (!boxes[0] ? "outside_right_" : "")) : (boxes[3] ? "inside_right_" : (boxes[2] ? "inside_left_" : ""));
                }
                case EAST: {
                    return outside ? (!boxes[3] ? "outside_left_" : (!boxes[1] ? "outside_right_" : "")) : (boxes[2] ? "inside_right_" : (boxes[0] ? "inside_left_" : ""));
                }
                case SOUTH: {
                    return outside ? (!boxes[2] ? "outside_left_" : (!boxes[3] ? "outside_right_" : "")) : (boxes[0] ? "inside_right_" : (boxes[1] ? "inside_left_" : ""));
                }
                case WEST: {
                    return outside ? (!boxes[0] ? "outside_left_" : (!boxes[2] ? "outside_right_" : "")) : (boxes[1] ? "inside_right_" : (boxes[3] ? "inside_left_" : ""));
                }
            }
        }
        return "";
    }

    @Override
    public float[] getBoxBounds() {
        if (this.rayTracing) {
            return this.getBox(this.traceBlock);
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    private boolean[] getBoxes() {
        boolean[] drawBox = new boolean[8];
        drawBox[7] = true;
        drawBox[6] = true;
        drawBox[5] = true;
        drawBox[4] = true;
        switch (this.facing) {
            case SOUTH: {
                drawBox[3] = true;
                drawBox[2] = true;
                break;
            }
            case WEST: {
                drawBox[2] = true;
                drawBox[0] = true;
                break;
            }
            case NORTH: {
                drawBox[1] = true;
                drawBox[0] = true;
                break;
            }
            case EAST: {
                drawBox[3] = true;
                drawBox[1] = true;
                break;
            }
        }
        switch (this.facing) {
            case SOUTH: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177968_d());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.WEST) {
                        drawBox[3] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.EAST) break;
                    drawBox[2] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177978_c());
                if (otherStair == EnumFacing.WEST) {
                    drawBox[0] = true;
                    break;
                }
                if (otherStair != EnumFacing.EAST) break;
                drawBox[1] = true;
                break;
            }
            case NORTH: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177978_c());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.WEST) {
                        drawBox[1] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.EAST) break;
                    drawBox[0] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177968_d());
                if (otherStair == EnumFacing.WEST) {
                    drawBox[2] = true;
                    break;
                }
                if (otherStair != EnumFacing.EAST) break;
                drawBox[3] = true;
                break;
            }
            case WEST: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177976_e());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.SOUTH) {
                        drawBox[0] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.NORTH) break;
                    drawBox[2] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177974_f());
                if (otherStair == EnumFacing.SOUTH) {
                    drawBox[3] = true;
                    break;
                }
                if (otherStair != EnumFacing.NORTH) break;
                drawBox[1] = true;
                break;
            }
            case EAST: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177974_f());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.SOUTH) {
                        drawBox[1] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.NORTH) break;
                    drawBox[3] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177976_e());
                if (otherStair == EnumFacing.SOUTH) {
                    drawBox[2] = true;
                    break;
                }
                if (otherStair != EnumFacing.NORTH) break;
                drawBox[0] = true;
                break;
            }
        }
        return drawBox;
    }

    private float[] getBox(int box) {
        float[] valX = new float[]{0.0f, 0.5f};
        float[] valY = new float[]{0.0f, 0.5f};
        float[] valZ = new float[]{0.0f, 0.5f};
        if (box % 2 != 0) {
            valX[0] = 0.5f;
            valX[1] = 1.0f;
        }
        if (box > 3) {
            valY[0] = 0.5f;
            valY[1] = 1.0f;
        }
        if (box % 4 > 1) {
            valZ[0] = 0.5f;
            valZ[1] = 1.0f;
        }
        return new float[]{valX[0], valY[0], valZ[0], valX[1], valY[1], valZ[1]};
    }

    @Override
    public float[] getCollisionBoxes() {
        boolean[] drawBox = this.getBoxes();
        ArrayList<float[]> boxList = new ArrayList<float[]>();
        for (int build = 0; build < 8; build = (int)((byte)(build + 1))) {
            if (!drawBox[build]) continue;
            boxList.add(this.getBox(build));
        }
        float[] collisionBoxes = new float[6 * boxList.size()];
        int set = 0;
        for (float[] box : boxList) {
            System.arraycopy(box, 0, collisionBoxes, 6 * set, 6);
            set = (byte)(set + 1);
        }
        return collisionBoxes;
    }

    private EnumFacing shouldConnect(BlockPos pos) {
        TileEntity tile = this.func_145831_w().func_175625_s(pos);
        if (tile instanceof TileEntityTypeFancyArch && this.func_145838_q() == tile.func_145838_q()) {
            return ((TileEntityTypeFancyArch)tile).facing;
        }
        return null;
    }

    @Override
    public RayTraceResult collisionRayTrace(IBlockState state, Vec3d startVec, Vec3d endVec, RayTraceResult original) {
        if (!(this.func_145838_q() instanceof BlockCloudFancy)) {
            return original;
        }
        BlockCloudFancy block = (BlockCloudFancy)this.func_145838_q();
        RayTraceResult[] arrayMOP = new RayTraceResult[8];
        this.rayTracing = true;
        for (int build = 0; build < 8; build = (int)((byte)(build + 1))) {
            this.traceBlock = build;
            arrayMOP[build] = block.preformRayTrace(state, this.func_145831_w(), this.func_174877_v(), startVec, endVec);
        }
        boolean[] boxes = this.getBoxes();
        for (int box = 0; box < 8; box = (int)((byte)(box + 1))) {
            if (boxes[box]) continue;
            arrayMOP[box] = null;
        }
        RayTraceResult returnMOP = null;
        double distance = 0.0;
        for (RayTraceResult tmpMOP : arrayMOP) {
            double tmpDistance;
            if (tmpMOP == null || !((tmpDistance = tmpMOP.field_72307_f.func_72436_e(endVec)) > distance)) continue;
            returnMOP = tmpMOP;
            distance = tmpDistance;
        }
        this.rayTracing = false;
        return returnMOP;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        this.setSavedType(null);
        Function.syncTile((TileEntity)this);
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        boolean[] boxes = this.getBoxes();
        switch (side) {
            case UP: {
                return boxes[4] && boxes[5] && boxes[6] && boxes[7];
            }
            case DOWN: {
                return boxes[0] && boxes[1] && boxes[2] && boxes[3];
            }
            case NORTH: {
                return boxes[0] && boxes[1] && boxes[4] && boxes[5];
            }
            case SOUTH: {
                return boxes[2] && boxes[3] && boxes[6] && boxes[7];
            }
            case EAST: {
                return boxes[1] && boxes[3] && boxes[5] && boxes[7];
            }
            case WEST: {
                return boxes[0] && boxes[2] && boxes[4] && boxes[6];
            }
        }
        return false;
    }

    @Override
    public boolean rotateBlock(EnumFacing axis) {
        this.facing = this.facing.func_176746_e();
        Function.syncTile((TileEntity)this);
        return true;
    }

    @Override
    public boolean renderSide(EnumFacing side, boolean original) {
        boolean[] boxes = this.getBoxes();
        switch (side) {
            case UP: {
                return !boxes[4] || !boxes[5] || !boxes[6] || !boxes[7] || original;
            }
            case DOWN: {
                return !boxes[0] || !boxes[1] || !boxes[2] || !boxes[3] || original;
            }
            case NORTH: {
                return !boxes[0] || !boxes[1] || !boxes[4] || !boxes[5] || original;
            }
            case SOUTH: {
                return !boxes[2] || !boxes[3] || !boxes[6] || !boxes[7] || original;
            }
            case WEST: {
                return !boxes[1] || !boxes[3] || !boxes[5] || !boxes[7] || original;
            }
            case EAST: {
                return !boxes[0] || !boxes[2] || !boxes[4] || !boxes[6] || original;
            }
        }
        return original;
    }
}

