/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockCloudFancy;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyBase;

public class TileEntityTypeFancyEdge
extends TileEntityTypeFancyBase {
    @Override
    public IBlockState getActualState(IBlockState state) {
        if (this.getSavedType() == null) {
            String name = "edge_" + this.cornerName() + this.facing.func_176610_l();
            this.setSavedType(BlockCloudFancy.EnumType.byName(name));
        }
        return state.func_177226_a(BlockCloudFancy.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    private String cornerName() {
        boolean[] drawBox = this.getBoxes();
        boolean[] boxes = new boolean[]{drawBox[8], drawBox[9], drawBox[10], drawBox[11]};
        int counter = 0;
        boolean[] blArray = boxes;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean value = blArray[i];
            if (!value.booleanValue()) continue;
            ++counter;
        }
        if (counter == 1 || counter == 3) {
            boolean outside = counter == 1;
            switch (this.facing) {
                case NORTH: {
                    return outside ? (!boxes[1] ? "outside_left_" : (!boxes[0] ? "outside_right_" : "")) : (boxes[3] ? "inside_right_" : (boxes[2] ? "inside_left_" : ""));
                }
                case EAST: {
                    return outside ? (!boxes[3] ? "outside_left_" : (!boxes[1] ? "outside_right_" : "")) : (boxes[2] ? "inside_right_" : (boxes[0] ? "inside_left_" : ""));
                }
                case SOUTH: {
                    return outside ? (!boxes[2] ? "outside_left_" : (!boxes[3] ? "outside_right_" : "")) : (boxes[0] ? "inside_right_" : (boxes[1] ? "inside_left_" : ""));
                }
                case WEST: {
                    return outside ? (!boxes[0] ? "outside_left_" : (!boxes[2] ? "outside_right_" : "")) : (boxes[1] ? "inside_right_" : (boxes[3] ? "inside_left_" : ""));
                }
            }
        }
        return "";
    }

    @Override
    public float[] getBoxBounds() {
        if (this.rayTracing) {
            return this.getBox(this.traceBlock);
        }
        boolean[] boxes = this.getBoxes();
        float minX = boxes[8] || boxes[10] ? 0.0f : 0.5f;
        float maxX = boxes[9] || boxes[11] ? 1.0f : 0.5f;
        float minZ = boxes[8] || boxes[9] ? 0.0f : 0.5f;
        float maxZ = boxes[10] || boxes[11] ? 1.0f : 0.5f;
        return new float[]{minX, 0.0f, minZ, maxX, 1.0f, maxZ};
    }

    private boolean[] getBoxes() {
        boolean[] drawBox = new boolean[12];
        switch (this.facing) {
            case SOUTH: {
                drawBox[10] = true;
                drawBox[11] = true;
                drawBox[2] = true;
                drawBox[7] = true;
                drawBox[3] = true;
                break;
            }
            case WEST: {
                drawBox[8] = true;
                drawBox[10] = true;
                drawBox[0] = true;
                drawBox[6] = true;
                drawBox[2] = true;
                break;
            }
            case NORTH: {
                drawBox[9] = true;
                drawBox[8] = true;
                drawBox[1] = true;
                drawBox[4] = true;
                drawBox[0] = true;
                break;
            }
            case EAST: {
                drawBox[11] = true;
                drawBox[9] = true;
                drawBox[3] = true;
                drawBox[5] = true;
                drawBox[1] = true;
                break;
            }
        }
        switch (this.facing) {
            case SOUTH: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177968_d());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.WEST) {
                        drawBox[11] = false;
                        drawBox[7] = false;
                        drawBox[3] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.EAST) break;
                    drawBox[10] = false;
                    drawBox[7] = false;
                    drawBox[2] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177978_c());
                if (otherStair == EnumFacing.WEST) {
                    drawBox[8] = true;
                    drawBox[6] = true;
                    drawBox[0] = true;
                    break;
                }
                if (otherStair != EnumFacing.EAST) break;
                drawBox[9] = true;
                drawBox[5] = true;
                drawBox[1] = true;
                break;
            }
            case NORTH: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177978_c());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.WEST) {
                        drawBox[9] = false;
                        drawBox[4] = false;
                        drawBox[1] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.EAST) break;
                    drawBox[8] = false;
                    drawBox[4] = false;
                    drawBox[0] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177968_d());
                if (otherStair == EnumFacing.WEST) {
                    drawBox[10] = true;
                    drawBox[6] = true;
                    drawBox[2] = true;
                    break;
                }
                if (otherStair != EnumFacing.EAST) break;
                drawBox[11] = true;
                drawBox[5] = true;
                drawBox[3] = true;
                break;
            }
            case WEST: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177976_e());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.SOUTH) {
                        drawBox[8] = false;
                        drawBox[6] = false;
                        drawBox[0] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.NORTH) break;
                    drawBox[10] = false;
                    drawBox[6] = false;
                    drawBox[2] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177974_f());
                if (otherStair == EnumFacing.SOUTH) {
                    drawBox[11] = true;
                    drawBox[7] = true;
                    drawBox[3] = true;
                    break;
                }
                if (otherStair != EnumFacing.NORTH) break;
                drawBox[9] = true;
                drawBox[4] = true;
                drawBox[1] = true;
                break;
            }
            case EAST: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177974_f());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.SOUTH) {
                        drawBox[9] = false;
                        drawBox[5] = false;
                        drawBox[1] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.NORTH) break;
                    drawBox[11] = false;
                    drawBox[5] = false;
                    drawBox[3] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177976_e());
                if (otherStair == EnumFacing.SOUTH) {
                    drawBox[10] = true;
                    drawBox[7] = true;
                    drawBox[2] = true;
                    break;
                }
                if (otherStair != EnumFacing.NORTH) break;
                drawBox[8] = true;
                drawBox[4] = true;
                drawBox[0] = true;
                break;
            }
        }
        return drawBox;
    }

    private float[] getBox(int box) {
        float[] y = new float[]{box < 8 ? 0.0f : 0.75f, box < 8 ? 0.75f : 1.0f};
        switch (box) {
            case 0: {
                return new float[]{0.0f, y[0], 0.0f, 0.25f, y[1], 0.25f};
            }
            case 1: {
                return new float[]{0.75f, y[0], 0.0f, 1.0f, y[1], 0.25f};
            }
            case 2: {
                return new float[]{0.0f, y[0], 0.75f, 0.25f, y[1], 1.0f};
            }
            case 3: {
                return new float[]{0.75f, y[0], 0.75f, 1.0f, y[1], 1.0f};
            }
            case 4: {
                return new float[]{0.25f, y[0], 0.0f, 0.75f, y[1], 0.25f};
            }
            case 5: {
                return new float[]{0.75f, y[0], 0.25f, 1.0f, y[1], 0.75f};
            }
            case 6: {
                return new float[]{0.0f, y[0], 0.25f, 0.25f, y[1], 0.75f};
            }
            case 7: {
                return new float[]{0.25f, y[0], 0.75f, 0.75f, y[1], 1.0f};
            }
            case 8: {
                return new float[]{0.0f, y[0], 0.0f, 0.5f, y[1], 0.5f};
            }
            case 9: {
                return new float[]{0.5f, y[0], 0.0f, 1.0f, y[1], 0.5f};
            }
            case 10: {
                return new float[]{0.0f, y[0], 0.5f, 0.5f, y[1], 1.0f};
            }
            case 11: {
                return new float[]{0.5f, y[0], 0.5f, 1.0f, y[1], 1.0f};
            }
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public float[] getCollisionBoxes() {
        boolean[] drawBox = this.getBoxes();
        ArrayList<float[]> boxList = new ArrayList<float[]>();
        for (int build = 0; build < 12; build = (int)((byte)(build + 1))) {
            if (!drawBox[build]) continue;
            boxList.add(this.getBox(build));
        }
        float[] collisionBoxes = new float[6 * boxList.size()];
        int set = 0;
        for (float[] box : boxList) {
            System.arraycopy(box, 0, collisionBoxes, 6 * set, 6);
            set = (byte)(set + 1);
        }
        return collisionBoxes;
    }

    private EnumFacing shouldConnect(BlockPos pos) {
        TileEntity tile = this.func_145831_w().func_175625_s(pos);
        if (tile instanceof TileEntityTypeFancyEdge && this.func_145838_q() == tile.func_145838_q()) {
            return ((TileEntityTypeFancyEdge)tile).facing;
        }
        return null;
    }

    @Override
    public RayTraceResult collisionRayTrace(IBlockState state, Vec3d startVec, Vec3d endVec, RayTraceResult original) {
        if (!(this.func_145838_q() instanceof BlockCloudFancy)) {
            return original;
        }
        BlockCloudFancy block = (BlockCloudFancy)this.func_145838_q();
        RayTraceResult[] arrayMOP = new RayTraceResult[12];
        this.rayTracing = true;
        for (int build = 0; build < 12; build = (int)((byte)(build + 1))) {
            this.traceBlock = build;
            arrayMOP[build] = block.preformRayTrace(state, this.func_145831_w(), this.func_174877_v(), startVec, endVec);
        }
        boolean[] boxes = this.getBoxes();
        for (int box = 0; box < 12; box = (int)((byte)(box + 1))) {
            if (boxes[box]) continue;
            arrayMOP[box] = null;
        }
        RayTraceResult returnMOP = null;
        double distance = 0.0;
        for (RayTraceResult tmpMOP : arrayMOP) {
            double tmpDistance;
            if (tmpMOP == null || !((tmpDistance = tmpMOP.field_72307_f.func_72436_e(endVec)) > distance)) continue;
            returnMOP = tmpMOP;
            distance = tmpDistance;
        }
        this.rayTracing = false;
        return returnMOP;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        this.setSavedType(null);
        Function.syncTile((TileEntity)this);
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        boolean[] boxes = this.getBoxes();
        switch (side) {
            case NORTH: {
                return boxes[0] && boxes[1] && boxes[4] && boxes[8] && boxes[9];
            }
            case SOUTH: {
                return boxes[2] && boxes[3] && boxes[7] && boxes[10] && boxes[11];
            }
            case EAST: {
                return boxes[1] && boxes[3] && boxes[5] && boxes[9] && boxes[11];
            }
            case WEST: {
                return boxes[0] && boxes[2] && boxes[6] && boxes[8] && boxes[10];
            }
        }
        return false;
    }

    @Override
    public boolean rotateBlock(EnumFacing axis) {
        this.facing = this.facing.func_176746_e();
        Function.syncTile((TileEntity)this);
        return true;
    }

    @Override
    public boolean renderSide(EnumFacing side, boolean original) {
        return side == EnumFacing.DOWN || original;
    }
}

