/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.block.BlockTypeCloud;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeBase;

public class TileEntityTypeFence
extends TileEntityTypeBase {
    public byte style = 0;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("style", this.style);
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.style = nbtTag.func_74771_c("style");
        this.setSavedType(null);
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        state = ((BlockTypeBase)this.func_145838_q()).getBlockType(state, this.style);
        if (this.getSavedType() == null) {
            boolean altStyle = this.func_145838_q() instanceof BlockTypeCloud;
            boolean[] connect = this.getConnections(altStyle);
            String name = (connect[4] ? "v" : "") + (connect[2] ? "n" : "") + (connect[1] ? "e" : "") + (connect[3] ? "s" : "") + (connect[0] ? "w" : "");
            if (!altStyle && connect[5] && (name.equals("ns") || name.equals("ew"))) {
                name = "u" + name;
            }
            name = name.isEmpty() ? "fence" : "fence_" + name;
            this.setSavedType(BlockTypeBase.EnumType.byName(name));
        }
        return state.func_177226_a(BlockTypeBase.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    private boolean[] getConnections(boolean altStyle) {
        boolean[] connect = new boolean[6];
        EnumFacing[] face = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.UP};
        for (int side = 0; side < 5; side = (int)((byte)(side + 1))) {
            BlockPos oPos = this.func_174877_v().func_177972_a(face[side]);
            IBlockState oState = this.func_145831_w().func_180495_p(oPos);
            Block oBlock = oState.func_177230_c();
            if (oBlock == null) continue;
            connect[side] = oBlock.isSideSolid(oState, (IBlockAccess)this.func_145831_w(), oPos, face[side].func_176734_d());
            if (!connect[side]) {
                int sideMeta = oBlock.func_176201_c(oState);
                boolean bl = connect[side] = oBlock == this.func_145838_q() && (sideMeta == 2 || sideMeta == 3);
            }
            if (!connect[side]) {
                connect[side] = oBlock instanceof BlockFenceGate;
            }
            if (connect[side]) continue;
            connect[side] = altStyle ? oBlock instanceof BlockWall : oBlock instanceof BlockFence;
        }
        if (!altStyle) {
            connect[5] = connect[4];
            BlockPos downPos = this.func_174877_v().func_177977_b();
            IBlockState downState = this.func_145831_w().func_180495_p(downPos);
            Block downBlock = this.func_145831_w().func_180495_p(this.func_174877_v().func_177977_b()).func_177230_c();
            AxisAlignedBB aabb = downState.func_185900_c((IBlockAccess)this.func_145831_w(), downPos);
            connect[4] = !(downBlock.func_176200_f((IBlockAccess)this.func_145831_w(), downPos) || aabb != null && aabb.field_72337_e < 0.9375);
        }
        return connect;
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        double minZ;
        double maxX;
        double minX;
        boolean altStyle = this.func_145838_q() instanceof BlockTypeCloud;
        boolean[] connect = this.getConnections(altStyle);
        double d = connect[0] ? 0.0 : (minX = altStyle ? 0.25 : 0.375);
        double d2 = connect[1] ? 1.0 : (maxX = altStyle ? 0.75 : 0.625);
        double d3 = connect[2] ? 0.0 : (minZ = altStyle ? 0.25 : 0.375);
        double maxZ = connect[3] ? 1.0 : (altStyle ? 0.75 : 0.625);
        double minY = altStyle || connect[4] ? 0.0 : 0.3125;
        double maxY = 1.0;
        if (altStyle) {
            boolean[] group = new boolean[]{!connect[0] && !connect[1] && connect[2] && connect[3], connect[0] && connect[1] && !connect[2] && !connect[3]};
            if ((group[0] || group[1]) && this.func_145831_w().func_175623_d(this.func_174877_v().func_177984_a())) {
                maxY = 0.8125;
            }
            minX = group[0] ? 0.3125 : minX;
            maxX = group[0] ? 0.6875 : maxX;
            minZ = group[1] ? 0.3125 : minZ;
            maxZ = group[1] ? 0.6875 : maxZ;
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        double max;
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boolean aboveWide = false;
        boolean aboveShort = false;
        BlockPos upPos = this.func_174877_v().func_177984_a();
        if (!this.func_145831_w().func_175623_d(upPos)) {
            IBlockState upState = this.func_145831_w().func_180495_p(upPos);
            AxisAlignedBB aabb = upState.func_185900_c((IBlockAccess)this.func_145831_w(), upPos);
            aboveWide = aabb != null && aabb.field_72340_a <= 0.2 && aabb.field_72339_c <= 0.2 && aabb.field_72336_d >= 0.8 && aabb.field_72334_f >= 0.8;
            aboveShort = aabb == null || aabb.field_72337_e - aabb.field_72338_b < 0.5;
        }
        boolean altStyle = this.func_145838_q() instanceof BlockTypeCloud;
        boolean[] connect = this.getConnections(altStyle);
        double minY = altStyle || connect[4] ? 0.0 : 0.3125;
        double maxY = !aboveWide ? 1.5 : 1.0;
        double min = altStyle ? 0.25 : 0.375;
        double d = max = altStyle ? 0.75 : 0.625;
        if (connect[0]) {
            boxes.add(new AxisAlignedBB(0.0, minY, min, 0.5, maxY, max));
        }
        if (connect[1]) {
            boxes.add(new AxisAlignedBB(0.5, minY, min, 1.0, maxY, max));
        }
        if (connect[2]) {
            boxes.add(new AxisAlignedBB(min, minY, 0.0, max, maxY, 0.5));
        }
        if (connect[3]) {
            boxes.add(new AxisAlignedBB(min, minY, 0.5, max, maxY, 1.0));
        }
        if (boxes.isEmpty()) {
            boxes.add(new AxisAlignedBB(min, minY, min, max, maxY, max));
        }
        if (aboveWide && aboveShort) {
            boxes.add(new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0));
        }
        return boxes;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        this.setSavedType(null);
        Function.syncTile((TileEntity)this);
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return side == EnumFacing.DOWN || side == EnumFacing.UP;
    }

    @Override
    public int providedPower(EnumFacing side, int original) {
        if (side == EnumFacing.DOWN) {
            return this.func_145831_w().func_175651_c(this.func_174877_v().func_177984_a(), EnumFacing.UP) - 1;
        }
        if (side == EnumFacing.UP) {
            return this.func_145831_w().func_175651_c(this.func_174877_v().func_177977_b(), EnumFacing.DOWN) - 1;
        }
        return 0;
    }

    @Override
    public int getDamageValue() {
        return super.getDamageValue() + this.style;
    }
}

