/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.block.BlockTypeCloud;
import shetiphian.terraqueous.common.tileentity.EnumPassageStatus;
import shetiphian.terraqueous.common.tileentity.TileEntityTypePassageBase;

public class TileEntityTypeGate
extends TileEntityTypePassageBase {
    private static final AxisAlignedBB AABB_NS = new AxisAlignedBB(0.0, 0.3125, 0.375, 1.0, 1.0, 0.625);
    private static final AxisAlignedBB AABB_NS_WALL = new AxisAlignedBB(0.0, 0.125, 0.375, 1.0, 0.8125, 0.625);
    private static final AxisAlignedBB AABB_NS_PLATE = new AxisAlignedBB(0.0, 0.9375, 0.40625, 1.0, 1.0, 0.59375);
    private static final AxisAlignedBB AABB_EW = new AxisAlignedBB(0.375, 0.3125, 0.0, 0.625, 1.0, 1.0);
    private static final AxisAlignedBB AABB_EW_WALL = new AxisAlignedBB(0.375, 0.125, 0.0, 0.625, 0.8125, 1.0);
    private static final AxisAlignedBB AABB_EW_PLATE = new AxisAlignedBB(0.40625, 0.9375, 0.0, 0.59375, 1.0, 1.0);
    public byte gateStyle = 0;
    public EnumFacing gateFacing = EnumFacing.NORTH;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("style", this.gateStyle);
        nbtTag.func_74778_a("facing", this.gateFacing.func_176610_l());
        nbtTag.func_74774_a("status", this.getStatus().getValue());
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.gateStyle = nbtTag.func_74771_c("style");
        this.gateFacing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
        this.setStatus(EnumPassageStatus.byValue(nbtTag.func_74771_c("status")));
        this.setSavedType(null);
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        state = ((BlockTypeBase)this.func_145838_q()).getBlockType(state, this.gateStyle);
        if (this.getSavedType() == null) {
            String name = "gate_" + (this.wallConnect() ? "wall_" : "") + (this.getStatus().isOpen() ? "open_" : "") + this.gateFacing.func_176610_l();
            this.setSavedType(BlockTypeBase.EnumType.byName(name));
        }
        return state.func_177226_a(BlockTypeBase.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    private boolean wallConnect() {
        boolean northsouth = this.isNorthOrSouth(this.gateFacing);
        if (this.func_145838_q() instanceof BlockTypeCloud) {
            return true;
        }
        if (northsouth) {
            return this.func_145831_w().func_180495_p(this.func_174877_v().func_177974_f()).func_177230_c() instanceof BlockWall && this.func_145831_w().func_180495_p(this.func_174877_v().func_177976_e()).func_177230_c() instanceof BlockWall;
        }
        return this.func_145831_w().func_180495_p(this.func_174877_v().func_177978_c()).func_177230_c() instanceof BlockWall && this.func_145831_w().func_180495_p(this.func_174877_v().func_177968_d()).func_177230_c() instanceof BlockWall;
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        if (this.isNorthOrSouth(this.gateFacing)) {
            return this.wallConnect() ? AABB_NS_WALL : AABB_NS;
        }
        return this.wallConnect() ? AABB_EW_WALL : AABB_EW;
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        if (this.blockAbove()) {
            boxes.add(this.isNorthOrSouth(this.gateFacing) ? AABB_NS_PLATE : AABB_EW_PLATE);
        }
        if (!this.getStatus().isOpen()) {
            boxes.add(this.getBoxBounds().func_186666_e(1.5));
        }
        return boxes;
    }

    private boolean blockAbove() {
        BlockPos sPos = this.func_174877_v().func_177984_a();
        if (!this.func_145831_w().func_175623_d(sPos)) {
            IBlockState sState = this.func_145831_w().func_180495_p(sPos);
            Block block = sState.func_177230_c();
            AxisAlignedBB aabb = sState.func_185900_c((IBlockAccess)this.func_145831_w(), sPos);
            return aabb != null && aabb.field_72338_b <= 0.0625 || block instanceof BlockBasePressurePlate;
        }
        return false;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return side == EnumFacing.UP;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, ItemStack heldItem) {
        if (!this.func_145831_w().field_72995_K) {
            EnumPassageStatus newStatus = this.getStatus();
            boolean isOpen = this.getStatus().isOpen();
            boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
            switch (this.getStatus()) {
                case CLOSED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.OPEN;
                    break;
                }
                case OPEN: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    break;
                }
                case CLOSED_POWERED: {
                    newStatus = isPowered ? EnumPassageStatus.OPEN_POWERED : EnumPassageStatus.CLOSED;
                    break;
                }
                case OPEN_POWERED: {
                    newStatus = isPowered ? EnumPassageStatus.CLOSED_POWERED : EnumPassageStatus.CLOSED;
                }
            }
            this.setStatus(newStatus);
            if (player != null && newStatus.isOpen()) {
                EnumFacing facing = player.func_174811_aO();
                if (this.isNorthOrSouth(this.gateFacing) == this.isNorthOrSouth(facing)) {
                    this.gateFacing = facing;
                }
            }
            Function.syncTile((TileEntity)this);
            if (isOpen != this.getStatus().isOpen()) {
                this.func_145831_w().func_180498_a(null, isOpen ? 1014 : 1008, this.func_174877_v(), 0);
            }
        }
        return true;
    }

    private boolean isNorthOrSouth(EnumFacing facing) {
        return facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        boolean isPowered = this.func_145831_w().func_175640_z(this.func_174877_v());
        if (isPowered && !this.getStatus().isPowered() || !isPowered && this.getStatus().isPowered()) {
            this.blockActivated(null, null);
        }
    }

    @Override
    public boolean blockMovementAI() {
        return !this.getStatus().isOpen();
    }

    @Override
    public int getDamageValue() {
        return super.getDamageValue() + this.gateStyle;
    }
}

