/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeBase;

public class TileEntityTypeSlab
extends TileEntityTypeBase {
    private static final AxisAlignedBB AABB_LOWER = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB AABB_UPPER = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    public byte styleTop = (byte)-1;
    public byte styleBottom = (byte)-1;
    private boolean rayTracing = false;
    private int traceBlock = 0;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("styleTop", this.styleTop);
        nbtTag.func_74774_a("styleBottom", this.styleBottom);
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.styleTop = nbtTag.func_74771_c("styleTop");
        this.styleBottom = nbtTag.func_74771_c("styleBottom");
        this.setSavedType(null);
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        boolean inverted = this.styleBottom == -1;
        boolean stacked = this.styleBottom != -1 && this.styleTop != -1;
        state = ((BlockTypeBase)this.func_145838_q()).getBlockType(state, inverted ? this.styleTop : this.styleBottom);
        if (this.getSavedType() == null) {
            String name = inverted ? "invert" : (stacked ? "double" + this.styleTop : "");
            name = name.isEmpty() ? "slab" : "slab_" + name;
            this.setSavedType(BlockTypeBase.EnumType.byName(name));
            this.func_145831_w().func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
        return state.func_177226_a(BlockTypeBase.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        if (this.rayTracing) {
            return this.getBox(this.traceBlock);
        }
        if (this.styleTop > -1 && this.styleBottom == -1) {
            return this.getBox(2);
        }
        if (this.styleTop == -1 && this.styleBottom > -1) {
            return this.getBox(1);
        }
        return this.getBox(0);
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        if (this.styleTop > -1 && this.styleBottom == -1) {
            boxes.add(this.getBox(2));
        } else if (this.styleTop == -1 && this.styleBottom > -1) {
            boxes.add(this.getBox(1));
        } else {
            boxes.add(this.getBox(0));
        }
        return boxes;
    }

    private AxisAlignedBB getBox(int box) {
        switch (box) {
            case 1: {
                return AABB_LOWER;
            }
            case 2: {
                return AABB_UPPER;
            }
        }
        return Block.field_185505_j;
    }

    @Override
    public RayTraceResult collisionRayTrace(IBlockState state, Vec3d startVec, Vec3d endVec, RayTraceResult original) {
        if (!(this.func_145838_q() instanceof BlockTypeBase)) {
            return original;
        }
        BlockTypeBase block = (BlockTypeBase)this.func_145838_q();
        if (this.styleTop == -1 || this.styleBottom == -1) {
            return block.preformRayTrace(this.func_174877_v(), startVec, endVec, this.getBoxBounds());
        }
        RayTraceResult areaHit = null;
        this.rayTracing = true;
        double hitDist = 100.0;
        for (int slab = 1; slab < 3; slab = (int)((byte)(slab + 1))) {
            this.traceBlock = slab;
            RayTraceResult slabHit = block.preformRayTrace(this.func_174877_v(), startVec, endVec, this.getBox(slab));
            if (slabHit == null) continue;
            slabHit.subHit = slab;
            double ringDist = slabHit.field_72307_f.func_72436_e(startVec);
            if (!(ringDist < hitDist)) continue;
            hitDist = ringDist;
            areaHit = slabHit;
        }
        if (areaHit != null && areaHit.subHit > 0) {
            this.traceBlock = areaHit.subHit;
            return areaHit;
        }
        this.rayTracing = false;
        return original;
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        return this.styleTop > -1 && this.styleBottom > -1 || this.styleTop > -1 && side == EnumFacing.UP || this.styleBottom > -1 && side == EnumFacing.DOWN;
    }

    @Override
    public int providedPower(EnumFacing side, int original) {
        return this.styleTop > -1 && this.styleBottom > -1 ? original - 1 : 0;
    }

    @Override
    public boolean removeBlock(EntityPlayer player, boolean willHarvest) {
        if (this.styleTop == -1 || this.styleBottom == -1) {
            return true;
        }
        Function.BlockInfo blockInfo = Function.getBlockInfront((World)this.func_145831_w(), (EntityPlayer)player, (double)5.0);
        this.rayTracing = false;
        if (blockInfo != null) {
            if (blockInfo.sub == 1 && this.styleBottom > -1) {
                if (player == null || !player.field_71075_bZ.field_75098_d) {
                    Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)new ItemStack(this.func_145838_q(), 1, this.getDamageValue() + this.styleBottom));
                }
                this.styleBottom = (byte)-1;
            } else if (blockInfo.sub == 2 && this.styleTop > -1) {
                if (player == null || !player.field_71075_bZ.field_75098_d) {
                    Function.dropItem((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (ItemStack)new ItemStack(this.func_145838_q(), 1, this.getDamageValue() + this.styleTop));
                }
                this.styleTop = (byte)-1;
            }
        }
        Function.syncTile((TileEntity)this);
        return false;
    }

    @Override
    public List<ItemStack> getDrops(int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        if (this.styleBottom > -1) {
            ret.add(new ItemStack(this.func_145838_q(), 1, this.getDamageValue() + this.styleBottom));
        }
        if (this.styleTop > -1) {
            ret.add(new ItemStack(this.func_145838_q(), 1, this.getDamageValue() + this.styleTop));
        }
        return ret;
    }

    @Override
    public boolean rotateBlock(EnumFacing axis) {
        if (this.styleTop == this.styleBottom) {
            return false;
        }
        byte temp = this.styleTop;
        this.styleTop = this.styleBottom;
        this.styleBottom = temp;
        Function.syncTile((TileEntity)this);
        return true;
    }

    @Override
    public boolean renderSide(EnumFacing side, boolean original) {
        if ((this.styleTop == -1 || this.styleBottom == -1) && (side == EnumFacing.DOWN && this.styleTop > -1 || side == EnumFacing.UP && this.styleBottom > -1)) {
            return true;
        }
        return original;
    }

    @Override
    public ItemStack pickBlock(RayTraceResult target, EntityPlayer player) {
        byte style = this.styleTop > -1 && this.styleBottom > -1 ? (target.subHit == 1 ? this.styleBottom : this.styleTop) : (this.styleBottom > -1 ? this.styleBottom : this.styleTop);
        return new ItemStack(this.func_145838_q(), 1, this.getDamageValue() + style);
    }
}

