/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.common.block.BlockTypeBase;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeBase;

public class TileEntityTypeStairs
extends TileEntityTypeBase {
    public byte style = 0;
    public EnumFacing facing = EnumFacing.NORTH;
    public boolean inverted = false;
    private boolean rayTracing = false;
    private int traceBlock = 0;

    protected void buildNBT(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("style", this.style);
        nbtTag.func_74778_a("facing", this.facing.func_176610_l());
        nbtTag.func_74757_a("inverted", this.inverted);
    }

    protected void processNBT(NBTTagCompound nbtTag) {
        this.style = nbtTag.func_74771_c("style");
        this.facing = EnumFacing.func_176739_a((String)nbtTag.func_74779_i("facing"));
        this.inverted = nbtTag.func_74767_n("inverted");
        this.setSavedType(null);
    }

    @Override
    public IBlockState getActualState(IBlockState state) {
        state = ((BlockTypeBase)this.func_145838_q()).getBlockType(state, this.style);
        if (this.getSavedType() == null) {
            String name = "stairs_" + (this.inverted ? "invert_" : "") + this.cornerName() + this.facing.func_176610_l();
            this.setSavedType(BlockTypeBase.EnumType.byName(name));
        }
        return state.func_177226_a(BlockTypeBase.VARIANT, (Comparable)((Object)this.getSavedType()));
    }

    private String cornerName() {
        boolean[] drawBox = this.getBoxes();
        int counter = 0;
        boolean[] blArray = drawBox;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean value = blArray[i];
            if (!value.booleanValue()) continue;
            ++counter;
        }
        if (counter == 5 || counter == 7) {
            boolean outside = counter == 5;
            boolean[] boxes = new boolean[]{drawBox[4], drawBox[5], drawBox[6], drawBox[7]};
            if (this.inverted) {
                boxes = new boolean[]{drawBox[0], drawBox[1], drawBox[2], drawBox[3]};
            }
            switch (this.facing) {
                case NORTH: {
                    return outside ? (!boxes[1] ? "outside_left_" : (!boxes[0] ? "outside_right_" : "")) : (boxes[3] ? "inside_right_" : (boxes[2] ? "inside_left_" : ""));
                }
                case EAST: {
                    return outside ? (!boxes[3] ? "outside_left_" : (!boxes[1] ? "outside_right_" : "")) : (boxes[2] ? "inside_right_" : (boxes[0] ? "inside_left_" : ""));
                }
                case SOUTH: {
                    return outside ? (!boxes[2] ? "outside_left_" : (!boxes[3] ? "outside_right_" : "")) : (boxes[0] ? "inside_right_" : (boxes[1] ? "inside_left_" : ""));
                }
                case WEST: {
                    return outside ? (!boxes[0] ? "outside_left_" : (!boxes[2] ? "outside_right_" : "")) : (boxes[1] ? "inside_right_" : (boxes[3] ? "inside_left_" : ""));
                }
            }
        }
        return "";
    }

    @Override
    public AxisAlignedBB getBoxBounds() {
        if (this.rayTracing) {
            return this.getBox(this.traceBlock);
        }
        return Block.field_185505_j;
    }

    private boolean[] getBoxes() {
        boolean[] drawBox = new boolean[8];
        drawBox[3] = true;
        drawBox[2] = true;
        drawBox[1] = true;
        drawBox[0] = true;
        switch (this.facing) {
            case SOUTH: {
                drawBox[7] = true;
                drawBox[6] = true;
                break;
            }
            case WEST: {
                drawBox[6] = true;
                drawBox[4] = true;
                break;
            }
            case NORTH: {
                drawBox[5] = true;
                drawBox[4] = true;
                break;
            }
            case EAST: {
                drawBox[7] = true;
                drawBox[5] = true;
                break;
            }
        }
        switch (this.facing) {
            case SOUTH: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177968_d());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.WEST) {
                        drawBox[7] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.EAST) break;
                    drawBox[6] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177978_c());
                if (otherStair == EnumFacing.WEST) {
                    drawBox[4] = true;
                    break;
                }
                if (otherStair != EnumFacing.EAST) break;
                drawBox[5] = true;
                break;
            }
            case NORTH: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177978_c());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.WEST) {
                        drawBox[5] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.EAST) break;
                    drawBox[4] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177968_d());
                if (otherStair == EnumFacing.WEST) {
                    drawBox[6] = true;
                    break;
                }
                if (otherStair != EnumFacing.EAST) break;
                drawBox[7] = true;
                break;
            }
            case WEST: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177976_e());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.SOUTH) {
                        drawBox[4] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.NORTH) break;
                    drawBox[6] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177974_f());
                if (otherStair == EnumFacing.SOUTH) {
                    drawBox[7] = true;
                    break;
                }
                if (otherStair != EnumFacing.NORTH) break;
                drawBox[5] = true;
                break;
            }
            case EAST: {
                EnumFacing otherStair = this.shouldConnect(this.func_174877_v().func_177974_f());
                if (otherStair != null) {
                    if (otherStair == EnumFacing.SOUTH) {
                        drawBox[5] = false;
                        break;
                    }
                    if (otherStair != EnumFacing.NORTH) break;
                    drawBox[7] = false;
                    break;
                }
                otherStair = this.shouldConnect(this.func_174877_v().func_177976_e());
                if (otherStair == EnumFacing.SOUTH) {
                    drawBox[6] = true;
                    break;
                }
                if (otherStair != EnumFacing.NORTH) break;
                drawBox[4] = true;
                break;
            }
        }
        if (this.inverted) {
            for (int pair = 0; pair < 4; pair = (int)((byte)(pair + 1))) {
                boolean swap = drawBox[pair];
                drawBox[pair] = drawBox[4 + pair];
                drawBox[4 + pair] = swap;
            }
        }
        return drawBox;
    }

    private AxisAlignedBB getBox(int box) {
        float[] x = new float[]{0.0f, 0.5f};
        float[] y = new float[]{0.0f, 0.5f};
        float[] z = new float[]{0.0f, 0.5f};
        if (box % 2 != 0) {
            x[0] = 0.5f;
            x[1] = 1.0f;
        }
        if (box > 3) {
            y[0] = 0.5f;
            y[1] = 1.0f;
        }
        if (box % 4 > 1) {
            z[0] = 0.5f;
            z[1] = 1.0f;
        }
        return new AxisAlignedBB((double)x[0], (double)y[0], (double)z[0], (double)x[1], (double)y[1], (double)z[1]);
    }

    @Override
    public List<AxisAlignedBB> getCollisionBoxes() {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boolean[] drawBox = this.getBoxes();
        for (int build = 0; build < 8; build = (int)((byte)(build + 1))) {
            if (!drawBox[build]) continue;
            boxes.add(this.getBox(build));
        }
        return boxes;
    }

    private EnumFacing shouldConnect(BlockPos pos) {
        TileEntity tile = this.func_145831_w().func_175625_s(pos);
        if (tile instanceof TileEntityTypeStairs && this.func_145838_q() == tile.func_145838_q() && this.inverted == ((TileEntityTypeStairs)tile).inverted) {
            return ((TileEntityTypeStairs)tile).facing;
        }
        return null;
    }

    @Override
    public RayTraceResult collisionRayTrace(IBlockState state, Vec3d startVec, Vec3d endVec, RayTraceResult original) {
        if (!(this.func_145838_q() instanceof BlockTypeBase)) {
            return original;
        }
        BlockTypeBase block = (BlockTypeBase)this.func_145838_q();
        RayTraceResult[] arrayMOP = new RayTraceResult[8];
        this.rayTracing = true;
        for (int build = 0; build < 8; build = (int)((byte)(build + 1))) {
            this.traceBlock = build;
            arrayMOP[build] = block.preformRayTrace(this.func_174877_v(), startVec, endVec, this.getBox(build));
        }
        boolean[] boxes = this.getBoxes();
        for (int box = 0; box < 8; box = (int)((byte)(box + 1))) {
            if (boxes[box]) continue;
            arrayMOP[box] = null;
        }
        RayTraceResult returnMOP = null;
        double distance = 0.0;
        for (RayTraceResult tmpMOP : arrayMOP) {
            double tmpDistance;
            if (tmpMOP == null || !((tmpDistance = tmpMOP.field_72307_f.func_72436_e(endVec)) > distance)) continue;
            returnMOP = tmpMOP;
            distance = tmpDistance;
        }
        this.rayTracing = false;
        return returnMOP;
    }

    @Override
    public void neighborChanged(Block neighbor) {
        this.setSavedType(null);
        Function.syncTile((TileEntity)this);
    }

    @Override
    public boolean isSideSolid(EnumFacing side) {
        boolean[] boxes = this.getBoxes();
        switch (side) {
            case UP: {
                return boxes[4] && boxes[5] && boxes[6] && boxes[7];
            }
            case DOWN: {
                return boxes[0] && boxes[1] && boxes[2] && boxes[3];
            }
            case NORTH: {
                return boxes[0] && boxes[1] && boxes[4] && boxes[5];
            }
            case SOUTH: {
                return boxes[2] && boxes[3] && boxes[6] && boxes[7];
            }
            case EAST: {
                return boxes[1] && boxes[3] && boxes[5] && boxes[7];
            }
            case WEST: {
                return boxes[0] && boxes[2] && boxes[4] && boxes[6];
            }
        }
        return false;
    }

    @Override
    public boolean rotateBlock(EnumFacing axis) {
        if (axis.func_176740_k() == EnumFacing.Axis.Y) {
            this.inverted = !this.inverted;
        } else {
            this.facing = this.facing.func_176746_e();
        }
        Function.syncTile((TileEntity)this);
        return true;
    }

    @Override
    public boolean renderSide(EnumFacing side, boolean original) {
        boolean[] boxes = this.getBoxes();
        switch (side) {
            case UP: {
                return !boxes[4] || !boxes[5] || !boxes[6] || !boxes[7] || original;
            }
            case DOWN: {
                return !boxes[0] || !boxes[1] || !boxes[2] || !boxes[3] || original;
            }
            case NORTH: {
                return !boxes[0] || !boxes[1] || !boxes[4] || !boxes[5] || original;
            }
            case SOUTH: {
                return !boxes[2] || !boxes[3] || !boxes[6] || !boxes[7] || original;
            }
            case WEST: {
                return !boxes[1] || !boxes[3] || !boxes[5] || !boxes[7] || original;
            }
            case EAST: {
                return !boxes[0] || !boxes[2] || !boxes[4] || !boxes[6] || original;
            }
        }
        return original;
    }

    @Override
    public int getDamageValue() {
        return super.getDamageValue() + this.style;
    }
}

