/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenClouds
extends GenBase {
    public static boolean generateCloud_Light;
    public static boolean generateCloud_Dense;
    public static boolean generateCloud_Storm;

    @Override
    public void generate(Random random, World world, BlockPos pos) {
        if (Values.blockClouds == null || !generateCloud_Light && !generateCloud_Dense && !generateCloud_Storm) {
            return;
        }
        if (!TerrainGen.decorate((World)world, (Random)random, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM)) {
            return;
        }
        int randSize = 24 + random.nextInt(17);
        int stormSize = 32 + random.nextInt(17);
        int randPosX = pos.func_177958_n() + 4 + random.nextInt(5);
        int randPosY = (int)((float)world.func_72940_L() * 0.75f - 6.0f + (float)random.nextInt(7));
        int randPosZ = pos.func_177952_p() + 4 + random.nextInt(5);
        int randCloud = random.nextInt(301);
        IBlockState state = null;
        if (generateCloud_Light && randCloud >= 0 && randCloud <= 3) {
            state = Values.blockClouds.func_176203_a(8);
        } else if (generateCloud_Dense && randCloud >= 150 && randCloud <= 153) {
            state = Values.blockClouds.func_176203_a(9);
        } else if (generateCloud_Storm && randCloud == 300) {
            state = Values.blockClouds.func_176203_a(10);
        }
        if (state != null) {
            this.generateCloud(random, state, randCloud == 300 ? stormSize : randSize, world, randPosX, randPosY, randPosZ);
        }
    }

    private void generateCloud(Random random, IBlockState state, int numberOfBlocks, World world, int x, int y, int z) {
        float pi = (float)Math.PI + (float)(random.nextInt(3) - 1);
        float ranPi = random.nextFloat() * pi;
        double sX1 = (float)(x + 8) + MathHelper.func_76126_a((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sX2 = (float)(x + 8) - MathHelper.func_76126_a((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sZ1 = (float)(z + 8) + MathHelper.func_76134_b((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sZ2 = (float)(z + 8) - MathHelper.func_76134_b((float)ranPi) * (float)numberOfBlocks / 8.0f;
        double sY1 = y + random.nextInt(3) - 2;
        double sY2 = y + random.nextInt(3) - 2;
        for (int placeBlock = 0; placeBlock <= numberOfBlocks; ++placeBlock) {
            double d6 = sX1 + (sX2 - sX1) * (double)placeBlock / (double)numberOfBlocks;
            double d7 = sY1 + (sY2 - sY1) * (double)placeBlock / (double)numberOfBlocks;
            double d8 = sZ1 + (sZ2 - sZ1) * (double)placeBlock / (double)numberOfBlocks;
            double d9 = random.nextDouble() * (double)numberOfBlocks / 16.0;
            double d10 = (double)(MathHelper.func_76126_a((float)((float)placeBlock * pi / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            double d11 = (double)(MathHelper.func_76126_a((float)((float)placeBlock * pi / (float)numberOfBlocks)) + 1.0f) * d9 + 1.0;
            int minX = MathHelper.func_76128_c((double)(d6 - d10 / 2.0));
            int minY = MathHelper.func_76128_c((double)(d7 - d11 / 2.0));
            int minZ = MathHelper.func_76128_c((double)(d8 - d10 / 2.0));
            int maxX = MathHelper.func_76128_c((double)(d6 + d10 / 2.0));
            int maxY = MathHelper.func_76128_c((double)(d7 + d11 / 2.0));
            int maxZ = MathHelper.func_76128_c((double)(d8 + d10 / 2.0));
            for (int posX = minX; posX <= maxX; ++posX) {
                double d12 = ((double)posX + 0.5 - d6) / (d10 / 2.0);
                if (d12 * d12 >= 1.0) continue;
                for (int posY = minY; posY <= maxY; ++posY) {
                    double d13 = ((double)posY + 0.5 - d7) / (d11 / 2.0);
                    if (d12 * d12 + d13 * d13 >= 1.0) continue;
                    for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                        double d14 = ((double)posZ + 0.5 - d8) / (d10 / 2.0);
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        if (d12 * d12 + d13 * d13 + d14 * d14 >= 1.0 || !world.func_175623_d(pos) || Math.abs(posX - x) + Math.abs(posY - y) + Math.abs(posZ - z) >= 16 + random.nextInt(9)) continue;
                        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false);
                    }
                }
            }
        }
    }
}

