/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockFlowers;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenFlowers
extends GenBase {
    public static boolean generateFlowers;
    private static List<Integer> forestFlowers;
    private static List<Integer> plainsFlowers;
    private static List<Integer> mountainFlowers;
    private static List<Integer> waterFlowers;
    private static List<Integer> jungleFlowers;
    private static List<Integer> magicFlowers;

    @Override
    public void generate(Random random, World world, BlockPos pos) {
        if (Values.blockFlowerSingle == null && Values.blockFlowerCluster == null || !generateFlowers) {
            return;
        }
        if (!TerrainGen.decorate((World)world, (Random)random, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.FLOWERS)) {
            return;
        }
        List<Integer> flowers = this.getFlowersForBiome(world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()));
        if (!flowers.isEmpty()) {
            IBlockState state;
            Block flower;
            pos = this.getTopBlock(world, pos);
            if (Values.blockFlowerSingle != null && Values.blockFlowerCluster != null) {
                flower = random.nextBoolean() ? Values.blockFlowerSingle : Values.blockFlowerCluster;
            } else {
                Block block = flower = Values.blockFlowerCluster != null ? Values.blockFlowerCluster : Values.blockFlowerSingle;
            }
            if (flower instanceof BlockFlowers && ((BlockFlowers)flower).func_180671_f(world, pos, state = flower.func_176203_a(flowers.get(random.nextInt(flowers.size())).intValue()))) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state, (boolean)false);
            }
        }
    }

    private List<Integer> getFlowersForBiome(Biome biome) {
        ArrayList<Integer> flowerList = new ArrayList<Integer>();
        if (BiomeDictionary.isBiomeRegistered((Biome)biome)) {
            BiomeDictionary.Type[] types;
            for (BiomeDictionary.Type type : types = BiomeDictionary.getTypesForBiome((Biome)biome)) {
                if (type == BiomeDictionary.Type.FOREST) {
                    flowerList.addAll(forestFlowers);
                }
                if (type == BiomeDictionary.Type.PLAINS) {
                    flowerList.addAll(plainsFlowers);
                }
                if (type == BiomeDictionary.Type.MOUNTAIN) {
                    flowerList.addAll(mountainFlowers);
                }
                if (type == BiomeDictionary.Type.WATER) {
                    flowerList.addAll(waterFlowers);
                }
                if (type == BiomeDictionary.Type.JUNGLE) {
                    flowerList.addAll(jungleFlowers);
                }
                if (type != BiomeDictionary.Type.MAGICAL) continue;
                flowerList.addAll(magicFlowers);
            }
        }
        return flowerList;
    }

    static {
        forestFlowers = new ArrayList<Integer>();
        plainsFlowers = new ArrayList<Integer>();
        mountainFlowers = new ArrayList<Integer>();
        waterFlowers = new ArrayList<Integer>();
        jungleFlowers = new ArrayList<Integer>();
        magicFlowers = new ArrayList<Integer>();
        byte[] forest = new byte[]{2, 4, 5, 6, 7, 8, 13};
        byte[] plains = new byte[]{0, 1, 5, 9, 11, 13, 14, 15};
        byte[] mountain = new byte[]{3, 5, 9};
        byte[] water = new byte[]{3, 6, 10, 12};
        byte[] jungle = new byte[]{2, 5, 6, 7, 8, 13};
        byte[] magic = new byte[]{4};
        for (byte value : forest) {
            forestFlowers.add(Integer.valueOf(value));
        }
        for (byte value : plains) {
            plainsFlowers.add(Integer.valueOf(value));
        }
        for (byte value : mountain) {
            mountainFlowers.add(Integer.valueOf(value));
        }
        for (byte value : water) {
            waterFlowers.add(Integer.valueOf(value));
        }
        for (byte value : jungle) {
            jungleFlowers.add(Integer.valueOf(value));
        }
        for (byte value : magic) {
            magicFlowers.add(Integer.valueOf(value));
        }
    }
}

