/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockTreeFoliage;
import shetiphian.terraqueous.common.block.BlockTreeTrunk;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenTrees
extends GenBase {
    public static boolean treesActive;
    public static boolean generateTree_Apple;
    public static boolean generateTree_Cherry;
    public static boolean generateTree_Orange;
    public static boolean generateTree_Pear;
    public static boolean generateTree_Peach;
    public static boolean generateTree_Mango;
    public static boolean generateTree_Lemon;
    public static boolean generateTree_Plum;
    public static boolean generateTree_Coconut;
    public static boolean generateTree_Banana;
    private static PlantAPI.TreeType lastPlaced;
    private static final byte[] mapAppleTree;
    private static final byte[] mapCherryTree;
    private static final byte[] mapOrangeTree;
    private static final byte[] mapPearTree;
    private static final byte[] mapPeachTree;
    private static final byte[] mapMangoTree;
    private static final byte[] mapLemonTree;
    private static final byte[] mapPlumTree;
    private static final byte[] mapBananaTree;
    private static final byte[] mapCoconutTreeTop;
    private static final byte[] mapCoconutTreeBottom;

    public static void setTreesActive() {
        if (Values.blockTreeFoliage1 != null && Values.blockTreeFoliage2 != null && Values.blockTreeFoliage3 != null && Values.blockTreeFoliage4 != null && Values.blockTreeFoliageCB != null && Values.blockTreeTrunk1 != null && Values.blockTreeTrunk2 != null && Values.blockSapling != null) {
            treesActive = true;
        }
    }

    @Override
    public void generate(Random random, World world, BlockPos pos) {
        if (!treesActive || random.nextInt(3) != 0) {
            return;
        }
        if (!TerrainGen.decorate((World)world, (Random)random, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.TREE)) {
            return;
        }
        List<PlantAPI.TreeType> trees = this.getTreesForBiome(world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()));
        if (!trees.isEmpty()) {
            pos = this.getTopBlock(world, pos);
            PlantAPI.TreeType type = trees.get(random.nextInt(trees.size()));
            if (lastPlaced != type) {
                lastPlaced = type;
                this.generateTree(random, world, pos, type, type == PlantAPI.TreeType.COCONUT ? 3 : 1);
            } else {
                lastPlaced = null;
            }
        }
    }

    public List<PlantAPI.TreeType> getTreesForBiome(Biome biome) {
        ArrayList<PlantAPI.TreeType> treeList = new ArrayList<PlantAPI.TreeType>();
        if (BiomeDictionary.isBiomeRegistered((Biome)biome) && !this.isBiomeOfType(biome, BiomeDictionary.Type.COLD, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DRY, BiomeDictionary.Type.END, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.MUSHROOM)) {
            if (generateTree_Apple && this.isBiomeAllTypes(biome, BiomeDictionary.Type.FOREST)) {
                treeList.add(PlantAPI.TreeType.APPLE);
            }
            if (generateTree_Cherry && this.isBiomeAllTypes(biome, BiomeDictionary.Type.HILLS) && !this.isBiomeOfType(biome, BiomeDictionary.Type.WATER)) {
                treeList.add(PlantAPI.TreeType.CHERRY);
            }
            if (generateTree_Orange && this.isBiomeAllTypes(biome, BiomeDictionary.Type.HILLS)) {
                treeList.add(PlantAPI.TreeType.ORANGE);
            }
            if (generateTree_Pear && this.isBiomeAllTypes(biome, BiomeDictionary.Type.FOREST)) {
                treeList.add(PlantAPI.TreeType.PEAR);
            }
            if (generateTree_Peach && this.isBiomeAllTypes(biome, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS)) {
                treeList.add(PlantAPI.TreeType.PEACH);
            }
            if (generateTree_Mango && this.isBiomeAllTypes(biome, BiomeDictionary.Type.FOREST)) {
                treeList.add(PlantAPI.TreeType.MANGO);
            }
            if (generateTree_Lemon && this.isBiomeAllTypes(biome, BiomeDictionary.Type.HILLS)) {
                treeList.add(PlantAPI.TreeType.LEMON);
            }
            if (generateTree_Plum && this.isBiomeAllTypes(biome, BiomeDictionary.Type.HILLS)) {
                treeList.add(PlantAPI.TreeType.PLUM);
            }
            if (generateTree_Coconut && this.isBiomeAllTypes(biome, BiomeDictionary.Type.BEACH)) {
                treeList.add(PlantAPI.TreeType.COCONUT);
            }
            if (generateTree_Banana && this.isBiomeAllTypes(biome, BiomeDictionary.Type.JUNGLE)) {
                treeList.add(PlantAPI.TreeType.BANANA);
            }
        }
        return treeList;
    }

    private boolean isBiomeOfType(Biome biome, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            if (!BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return true;
        }
        return false;
    }

    private boolean isBiomeAllTypes(Biome biome, BiomeDictionary.Type ... types) {
        for (BiomeDictionary.Type type : types) {
            if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)type)) continue;
            return false;
        }
        return true;
    }

    public boolean growSapling(Random random, World world, BlockPos pos, PlantAPI.TreeType type) {
        return TerrainGen.saplingGrowTree((World)world, (Random)random, (BlockPos)pos) && this.generateTree(random, world, pos.func_177977_b(), type, 0);
    }

    private boolean generateTree(Random random, World world, BlockPos pos, PlantAPI.TreeType type, int maxReplacements) {
        byte sZ;
        int chZ;
        byte sX;
        int chX;
        byte sY;
        boolean canPlant;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int replacements = 0;
        while ((block == null || block.func_176200_f((IBlockAccess)world, pos)) && replacements < maxReplacements) {
            if (!world.func_175623_d(pos)) {
                ++replacements;
            }
            if (block != null && block.func_149688_o(state).func_76224_d() && maxReplacements < 2) {
                return false;
            }
            pos = pos.func_177977_b();
            state = world.func_180495_p(pos);
            block = state.func_177230_c();
        }
        Block soil = block;
        boolean bl = canPlant = soil != null && soil.canSustainPlant(Blocks.field_150345_g.func_176223_P(), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)Blocks.field_150345_g);
        if (!canPlant && type == PlantAPI.TreeType.COCONUT) {
            boolean bl2 = canPlant = soil != null && soil.canSustainPlant(Blocks.field_150434_aF.func_176223_P(), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)Blocks.field_150434_aF);
        }
        if (!canPlant) {
            return false;
        }
        pos = pos.func_177984_a();
        byte coconutTree = (byte)(random.nextInt(4) + 5);
        byte treeWidth = GenTrees.getTreeSize(type)[0];
        byte treeHeight = GenTrees.getTreeSize(type)[1];
        if (treeWidth == 0 || treeHeight == 0) {
            return false;
        }
        if (type == PlantAPI.TreeType.COCONUT) {
            int offsetZ;
            int n = coconutTree == 5 ? -3 : (offsetZ = coconutTree == 6 ? 3 : 0);
            int offsetX = coconutTree == 8 ? -3 : (coconutTree == 7 ? 3 : 0);
            pos = pos.func_177982_a(offsetX, 0, offsetZ);
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        int chY = pos.func_177956_o();
        for (sY = 0; sY < treeHeight; sY = (byte)(sY + 1)) {
            chX = pos.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (byte)(sX + 1)) {
                chZ = pos.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (byte)(sZ + 1)) {
                    if (GenTrees.getMapValue(sX, sY, sZ, type, coconutTree) > 0) {
                        checkPos.func_181079_c(chX, chY, chZ);
                        if (!world.func_175623_d((BlockPos)checkPos) && !this.ignoreBlock(world, (BlockPos)checkPos, type)) {
                            return false;
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        chY = pos.func_177956_o();
        for (sY = 0; sY < treeHeight; sY = (byte)(sY + 1)) {
            chX = pos.func_177958_n() - (treeWidth - 1) / 2;
            for (sX = 0; sX < treeWidth; sX = (byte)(sX + 1)) {
                chZ = pos.func_177952_p() - (treeWidth - 1) / 2;
                for (sZ = 0; sZ < treeWidth; sZ = (byte)(sZ + 1)) {
                    byte mapValue = GenTrees.getMapValue(sX, sY, sZ, type, coconutTree);
                    if (mapValue > 0) {
                        checkPos.func_181079_c(chX, chY, chZ);
                        switch (mapValue) {
                            case 1: {
                                int[] metadata = new int[]{0, 3, 6, 9, 12, 0, 3, 6, 9, 12};
                                this.setBlock(world, (BlockPos)checkPos, type, metadata[type.getID()], true);
                                break;
                            }
                            case 2: {
                                int[] metadata;
                                if (random.nextInt(15) == 0) {
                                    metadata = new int[]{2, 6, 2, 6, 2, 6, 2, 6, 0, 1};
                                    this.setBlock(world, (BlockPos)checkPos, type, metadata[type.getID()], false);
                                    break;
                                }
                                if (random.nextInt(15) == 0) {
                                    metadata = new int[]{1, 5, 1, 5, 1, 5, 1, 5, 0, 1};
                                    this.setBlock(world, (BlockPos)checkPos, type, metadata[type.getID()], false);
                                    break;
                                }
                                metadata = new int[]{0, 4, 0, 4, 0, 4, 0, 4, 0, 1};
                                this.setBlock(world, (BlockPos)checkPos, type, metadata[type.getID()], false);
                                break;
                            }
                            case 3: {
                                int[] metadata = new int[]{0, 4, 0, 4, 0, 4, 0, 4, 0, 1};
                                this.setBlock(world, (BlockPos)checkPos, type, metadata[type.getID()], false);
                                break;
                            }
                            case 4: {
                                int[] metadata = new int[]{2, 5, 8, 11, 14, 2, 5, 8, 11, 14};
                                this.setBlock(world, (BlockPos)checkPos, type, metadata[type.getID()], true);
                                break;
                            }
                            case 5: {
                                int[] metadata = new int[]{1, 4, 7, 10, 13, 1, 4, 7, 10, 13};
                                this.setBlock(world, (BlockPos)checkPos, type, metadata[type.getID()], true);
                            }
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
        chY = pos.func_177956_o();
        for (byte sY2 = 0; sY2 < treeHeight; sY2 = (byte)(sY2 + 1)) {
            int chX2 = pos.func_177958_n() - (treeWidth - 1) / 2;
            for (byte sX2 = 0; sX2 < treeWidth; sX2 = (byte)(sX2 + 1)) {
                int chZ2 = pos.func_177952_p() - (treeWidth - 1) / 2;
                for (byte sZ2 = 0; sZ2 < treeWidth; sZ2 = (byte)(sZ2 + 1)) {
                    if (GenTrees.getMapValue(sX2, sY2, sZ2, type, coconutTree) > 0) {
                        checkPos.func_181079_c(chX2, chY, chZ2);
                        IBlockState cState = world.func_180495_p((BlockPos)checkPos);
                        Function.sync((World)world, (BlockPos)checkPos, (IBlockState)cState);
                    }
                    ++chZ2;
                }
                ++chX2;
            }
            ++chY;
        }
        return true;
    }

    private void setBlock(World world, BlockPos pos, PlantAPI.TreeType type, int meta, boolean log) {
        if (meta == -1) {
            return;
        }
        switch (type) {
            case APPLE: 
            case CHERRY: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)(log ? Values.blockTreeTrunk1 : Values.blockTreeFoliage1).func_176203_a(meta), (boolean)false);
                break;
            }
            case ORANGE: 
            case PEAR: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)(log ? Values.blockTreeTrunk1 : Values.blockTreeFoliage2).func_176203_a(meta), (boolean)false);
                break;
            }
            case PEACH: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)(log ? Values.blockTreeTrunk1 : Values.blockTreeFoliage3).func_176203_a(meta), (boolean)false);
                break;
            }
            case MANGO: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)(log ? Values.blockTreeTrunk2 : Values.blockTreeFoliage3).func_176203_a(meta), (boolean)false);
                break;
            }
            case LEMON: 
            case PLUM: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)(log ? Values.blockTreeTrunk2 : Values.blockTreeFoliage4).func_176203_a(meta), (boolean)false);
                break;
            }
            case COCONUT: 
            case BANANA: {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)(log ? Values.blockTreeTrunk2 : Values.blockTreeFoliageCB).func_176203_a(meta), (boolean)false);
            }
        }
    }

    private static byte[] getTreeSize(PlantAPI.TreeType type) {
        switch (type) {
            case APPLE: {
                return new byte[]{5, 7};
            }
            case CHERRY: {
                return new byte[]{7, 6};
            }
            case ORANGE: {
                return new byte[]{5, 7};
            }
            case PEAR: {
                return new byte[]{7, 12};
            }
            case PEACH: {
                return new byte[]{5, 7};
            }
            case MANGO: {
                return new byte[]{9, 8};
            }
            case LEMON: {
                return new byte[]{5, 4};
            }
            case PLUM: {
                return new byte[]{5, 8};
            }
            case COCONUT: {
                return new byte[]{7, 14};
            }
            case BANANA: {
                return new byte[]{7, 9};
            }
        }
        return new byte[]{0, 0};
    }

    private static byte getMapValue(byte sX, byte sY, byte sZ, PlantAPI.TreeType type, byte coconutTree) {
        byte width = GenTrees.getTreeSize(type)[0];
        int index = sY * width * width + sX + sZ * width;
        switch (type) {
            case APPLE: {
                return mapAppleTree[index];
            }
            case CHERRY: {
                return mapCherryTree[index];
            }
            case ORANGE: {
                return mapOrangeTree[index];
            }
            case PEAR: {
                return mapPearTree[index];
            }
            case PEACH: {
                return mapPeachTree[index];
            }
            case MANGO: {
                return mapMangoTree[index];
            }
            case LEMON: {
                return mapLemonTree[index];
            }
            case PLUM: {
                return mapPlumTree[index];
            }
            case COCONUT: {
                if (sY > 8) {
                    index = (sY - 9) * width * width + sX + sZ * width;
                    return mapCoconutTreeTop[index];
                }
                return (byte)(mapCoconutTreeBottom[index] == coconutTree ? 1 : 0);
            }
            case BANANA: {
                return mapBananaTree[index];
            }
        }
        return 0;
    }

    private boolean ignoreBlock(World world, BlockPos pos, PlantAPI.TreeType type) {
        IBlockState state = world.func_180495_p(pos);
        if (world.func_175623_d(pos) || state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos)) {
            return true;
        }
        if (state.func_177230_c() == Values.blockSapling) {
            return type == PlantAPI.getTreeType(world.func_180495_p(pos));
        }
        return false;
    }

    public static void treePunch(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockTreeTrunk) {
            GenTrees.treePunch(world, pos, PlantAPI.getTreeType(state));
        }
    }

    private static void treePunch(World world, BlockPos pos, PlantAPI.TreeType type) {
        if (type == PlantAPI.TreeType.COCONUT || type == PlantAPI.TreeType.BANANA) {
            return;
        }
        while (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockTreeTrunk) {
            pos = pos.func_177977_b();
        }
        int chY = pos.func_177956_o();
        byte treeWidth = GenTrees.getTreeSize(type)[0];
        byte treeHeight = GenTrees.getTreeSize(type)[1];
        if (treeWidth == 0 || treeHeight == 0) {
            return;
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (byte sY = 0; sY < treeHeight; sY = (byte)(sY + 1)) {
            int chX = pos.func_177958_n() - 2;
            for (byte sX = 0; sX < treeWidth; sX = (byte)(sX + 1)) {
                int chZ = pos.func_177952_p() - 2;
                for (byte sZ = 0; sZ < treeWidth; sZ = (byte)(sZ + 1)) {
                    if (GenTrees.getMapValue(sX, sY, sZ, type, (byte)0) >= 2) {
                        checkPos.func_181079_c(chX, chY, chZ);
                        IBlockState checkState = world.func_180495_p((BlockPos)checkPos);
                        Block block = checkState.func_177230_c();
                        if (block instanceof BlockTreeFoliage) {
                            ((BlockTreeFoliage)block).dropFruit(world, (BlockPos)checkPos, checkState, null, true);
                        }
                    }
                    ++chZ;
                }
                ++chX;
            }
            ++chY;
        }
    }

    /*
     * Opcode count of 13963 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        mapAppleTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 1, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 2, 3, 3, 3, 2, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 2, 3, 3, 3, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0};
        mapCherryTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 2, 3, 3, 3, 3, 3, 2, 2, 3, 3, 1, 3, 3, 2, 2, 3, 3, 3, 3, 3, 2, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 2, 3, 3, 3, 3, 3, 2, 2, 3, 3, 1, 3, 3, 2, 2, 3, 3, 3, 3, 3, 2, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 3, 2, 0, 0, 0, 2, 3, 1, 3, 2, 0, 0, 0, 2, 3, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 3, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapOrangeTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 2, 2, 0, 2, 2, 1, 2, 2, 0, 2, 2, 2, 0, 0, 0, 2, 0, 0, 2, 2, 3, 2, 2, 2, 3, 3, 3, 2, 2, 4, 1, 4, 2, 2, 3, 3, 3, 2, 2, 2, 3, 2, 2, 0, 2, 2, 2, 0, 2, 3, 3, 3, 2, 2, 1, 3, 1, 2, 2, 3, 3, 3, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 3, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0};
        mapPearTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 2, 3, 1, 3, 2, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 2, 3, 3, 3, 3, 3, 2, 2, 3, 3, 1, 3, 3, 2, 2, 3, 3, 3, 3, 3, 2, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 2, 3, 3, 3, 3, 3, 2, 2, 3, 3, 1, 3, 3, 2, 2, 3, 3, 3, 3, 3, 2, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 2, 3, 1, 3, 2, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 2, 3, 1, 3, 2, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 2, 3, 1, 3, 2, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 2, 3, 2, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapPeachTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 2, 3, 3, 3, 2, 0, 2, 2, 2, 0, 0, 0, 2, 0, 0, 0, 2, 3, 2, 0, 2, 3, 1, 3, 2, 0, 2, 3, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 1, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 1, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 3, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapMangoTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 1, 4, 1, 4, 1, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 3, 3, 1, 3, 3, 2, 0, 2, 3, 3, 3, 3, 3, 3, 3, 2, 2, 3, 1, 3, 1, 3, 1, 3, 2, 2, 3, 3, 3, 3, 3, 3, 3, 2, 0, 2, 3, 3, 1, 3, 3, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 3, 1, 3, 2, 0, 0, 0, 2, 3, 3, 3, 3, 3, 2, 0, 2, 3, 3, 3, 3, 3, 3, 3, 2, 2, 1, 3, 3, 1, 3, 3, 1, 2, 2, 3, 3, 3, 3, 3, 3, 3, 2, 0, 2, 3, 3, 3, 3, 3, 2, 0, 0, 0, 2, 3, 1, 3, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 3, 3, 3, 3, 3, 2, 0, 0, 2, 3, 3, 1, 3, 3, 2, 0, 0, 2, 3, 3, 3, 3, 3, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 2, 3, 2, 0, 0, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 2, 3, 3, 1, 3, 3, 2, 0, 0, 0, 2, 3, 3, 3, 2, 0, 0, 0, 0, 0, 2, 3, 2, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 2, 3, 2, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapLemonTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 2, 3, 3, 3, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 1, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapPlumTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 1, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 2, 3, 3, 3, 2, 0, 2, 2, 2, 0, 2, 2, 2, 2, 2, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 0, 2, 2, 2, 0, 2, 3, 3, 3, 2, 2, 3, 1, 3, 2, 2, 3, 3, 3, 2, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 2, 1, 2, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 3, 2, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapBananaTree = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 3, 1, 3, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 3, 3, 0, 0, 2, 3, 0, 3, 0, 0, 0, 0, 3, 3, 1, 3, 3, 0, 0, 0, 0, 3, 0, 3, 2, 0, 0, 3, 3, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapCoconutTreeTop = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, 1, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 3, 3, 3, 1, 3, 3, 3, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 3, 3, 0, 0, 3, 3, 3, 3, 0, 0, 0, 0, 3, 1, 3, 0, 0, 0, 0, 3, 3, 3, 3, 0, 0, 3, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        mapCoconutTreeBottom = new byte[]{0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 7, 0, 8, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 7, 0, 8, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

