/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.terraqueous.api.machines.EnderTableRecipeHandler;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;
import shetiphian.terraqueous.modintegration.jei.EnderTableRecipeWrapper;

public class EnderTableHandlers {
    public static List<EnderTableRecipeWrapper> buildRecipeList() {
        ArrayList<EnderTableRecipeWrapper> list = new ArrayList<EnderTableRecipeWrapper>();
        for (IEnderTableRecipe recipe : EnderTableRecipeHandler.INSTANCE.getTableRecipes()) {
            try {
                for (int index = 0; index < 3; ++index) {
                    ItemStack materialStack;
                    IEnderTableRecipe.EnumOption option = IEnderTableRecipe.EnumOption.byIndex(index);
                    Pair<List<ItemStack>, List<ItemStack>> inputs = recipe.getInput(option);
                    if (inputs == null || inputs.getLeft() == null || ((List)inputs.getLeft()).size() == 0) continue;
                    ItemStack enchantStack = (ItemStack)((List)inputs.getLeft()).get(0);
                    ItemStack result = recipe.getResult(enchantStack, materialStack = inputs.getRight() == null || ((List)inputs.getRight()).size() == 0 ? null : (ItemStack)((List)inputs.getRight()).get(0), option);
                    if (result == null) continue;
                    int expCost = recipe.getExpCost(enchantStack, materialStack, option);
                    int matCost = recipe.getMaterialCost(enchantStack, materialStack, option);
                    list.add(new EnderTableRecipeWrapper(result, inputs, expCost, matCost));
                }
            }
            catch (Exception exception) {
            }
        }
        return list;
    }

    public static class RecipeHandler
    implements IRecipeHandler<EnderTableRecipeWrapper> {
        @Nonnull
        public Class<EnderTableRecipeWrapper> getRecipeClass() {
            return EnderTableRecipeWrapper.class;
        }

        @Nonnull
        @Deprecated
        public String getRecipeCategoryUid() {
            return "terraqueous.endertable";
        }

        @Nonnull
        public String getRecipeCategoryUid(@Nonnull EnderTableRecipeWrapper enderTableRecipeWrapper) {
            return "terraqueous.endertable";
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(@Nonnull EnderTableRecipeWrapper recipe) {
            return recipe;
        }

        public boolean isRecipeValid(@Nonnull EnderTableRecipeWrapper recipe) {
            return recipe.getInputs().size() == 2 && recipe.getOutputs().size() == 1 && recipe.getExpCost() > 0;
        }
    }
}

