/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.power;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import net.minecraft.item.ItemStack;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;

public class EnergyUnits {
    public static void init() {
        if (Settings.INSTANCE.sfPowerMultiplierEU > 0.0f && ElectricItem.manager != null) {
            StormForgeRegistry.register(new RechargeHandler());
        }
    }

    public static class RechargeHandler
    implements IStormForgeRechargeHandler {
        @Override
        public boolean handleStack(ItemStack stack) {
            return stack != null && stack.func_77973_b() instanceof IElectricItem;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean charge(ItemStack stack, double amount, boolean outright) {
            if (!this.handleStack(stack)) return false;
            double d = outright ? Double.MAX_VALUE : amount;
            if (!(ElectricItem.manager.charge(stack, d, ((IElectricItem)stack.func_77973_b()).getTier(stack), outright, false) > 0.0)) return false;
            return true;
        }

        @Override
        public boolean isFull(ItemStack stack) {
            return !this.handleStack(stack) || ElectricItem.manager.getCharge(stack) >= ((IElectricItem)stack.func_77973_b()).getMaxCharge(stack);
        }

        @Override
        public float multiplier() {
            return Settings.INSTANCE.sfPowerMultiplierEU;
        }
    }
}

