/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.power;

import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.api.machines.IStormForgeRechargeHandler;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;

public class ForgeUnits {
    public static void init() {
        if (Settings.INSTANCE.sfPowerMultiplierFU > 0.0f) {
            StormForgeRegistry.register(new RechargeHandler());
        }
    }

    public static class RechargeHandler
    implements IStormForgeRechargeHandler {
        @Override
        public boolean handleStack(ItemStack stack) {
            return stack != null && stack.hasCapability(CapabilityEnergy.ENERGY, null);
        }

        @Override
        public boolean charge(ItemStack stack, double amount, boolean outright) {
            IEnergyStorage storage;
            if (stack != null && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                return storage.receiveEnergy(outright ? Integer.MAX_VALUE : (int)amount, false) > 0;
            }
            return false;
        }

        @Override
        public boolean isFull(ItemStack stack) {
            IEnergyStorage storage;
            if (stack != null && (storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null)) != null) {
                return storage.getEnergyStored() >= storage.getMaxEnergyStored();
            }
            return true;
        }

        @Override
        public float multiplier() {
            return Settings.INSTANCE.sfPowerMultiplierFU;
        }
    }
}

