/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.thaumcraft;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import shetiphian.terraqueous.Values;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;

public class Thaumcraft_Active {
    public static void init() {
        if (ThaumcraftApi.class != null) {
            new Thaumcraft_Active().addTags();
        }
    }

    private void addTags() {
        AspectList aspectsLightCloud = new AspectList().add(Aspect.WATER, 2).add(Aspect.AIR, 3).add(Aspect.VOID, 3);
        AspectList aspectsDenseCloud = new AspectList().add(Aspect.WATER, 6).add(Aspect.AIR, 2).add(Aspect.VOID, 2);
        AspectList aspectsStormCloud = new AspectList().add(Aspect.WATER, 18).add(Aspect.AIR, 1).add(Aspect.VOID, 1);
        if (Values.blockCloudFancy != null) {
            this.registerObjectTag(this.iStack("cloud_column", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("cloud_capital", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("cloud_arch", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("cloud_edge", new int[0]), aspectsDenseCloud.copy());
        }
        if (Values.blockClouds != null) {
            this.registerObjectTag(this.iStack("lightcloud_block", new int[0]), aspectsLightCloud.copy());
            this.registerObjectTag(this.iStack("densecloud_block", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("stormcloud_block", new int[0]), aspectsStormCloud.copy());
            this.registerObjectTag(this.iStack("kickable_lightcloud_block", new int[0]), aspectsLightCloud.copy());
            this.registerObjectTag(this.iStack("kickable_densecloud_block", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("kickable_stormcloud_block", new int[0]), aspectsStormCloud.copy());
        }
        if (Values.blockCrafting != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("cloud_workbench", new int[0]), (AspectList)aspectsStormCloud.copy().add(Aspect.CRAFT, 4));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("cloud_furnace", new int[0]), (AspectList)aspectsStormCloud.copy().add(Aspect.ENERGY, 2));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("cloud_craftbench", new int[0]), (AspectList)aspectsStormCloud.copy().add(Aspect.CRAFT, 4).add(Aspect.VOID, 4));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("cloud_craftfurnace", new int[0]), (AspectList)aspectsStormCloud.copy().add(Aspect.ENERGY, 6).add(Aspect.VOID, 4));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("craftbench", new int[0]), (AspectList)new AspectList().add(Aspect.EARTH, 16).add(Aspect.CRAFT, 4).add(Aspect.VOID, 4));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("craftfurnace", new int[0]), (AspectList)new AspectList().add(Aspect.EARTH, 16).add(Aspect.FIRE, 6).add(Aspect.VOID, 4));
        }
        if (Values.blockDoodad != null) {
            this.registerObjectTag(this.iStack(Values.blockDoodad, 0), this.buildListFrom(this.iStack(Blocks.field_150364_r)));
            this.registerObjectTag(this.iStack(Values.blockDoodad, 1), this.buildListFrom(this.iStack(Blocks.field_150348_b)));
            this.registerObjectTag(this.iStack(Values.blockDoodad, 2), this.buildListFrom(this.iStack(Items.field_151103_aS)));
            this.registerObjectTag(this.iStack(Values.blockDoodad, 3), this.buildListFrom(this.iStack(Blocks.field_150322_A)));
            this.registerObjectTag(this.iStack(Values.blockDoodad, 4), this.buildListFrom(this.iStack(Items.field_151079_bi)).add(Aspect.CRYSTAL, 2));
            this.registerObjectTag(this.iStack(Values.blockDoodad, 5), this.buildListFrom(this.iStack(Items.field_151065_br)).add(Aspect.CRYSTAL, 2));
            this.registerObjectTag(this.iStack("glass_shards", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150359_w)).add(Aspect.ENTROPY, 1));
            this.registerObjectTag(this.iStack(Values.blockDoodad, 7), this.buildListFrom(this.iStack(Blocks.field_180395_cM)));
        }
        if (Values.blockEarthOre != null) {
            this.registerObjectTag(this.iStack("endimium_ore", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150377_bs), this.iStack(Items.field_151079_bi), this.iStack(Items.field_151045_i)));
            this.registerObjectTag(this.iStack("burnium_ore", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150424_aL), this.iStack(Items.field_151065_br), this.iStack(Items.field_151044_h)));
            for (int index = 3; index < 13; index = (int)((byte)(index + 3))) {
                this.registerObjectTag(this.iStack(Values.blockEarthOre, index), this.buildListFrom(4.0f, this.iStack("endimium_ore", new int[0])).remove(Aspect.EARTH));
                this.registerObjectTag(this.iStack(Values.blockEarthOre, index + 1), this.buildListFrom(4.0f, this.iStack("burnium_ore", new int[0])).remove(Aspect.EARTH));
            }
        }
        if (Values.blockEnderTable != null) {
            this.registerObjectTag(this.iStack(Values.blockEnderTable), this.buildListFrom(this.iStack(Blocks.field_150381_bn), this.iStack(Items.field_151061_bv)));
        }
        if (Values.blockFlowerCluster != null) {
            this.registerObjectTag(this.iStack(Values.blockFlowerCluster, Short.MAX_VALUE), this.buildListFrom(this.iStack((Block)Blocks.field_150328_O)));
        }
        if (Values.blockFlowerSingle != null) {
            this.registerObjectTag(this.iStack(Values.blockFlowerSingle, Short.MAX_VALUE), this.buildListFrom(this.iStack((Block)Blocks.field_150328_O)));
        }
        if (Values.blockFlowerPot != null) {
            this.registerObjectTag(this.iStack("flowerrpot", new int[0]), this.buildListFrom(this.iStack(Items.field_151162_bE)));
            this.registerObjectTag(this.iStack("planterpot", new int[0]), this.buildListFrom(this.iStack(Items.field_151162_bE), this.iStack(Items.field_151118_aC)));
        }
        if (Values.blockHay != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("hayblock", new int[0]), (AspectList)this.buildListFrom(this.iStack(Blocks.field_150407_cf)));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("haypile_large", new int[0]), (AspectList)new AspectList().add(Aspect.FIRE, 3).add(Aspect.AIR, 2));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("haypile", new int[0]), (AspectList)new AspectList().add(Aspect.FIRE, 3).add(Aspect.AIR, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("haypile_small", new int[0]), (AspectList)new AspectList().add(Aspect.FIRE, 2).add(Aspect.AIR, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("thresh", new int[0]), (AspectList)new AspectList().add(Aspect.FIRE, 1).add(Aspect.AIR, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("loosehay", new int[0]), (AspectList)new AspectList().add(Aspect.FIRE, 1).add(Aspect.AIR, 1));
            AspectList aspects = new AspectList().add(Aspect.EXCHANGE, 1).add(Aspect.AIR, 1);
            for (int meta = 6; meta < 15; meta = (int)((byte)(meta + 1))) {
                if (meta < 10) {
                    ThaumcraftApi.registerObjectTag((ItemStack)this.iStack(Values.blockHay, meta), (AspectList)aspects.copy().add(Aspect.FIRE, 1));
                    continue;
                }
                ThaumcraftApi.registerObjectTag((ItemStack)this.iStack(Values.blockHay, meta), (AspectList)aspects.copy().add(Aspect.PLANT, 1));
            }
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockHay, 1, 15), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.AIR, 1));
        }
        if (Values.blockPlants != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 0), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 2));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 1), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.SENSES, 1).add(Aspect.LIFE, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 2), (AspectList)new AspectList().add(Aspect.LIFE, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 3), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.WATER, 1).add(Aspect.LIFE, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 4), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.WATER, 1).add(Aspect.LIFE, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 5), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.WATER, 1).add(Aspect.LIFE, 2));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 6), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.SENSES, 1).add(Aspect.LIFE, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 7), (AspectList)new AspectList().add(Aspect.PLANT, 1).add(Aspect.SENSES, 1).add(Aspect.LIFE, 2));
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.blockPlants, 1, 8), (AspectList)new AspectList().add(Aspect.LIFE, 1));
        }
        if (Values.blockTypeCloud != null) {
            this.registerObjectTag(this.iStack("lightcloud_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)).add(aspectsLightCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("densecloud_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)).add(aspectsDenseCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("stormcloud_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)).add(aspectsStormCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("lightcloud_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)).add(aspectsLightCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("densecloud_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)).add(aspectsDenseCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("stormcloud_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)).add(aspectsStormCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("lightcloud_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)).add(aspectsLightCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("densecloud_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)).add(aspectsDenseCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("stormcloud_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)).add(aspectsStormCloud).remove(Aspect.PLANT));
            this.registerObjectTag(this.iStack("lightcloud_wall", new int[0]), aspectsLightCloud.copy());
            this.registerObjectTag(this.iStack("densecloud_wall", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("stormcloud_wall", new int[0]), aspectsStormCloud.copy());
            this.registerObjectTag(this.iStack("lightcloud_stairs", new int[0]), aspectsLightCloud.copy());
            this.registerObjectTag(this.iStack("densecloud_stairs", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("stormcloud_stairs", new int[0]), aspectsStormCloud.copy());
            this.registerObjectTag(this.iStack("lightcloud_slab", new int[0]), aspectsLightCloud.copy());
            this.registerObjectTag(this.iStack("densecloud_slab", new int[0]), aspectsDenseCloud.copy());
            this.registerObjectTag(this.iStack("stormcloud_slab", new int[0]), aspectsStormCloud.copy());
            AspectList aspectsVapor = new AspectList().add(Aspect.WATER, 1).add(Aspect.AIR, 8).add(Aspect.VOID, 4);
            this.registerObjectTag(this.iStack("water_vapor", new int[0]), aspectsVapor.copy());
            this.registerObjectTag(this.iStack("glow_vapor", new int[0]), aspectsVapor.copy().add(this.buildListFrom(this.iStack(Items.field_151114_aO))));
        }
        if (Values.blockTypeEarth != null) {
            this.registerObjectTag(this.iStack("applewood_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)));
            this.registerObjectTag(this.iStack("cherrywood_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)));
            this.registerObjectTag(this.iStack("orangewood_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)));
            this.registerObjectTag(this.iStack("coconutwood_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)));
            this.registerObjectTag(this.iStack("bananawood_door", new int[0]), this.buildListFrom(this.iStack(Items.field_179570_aq)));
            this.registerObjectTag(this.iStack("applewood_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)));
            this.registerObjectTag(this.iStack("cherrywood_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)));
            this.registerObjectTag(this.iStack("orangewood_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)));
            this.registerObjectTag(this.iStack("coconutwood_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)));
            this.registerObjectTag(this.iStack("bananawood_trapdoor", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150415_aT)));
            this.registerObjectTag(this.iStack("applewood_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)));
            this.registerObjectTag(this.iStack("cherrywood_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)));
            this.registerObjectTag(this.iStack("orangewood_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)));
            this.registerObjectTag(this.iStack("coconutwood_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)));
            this.registerObjectTag(this.iStack("bananawood_gate", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180390_bo)));
            this.registerObjectTag(this.iStack("applewood_fence", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180407_aO)));
            this.registerObjectTag(this.iStack("cherrywood_fence", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180407_aO)));
            this.registerObjectTag(this.iStack("orangewood_fence", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180407_aO)));
            this.registerObjectTag(this.iStack("coconutwood_fence", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180407_aO)));
            this.registerObjectTag(this.iStack("bananawood_fence", new int[0]), this.buildListFrom(this.iStack(Blocks.field_180407_aO)));
            this.registerObjectTag(this.iStack("applewood_stairs", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150476_ad)));
            this.registerObjectTag(this.iStack("cherrywood_stairs", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150476_ad)));
            this.registerObjectTag(this.iStack("orangewood_stairs", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150476_ad)));
            this.registerObjectTag(this.iStack("coconutwood_stairs", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150476_ad)));
            this.registerObjectTag(this.iStack("bananawood_stairs", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150476_ad)));
            this.registerObjectTag(this.iStack("applewood_slab", new int[0]), this.buildListFrom(this.iStack((Block)Blocks.field_150376_bx)));
            this.registerObjectTag(this.iStack("cherrywood_slab", new int[0]), this.buildListFrom(this.iStack((Block)Blocks.field_150376_bx)));
            this.registerObjectTag(this.iStack("orangewood_slab", new int[0]), this.buildListFrom(this.iStack((Block)Blocks.field_150376_bx)));
            this.registerObjectTag(this.iStack("coconutwood_slab", new int[0]), this.buildListFrom(this.iStack((Block)Blocks.field_150376_bx)));
            this.registerObjectTag(this.iStack("bananawood_slab", new int[0]), this.buildListFrom(this.iStack((Block)Blocks.field_150376_bx)));
            this.registerObjectTag(this.iStack("paper_block", new int[0]), this.buildListFrom(8.0f, this.iStack(Items.field_151121_aF)));
            this.registerObjectTag(this.iStack("glow_paper", new int[0]), this.buildListFrom(8.0f, this.iStack(Items.field_151121_aF)).add(this.buildListFrom(this.iStack(Items.field_151114_aO))));
        }
        if (Values.itemColorizer != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("colorizer", new int[0]), (AspectList)new AspectList().add(Aspect.TOOL, 1).add(Aspect.EXCHANGE, 1).add(Aspect.SENSES, 1).add(Aspect.ENTROPY, 1).add(Aspect.ORDER, 1));
        }
        if (Values.itemMain != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("paintbrush", new int[0]), (AspectList)new AspectList().add(Aspect.TOOL, 1));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("painting_cloud", new int[0]), (AspectList)new AspectList().add(Aspect.WATER, 1).add(Aspect.AIR, 2));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("painting", new int[0]), (AspectList)new AspectList().add(Aspect.PLANT, 3));
            this.registerObjectTag(this.iStack("burnium_gem", new int[0]), this.buildListFrom(this.iStack(Items.field_151065_br), this.iStack(Items.field_151044_h)).add(Aspect.CRYSTAL, 1));
            this.registerObjectTag(this.iStack("endimium_gem", new int[0]), this.buildListFrom(this.iStack(Items.field_151079_bi), this.iStack(Items.field_151045_i)).add(Aspect.CRYSTAL, 1));
            this.registerObjectTag(this.iStack("leather_scraps", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151116_aA)));
            this.registerObjectTag(this.iStack("leather_boot1", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151116_aA)));
            this.registerObjectTag(this.iStack("leather_boot2", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151116_aA)));
            this.registerObjectTag(this.iStack("leather_belt", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151116_aA)));
            this.registerObjectTag(this.iStack("dye_black", new int[0]), this.buildListFrom(this.iStack(Items.field_151100_aR)));
            this.registerObjectTag(this.iStack("dye_brown", new int[0]), this.buildListFrom(this.iStack(Items.field_151100_aR)));
            this.registerObjectTag(this.iStack("dye_blue", new int[0]), this.buildListFrom(this.iStack(Items.field_151100_aR)));
            this.registerObjectTag(this.iStack("dye_white", new int[0]), this.buildListFrom(this.iStack(Items.field_151100_aR)));
            this.registerObjectTag(this.iStack("glass_shard", new int[0]), this.buildListFrom(this.iStack(Blocks.field_150410_aZ)));
            this.registerObjectTag(this.iStack("burnium_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151065_br), this.iStack(Items.field_151044_h)));
            this.registerObjectTag(this.iStack("burnium_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151065_br), this.iStack(Items.field_151044_h)));
            this.registerObjectTag(this.iStack("endimium_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151079_bi), this.iStack(Items.field_151045_i)));
            this.registerObjectTag(this.iStack("endimium_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151079_bi), this.iStack(Items.field_151045_i)));
            this.registerObjectTag(this.iStack("ender_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151079_bi)));
            this.registerObjectTag(this.iStack("ender_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151079_bi)));
            this.registerObjectTag(this.iStack("iron_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151042_j)));
            this.registerObjectTag(this.iStack("iron_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151042_j)));
            this.registerObjectTag(this.iStack("gold_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151043_k)));
            this.registerObjectTag(this.iStack("gold_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151043_k)));
            this.registerObjectTag(this.iStack("coal_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151044_h)));
            this.registerObjectTag(this.iStack("coal_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151044_h)));
            this.registerObjectTag(this.iStack("diamond_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151045_i)));
            this.registerObjectTag(this.iStack("diamond_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151045_i)));
            this.registerObjectTag(this.iStack("emerald_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151166_bC)));
            this.registerObjectTag(this.iStack("emerald_dust", new int[0]), this.buildListFrom(this.iStack(Items.field_151166_bC)));
            this.registerObjectTag(this.iStack("lapis_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151100_aR, 4)));
            this.registerObjectTag(this.iStack("redstone_tinydust", new int[0]), this.buildListFrom(0.25f, this.iStack(Items.field_151137_ax)));
            this.registerObjectTag(this.iStack("sandstone_lump", new int[0]), this.buildListFrom(0.25f, this.iStack(Blocks.field_150322_A)));
            this.registerObjectTag(this.iStack("gravel_lump", new int[0]), this.buildListFrom(0.25f, this.iStack(Blocks.field_150351_n)));
            this.registerObjectTag(this.iStack("redsandstone_lump", new int[0]), this.buildListFrom(0.25f, this.iStack(Blocks.field_180395_cM)));
            ThaumcraftApi.registerObjectTag((ItemStack)this.iStack("scroll_strange", new int[0]), (AspectList)new AspectList().add(Aspect.SENSES, 8).add(Aspect.MIND, 8));
        }
        if (Values.itemHammer != null) {
            // empty if block
        }
        if (Values.itemMultiFood != null) {
            this.registerObjectTag(this.iStack(Values.itemMultiFood, Short.MAX_VALUE), this.buildListFrom(this.iStack(Items.field_151034_e)));
        }
        if (Values.itemMultiTool != null) {
            // empty if block
        }
        if (Values.itemScythe != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)new ItemStack(Values.itemScythe), (AspectList)new AspectList().add(Aspect.TOOL, 2).add(Aspect.EARTH, 2));
        }
    }

    private void registerObjectTag(ItemStack stack, AspectList aspects) {
        if (stack != null && aspects != null) {
            ThaumcraftApi.registerObjectTag((ItemStack)stack, (AspectList)aspects);
        }
    }

    private AspectList buildListFrom(ItemStack ... stacks) {
        AspectList aspects = new AspectList();
        for (ItemStack stack : stacks) {
            aspects.add(AspectHelper.getObjectAspects((ItemStack)stack));
        }
        return aspects;
    }

    private AspectList buildListFrom(float multiplier, ItemStack ... stacks) {
        AspectList aspects = new AspectList();
        for (ItemStack stack : stacks) {
            if (stack == null) continue;
            aspects.add(AspectHelper.getObjectAspects((ItemStack)stack));
        }
        AspectList aspects2 = new AspectList();
        Aspect[] aspectArray = aspects.getAspects();
        int n = aspectArray.length;
        for (int i = 0; i < n; ++i) {
            Aspect key;
            int amount = (int)((float)aspects.getAmount(key = aspectArray[i]) * multiplier);
            aspects2.add(key, amount < 1 ? 1 : amount);
        }
        return aspects2;
    }

    private ItemStack iStack(String name, int ... val) {
        ItemStack stack = Values.stacks.get(name, new int[0]);
        if (stack == null) {
            Values.logTerraqueous.error("ThaumcraftModule: Could not find " + name + " in stack map");
            return null;
        }
        if (val.length > 0) {
            stack = stack.func_77946_l();
            stack.field_77994_a = val[0];
        }
        return stack;
    }

    private ItemStack iStack(Item item) {
        return new ItemStack(item);
    }

    private ItemStack iStack(Item item, int metadata) {
        return new ItemStack(item, 1, metadata);
    }

    private ItemStack iStack(Block block) {
        return new ItemStack(block);
    }

    private ItemStack iStack(Block block, int metadata) {
        return new ItemStack(block, 1, metadata);
    }
}

