/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import shetiphian.core.common.RecipeHelper;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.EnderTableRecipeHandler;
import shetiphian.terraqueous.api.machines.SimpleEnderTableRecipe;
import shetiphian.terraqueous.api.plant.PlantAPI;

public class Recipes {
    public static Recipes INSTANCE = new Recipes();
    private String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    private RecipeHelper helper;

    public static RecipeHelper getHelper() {
        if (Recipes.INSTANCE.helper == null) {
            Recipes.INSTANCE.helper = new RecipeHelper(Values.logTerraqueous);
        }
        return Recipes.INSTANCE.helper;
    }

    void loadRecipes() {
        this.helper = new RecipeHelper(Values.logTerraqueous);
        this.rBlockCloudFancy();
        this.rBlockClouds();
        this.rBlockCrafting();
        this.rBlockDoodad();
        this.rBlockEnderTable();
        this.rBlockEarthOre();
        this.rBlockFlowerPot();
        this.rBlockFlowers();
        this.rBlockHay();
        this.rBlockPergola();
        this.rBlockPlants();
        this.rBlockTreesX();
        this.rBlockTypeCloud();
        this.rBlockTypeEarth();
        this.rItemEquipable();
        this.rItemMain();
        this.rTools();
        this.rMinecraft();
    }

    private void rBlockCloudFancy() {
        if (Values.blockCloudFancy == null) {
            return;
        }
        if (Values.blockClouds != null) {
            this.helper.addShapedRecipe(this.iStack("cloud_column", new int[0]), new Object[]{"#", "#", "#", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_capital", new int[0]), new Object[]{"###", " # ", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_arch", 2), new Object[]{"###", "## ", "#  ", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_arch", 2), new Object[]{"###", " ##", "  #", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_edge", 4), new Object[]{"@@", "# ", "# ", Character.valueOf('#'), this.iStack("densecloud_block", new int[0]), Character.valueOf('@'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_edge", 4), new Object[]{"@@", " #", " #", Character.valueOf('#'), this.iStack("densecloud_block", new int[0]), Character.valueOf('@'), this.iStack("lightcloud_block", new int[0])});
        }
    }

    private void rBlockClouds() {
        if (Values.blockClouds == null) {
            return;
        }
        if (Values.blockCloudFancy != null) {
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 3), new Object[]{this.iStack("cloud_column", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 4), new Object[]{this.iStack("cloud_capital", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 3), new Object[]{this.iStack("cloud_arch", new int[0])});
        }
        this.helper.addShapedRecipe(this.iStack("densecloud_block", new int[0]), new Object[]{"##", "##", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
        this.helper.addShapedRecipe(this.iStack("stormcloud_block", new int[0]), new Object[]{"##", "##", Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 4), new Object[]{this.iStack("densecloud_block", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("densecloud_block", 4), new Object[]{this.iStack("stormcloud_block", new int[0])});
        if (Values.blockCrafting != null) {
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", 4), new Object[]{this.iStack("cloud_workbench", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", 8), new Object[]{this.iStack("cloud_furnace", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", 12), new Object[]{this.iStack("cloud_craftbench", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", 23), new Object[]{this.iStack("cloud_craftfurnace", new int[0])});
        }
        if (Values.blockTypeCloud != null) {
            this.helper.addShapedRecipe(this.iStack("lightcloud_block", new int[0]), new Object[]{"##", "##", Character.valueOf('#'), this.iStack("water_vapor", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 3), new Object[]{this.iStack("lightcloud_door", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("densecloud_block", 3), new Object[]{this.iStack("densecloud_door", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", 3), new Object[]{this.iStack("stormcloud_door", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 2), new Object[]{this.iStack("lightcloud_trapdoor", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("densecloud_block", 2), new Object[]{this.iStack("densecloud_trapdoor", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", 2), new Object[]{this.iStack("stormcloud_trapdoor", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 3), new Object[]{this.iStack("lightcloud_gate", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("densecloud_block", 3), new Object[]{this.iStack("densecloud_gate", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", 3), new Object[]{this.iStack("stormcloud_gate", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 6), new Object[]{this.iStack("densecloud_wall", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("densecloud_block", 6), new Object[]{this.iStack("stormcloud_wall", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", new int[0]), new Object[]{this.iStack("lightcloud_stairs", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("densecloud_block", new int[0]), new Object[]{this.iStack("densecloud_stairs", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("stormcloud_block", new int[0]), new Object[]{this.iStack("stormcloud_stairs", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("lightcloud_block", 2), new Object[]{this.iStack("densecloud_slab", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("densecloud_block", 2), new Object[]{this.iStack("stormcloud_slab", new int[0])});
        }
    }

    private void rBlockCrafting() {
        if (Values.blockCrafting == null) {
            return;
        }
        if (Values.blockClouds != null) {
            this.helper.addShapedRecipe(this.iStack("cloud_workbench", new int[0]), new Object[]{"##", "##", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_furnace", new int[0]), new Object[]{"###", "# #", "###", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_craftbench", new int[0]), new Object[]{"###", "#@#", "###", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0]), Character.valueOf('@'), this.iStack("cloud_workbench", new int[0])});
            this.helper.addShapedRecipe(this.iStack("cloud_craftfurnace", new int[0]), new Object[]{"###", "#@#", "#@#", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0]), Character.valueOf('@'), this.iStack("cloud_furnace", new int[0])});
        }
        this.helper.addShapedOreRecipe(this.iStack("craftbench", new int[0]), new Object[]{"###", "#@#", "###", Character.valueOf('#'), "stone", Character.valueOf('@'), "workbench"});
        this.helper.addShapedOreRecipe(this.iStack("craftfurnace", new int[0]), new Object[]{"###", "#@#", "#@#", Character.valueOf('#'), "stone", Character.valueOf('@'), this.iStack(Blocks.field_150460_al, new int[0])});
    }

    private void rBlockDoodad() {
        if (Values.blockDoodad == null) {
            return;
        }
        if (Values.itemMain != null) {
            this.helper.addShapelessRecipe(this.iStack("glass_shards", new int[0]), new Object[]{this.iStack("glass_shard", new int[0]), this.iStack("glass_shard", new int[0]), this.iStack("glass_shard", new int[0]), this.iStack("glass_shard", new int[0])});
        }
    }

    private void rBlockEnderTable() {
        if (Values.blockEnderTable == null) {
            return;
        }
        if (Values.itemMain != null) {
            this.helper.addShapedOreRecipe(new ItemStack(Values.blockEnderTable), new Object[]{" B ", "DOD", "OOO", Character.valueOf('B'), this.iStack("ender_book", new int[0]), Character.valueOf('D'), "gemDiamond", Character.valueOf('O'), "obsidian"});
        }
    }

    private void rBlockEarthOre() {
        if (Values.blockEarthOre == null) {
            return;
        }
        this.helper.addShapedOreRecipe(this.iStack("endimium_block", new int[0]), new Object[]{"###", "###", "###", Character.valueOf('#'), "gemEndimium"});
        this.helper.addShapedOreRecipe(this.iStack("burnium_block", new int[0]), new Object[]{"###", "###", "###", Character.valueOf('#'), "gemBurnium"});
    }

    private void rBlockFlowerPot() {
        this.helper.addShapelessRecipe(this.iStack("flowerpot", new int[0]), new Object[]{Items.field_151162_bE});
        this.helper.addShapedOreRecipe(this.iStack("flowerpot", new int[0]), new Object[]{"# #", " # ", Character.valueOf('#'), "ingotBrick"});
        this.helper.addShapedOreRecipe(this.iStack("planterpot", new int[0]), new Object[]{"# #", "###", Character.valueOf('#'), "ingotBrick"});
        this.addColoredRecipes(this.iStack("flowerpot", new int[0]));
        this.addColoredRecipes(this.iStack("planterpot", new int[0]));
    }

    private void rBlockFlowers() {
        if (Values.blockFlowerCluster == null || Values.blockFlowerSingle == null) {
            return;
        }
        int meta = 0;
        while (meta < 16) {
            this.helper.addShapelessRecipe(this.iStack(Values.blockFlowerCluster, 1, meta), new Object[]{this.iStack(Values.blockFlowerSingle, 1, meta), this.iStack(Values.blockFlowerSingle, 1, meta), this.iStack(Values.blockFlowerSingle, 1, meta)});
            this.helper.addShapelessRecipe(this.iStack(Values.blockFlowerSingle, 3, meta), new Object[]{this.iStack(Values.blockFlowerCluster, 1, meta++)});
        }
    }

    private void rBlockHay() {
        if (Values.blockHay == null) {
            return;
        }
        if (Settings.INSTANCE.setup().replaceHayBaleRecipes) {
            this.helper.remove(new ItemStack(Blocks.field_150407_cf), 9, false, true);
            this.helper.remove(new ItemStack(Items.field_151015_O, 9), 1, false, true);
            this.helper.addShapelessRecipe(this.iStack("hayblock", 4), new Object[]{new ItemStack(Blocks.field_150407_cf)});
        }
        this.helper.addShapelessRecipe(this.iStack("hayblock", new int[0]), new Object[]{this.iStack("haypile_small", new int[0]), this.iStack("haypile_small", new int[0]), this.iStack("haypile_small", new int[0]), this.iStack("haypile_small", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("hayblock", new int[0]), new Object[]{this.iStack("haypile_large", new int[0]), this.iStack("haypile_small", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("hayblock", new int[0]), new Object[]{this.iStack("haypile", new int[0]), this.iStack("haypile", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_large", new int[0]), new Object[]{this.iStack("haypile_small", new int[0]), this.iStack("haypile_small", new int[0]), this.iStack("haypile_small", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_large", new int[0]), new Object[]{this.iStack("haypile_small", new int[0]), this.iStack("haypile", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile", new int[0]), new Object[]{this.iStack("haypile_small", new int[0]), this.iStack("haypile_small", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_small", 4), new Object[]{this.iStack("hayblock", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_small", 3), new Object[]{this.iStack("haypile_large", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_small", 2), new Object[]{this.iStack("haypile", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_small", new int[0]), new Object[]{this.iStack("loosehay", new int[0]), this.iStack("loosehay", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_small", new int[0]), new Object[]{this.iStack("thresh", new int[0]), this.iStack("thresh", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("haypile_small", new int[0]), new Object[]{this.iStack("thresh", new int[0]), this.iStack("loosehay", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("thresh", 2), new Object[]{this.iStack("haypile_small", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("thresh", new int[0]), new Object[]{this.iStack("loosehay", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("loosehay", new int[0]), new Object[]{this.iStack("thresh", new int[0])});
    }

    private void rBlockPergola() {
        if (Values.blockPergola == null) {
            return;
        }
        this.helper.addShapedOreRecipe(this.iStack("pergolatop", 4), new Object[]{"SSS", "HHH", "PPP", Character.valueOf('S'), "stickWood", Character.valueOf('H'), "slabWood", Character.valueOf('P'), "plankWood"});
        this.helper.addShapedOreRecipe(this.iStack("pergolawall", 4), new Object[]{"PHP", "PSP", "PHP", Character.valueOf('S'), "stickWood", Character.valueOf('H'), "slabWood", Character.valueOf('P'), "plankWood"});
        this.helper.addShapedOreRecipe(this.iStack("pergolagate", 2), new Object[]{" S ", "SSS", "PHP", Character.valueOf('S'), "stickWood", Character.valueOf('H'), "slabWood", Character.valueOf('P'), "plankWood"});
        this.addColoredRecipes(this.iStack("pergolatop", new int[0]));
        this.addColoredRecipes(this.iStack("pergolawall", new int[0]));
        this.addColoredRecipes(this.iStack("pergolagate", new int[0]));
    }

    private void rBlockPlants() {
        if (Values.blockPlants == null) {
            return;
        }
        this.helper.addSmelting(this.iStack(Items.field_151100_aR, 1, EnumDyeColor.GREEN.func_176767_b()), this.iStack("cactus", new int[0]), 0.2f);
        this.helper.addShapelessRecipe(this.iStack("cactus_large", new int[0]), new Object[]{this.iStack("cactus", new int[0]), this.iStack("cactus", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("cactus_fruit", new int[0]), new Object[]{this.iStack("cactus_large", new int[0]), this.iStack("pricklypear", new int[0]), this.iStack("pricklypear", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("cactus_fruit", new int[0]), new Object[]{this.iStack("cactus", new int[0]), this.iStack("cactus", new int[0]), this.iStack("pricklypear", new int[0]), this.iStack("pricklypear", new int[0])});
    }

    private void rBlockTreesX() {
        if (Values.blockPlanks != null && Values.blockTreeTrunk1 != null && Values.blockTreeTrunk2 != null) {
            this.recipeCleaner();
            for (PlantAPI.TreeType tree : PlantAPI.TreeType.values()) {
                String name = tree.func_176610_l();
                this.helper.addShapelessRecipe(this.iStack(name + "_planks", 4), new Object[]{this.iStack(name + "_log", new int[0])});
            }
        }
    }

    private void rBlockTypeCloud() {
        if (Values.blockTypeCloud == null) {
            return;
        }
        if (Values.blockCloudFancy != null) {
            this.helper.addShapelessRecipe(this.iStack("water_vapor", 10), new Object[]{this.iStack("cloud_edge", new int[0])});
        }
        if (Values.blockClouds != null) {
            this.helper.addShapelessRecipe(this.iStack("water_vapor", 4), new Object[]{this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("lightcloud_door", 2), new Object[]{"##", "##", "##", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("densecloud_door", 2), new Object[]{"##", "##", "##", Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("stormcloud_door", 2), new Object[]{"##", "##", "##", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("lightcloud_trapdoor", 3), new Object[]{"###", "###", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("densecloud_trapdoor", 3), new Object[]{"###", "###", Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("stormcloud_trapdoor", 3), new Object[]{"###", "###", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("lightcloud_gate", new int[0]), new Object[]{"$#$", "$#$", Character.valueOf('$'), this.iStack("water_vapor", new int[0]), Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("densecloud_gate", new int[0]), new Object[]{"$#$", "$#$", Character.valueOf('$'), this.iStack("lightcloud_block", new int[0]), Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("stormcloud_gate", new int[0]), new Object[]{"$#$", "$#$", Character.valueOf('$'), this.iStack("densecloud_block", new int[0]), Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("lightcloud_wall", 3), new Object[]{"#$#", "#$#", Character.valueOf('$'), this.iStack("water_vapor", new int[0]), Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("densecloud_wall", 3), new Object[]{"#$#", "#$#", Character.valueOf('$'), this.iStack("lightcloud_block", new int[0]), Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("stormcloud_wall", 3), new Object[]{"#$#", "#$#", Character.valueOf('$'), this.iStack("densecloud_block", new int[0]), Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("lightcloud_stairs", 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("lightcloud_stairs", 6), new Object[]{"  #", " ##", "###", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("densecloud_stairs", 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("densecloud_stairs", 6), new Object[]{"  #", " ##", "###", Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("stormcloud_stairs", 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("stormcloud_stairs", 6), new Object[]{"  #", " ##", "###", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("lightcloud_slab", 6), new Object[]{"###", Character.valueOf('#'), this.iStack("lightcloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("densecloud_slab", 6), new Object[]{"###", Character.valueOf('#'), this.iStack("densecloud_block", new int[0])});
            this.helper.addShapedRecipe(this.iStack("stormcloud_slab", 6), new Object[]{"###", Character.valueOf('#'), this.iStack("stormcloud_block", new int[0])});
        }
        this.helper.addShapelessRecipe(this.iStack("water_vapor", 6), new Object[]{this.iStack("lightcloud_wall", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("water_vapor", 2), new Object[]{this.iStack("lightcloud_slab", new int[0])});
        this.helper.addShapelessOreRecipe(this.iStack("glow_vapor", 2), new Object[]{"dustGlowstone", this.iStack("water_vapor", new int[0]), this.iStack("water_vapor", new int[0])});
        this.helper.addShapelessOreRecipe(this.iStack("glow_vapor", 4), new Object[]{"dustGlowstone", this.iStack("water_vapor", new int[0]), this.iStack("water_vapor", new int[0]), "dustGlowstone", this.iStack("water_vapor", new int[0]), this.iStack("water_vapor", new int[0])});
        this.helper.addShapelessOreRecipe(this.iStack("glow_vapor", 6), new Object[]{"dustGlowstone", this.iStack("water_vapor", new int[0]), this.iStack("water_vapor", new int[0]), "dustGlowstone", this.iStack("water_vapor", new int[0]), this.iStack("water_vapor", new int[0]), "dustGlowstone", this.iStack("water_vapor", new int[0]), this.iStack("water_vapor", new int[0])});
        this.addColoredRecipes(this.iStack("water_vapor", new int[0]));
        this.addColoredRecipes(this.iStack("glow_vapor", new int[0]));
    }

    private void rBlockTypeEarth() {
        if (Values.blockTypeEarth == null) {
            return;
        }
        if (Values.blockPlanks != null) {
            for (PlantAPI.TreeType tree : PlantAPI.TreeType.values()) {
                String name = tree.func_176610_l();
                this.helper.addShapedRecipe(this.iStack(name + "wood_door", 2), new Object[]{"##", "##", "##", Character.valueOf('#'), this.iStack(name + "_planks", new int[0])});
                this.helper.addShapedRecipe(this.iStack(name + "wood_trapdoor", 4), new Object[]{"###", "###", Character.valueOf('#'), this.iStack(name + "_planks", new int[0])});
                this.helper.addShapedOreRecipe(this.iStack(name + "wood_gate", new int[0]), new Object[]{"S#S", "S#S", Character.valueOf('S'), "stickWood", Character.valueOf('#'), this.iStack(name + "_planks", new int[0])});
                this.helper.addShapedOreRecipe(this.iStack(name + "wood_fence", 3), new Object[]{"#S#", "#S#", Character.valueOf('S'), "stickWood", Character.valueOf('#'), this.iStack(name + "_planks", new int[0])});
                this.helper.addShapedRecipe(this.iStack(name + "wood_stairs", 6), new Object[]{"#  ", "## ", "###", Character.valueOf('#'), this.iStack(name + "_planks", new int[0])});
                this.helper.addShapedRecipe(this.iStack(name + "wood_slab", 6), new Object[]{"###", Character.valueOf('#'), this.iStack(name + "_planks", new int[0])});
            }
        }
        this.helper.addShapedOreRecipe(this.iStack("paper_block", new int[0]), new Object[]{"###", "###", "###", Character.valueOf('#'), "paper"});
        this.helper.addShapedOreRecipe(this.iStack("glow_paper", 8), new Object[]{"###", "#G#", "###", Character.valueOf('#'), this.iStack("paper_block", new int[0]), Character.valueOf('G'), "glowstone"});
        this.addColoredRecipes(this.iStack("paper_block", new int[0]));
        this.addColoredRecipes(this.iStack("glow_paper", new int[0]));
    }

    private void rItemEquipable() {
        if (Values.itemCloudTalisman != null) {
            EnderTableRecipeHandler.INSTANCE.addEnderTableRecipe(new SimpleEnderTableRecipe(this.iStack(Values.itemCloudTalisman, new int[0]), this.iStack("talisman_assembled", new int[0]), null, 0, 5, 0.0f, "info.terraqueous.infuse.txt", true));
        }
        if (Values.itemEnderMonocle != null) {
            EnderTableRecipeHandler.INSTANCE.addEnderTableRecipe(new SimpleEnderTableRecipe(this.iStack(Values.itemEnderMonocle, new int[0]), this.iStack(Items.field_151061_bv, new int[0]), "nuggetGold", 9, 5, 0.0f, "info.terraqueous.fusion.txt", true));
        }
    }

    private void rItemMain() {
        if (Values.itemMain == null) {
            return;
        }
        if (Values.blockClouds != null) {
            this.helper.addShapedRecipe(this.iStack("painting_cloud", new int[0]), new Object[]{"DDD", "DLD", "DDD", Character.valueOf('D'), this.iStack("densecloud_block", new int[0]), Character.valueOf('L'), this.iStack("lightcloud_block", new int[0])});
        }
        if (Values.blockEarthOre != null) {
            this.helper.addShapelessRecipe(this.iStack("endimium_gem", 9), new Object[]{this.iStack("endimium_block", new int[0])});
            this.helper.addShapelessRecipe(this.iStack("burnium_gem", 9), new Object[]{this.iStack("burnium_block", new int[0])});
        }
        if (Values.blockFlowerSingle != null) {
            this.helper.addShapelessRecipe(this.iStack("dye_black", new int[0]), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 0), this.iStack(Values.blockFlowerSingle, 1, 0)});
            this.helper.addShapelessRecipe(this.iStack("dye_brown", new int[0]), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 3), this.iStack(Values.blockFlowerSingle, 1, 3)});
            this.helper.addShapelessRecipe(this.iStack("dye_blue", new int[0]), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 4), this.iStack(Values.blockFlowerSingle, 1, 4)});
            this.helper.addShapelessRecipe(this.iStack("dye_white", new int[0]), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 15), this.iStack(Values.blockFlowerSingle, 1, 15)});
        }
        this.helper.addShapedOreRecipe(this.iStack("paintbrush", new int[0]), new Object[]{"CB ", "RSW", "YbS", Character.valueOf('C'), "string", Character.valueOf('S'), "stickWood", Character.valueOf('B'), "dyeBlack", Character.valueOf('W'), "dyeWhite", Character.valueOf('R'), "dyeRed", Character.valueOf('Y'), "dyeYellow", Character.valueOf('b'), "dyeBlue"});
        this.helper.addShapedOreRecipe(this.iStack("painting", new int[0]), new Object[]{"SSS", "SPS", "SSS", Character.valueOf('S'), "stickWood", Character.valueOf('P'), "paper"});
        this.helper.addShapedOreRecipe(this.iStack("talisman_unbaked", new int[0]), new Object[]{"FEF", "CCC", Character.valueOf('F'), "feather", Character.valueOf('E'), "gemEndimium", Character.valueOf('C'), Items.field_151119_aD});
        this.helper.addSmelting(this.iStack("talisman_baked", new int[0]), this.iStack("talisman_unbaked", new int[0]), 0.3f);
        this.helper.addShapedOreRecipe(this.iStack("talisman_assembled", new int[0]), new Object[]{"FEF", " T ", Character.valueOf('F'), "feather", Character.valueOf('E'), "gemEndimium", Character.valueOf('T'), this.iStack("talisman_baked", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("leather_scraps", 3), new Object[]{this.iStack("leather_boot1", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("leather_scraps", 2), new Object[]{this.iStack("leather_boot2", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("leather_scraps", new int[0]), new Object[]{this.iStack("leather_belt", new int[0])});
        this.helper.addShapelessRecipe(this.iStack("ender_book", new int[0]), new Object[]{Items.field_151122_aG, Items.field_151061_bv});
        this.helper.addShapelessOreRecipe(this.iStack("burnium_dust", new int[0]), new Object[]{"dustTinyBurnium", "dustTinyBurnium", "dustTinyBurnium", "dustTinyBurnium"});
        this.helper.addShapelessOreRecipe(this.iStack("burnium_dust", new int[0]), new Object[]{"dustCoal", Items.field_151065_br});
        this.helper.addSmelting(this.iStack("burnium_gem", new int[0]), this.iStack("burnium_dust", new int[0]), 2.75f);
        this.helper.addShapelessOreRecipe(this.iStack("endimium_dust", new int[0]), new Object[]{"dustTinyEndimium", "dustTinyEndimium", "dustTinyEndimium", "dustTinyEndimium"});
        this.helper.addShapelessOreRecipe(this.iStack("endimium_dust", new int[0]), new Object[]{"dustEnder", "dustDiamond"});
        this.helper.addSmelting(this.iStack("endimium_gem", new int[0]), this.iStack("endimium_dust", new int[0]), 2.75f);
        if (Settings.INSTANCE.setup().enableCrafting_TinyDustToEnderDust) {
            this.helper.addShapelessOreRecipe(this.iStack("ender_dust", new int[0]), new Object[]{"dustTinyEnder", "dustTinyEnder", "dustTinyEnder", "dustTinyEnder"});
        }
        if (Settings.INSTANCE.setup().enableCrafting_TinyDustToIronDust) {
            this.helper.addShapelessOreRecipe(this.iStack("iron_dust", new int[0]), new Object[]{"dustTinyIron", "dustTinyIron", "dustTinyIron", "dustTinyIron"});
        }
        if (Settings.INSTANCE.setup().enableCrafting_TinyDustToGoldDust) {
            this.helper.addShapelessOreRecipe(this.iStack("gold_dust", new int[0]), new Object[]{"dustTinyGold", "dustTinyGold", "dustTinyGold", "dustTinyGold"});
        }
        if (Settings.INSTANCE.setup().enableCrafting_TinyDustToCoalDust) {
            this.helper.addShapelessOreRecipe(this.iStack("coal_dust", new int[0]), new Object[]{"dustTinyCoal", "dustTinyCoal", "dustTinyCoal", "dustTinyCoal"});
        }
        if (Settings.INSTANCE.setup().enableCrafting_TinyDustToDiamondDust) {
            this.helper.addShapelessOreRecipe(this.iStack("diamond_dust", new int[0]), new Object[]{"dustTinyDiamond", "dustTinyDiamond", "dustTinyDiamond", "dustTinyDiamond"});
        }
        if (Settings.INSTANCE.setup().enableCrafting_TinyDustToEmeraldDust) {
            this.helper.addShapelessOreRecipe(this.iStack("emerald_dust", new int[0]), new Object[]{"dustTinyEmerald", "dustTinyEmerald", "dustTinyEmerald", "dustTinyEmerald"});
        }
        if (Values.itemHammer != null) {
            if (Settings.INSTANCE.setup().enableSmashing_EnderPearlsToDust) {
                this.helper.addShapelessOreRecipe(this.iStack("ender_dust", new int[0]), new Object[]{this.iStack("hammer", new int[0]), "enderpearl"});
            }
            if (Settings.INSTANCE.setup().enableSmashing_CoalToDust) {
                this.helper.addShapelessOreRecipe(this.iStack("coal_dust", new int[0]), new Object[]{this.iStack("hammer", new int[0]), Items.field_151044_h});
            }
            if (Settings.INSTANCE.setup().enableSmashing_DiamondToDust) {
                this.helper.addShapelessOreRecipe(this.iStack("diamond_dust", new int[0]), new Object[]{this.iStack("hammer", new int[0]), "gemDiamond"});
            }
        }
    }

    private void rTools() {
        if (Values.itemColorizer != null) {
            this.helper.addShapedOreRecipe(this.iStack("colorizer_empty", new int[0]), new Object[]{"RII", "GPI", "BII", Character.valueOf('R'), "dyeRed", Character.valueOf('G'), "dyeGreen", Character.valueOf('B'), "dyeBlue", Character.valueOf('P'), "paneGlass", Character.valueOf('I'), "ingotIron"});
        }
        if (Values.itemHammer != null) {
            this.helper.addShapedOreRecipe(this.iStack("hammer", new int[0]), new Object[]{"I", "L", Character.valueOf('I'), "blockIron", Character.valueOf('L'), "logWood"});
        }
        if (Values.itemMultiTool != null) {
            this.helper.addShapedOreRecipe(this.iStack("multitool", new int[0]), new Object[]{"BIE", " L ", " L ", Character.valueOf('I'), "blockIron", Character.valueOf('L'), "logWood", Character.valueOf('E'), this.iStack("endimium_block", new int[0]), Character.valueOf('B'), this.iStack("burnium_block", new int[0])});
        }
        if (Values.itemScythe != null) {
            this.helper.addShapedOreRecipe(this.iStack("scythe", new int[0]), new Object[]{"II", " S", "SC", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood", Character.valueOf('C'), "string"});
        }
    }

    private void rMinecraft() {
        if (Settings.INSTANCE.setup().enableWoolToString) {
            this.helper.addShapelessRecipe(this.iStack(Items.field_151007_F, 4), new Object[]{Blocks.field_150325_L});
        }
        if (Values.blockDoodad != null) {
            this.helper.addSmelting(this.iStack(Blocks.field_150359_w, new int[0]), this.iStack("glass_shards", new int[0]), 0.0f);
        }
        if (Values.blockFlowerPot != null) {
            this.helper.addShapelessRecipe(this.iStack(Items.field_151162_bE, new int[0]), new Object[]{this.iStack("flowerpot", new int[0])});
        }
        if (Values.blockFlowerSingle != null) {
            for (int x = 1; x < 15; ++x) {
                if (x == 3 || x == 4) continue;
                this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, x), new Object[]{this.iStack(Values.blockFlowerSingle, 1, x), this.iStack(Values.blockFlowerSingle, 1, x)});
            }
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 5), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 1), this.iStack(Values.blockFlowerSingle, 1, 4)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 6), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 2), this.iStack(Values.blockFlowerSingle, 1, 4)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 7), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 8), this.iStack(Values.blockFlowerSingle, 1, 15)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 8), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 7), this.iStack(Values.blockFlowerSingle, 1, 0)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 8), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 0), this.iStack(Values.blockFlowerSingle, 1, 15)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 9), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 1), this.iStack(Values.blockFlowerSingle, 1, 15)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 10), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 2), this.iStack(Values.blockFlowerSingle, 1, 15)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 12), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 4), this.iStack(Values.blockFlowerSingle, 1, 15)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 13), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 5), this.iStack(Values.blockFlowerSingle, 1, 9)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 1, 14), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 1), this.iStack(Values.blockFlowerSingle, 1, 11)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 2, 7), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 0), this.iStack(Values.blockFlowerSingle, 1, 15), this.iStack(Values.blockFlowerSingle, 1, 15)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 2, 13), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 5), this.iStack(Values.blockFlowerSingle, 1, 1), this.iStack(Values.blockFlowerSingle, 1, 15)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 2, 13), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 9), this.iStack(Values.blockFlowerSingle, 1, 1), this.iStack(Values.blockFlowerSingle, 1, 4)});
            this.helper.addShapelessRecipe(this.iStack(Items.field_151100_aR, 2, 13), new Object[]{this.iStack(Values.blockFlowerSingle, 1, 1), this.iStack(Values.blockFlowerSingle, 1, 4), this.iStack(Values.blockFlowerSingle, 1, 1), this.iStack(Values.blockFlowerSingle, 1, 15)});
        }
        if (Values.blockHay != null && Settings.INSTANCE.setup().replaceHayBaleRecipes) {
            this.helper.addShapedRecipe(this.iStack(Blocks.field_150407_cf, new int[0]), new Object[]{"##", "##", Character.valueOf('#'), this.iStack("hayblock", new int[0])});
        }
        if (Values.blockTreeTrunk1 != null) {
            this.helper.addSmelting(this.iStack(Items.field_151044_h, 1, 1), this.iStack(Values.blockTreeTrunk1, 1, Short.MAX_VALUE), 0.15f);
        }
        if (Values.blockTreeTrunk2 != null) {
            this.helper.addSmelting(this.iStack(Items.field_151044_h, 1, 1), this.iStack(Values.blockTreeTrunk2, 1, Short.MAX_VALUE), 0.15f);
        }
        if (Values.itemMain != null) {
            this.helper.addShapedRecipe(this.iStack(Items.field_151116_aA, new int[0]), new Object[]{"##", "##", Character.valueOf('#'), this.iStack("leather_scraps", new int[0])});
            this.helper.addSmelting(this.iStack(Blocks.field_150410_aZ, new int[0]), this.iStack("glass_shard", new int[0]), 0.0f);
            this.helper.addSmelting(this.iStack(Items.field_151079_bi, new int[0]), this.iStack("ender_dust", new int[0]), 1.0f);
            this.helper.addSmelting(this.iStack(Items.field_151042_j, new int[0]), this.iStack("iron_dust", new int[0]), 0.7f);
            this.helper.addSmelting(this.iStack(Items.field_151043_k, new int[0]), this.iStack("gold_dust", new int[0]), 1.0f);
            this.helper.addSmelting(this.iStack(Items.field_151045_i, new int[0]), this.iStack("diamond_dust", new int[0]), 1.5f);
            this.helper.addSmelting(this.iStack(Items.field_151166_bC, new int[0]), this.iStack("emerald_dust", new int[0]), 2.0f);
            if (Settings.INSTANCE.setup().enableCrafting_TinyDustToLapis) {
                this.helper.addShapelessOreRecipe(this.iStack(Items.field_151100_aR, 1, 4), new Object[]{"dustTinyLapis", "dustTinyLapis", "dustTinyLapis", "dustTinyLapis"});
            }
            if (Settings.INSTANCE.setup().enableCrafting_TinyDustToRedstone) {
                this.helper.addShapelessOreRecipe(this.iStack(Items.field_151137_ax, new int[0]), new Object[]{"dustTinyRedstone", "dustTinyRedstone", "dustTinyRedstone", "dustTinyRedstone"});
            }
            if (Settings.INSTANCE.setup().enableCrafting_LumpToSandstone) {
                this.helper.addShapelessOreRecipe(this.iStack(Blocks.field_150322_A, new int[0]), new Object[]{"lumpSandstone", "lumpSandstone", "lumpSandstone", "lumpSandstone"});
            }
            if (Settings.INSTANCE.setup().enableCrafting_LumpToGravel) {
                this.helper.addShapelessOreRecipe(this.iStack(Blocks.field_150351_n, new int[0]), new Object[]{"lumpGravel", "lumpGravel", "lumpGravel", "lumpGravel"});
            }
            if (Settings.INSTANCE.setup().enableCrafting_LumpToRedSandstone) {
                this.helper.addShapelessOreRecipe(this.iStack(Blocks.field_180395_cM, new int[0]), new Object[]{"lumpRedSandstone", "lumpRedSandstone", "lumpRedSandstone", "lumpRedSandstone"});
            }
        }
        if (Values.blockTypeCloud != null) {
            this.helper.addShapedRecipe(this.iStack(Items.field_151131_as, 1), new Object[]{" # ", "#@#", " # ", Character.valueOf('@'), this.iStack(Items.field_151133_ar, new int[0]), Character.valueOf('#'), this.iStack("water_vapor", new int[0])});
        }
        if (Values.blockTypeEarth != null) {
            this.helper.addShapelessRecipe(this.iStack(Items.field_151121_aF, 9), new Object[]{this.iStack("paper_block", new int[0])});
        }
    }

    private void addColoredRecipes(ItemStack baseStack) {
        if (baseStack.func_77973_b() instanceof IRGB16_Item) {
            ItemStack coloredStack = baseStack.func_77946_l();
            for (String dye : this.dyes) {
                ((IRGB16_Item)coloredStack.func_77973_b()).setRGB16(coloredStack, RGB16Helper.getIndexFor((String)dye));
                this.helper.addShapelessOreRecipe(coloredStack, new Object[]{dye, baseStack});
            }
        }
    }

    private ItemStack iStack(Block block, int ... val) {
        return new ItemStack(block, val.length > 0 ? val[0] : 1, val.length > 1 ? val[1] : 0);
    }

    private ItemStack iStack(Item item, int ... val) {
        return new ItemStack(item, val.length > 0 ? val[0] : 1, val.length > 1 ? val[1] : 0);
    }

    private ItemStack iStack(String name, int ... val) {
        ItemStack stack = Values.stacks.get(name, new int[0]);
        if (stack == null) {
            Values.logTerraqueous.error("Could not find " + name + " in stack map");
            return null;
        }
        if (val.length > 0) {
            stack = stack.func_77946_l();
            stack.field_77994_a = val[0];
        }
        return stack;
    }

    private void recipeCleaner() {
        ArrayList recipes = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe iRecipe : recipes) {
            if (iRecipe == null || !(iRecipe instanceof ShapedOreRecipe) || !ItemStack.func_77989_b((ItemStack)iRecipe.func_77571_b(), (ItemStack)new ItemStack(Blocks.field_150415_aT, 2))) continue;
            Values.logTerraqueous.info("Removing my planks from dictionary recipe: Trap Door");
            this.removeMyBlocks(((ShapedOreRecipe)iRecipe).getInput());
        }
    }

    private void removeMyBlocks(Object[] recipe) {
        for (int part = 0; part < recipe.length; ++part) {
            if (recipe[part] == null) continue;
            ArrayList stackList = null;
            try {
                stackList = (ArrayList)recipe[part];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stackList == null || stackList.isEmpty()) continue;
            ArrayList<ItemStack> newStackList = new ArrayList<ItemStack>();
            for (ItemStack aStackList : stackList) {
                if (aStackList.func_77973_b() == Item.func_150898_a((Block)Values.blockPlanks)) continue;
                newStackList.add(aStackList);
            }
            recipe[part] = newStackList;
        }
    }
}

