/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import com.google.common.base.Strings;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.RegistryHelper;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockCloudFancy;
import shetiphian.terraqueous.common.block.BlockClouds;
import shetiphian.terraqueous.common.block.BlockCrafting;
import shetiphian.terraqueous.common.block.BlockDoodad;
import shetiphian.terraqueous.common.block.BlockEarthOre;
import shetiphian.terraqueous.common.block.BlockEnderTable;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.block.BlockFlowers;
import shetiphian.terraqueous.common.block.BlockHay;
import shetiphian.terraqueous.common.block.BlockPergola;
import shetiphian.terraqueous.common.block.BlockPlanks;
import shetiphian.terraqueous.common.block.BlockPlants;
import shetiphian.terraqueous.common.block.BlockTallGrass;
import shetiphian.terraqueous.common.block.BlockTreeFoliage;
import shetiphian.terraqueous.common.block.BlockTreeFoliageCB;
import shetiphian.terraqueous.common.block.BlockTreeSapling;
import shetiphian.terraqueous.common.block.BlockTreeTrunk;
import shetiphian.terraqueous.common.block.BlockTypeCloud;
import shetiphian.terraqueous.common.block.BlockTypeEarth;
import shetiphian.terraqueous.common.entity.EntityCloudPainting;
import shetiphian.terraqueous.common.entity.EntityCoconut;
import shetiphian.terraqueous.common.entity.EntityEarthPainting;
import shetiphian.terraqueous.common.item.ItemBlockCloudFancy;
import shetiphian.terraqueous.common.item.ItemBlockClouds;
import shetiphian.terraqueous.common.item.ItemBlockCrafting;
import shetiphian.terraqueous.common.item.ItemBlockDoodad;
import shetiphian.terraqueous.common.item.ItemBlockEarthOre;
import shetiphian.terraqueous.common.item.ItemBlockEnderTable;
import shetiphian.terraqueous.common.item.ItemBlockFlowerPot;
import shetiphian.terraqueous.common.item.ItemBlockFlowers;
import shetiphian.terraqueous.common.item.ItemBlockHay;
import shetiphian.terraqueous.common.item.ItemBlockPergola;
import shetiphian.terraqueous.common.item.ItemBlockPlanks;
import shetiphian.terraqueous.common.item.ItemBlockPlants;
import shetiphian.terraqueous.common.item.ItemBlockSapling;
import shetiphian.terraqueous.common.item.ItemBlockTreeFoliage;
import shetiphian.terraqueous.common.item.ItemBlockTreeFoliageCB;
import shetiphian.terraqueous.common.item.ItemBlockTreeTrunk;
import shetiphian.terraqueous.common.item.ItemBlockType;
import shetiphian.terraqueous.common.item.ItemColorizer;
import shetiphian.terraqueous.common.item.ItemEquipable;
import shetiphian.terraqueous.common.item.ItemEquipableBauble;
import shetiphian.terraqueous.common.item.ItemHammer;
import shetiphian.terraqueous.common.item.ItemMain;
import shetiphian.terraqueous.common.item.ItemMultiFood;
import shetiphian.terraqueous.common.item.ItemMultiTool;
import shetiphian.terraqueous.common.item.ItemScythe;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;
import shetiphian.terraqueous.common.misc.FoodAction;
import shetiphian.terraqueous.common.misc.FoodData;
import shetiphian.terraqueous.common.tileentity.TileEntityCloudCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCloudFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftBench;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftFurnace;
import shetiphian.terraqueous.common.tileentity.TileEntityDoodad;
import shetiphian.terraqueous.common.tileentity.TileEntityEnderTable;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaFrame;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaGate;
import shetiphian.terraqueous.common.tileentity.TileEntityPergolaWall;
import shetiphian.terraqueous.common.tileentity.TileEntitySFController;
import shetiphian.terraqueous.common.tileentity.TileEntitySFStatic;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeColored;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeDoor;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyArch;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyEdge;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFence;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeGate;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeSlab;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeStairs;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeTrapdoor;
import shetiphian.terraqueous.common.worldgen.GenTrees;

public class Registry {
    void doRegistration() {
        this.registerBlocks();
        this.registerItems();
        this.registerSounds();
        this.setTabIcon();
        this.registerCustomItemStacks();
        this.registerOreDictionaryEntries();
    }

    private void registerBlocks() {
        if (Settings.INSTANCE.setup().addClouds) {
            Values.blockClouds = RegistryHelper.registerBlock((Block)new BlockClouds(), ItemBlockClouds.class, (String)"clouds", (String)"terraqueous.clouds", (Object[])new Object[0]);
            Values.blockCloudFancy = RegistryHelper.registerBlock((Block)new BlockCloudFancy(), ItemBlockCloudFancy.class, (String)"cloudfancy", (String)"terraqueous.cloudfancy", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityTypeFancyArch.class, (String)"terraqueous:cloudfancy.arch");
            RegistryHelper.registerTileEntity(TileEntityTypeFancyEdge.class, (String)"terraqueous:cloudfancy.edge");
        }
        if (Settings.INSTANCE.setup().addCraftables) {
            Values.blockTypeCloud = RegistryHelper.registerBlock((Block)new BlockTypeCloud(), ItemBlockType.class, (String)"type_cloud", (String)"terraqueous.typecloud", (Object[])new Object[0]);
            Values.blockTypeEarth = RegistryHelper.registerBlock((Block)new BlockTypeEarth(), ItemBlockType.class, (String)"type_earth", (String)"terraqueous.typeearth", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityTypeDoor.class, (String)"terraqueous:type.door");
            RegistryHelper.registerTileEntity(TileEntityTypeTrapdoor.class, (String)"terraqueous:type.trapdoor");
            RegistryHelper.registerTileEntity(TileEntityTypeGate.class, (String)"terraqueous:type.gate");
            RegistryHelper.registerTileEntity(TileEntityTypeFence.class, (String)"terraqueous:type.fence");
            RegistryHelper.registerTileEntity(TileEntityTypeStairs.class, (String)"terraqueous:type.stairs");
            RegistryHelper.registerTileEntity(TileEntityTypeSlab.class, (String)"terraqueous:type.slab");
            RegistryHelper.registerTileEntity(TileEntityTypeColored.class, (String)"terraqueous:type.colored");
        }
        if (Settings.INSTANCE.setup().addCrafting) {
            Values.blockCrafting = RegistryHelper.registerBlock((Block)new BlockCrafting(), ItemBlockCrafting.class, (String)"crafting", (String)"terraqueous.crafting", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityCloudFurnace.class, (String)"terraqueous:crafting.cloudfurnace");
            RegistryHelper.registerTileEntity(TileEntityCraftBench.class, (String)"terraqueous:crafting.craftbench");
            RegistryHelper.registerTileEntity(TileEntityCraftFurnace.class, (String)"terraqueous:crafting.craftfurnace");
            RegistryHelper.registerTileEntity(TileEntityCloudCraftFurnace.class, (String)"terraqueous:crafting.craftfurnace.cloud");
            RegistryHelper.registerTileEntity(TileEntitySFController.class, (String)"terraqueous:stormforge.controller");
            RegistryHelper.registerTileEntity(TileEntitySFStatic.class, (String)"terraqueous:stormforge.static");
        }
        if (Settings.INSTANCE.setup().addDoodads) {
            Values.blockDoodad = RegistryHelper.registerBlock((Block)new BlockDoodad(), ItemBlockDoodad.class, (String)"doodads", (String)"terraqueous.doodad", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityDoodad.class, (String)"terraqueous:doodad.doodad");
        }
        if (Settings.INSTANCE.setup().addEnderTable || Settings.INSTANCE.setup().addClouds) {
            Values.blockEnderTable = RegistryHelper.registerBlock((Block)new BlockEnderTable(), ItemBlockEnderTable.class, (String)"ender_table", (String)"terraqueous.endertable", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityEnderTable.class, (String)"terraqueous:endertable.table");
        }
        if (Settings.INSTANCE.setup().addFlowerPots) {
            Values.blockFlowerPot = RegistryHelper.registerBlock((Block)new BlockFlowerPot(), ItemBlockFlowerPot.class, (String)"flowerpot", (String)"terraqueous.flowerpot", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityFlowerPot.class, (String)"terraqueous:flowerpot.flowerpot");
        }
        if (Settings.INSTANCE.setup().addFlowers) {
            Values.blockFlowerCluster = RegistryHelper.registerBlock((Block)new BlockFlowers(), ItemBlockFlowers.class, (String)"flowers_cluster", (String)"terraqueous.flowercluster", (Object[])new Object[0]);
            Values.blockFlowerSingle = RegistryHelper.registerBlock((Block)new BlockFlowers(), ItemBlockFlowers.class, (String)"flowers_single", (String)"terraqueous.flowersingle", (Object[])new Object[0]);
        }
        if (Settings.INSTANCE.setup().addHay) {
            Values.blockHay = RegistryHelper.registerBlock((Block)new BlockHay(), ItemBlockHay.class, (String)"hay", (String)"terraqueous.hay", (Object[])new Object[0]);
        }
        if (Settings.INSTANCE.setup().addOres) {
            Values.blockEarthOre = RegistryHelper.registerBlock((Block)new BlockEarthOre(), ItemBlockEarthOre.class, (String)"earth_ore", (String)"terraqueous.earthore", (Object[])new Object[0]);
        }
        if (Settings.INSTANCE.setup().addPlants) {
            Values.blockPergola = RegistryHelper.registerBlock((Block)new BlockPergola(), ItemBlockPergola.class, (String)"pergola", (String)"terraqueous.pergola", (Object[])new Object[0]);
            Values.blockPlants = RegistryHelper.registerBlock((Block)new BlockPlants(), ItemBlockPlants.class, (String)"plants", (String)"terraqueous.plants", (Object[])new Object[0]);
            RegistryHelper.registerTileEntity(TileEntityPergolaFrame.class, (String)"terraqueous:pergola.frame");
            RegistryHelper.registerTileEntity(TileEntityPergolaWall.class, (String)"terraqueous:pergola.wall");
            RegistryHelper.registerTileEntity(TileEntityPergolaGate.class, (String)"terraqueous:pergola.gate");
        }
        if (Settings.INSTANCE.setup().addTrees) {
            Values.blockPlanks = RegistryHelper.registerBlock((Block)new BlockPlanks(), ItemBlockPlanks.class, (String)"planks", (String)"terraqueous.planks", (Object[])new Object[0]);
            Values.blockSapling = RegistryHelper.registerBlock((Block)new BlockTreeSapling(), ItemBlockSapling.class, (String)"sapling", (String)"terraqueous.sapling", (Object[])new Object[0]);
            Values.blockTreeTrunk1 = RegistryHelper.registerBlock((Block)new BlockTreeTrunk(0), ItemBlockTreeTrunk.class, (String)"trunk1", (String)"terraqueous.trunk", (Object[])new Object[]{0});
            Values.blockTreeTrunk2 = RegistryHelper.registerBlock((Block)new BlockTreeTrunk(1), ItemBlockTreeTrunk.class, (String)"trunk2", (String)"terraqueous.trunk", (Object[])new Object[]{1});
            Values.blockTreeFoliage1 = RegistryHelper.registerBlock((Block)new BlockTreeFoliage(0), ItemBlockTreeFoliage.class, (String)"foliage1", (String)"terraqueous.foliage", (Object[])new Object[]{0});
            Values.blockTreeFoliage2 = RegistryHelper.registerBlock((Block)new BlockTreeFoliage(1), ItemBlockTreeFoliage.class, (String)"foliage2", (String)"terraqueous.foliage", (Object[])new Object[]{1});
            Values.blockTreeFoliage3 = RegistryHelper.registerBlock((Block)new BlockTreeFoliage(2), ItemBlockTreeFoliage.class, (String)"foliage3", (String)"terraqueous.foliage", (Object[])new Object[]{2});
            Values.blockTreeFoliage4 = RegistryHelper.registerBlock((Block)new BlockTreeFoliage(3), ItemBlockTreeFoliage.class, (String)"foliage4", (String)"terraqueous.foliage", (Object[])new Object[]{3});
            Values.blockTreeFoliageCB = RegistryHelper.registerBlock((Block)new BlockTreeFoliageCB(), ItemBlockTreeFoliageCB.class, (String)"foliage5", (String)"terraqueous.foliage", (Object[])new Object[0]);
            GenTrees.setTreesActive();
        }
        if (Settings.INSTANCE.setup().enableGrassSpread) {
            Values.blockTallGrass = RegistryHelper.registerBlock((Block)new BlockTallGrass(), null, (String)"tall_grass", (String)"terraqueous.tallgrass", (Object[])new Object[0]);
        }
    }

    private void registerItems() {
        Values.itemMain = RegistryHelper.registerItem((Item)new ItemMain(), (String)"item_main", (String)"terraqueous.itemmain");
        EntityRegistry.registerModEntity(EntityEarthPainting.class, (String)"paintingearth", (int)0, (Object)Terraqueous.INSTANCE, (int)160, (int)Integer.MAX_VALUE, (boolean)false);
        EntityRegistry.registerModEntity(EntityCloudPainting.class, (String)"paintingcloud", (int)1, (Object)Terraqueous.INSTANCE, (int)160, (int)Integer.MAX_VALUE, (boolean)false);
        if (Settings.INSTANCE.setup().addClouds) {
            Values.itemCloudTalisman = RegistryHelper.registerItem((Item)new ItemEquipableBauble("CloudTalisman", EntityEquipmentSlot.CHEST), (String)"cloud_talisman", (String)"terraqueous.cloudtalisman");
        }
        if (Settings.INSTANCE.setup().addEnderTable) {
            Values.itemEnderMonocle = RegistryHelper.registerItem((Item)new ItemEquipable("EnderMonocle", EntityEquipmentSlot.HEAD), (String)"ender_monocle", (String)"terraqueous.endermonocle");
        }
        if (Settings.INSTANCE.setup().addFood) {
            ArrayList<FoodData> foodList = new ArrayList<FoodData>();
            foodList.add(new FoodData("cherry").setHealAmount(2).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("orange").setHealAmount(4).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("pear").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("peach").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("mango").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("lemon").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("plum").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("coconut").setHealAmount(5).setSaturationModifier(0.4f).setDietInfo(true, true, false, false, false).setDamage(Values.damageCoconut, 1.0f).setFoodUseAction(new FoodAction.FoodActionSpawnEntity(EntityCoconut.class)));
            foodList.add(new FoodData("banana").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("pineapple").setHealAmount(5).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false).setFoodUseAction(new FoodAction.FoodActionPlaceBlock(BlockPlants.EnumType.PINEAPPLE_SMALL.state(), new EnumFacing[0])));
            foodList.add(new FoodData("pricklypear").setHealAmount(3).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("grapes").setHealAmount(2).setSaturationModifier(0.3f).setDietInfo(true, true, false, false, false));
            foodList.add(new FoodData("lifefruit").setHealAmount(2).setSaturationModifier(0.0f).setDietInfo(true, true, true, true, false).setAlwaysEdible(true).setStackLimit(8).setFoodFinishAction(new FoodActionLifeFruit()));
            foodList.add(new FoodData("deathfruit").setHealAmount(0).setSaturationModifier(0.0f).setDietInfo(true, true, true, true, false).setAlwaysEdible(true).setStackLimit(8).setFoodFinishAction(new FoodActionDeathFruit()).setTooltip("info.terraqueous.deathfruit.txt"));
            Values.itemMultiFood = RegistryHelper.registerItem((Item)new ItemMultiFood(foodList), (String)"multifood", (String)"terraqueous.multifood");
            EntityRegistry.registerModEntity(EntityCoconut.class, (String)"coconut", (int)2, (Object)Terraqueous.INSTANCE, (int)160, (int)Integer.MAX_VALUE, (boolean)true);
        }
        if (Settings.INSTANCE.setup().addTools) {
            Values.itemColorizer = RegistryHelper.registerItem((Item)new ItemColorizer(), (String)"colorizer", (String)"terraqueous.colorizer");
            Values.itemHammer = RegistryHelper.registerItem((Item)new ItemHammer(), (String)"hammer", (String)"terraqueous.itemhammer");
            Values.itemMultiTool = RegistryHelper.registerItem((Item)new ItemMultiTool(), (String)"multitool", (String)"terraqueous.multitool");
            Values.itemScythe = RegistryHelper.registerItem((Item)new ItemScythe(), (String)"scythe", (String)"terraqueous.scythe");
        }
    }

    private void registerSounds() {
        Values.soundArc = RegistryHelper.registerSound((String)"terraqueous:arc");
        Values.soundSpark = RegistryHelper.registerSound((String)"terraqueous:spark");
        Values.soundHammer = RegistryHelper.registerSound((String)"terraqueous:hammer");
    }

    private void setTabIcon() {
        if (Values.itemMain != null) {
            Values.tabTerraqueous.setIcon(new ItemStack(Values.itemMain, 1, 477));
            return;
        }
        if (Values.blockFlowerSingle != null) {
            Values.tabTerraqueous.setIcon(new ItemStack(Values.blockFlowerSingle, 1, 4));
            return;
        }
        if (Values.blockPlants != null) {
            Values.tabTerraqueous.setIcon(new ItemStack(Values.blockPlants, 1, 5));
        }
    }

    private void registerCustomItemStacks() {
        if (Values.blockCloudFancy != null) {
            Values.stacks.put("cloud_column", this.iStack(Values.blockCloudFancy, 1));
            Values.stacks.put("cloud_capital", this.iStack(Values.blockCloudFancy, 3));
            Values.stacks.put("cloud_arch", this.iStack(Values.blockCloudFancy, 4));
            Values.stacks.put("cloud_edge", this.iStack(Values.blockCloudFancy, 5));
        }
        if (Values.blockClouds != null) {
            Values.stacks.put("lightcloud_block", this.iStack(Values.blockClouds, 0));
            Values.stacks.put("densecloud_block", this.iStack(Values.blockClouds, 1));
            Values.stacks.put("stormcloud_block", this.iStack(Values.blockClouds, 2));
            Values.stacks.put("kickable_lightcloud_block", this.iStack(Values.blockClouds, 8));
            Values.stacks.put("kickable_densecloud_block", this.iStack(Values.blockClouds, 9));
            Values.stacks.put("kickable_stormcloud_block", this.iStack(Values.blockClouds, 10));
        }
        if (Values.blockCrafting != null) {
            Values.stacks.put("cloud_workbench", this.iStack(Values.blockCrafting, 0));
            Values.stacks.put("cloud_furnace", this.iStack(Values.blockCrafting, 1));
            Values.stacks.put("cloud_craftbench", this.iStack(Values.blockCrafting, 2));
            Values.stacks.put("cloud_craftfurnace", this.iStack(Values.blockCrafting, 3));
            Values.stacks.put("craftbench", this.iStack(Values.blockCrafting, 5));
            Values.stacks.put("craftfurnace", this.iStack(Values.blockCrafting, 6));
        }
        if (Values.blockDoodad != null) {
            Values.stacks.put("glass_shards", this.iStack(Values.blockDoodad, 6));
        }
        if (Values.blockEarthOre != null) {
            Values.stacks.put("endimium_ore", this.iStack(Values.blockEarthOre, 0));
            Values.stacks.put("burnium_ore", this.iStack(Values.blockEarthOre, 1));
            Values.stacks.put("endimium_block", this.iStack(Values.blockEarthOre, 3));
            Values.stacks.put("burnium_block", this.iStack(Values.blockEarthOre, 4));
        }
        if (Values.blockFlowerPot != null) {
            Values.stacks.put("flowerpot", this.iStackColored(Values.blockFlowerPot, 0, RGB16Helper.getIndexFor((int)10, (int)5, (int)4)));
            Values.stacks.put("planterpot", this.iStackColored(Values.blockFlowerPot, 1, RGB16Helper.getIndexFor((int)10, (int)5, (int)4)));
        }
        if (Values.blockHay != null) {
            Values.stacks.put("hayblock", this.iStack(Values.blockHay, 0));
            Values.stacks.put("haypile_large", this.iStack(Values.blockHay, 1));
            Values.stacks.put("haypile", this.iStack(Values.blockHay, 2));
            Values.stacks.put("haypile_small", this.iStack(Values.blockHay, 3));
            Values.stacks.put("thresh", this.iStack(Values.blockHay, 4));
            Values.stacks.put("loosehay", this.iStack(Values.blockHay, 5));
        }
        if (Values.blockPergola != null) {
            Values.stacks.put("pergolatop", this.iStackColored(Values.blockPergola, 0, RGB16Helper.getIndexFor((String)"dyeWhite")));
            Values.stacks.put("pergolawall", this.iStackColored(Values.blockPergola, 7, RGB16Helper.getIndexFor((String)"dyeWhite")));
            Values.stacks.put("pergolagate", this.iStackColored(Values.blockPergola, 8, RGB16Helper.getIndexFor((String)"dyeWhite")));
        }
        if (Values.blockPlants != null) {
            Values.stacks.put("cactus", this.iStack(Values.blockPlants, 3));
            Values.stacks.put("cactus_large", this.iStack(Values.blockPlants, 4));
            Values.stacks.put("cactus_fruit", this.iStack(Values.blockPlants, 5));
        }
        if (GenTrees.treesActive) {
            Values.stacks.put("apple_sapling", this.iStack(Values.blockSapling, 0));
            Values.stacks.put("cherry_sapling", this.iStack(Values.blockSapling, 1));
            Values.stacks.put("orange_sapling", this.iStack(Values.blockSapling, 2));
            Values.stacks.put("pear_sapling", this.iStack(Values.blockSapling, 3));
            Values.stacks.put("peach_sapling", this.iStack(Values.blockSapling, 4));
            Values.stacks.put("mango_sapling", this.iStack(Values.blockSapling, 5));
            Values.stacks.put("lemon_sapling", this.iStack(Values.blockSapling, 6));
            Values.stacks.put("plum_sapling", this.iStack(Values.blockSapling, 7));
            Values.stacks.put("coconut_sapling", this.iStack(Values.blockSapling, 8));
            Values.stacks.put("banana_sapling", this.iStack(Values.blockSapling, 9));
            Values.stacks.put("apple_planks", this.iStack(Values.blockPlanks, 0));
            Values.stacks.put("cherry_planks", this.iStack(Values.blockPlanks, 1));
            Values.stacks.put("orange_planks", this.iStack(Values.blockPlanks, 2));
            Values.stacks.put("pear_planks", this.iStack(Values.blockPlanks, 3));
            Values.stacks.put("peach_planks", this.iStack(Values.blockPlanks, 4));
            Values.stacks.put("mango_planks", this.iStack(Values.blockPlanks, 5));
            Values.stacks.put("lemon_planks", this.iStack(Values.blockPlanks, 6));
            Values.stacks.put("plum_planks", this.iStack(Values.blockPlanks, 7));
            Values.stacks.put("coconut_planks", this.iStack(Values.blockPlanks, 8));
            Values.stacks.put("banana_planks", this.iStack(Values.blockPlanks, 9));
            Values.stacks.put("apple_log", this.iStack(Values.blockTreeTrunk1, 0));
            Values.stacks.put("cherry_log", this.iStack(Values.blockTreeTrunk1, 1));
            Values.stacks.put("orange_log", this.iStack(Values.blockTreeTrunk1, 2));
            Values.stacks.put("pear_log", this.iStack(Values.blockTreeTrunk1, 3));
            Values.stacks.put("peach_log", this.iStack(Values.blockTreeTrunk1, 4));
            Values.stacks.put("mango_log", this.iStack(Values.blockTreeTrunk2, 0));
            Values.stacks.put("lemon_log", this.iStack(Values.blockTreeTrunk2, 1));
            Values.stacks.put("plum_log", this.iStack(Values.blockTreeTrunk2, 2));
            Values.stacks.put("coconut_log", this.iStack(Values.blockTreeTrunk2, 3));
            Values.stacks.put("banana_log", this.iStack(Values.blockTreeTrunk2, 4));
            Values.stacks.put("apple_leaves", this.iStack(Values.blockTreeFoliage1, 0));
            Values.stacks.put("cherry_leaves", this.iStack(Values.blockTreeFoliage1, 4));
            Values.stacks.put("orange_leaves", this.iStack(Values.blockTreeFoliage2, 0));
            Values.stacks.put("pear_leaves", this.iStack(Values.blockTreeFoliage2, 4));
            Values.stacks.put("peach_leaves", this.iStack(Values.blockTreeFoliage3, 0));
            Values.stacks.put("mango_leaves", this.iStack(Values.blockTreeFoliage3, 4));
            Values.stacks.put("lemon_leaves", this.iStack(Values.blockTreeFoliage4, 0));
            Values.stacks.put("plum_leaves", this.iStack(Values.blockTreeFoliage4, 4));
            Values.stacks.put("coconut_leaves", this.iStack(Values.blockTreeFoliageCB, 0));
            Values.stacks.put("banana_leaves", this.iStack(Values.blockTreeFoliageCB, 4));
        }
        if (Values.blockTypeCloud != null) {
            Values.stacks.put("lightcloud_door", this.iStack(Values.blockTypeCloud, 0));
            Values.stacks.put("densecloud_door", this.iStack(Values.blockTypeCloud, 1));
            Values.stacks.put("stormcloud_door", this.iStack(Values.blockTypeCloud, 2));
            Values.stacks.put("lightcloud_trapdoor", this.iStack(Values.blockTypeCloud, 10));
            Values.stacks.put("densecloud_trapdoor", this.iStack(Values.blockTypeCloud, 11));
            Values.stacks.put("stormcloud_trapdoor", this.iStack(Values.blockTypeCloud, 12));
            Values.stacks.put("lightcloud_gate", this.iStack(Values.blockTypeCloud, 20));
            Values.stacks.put("densecloud_gate", this.iStack(Values.blockTypeCloud, 21));
            Values.stacks.put("stormcloud_gate", this.iStack(Values.blockTypeCloud, 22));
            Values.stacks.put("lightcloud_wall", this.iStack(Values.blockTypeCloud, 30));
            Values.stacks.put("densecloud_wall", this.iStack(Values.blockTypeCloud, 31));
            Values.stacks.put("stormcloud_wall", this.iStack(Values.blockTypeCloud, 32));
            Values.stacks.put("lightcloud_stairs", this.iStack(Values.blockTypeCloud, 40));
            Values.stacks.put("densecloud_stairs", this.iStack(Values.blockTypeCloud, 41));
            Values.stacks.put("stormcloud_stairs", this.iStack(Values.blockTypeCloud, 42));
            Values.stacks.put("lightcloud_slab", this.iStack(Values.blockTypeCloud, 50));
            Values.stacks.put("densecloud_slab", this.iStack(Values.blockTypeCloud, 51));
            Values.stacks.put("stormcloud_slab", this.iStack(Values.blockTypeCloud, 52));
            Values.stacks.put("water_vapor", this.iStackColored(Values.blockTypeCloud, 110, RGB16Helper.getIndexFor((String)"dyeBlue")));
            Values.stacks.put("glow_vapor", this.iStackColored(Values.blockTypeCloud, 120, RGB16Helper.getIndexFor((String)"dyeBlue")));
        }
        if (Values.blockTypeEarth != null) {
            Values.stacks.put("applewood_door", this.iStack(Values.blockTypeEarth, 0));
            Values.stacks.put("cherrywood_door", this.iStack(Values.blockTypeEarth, 1));
            Values.stacks.put("orangewood_door", this.iStack(Values.blockTypeEarth, 2));
            Values.stacks.put("pearwood_door", this.iStack(Values.blockTypeEarth, 3));
            Values.stacks.put("peachwood_door", this.iStack(Values.blockTypeEarth, 4));
            Values.stacks.put("mangowood_door", this.iStack(Values.blockTypeEarth, 5));
            Values.stacks.put("lemonwood_door", this.iStack(Values.blockTypeEarth, 6));
            Values.stacks.put("plumwood_door", this.iStack(Values.blockTypeEarth, 7));
            Values.stacks.put("coconutwood_door", this.iStack(Values.blockTypeEarth, 8));
            Values.stacks.put("bananawood_door", this.iStack(Values.blockTypeEarth, 9));
            Values.stacks.put("applewood_trapdoor", this.iStack(Values.blockTypeEarth, 10));
            Values.stacks.put("cherrywood_trapdoor", this.iStack(Values.blockTypeEarth, 11));
            Values.stacks.put("orangewood_trapdoor", this.iStack(Values.blockTypeEarth, 12));
            Values.stacks.put("pearwood_trapdoor", this.iStack(Values.blockTypeEarth, 13));
            Values.stacks.put("peachwood_trapdoor", this.iStack(Values.blockTypeEarth, 14));
            Values.stacks.put("mangowood_trapdoor", this.iStack(Values.blockTypeEarth, 15));
            Values.stacks.put("lemonwood_trapdoor", this.iStack(Values.blockTypeEarth, 16));
            Values.stacks.put("plumwood_trapdoor", this.iStack(Values.blockTypeEarth, 17));
            Values.stacks.put("coconutwood_trapdoor", this.iStack(Values.blockTypeEarth, 18));
            Values.stacks.put("bananawood_trapdoor", this.iStack(Values.blockTypeEarth, 19));
            Values.stacks.put("applewood_gate", this.iStack(Values.blockTypeEarth, 20));
            Values.stacks.put("cherrywood_gate", this.iStack(Values.blockTypeEarth, 21));
            Values.stacks.put("orangewood_gate", this.iStack(Values.blockTypeEarth, 22));
            Values.stacks.put("pearwood_gate", this.iStack(Values.blockTypeEarth, 23));
            Values.stacks.put("peachwood_gate", this.iStack(Values.blockTypeEarth, 24));
            Values.stacks.put("mangowood_gate", this.iStack(Values.blockTypeEarth, 25));
            Values.stacks.put("lemonwood_gate", this.iStack(Values.blockTypeEarth, 26));
            Values.stacks.put("plumwood_gate", this.iStack(Values.blockTypeEarth, 27));
            Values.stacks.put("coconutwood_gate", this.iStack(Values.blockTypeEarth, 28));
            Values.stacks.put("bananawood_gate", this.iStack(Values.blockTypeEarth, 29));
            Values.stacks.put("applewood_fence", this.iStack(Values.blockTypeEarth, 30));
            Values.stacks.put("cherrywood_fence", this.iStack(Values.blockTypeEarth, 31));
            Values.stacks.put("orangewood_fence", this.iStack(Values.blockTypeEarth, 32));
            Values.stacks.put("pearwood_fence", this.iStack(Values.blockTypeEarth, 33));
            Values.stacks.put("peachwood_fence", this.iStack(Values.blockTypeEarth, 34));
            Values.stacks.put("mangowood_fence", this.iStack(Values.blockTypeEarth, 35));
            Values.stacks.put("lemonwood_fence", this.iStack(Values.blockTypeEarth, 36));
            Values.stacks.put("plumwood_fence", this.iStack(Values.blockTypeEarth, 37));
            Values.stacks.put("coconutwood_fence", this.iStack(Values.blockTypeEarth, 38));
            Values.stacks.put("bananawood_fence", this.iStack(Values.blockTypeEarth, 39));
            Values.stacks.put("applewood_stairs", this.iStack(Values.blockTypeEarth, 40));
            Values.stacks.put("cherrywood_stairs", this.iStack(Values.blockTypeEarth, 41));
            Values.stacks.put("orangewood_stairs", this.iStack(Values.blockTypeEarth, 42));
            Values.stacks.put("pearwood_stairs", this.iStack(Values.blockTypeEarth, 43));
            Values.stacks.put("peachwood_stairs", this.iStack(Values.blockTypeEarth, 44));
            Values.stacks.put("mangowood_stairs", this.iStack(Values.blockTypeEarth, 45));
            Values.stacks.put("lemonwood_stairs", this.iStack(Values.blockTypeEarth, 46));
            Values.stacks.put("plumwood_stairs", this.iStack(Values.blockTypeEarth, 47));
            Values.stacks.put("coconutwood_stairs", this.iStack(Values.blockTypeEarth, 48));
            Values.stacks.put("bananawood_stairs", this.iStack(Values.blockTypeEarth, 49));
            Values.stacks.put("applewood_slab", this.iStack(Values.blockTypeEarth, 50));
            Values.stacks.put("cherrywood_slab", this.iStack(Values.blockTypeEarth, 51));
            Values.stacks.put("orangewood_slab", this.iStack(Values.blockTypeEarth, 52));
            Values.stacks.put("pearwood_slab", this.iStack(Values.blockTypeEarth, 53));
            Values.stacks.put("peachwood_slab", this.iStack(Values.blockTypeEarth, 54));
            Values.stacks.put("mangowood_slab", this.iStack(Values.blockTypeEarth, 55));
            Values.stacks.put("lemonwood_slab", this.iStack(Values.blockTypeEarth, 56));
            Values.stacks.put("plumwood_slab", this.iStack(Values.blockTypeEarth, 57));
            Values.stacks.put("coconutwood_slab", this.iStack(Values.blockTypeEarth, 58));
            Values.stacks.put("bananawood_slab", this.iStack(Values.blockTypeEarth, 59));
            Values.stacks.put("paper_block", this.iStackColored(Values.blockTypeEarth, 110, RGB16Helper.getIndexFor((String)"dyeWhite")));
            Values.stacks.put("glow_paper", this.iStackColored(Values.blockTypeEarth, 120, RGB16Helper.getIndexFor((String)"dyeWhite")));
        }
        if (Values.itemColorizer != null) {
            Values.stacks.put("colorizer", this.iStack(Values.itemColorizer, 0));
            Values.stacks.put("colorizer_empty", this.iStack(Values.itemColorizer, 255));
        }
        if (Values.itemHammer != null) {
            Values.stacks.put("hammer", this.iStack(Values.itemHammer, 0));
        }
        if (Values.itemMultiFood != null) {
            Values.stacks.put("cherry", this.iStack(Values.itemMultiFood, 0));
            Values.stacks.put("orange", this.iStack(Values.itemMultiFood, 1));
            Values.stacks.put("pear", this.iStack(Values.itemMultiFood, 2));
            Values.stacks.put("peach", this.iStack(Values.itemMultiFood, 3));
            Values.stacks.put("mango", this.iStack(Values.itemMultiFood, 4));
            Values.stacks.put("lemon", this.iStack(Values.itemMultiFood, 5));
            Values.stacks.put("plum", this.iStack(Values.itemMultiFood, 6));
            Values.stacks.put("coconut", this.iStack(Values.itemMultiFood, 7));
            Values.stacks.put("banana", this.iStack(Values.itemMultiFood, 8));
            Values.stacks.put("pineapple", this.iStack(Values.itemMultiFood, 9));
            Values.stacks.put("pricklypear", this.iStack(Values.itemMultiFood, 10));
            Values.stacks.put("grapes", this.iStack(Values.itemMultiFood, 11));
            Values.stacks.put("lifefruit", this.iStack(Values.itemMultiFood, 12));
            Values.stacks.put("deathfruit", this.iStack(Values.itemMultiFood, 13));
        }
        if (Values.itemMultiTool != null) {
            Values.stacks.put("multitool", ItemMultiTool.newTool(ItemMultiTool.EnumType.PICKAXE));
        }
        if (Values.itemScythe != null) {
            Values.stacks.put("scythe", ItemScythe.newScythe(false));
            Values.stacks.put("sickle", ItemScythe.newScythe(true));
        }
        Values.stacks.put("paintbrush", this.iStack(Values.itemMain, 0));
        Values.stacks.put("painting_cloud", this.iStack(Values.itemMain, 1));
        Values.stacks.put("painting", this.iStack(Values.itemMain, 2));
        Values.stacks.put("talisman_unbaked", this.iStack(Values.itemMain, 3));
        Values.stacks.put("talisman_baked", this.iStack(Values.itemMain, 4));
        Values.stacks.put("talisman_assembled", this.iStack(Values.itemMain, 5));
        Values.stacks.put("burnium_gem", this.iStack(Values.itemMain, 50));
        Values.stacks.put("endimium_gem", this.iStack(Values.itemMain, 51));
        Values.stacks.put("leather_scraps", this.iStack(Values.itemMain, 100));
        Values.stacks.put("leather_boot1", this.iStack(Values.itemMain, 101));
        Values.stacks.put("leather_boot2", this.iStack(Values.itemMain, 102));
        Values.stacks.put("leather_belt", this.iStack(Values.itemMain, 103));
        Values.stacks.put("dye_black", this.iStack(Values.itemMain, 104));
        Values.stacks.put("dye_brown", this.iStack(Values.itemMain, 105));
        Values.stacks.put("dye_blue", this.iStack(Values.itemMain, 106));
        Values.stacks.put("dye_white", this.iStack(Values.itemMain, 107));
        Values.stacks.put("glass_shard", this.iStack(Values.itemMain, 108));
        Values.stacks.put("ender_book", this.iStack(Values.itemMain, 109));
        Values.stacks.put("ender_tinydust", this.iStack(Values.itemMain, 200));
        Values.stacks.put("ender_dust", this.iStack(Values.itemMain, 201));
        Values.stacks.put("iron_tinydust", this.iStack(Values.itemMain, 202));
        Values.stacks.put("iron_dust", this.iStack(Values.itemMain, 203));
        Values.stacks.put("gold_tinydust", this.iStack(Values.itemMain, 204));
        Values.stacks.put("gold_dust", this.iStack(Values.itemMain, 205));
        Values.stacks.put("coal_tinydust", this.iStack(Values.itemMain, 206));
        Values.stacks.put("coal_dust", this.iStack(Values.itemMain, 207));
        Values.stacks.put("diamond_tinydust", this.iStack(Values.itemMain, 208));
        Values.stacks.put("diamond_dust", this.iStack(Values.itemMain, 209));
        Values.stacks.put("emerald_tinydust", this.iStack(Values.itemMain, 210));
        Values.stacks.put("emerald_dust", this.iStack(Values.itemMain, 211));
        Values.stacks.put("lapis_tinydust", this.iStack(Values.itemMain, 212));
        Values.stacks.put("redstone_tinydust", this.iStack(Values.itemMain, 213));
        Values.stacks.put("sandstone_lump", this.iStack(Values.itemMain, 214));
        Values.stacks.put("gravel_lump", this.iStack(Values.itemMain, 215));
        Values.stacks.put("redsandstone_lump", this.iStack(Values.itemMain, 216));
        Values.stacks.put("burnium_tinydust", this.iStack(Values.itemMain, 250));
        Values.stacks.put("burnium_dust", this.iStack(Values.itemMain, 251));
        Values.stacks.put("endimium_tinydust", this.iStack(Values.itemMain, 252));
        Values.stacks.put("endimium_dust", this.iStack(Values.itemMain, 253));
        Values.stacks.put("scroll_strange", this.iStack(Values.itemMain, 477));
        Values.stacks.put("turtle_colorizer", this.iStack(Values.itemMain, 1000));
        Values.stacks.put("turtle_colorizer_right", this.iStack(Values.itemMain, 1001));
        Values.stacks.put("robot_colorizer", this.iStack(Values.itemMain, 1002));
    }

    private void registerOreDictionaryEntries() {
        if (Values.blockEarthOre != null) {
            this.registerToOreDictionary("oreEndimium", "endimium_ore");
            this.registerToOreDictionary("oreBurnium", "burnium_ore");
            this.registerToOreDictionary("blockEndimium", "endimium_block");
            this.registerToOreDictionary("blockBurnium", "burnium_block");
        }
        if (GenTrees.treesActive) {
            this.registerToOreDictionary("treeSapling", new ItemStack(Values.blockSapling, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("plankWood", new ItemStack(Values.blockPlanks, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("logWood", new ItemStack(Values.blockTreeTrunk1, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("logWood", new ItemStack(Values.blockTreeTrunk2, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage1, 1, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage2, 2, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage3, 3, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliage4, 4, Short.MAX_VALUE));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 0));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 1));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 8));
            this.registerToOreDictionary("treeLeaves", new ItemStack(Values.blockTreeFoliageCB, 5, 9));
        }
        if (Values.blockTypeEarth != null) {
            for (PlantAPI.TreeType tree : PlantAPI.TreeType.values()) {
                String name = tree.toString();
                this.registerToOreDictionary("doorWood", name + "wood_door");
                this.registerToOreDictionary("trapdoorWood", name + "wood_trapdoor");
                this.registerToOreDictionary("gateWood", name + "wood_gate");
                this.registerToOreDictionary("fenceWood", name + "wood_fence");
                this.registerToOreDictionary("stairWood", name + "wood_stairs");
                this.registerToOreDictionary("slabWood", name + "wood_slab");
            }
        }
        if (Values.itemMultiFood != null) {
            this.registerToOreDictionary("cropCherry", "cherry");
            this.registerToOreDictionary("cropOrange", "orange");
            this.registerToOreDictionary("cropPear", "pear");
            this.registerToOreDictionary("cropPeach", "peach");
            this.registerToOreDictionary("cropMango", "mango");
            this.registerToOreDictionary("cropLemon", "lemon");
            this.registerToOreDictionary("cropPlum", "plum");
            this.registerToOreDictionary("cropCoconut", "coconut");
            this.registerToOreDictionary("cropBanana", "banana");
            this.registerToOreDictionary("cropPineapple", "pineapple");
            this.registerToOreDictionary("cropPricklyPear", "pricklypear");
            this.registerToOreDictionary("cropGrapes", "grapes");
            this.registerToOreDictionary("cropLifeFruit", "lifefruit");
            this.registerToOreDictionary("cropDeathFruit", "deathfruit");
            this.registerToOreDictionary("cropPear", "pricklypear");
            this.registerToOreDictionary("cropGrape", "grapes");
            this.registerToOreDictionary("listAllCitrus", "orange");
            this.registerToOreDictionary("listAllCitrus", "lemon");
            this.registerToOreDictionary("listAllfruit", "cherry");
            this.registerToOreDictionary("listAllfruit", "orange");
            this.registerToOreDictionary("listAllfruit", "pear");
            this.registerToOreDictionary("listAllfruit", "peach");
            this.registerToOreDictionary("listAllfruit", "mango");
            this.registerToOreDictionary("listAllfruit", "lemon");
            this.registerToOreDictionary("listAllfruit", "plum");
            this.registerToOreDictionary("listAllfruit", "banana");
            this.registerToOreDictionary("listAllfruit", "pineapple");
            this.registerToOreDictionary("listAllfruit", "pricklypear");
            this.registerToOreDictionary("listAllfruit", "grapes");
        }
        this.registerToOreDictionary("gemEndimium", "endimium_gem");
        this.registerToOreDictionary("gemBurnium", "burnium_gem");
        this.registerToOreDictionary("dyeBlack", "dye_black");
        this.registerToOreDictionary("dyeBrown", "dye_brown");
        this.registerToOreDictionary("dyeBlue", "dye_blue");
        this.registerToOreDictionary("dyeWhite", "dye_white");
        this.registerToOreDictionary("dye", "dye_black");
        this.registerToOreDictionary("dye", "dye_brown");
        this.registerToOreDictionary("dye", "dye_blue");
        this.registerToOreDictionary("dye", "dye_white");
        this.registerToOreDictionary("dustTinyBurnium", "burnium_tinydust");
        this.registerToOreDictionary("dustBurnium", "burnium_dust");
        this.registerToOreDictionary("dustTinyEndimium", "endimium_tinydust");
        this.registerToOreDictionary("dustEndimium", "endimium_dust");
        this.registerToOreDictionary("dustTinyEnder", "ender_tinydust");
        this.registerToOreDictionary("dustEnder", "ender_dust");
        this.registerToOreDictionary("dustTinyIron", "iron_tinydust");
        this.registerToOreDictionary("dustIron", "iron_dust");
        this.registerToOreDictionary("dustTinyGold", "gold_tinydust");
        this.registerToOreDictionary("dustGold", "gold_dust");
        this.registerToOreDictionary("dustTinyCoal", "coal_tinydust");
        this.registerToOreDictionary("dustCoal", "coal_dust");
        this.registerToOreDictionary("dustTinyDiamond", "diamond_tinydust");
        this.registerToOreDictionary("dustDiamond", "diamond_dust");
        this.registerToOreDictionary("dustTinyEmerald", "emerald_tinydust");
        this.registerToOreDictionary("dustEmerald", "emerald_dust");
        this.registerToOreDictionary("dustTinyLapis", "lapis_tinydust");
        this.registerToOreDictionary("dustTinyRedstone", "redstone_tinydust");
        this.registerToOreDictionary("lumpSandstone", "sandstone_lump");
        this.registerToOreDictionary("lumpGravel", "gravel_lump");
        this.registerToOreDictionary("lumpRedSandstone", "redsandstone_lump");
    }

    private void registerToOreDictionary(String oreName, String stackName) {
        if (Strings.isNullOrEmpty((String)oreName) || Strings.isNullOrEmpty((String)stackName)) {
            return;
        }
        ItemStack stack = Values.stacks.get(stackName, new int[0]);
        this.registerToOreDictionary(oreName, stack);
    }

    private void registerToOreDictionary(String oreName, ItemStack stack) {
        if (Strings.isNullOrEmpty((String)oreName)) {
            return;
        }
        if (stack == null || stack.func_77973_b() == null || stack.field_77994_a < 1) {
            return;
        }
        OreDictionary.registerOre((String)oreName, (ItemStack)stack);
    }

    private ItemStack iStack(Item item, int metadata) {
        return new ItemStack(item, 1, metadata);
    }

    private ItemStack iStackColored(Block block, int metadata, short rgbIndex) {
        ItemStack stack = this.iStack(block, metadata);
        if (stack.func_77973_b() instanceof IRGB16_Item) {
            ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, rgbIndex);
        }
        return stack;
    }

    private ItemStack iStack(Block block, int metadata) {
        return new ItemStack(block, 1, metadata);
    }

    private class FoodActionDeathFruit
    extends FoodAction {
        private FoodActionDeathFruit() {
        }

        @Override
        public ItemStack doFinishAction(ItemStack stack, World world, EntityPlayer player) {
            DeathFruitHelper.INSTANCE.onPlayerEat(player);
            return stack;
        }
    }

    private class FoodActionLifeFruit
    extends FoodAction {
        private FoodActionLifeFruit() {
        }

        @Override
        public ItemStack doFinishAction(ItemStack stack, World world, EntityPlayer player) {
            if (player != null) {
                IAttributeInstance attribute = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
                float health = player.func_110143_aJ();
                if ((double)health < attribute.func_111126_e()) {
                    player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:instant_health"), 1, 0, false, false));
                } else {
                    attribute.func_111128_a(SharedMonsterAttributes.field_111267_a.func_111109_a(attribute.func_111126_e() + 2.0));
                }
                player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:regeneration"), 900, 0, false, false));
            }
            return stack;
        }
    }
}

