/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous;

import net.minecraft.command.ICommand;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import shetiphian.core.common.FuelHelper;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.terraqueous.Recipes;
import shetiphian.terraqueous.Registry;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.command.StormForgeCommand;
import shetiphian.terraqueous.common.misc.DeathFruitHelper;
import shetiphian.terraqueous.common.misc.ProxyCommon;
import shetiphian.terraqueous.common.network.NetworkHandler;
import shetiphian.terraqueous.common.worldgen.GenClouds;
import shetiphian.terraqueous.common.worldgen.GenDoodads;
import shetiphian.terraqueous.common.worldgen.GenFlowers;
import shetiphian.terraqueous.common.worldgen.GenPlants;
import shetiphian.terraqueous.common.worldgen.GenTrees;
import shetiphian.terraqueous.common.worldgen.VillageHandler_Vineyard;
import shetiphian.terraqueous.modintegration.ModIntegration;

@Mod(modid="terraqueous", name="Terraqueous", version="1.2.12", dependencies="required-after:shetiphiancore@[3.3.6,)", guiFactory="shetiphian.terraqueous.client.misc.ConfigGUIHandler", updateJSON="https://gist.githubusercontent.com/ShetiPhian/8f54131fc6436c8c85a5/raw/Terraqueous", acceptedMinecraftVersions="[1.10.2]")
public class Terraqueous {
    @SidedProxy(clientSide="shetiphian.terraqueous.client.misc.ProxyClient", serverSide="shetiphian.terraqueous.common.misc.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="terraqueous")
    public static Terraqueous INSTANCE;
    public static final String MOD_ID = "terraqueous";

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Values.logTerraqueous = event.getModLog();
        Values.tabTerraqueous = new MyCreativeTab("Terraqueous", MyCreativeTab.MyTabType.SEARCH_L);
        proxy.setupConfig(event.getSuggestedConfigurationFile());
        new Registry().doRegistration();
        GameRegistry.registerFuelHandler((IFuelHandler)FuelHelper.INSTANCE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenClouds(), (int)10);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenDoodads(), (int)3);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenFlowers(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenPlants(), (int)1);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GenTrees(), (int)2);
        proxy.renderingPreInt();
        DeathFruitHelper.INSTANCE.register();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkHandler.initialise();
        proxy.renderingInt();
        proxy.registerEventHandlers();
        new Recipes().loadRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new VillageHandler_Vineyard());
        new ModIntegration().load();
        Settings.INSTANCE.setup = null;
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new StormForgeCommand());
    }

    @Mod.EventHandler
    public void fmlInterModComms(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            try {
                if (msg.isStringMessage()) {
                    String regex = "~NOT-SET~";
                    if (msg.key.equals("addCloudBlock")) {
                        regex = "[^:, ]*:[^:, ]*,[0-9]*-[0-9]*,\\?(true|false)";
                        if (msg.getStringValue().matches(regex)) {
                            String[] data = msg.getStringValue().split(",");
                            String[] numbers = data[1].split("-");
                            CloudAPI.addCloudBlock(data[0], (int)Integer.getInteger(numbers[0]), (int)Integer.getInteger(numbers[1]), Boolean.parseBoolean(data[2].replace("?", "")));
                            continue;
                        }
                    }
                    if (!regex.equals("~NOT-SET~")) {
                        Values.logTerraqueous.error(String.format("Received an invalid %s IMC: %s from mod %s. Regex Check Failure: %s", msg.key, msg.getStringValue(), msg.getSender(), regex));
                        continue;
                    }
                }
                Values.logTerraqueous.error(String.format("Received an unknown IMC: %s from mod %s.", msg.key, msg.getSender()));
            }
            catch (Exception e) {
                if (msg.isStringMessage()) {
                    Values.logTerraqueous.error(String.format("Received an invalid %s IMC: %s from mod %s", msg.key, msg.getStringValue(), msg.getSender()));
                    continue;
                }
                Values.logTerraqueous.error(String.format("Received an invalid %s IMC from mod %s", msg.key, msg.getSender()));
            }
        }
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        Values.logTerraqueous.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    public static ItemStack getCustomItemStack(String name, int ... amount) {
        ItemStack stack = Values.stacks.get(name, amount);
        if (stack == null) {
            Values.logTerraqueous.error("Could not find " + name + " in stack map");
            return null;
        }
        return stack;
    }
}

