/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.cloud;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shetiphian.terraqueous.api.cloud.CloudAPI_Client;
import shetiphian.terraqueous.api.cloud.ICloud;
import shetiphian.terraqueous.api.cloud.MaterialCloud;

public class CloudAPI {
    public static final PropertyEnum<CloudType> VARIANT = PropertyEnum.func_177709_a((String)"cloudvariant", CloudType.class);
    public static final PropertyBool KICKABLE = PropertyBool.func_177716_a((String)"generated");
    public static final Material materialCloud = new MaterialCloud();
    public static SoundType soundTypeCloud = new SoundType(1.0f, -5.0f, SoundEvents.field_187807_fF, SoundEvents.field_187815_fJ, SoundEvents.field_187813_fI, SoundEvents.field_187811_fH, SoundEvents.field_187809_fG);
    private static final Map<String, List<Pair<Byte, Boolean>>> mapCloudBlock = new HashMap<String, List<Pair<Byte, Boolean>>>();
    private static final HashSet<Pair<UUID, String>> listCloudWalk = new HashSet();
    protected static Logger logCloud = LogManager.getLogger((String)"Terraqueous|CloudAPI");

    public static void addCloudBlock(Block block, int lowestMeta, int highestMeta, boolean punchable) {
        if (block != null) {
            CloudAPI.addCloudBlock(GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)block).toString(), lowestMeta, highestMeta, punchable);
        }
    }

    public static void addCloudBlock(String key, int lowestMeta, int highestMeta, boolean punchable) {
        if (Strings.isNullOrEmpty((String)key)) {
            return;
        }
        if (lowestMeta > highestMeta) {
            int temp = lowestMeta;
            lowestMeta = highestMeta;
            highestMeta = temp;
        }
        List<Object> list = mapCloudBlock.containsKey(key) ? mapCloudBlock.get(key) : new ArrayList();
        for (int meta = lowestMeta; meta <= highestMeta; ++meta) {
            list.add(Pair.of((Object)((byte)meta), (Object)punchable));
        }
    }

    public static void grantCloudWalk(EntityPlayer player, String source) {
        if (player != null && !Strings.isNullOrEmpty((String)source)) {
            listCloudWalk.add((Pair<UUID, String>)Pair.of((Object)player.func_110124_au(), (Object)source.toLowerCase().trim()));
        }
    }

    public static void revokeCloudWalk(EntityPlayer player, String source) {
        if (player != null && !Strings.isNullOrEmpty((String)source)) {
            listCloudWalk.remove(Pair.of((Object)player.func_110124_au(), (Object)source.toLowerCase().trim()));
        }
    }

    public static boolean hasCloudWalk(EntityPlayer player) {
        if (player != null) {
            for (Pair<UUID, String> pair : listCloudWalk) {
                if (pair.getKey() != player.func_110124_au()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean entityCanBeOnClouds() {
        return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && CloudAPI_Client.entityCanBeOnClouds();
    }

    public static boolean entityCanBeOnClouds(EntityPlayer player) {
        return player != null && (player.field_71075_bZ.field_75098_d || player.field_71075_bZ.field_75101_c || CloudAPI.hasCloudWalk(player));
    }

    public static boolean isCloud(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() instanceof ICloud) {
            return ((ICloud)state.func_177230_c()).isCloudBlock(state, world, pos);
        }
        return CloudAPI.isCloud(state, state.func_177230_c().func_176201_c(state));
    }

    public static boolean isCloud(IBlockState state, int metadata) {
        if (state.func_177230_c().func_149688_o(state) instanceof MaterialCloud) {
            return true;
        }
        ResourceLocation id = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)state.func_177230_c());
        if (id != null && mapCloudBlock.containsKey(id)) {
            for (Pair<Byte, Boolean> entry : mapCloudBlock.get(id)) {
                if ((Byte)entry.getKey() != metadata) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canBlockTouchClouds(IBlockState state, World world, BlockPos pos) {
        return world.func_175623_d(pos) || state.func_177230_c().func_149688_o(state).func_76222_j() || CloudAPI.isCloud(state, (IBlockAccess)world, pos);
    }

    public static boolean isCloudKickable(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() instanceof ICloud) {
            return ((ICloud)state.func_177230_c()).isCloudKickable(state, world, pos);
        }
        boolean kickable = false;
        try {
            kickable = (Boolean)state.func_177229_b((IProperty)KICKABLE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return kickable || CloudAPI.isCloudKickable(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public static boolean isCloudKickable(Block block, int metadata) {
        ResourceLocation id = GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)block);
        if (id != null && mapCloudBlock.containsKey(id)) {
            for (Pair<Byte, Boolean> entry : mapCloudBlock.get(id)) {
                if ((Byte)entry.getKey() != metadata || !((Boolean)entry.getValue()).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getKickable(IBlockState state) {
        boolean kickable;
        try {
            kickable = (Boolean)state.func_177229_b((IProperty)KICKABLE);
        }
        catch (Exception e) {
            kickable = false;
            CloudAPI.errorPropertyNotFound("CloudAPI.KICKABLE", "FALSE", state.toString());
        }
        return kickable;
    }

    public static CloudType getCloudType(IBlockState state) {
        CloudType type;
        try {
            type = (CloudType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = CloudType.LIGHT;
            CloudAPI.errorPropertyNotFound("CloudAPI.VARIANT", "LIGHT", state.toString());
        }
        return type;
    }

    public static void errorPropertyNotFound(String property, String returning, String state) {
        logCloud.error("PropertyEnum '" + property + "' not found in provided BlockState, returning '" + returning + "'. Provided BlockState: " + state);
    }

    public static enum CloudType implements IStringSerializable
    {
        LIGHT(0),
        DENSE(1),
        STORM(2);

        private static final CloudType[] array;
        private final byte id;

        private CloudType(int id) {
            this.id = (byte)id;
        }

        public byte getID() {
            return this.id;
        }

        public static CloudType byID(int id) {
            return array[MathHelper.func_76125_a((int)id, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new CloudType[]{LIGHT, DENSE, STORM};
        }
    }
}

