/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.api.machines;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;

public class EnderTableRecipeHandler {
    public static final EnderTableRecipeHandler INSTANCE = new EnderTableRecipeHandler();
    private List<IEnderTableRecipe> tableRecipes = new ArrayList<IEnderTableRecipe>();

    public void addEnderTableRecipe(IEnderTableRecipe recipe) {
        this.tableRecipes.add(recipe);
    }

    public void removeEnderTableRecipe(IEnderTableRecipe recipe) {
        if (this.tableRecipes.contains(recipe)) {
            this.tableRecipes.remove(recipe);
        }
    }

    public List<IEnderTableRecipe> getTableRecipes() {
        return ImmutableList.copyOf(this.tableRecipes);
    }

    public boolean hasEnchantAnyResult(ItemStack enchantStack, ItemStack materialStack, float enchantPower, World world) {
        return this.hasEnchantResult(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.FIRST, world) || this.hasEnchantResult(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.SECOND, world) || this.hasEnchantResult(enchantStack, materialStack, enchantPower, IEnderTableRecipe.EnumOption.THIRD, world);
    }

    public boolean hasEnchantResult(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        return this.getEnchantResult(enchantStack, materialStack, enchantPower, option, world) != null;
    }

    public ItemStack getEnchantResult(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        IEnderTableRecipe recipe = this.getRecipe(enchantStack, materialStack, enchantPower, option, world);
        return recipe == null ? null : recipe.getResult(enchantStack, materialStack, option);
    }

    public int getExpCost(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        IEnderTableRecipe recipe = this.getRecipe(enchantStack, materialStack, enchantPower, option, world);
        return recipe == null ? 0 : recipe.getExpCost(enchantStack, materialStack, option);
    }

    public int getMaterialCost(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        IEnderTableRecipe recipe = this.getRecipe(enchantStack, materialStack, enchantPower, option, world);
        return recipe == null ? 0 : recipe.getMaterialCost(enchantStack, materialStack, option);
    }

    public String getTooltip(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        IEnderTableRecipe recipe = this.getRecipe(enchantStack, materialStack, enchantPower, option, world);
        return recipe == null ? "" : recipe.getTooltip(enchantStack, materialStack, option);
    }

    public boolean obfuscateTooltip(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        IEnderTableRecipe recipe = this.getRecipe(enchantStack, materialStack, enchantPower, option, world);
        return recipe == null || recipe.obfuscateTooltip(enchantStack, materialStack, option);
    }

    public void doneEnchant(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        IEnderTableRecipe recipe = this.getRecipe(enchantStack, materialStack, enchantPower, option, world);
        if (recipe != null) {
            recipe.doneEnchant(enchantStack, materialStack, enchantPower, option, world);
        }
    }

    private IEnderTableRecipe getRecipe(ItemStack enchantStack, ItemStack materialStack, float enchantPower, IEnderTableRecipe.EnumOption option, World world) {
        for (IEnderTableRecipe recipe : this.tableRecipes) {
            if (!recipe.matches(enchantStack, materialStack, enchantPower, option, world)) continue;
            return recipe;
        }
        return null;
    }
}

