/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import shetiphian.terraqueous.common.entity.EntityPaintingBase;
import shetiphian.terraqueous.common.misc.EnumArtLayout;

@SideOnly(value=Side.CLIENT)
public class RenderPaintings
implements IRenderFactory<EntityPaintingBase> {
    public static RenderPaintings INSTANCE = new RenderPaintings();

    public Render<? super EntityPaintingBase> createRenderFor(RenderManager manager) {
        return new PaintingsRenderer(manager);
    }

    public static class PaintingsRenderer
    extends Render<EntityPaintingBase> {
        protected PaintingsRenderer(RenderManager manager) {
            super(manager);
        }

        public void doRender(EntityPaintingBase entity, double x, double y, double z, float entityYaw, float partialTicks) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179091_B();
            this.func_180548_c((Entity)entity);
            EnumArtLayout painting = entity.art;
            GlStateManager.func_179152_a((float)0.0625f, (float)0.0625f, (float)0.0625f);
            if (painting != null) {
                this.renderArt(entity, painting.sizeX, painting.sizeY, painting.offsetX, painting.offsetY);
            }
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        }

        protected ResourceLocation getEntityTexture(EntityPaintingBase entity) {
            return entity.getEntityTexture();
        }

        private void renderArt(EntityPaintingBase entityPainting, int width, int height, int textureU, int textureV) {
            float f = (float)(-width) / 2.0f;
            float f1 = (float)(-height) / 2.0f;
            float f2 = 0.5f;
            float f3 = 0.75f;
            float f4 = 0.8125f;
            float f5 = 0.0f;
            float f6 = 0.0625f;
            float f7 = 0.75f;
            float f8 = 0.8125f;
            float f9 = 0.001953125f;
            float f10 = 0.001953125f;
            float f11 = 0.7519531f;
            float f12 = 0.7519531f;
            float f13 = 0.0f;
            float f14 = 0.0625f;
            for (int i = 0; i < width / 16; ++i) {
                for (int j = 0; j < height / 16; ++j) {
                    float f15 = f + (float)((i + 1) * 16);
                    float f16 = f + (float)(i * 16);
                    float f17 = f1 + (float)((j + 1) * 16);
                    float f18 = f1 + (float)(j * 16);
                    this.setLightmap(entityPainting, (f15 + f16) / 2.0f, (f17 + f18) / 2.0f);
                    float f19 = (float)(textureU + width - i * 16) / 256.0f;
                    float f20 = (float)(textureU + width - (i + 1) * 16) / 256.0f;
                    float f21 = (float)(textureV + height - j * 16) / 256.0f;
                    float f22 = (float)(textureV + height - (j + 1) * 16) / 256.0f;
                    Tessellator tessellator = Tessellator.func_178181_a();
                    VertexBuffer renderer = tessellator.func_178180_c();
                    renderer.func_181668_a(7, DefaultVertexFormats.field_181710_j);
                    renderer.func_181662_b((double)f15, (double)f18, (double)(-f2)).func_187315_a((double)f20, (double)f21).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f18, (double)(-f2)).func_187315_a((double)f19, (double)f21).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f17, (double)(-f2)).func_187315_a((double)f19, (double)f22).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f17, (double)(-f2)).func_187315_a((double)f20, (double)f22).func_181663_c(0.0f, 0.0f, -1.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f17, (double)f2).func_187315_a((double)f3, (double)f5).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f17, (double)f2).func_187315_a((double)f4, (double)f5).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f18, (double)f2).func_187315_a((double)f4, (double)f6).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f18, (double)f2).func_187315_a((double)f3, (double)f6).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f17, (double)(-f2)).func_187315_a((double)f7, (double)f9).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f17, (double)(-f2)).func_187315_a((double)f8, (double)f9).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f17, (double)f2).func_187315_a((double)f8, (double)f10).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f17, (double)f2).func_187315_a((double)f7, (double)f10).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f18, (double)f2).func_187315_a((double)f7, (double)f9).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f18, (double)f2).func_187315_a((double)f8, (double)f9).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f18, (double)(-f2)).func_187315_a((double)f8, (double)f10).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f18, (double)(-f2)).func_187315_a((double)f7, (double)f10).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f17, (double)f2).func_187315_a((double)f12, (double)f13).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f18, (double)f2).func_187315_a((double)f12, (double)f14).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f18, (double)(-f2)).func_187315_a((double)f11, (double)f14).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f15, (double)f17, (double)(-f2)).func_187315_a((double)f11, (double)f13).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f17, (double)(-f2)).func_187315_a((double)f12, (double)f13).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f18, (double)(-f2)).func_187315_a((double)f12, (double)f14).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f18, (double)f2).func_187315_a((double)f11, (double)f14).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    renderer.func_181662_b((double)f16, (double)f17, (double)f2).func_187315_a((double)f11, (double)f13).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
        }

        private void setLightmap(EntityPaintingBase entity, float par2, float par3) {
            int posX = MathHelper.func_76128_c((double)entity.field_70165_t);
            int posY = MathHelper.func_76128_c((double)(entity.field_70163_u + (double)(par3 / 16.0f)));
            int posZ = MathHelper.func_76128_c((double)entity.field_70161_v);
            EnumFacing enumfacing = entity.field_174860_b;
            if (enumfacing == EnumFacing.NORTH) {
                posX = MathHelper.func_76128_c((double)(entity.field_70165_t + (double)(par2 / 16.0f)));
            }
            if (enumfacing == EnumFacing.WEST) {
                posZ = MathHelper.func_76128_c((double)(entity.field_70161_v - (double)(par2 / 16.0f)));
            }
            if (enumfacing == EnumFacing.SOUTH) {
                posX = MathHelper.func_76128_c((double)(entity.field_70165_t - (double)(par2 / 16.0f)));
            }
            if (enumfacing == EnumFacing.EAST) {
                posZ = MathHelper.func_76128_c((double)(entity.field_70161_v + (double)(par2 / 16.0f)));
            }
            int var7 = this.field_76990_c.field_78722_g.func_175626_b(new BlockPos(posX, posY, posZ), 0);
            int var8 = var7 % 65536;
            int var9 = var7 / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)var8, (float)var9);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

