/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.client.render;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import shetiphian.core.client.ClientFunction;
import shetiphian.core.common.item.NameMapper;
import shetiphian.core.forgefixes.OBJLoader;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.client.misc.FoliageColor;
import shetiphian.terraqueous.client.model.CustomModelLoader;
import shetiphian.terraqueous.client.model.ModelTool;
import shetiphian.terraqueous.client.render.RenderCoconut;
import shetiphian.terraqueous.client.render.RenderEnderTable;
import shetiphian.terraqueous.client.render.RenderFlowerPot;
import shetiphian.terraqueous.client.render.RenderPaintings;
import shetiphian.terraqueous.client.render.RenderStormForge;
import shetiphian.terraqueous.common.entity.EntityCloudPainting;
import shetiphian.terraqueous.common.entity.EntityCoconut;
import shetiphian.terraqueous.common.entity.EntityEarthPainting;
import shetiphian.terraqueous.common.tileentity.TileEntityEnderTable;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;
import shetiphian.terraqueous.common.tileentity.TileEntitySFController;

public class RenderRegistry {
    private static RenderRegistry INSTANCE = new RenderRegistry();
    private Minecraft mc = FMLClientHandler.instance().getClient();

    public static void renderingPreInt() {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        OBJLoader.INSTANCE.addDomain("terraqueous");
        INSTANCE.registerCustomStateMappers();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new CustomModelLoader());
        INSTANCE.registerItemModels();
        INSTANCE.registerEntityRendering();
        INSTANCE.registerTileEntityRendering();
    }

    public static void renderingInt() {
        INSTANCE.registerColorize();
        INSTANCE.loadFoliageColors();
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        ModelTool.buildCache((IRegistry<ModelResourceLocation, IBakedModel>)event.getModelRegistry());
    }

    private void registerCustomStateMappers() {
        StateMapperBase stateMapperBase;
        if (Values.blockPergola != null) {
            StateMapperBase statePergola = new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    return new ModelResourceLocation("terraqueous:pergola");
                }
            };
            ModelLoader.setCustomStateMapper((Block)Values.blockPergola, (IStateMapper)statePergola);
        }
        if (Values.blockTypeCloud != null) {
            stateMapperBase = new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    String property = this.func_178131_a((Map)state.func_177228_b());
                    if (property.contains("colored")) {
                        property = property.replaceFirst("(?<=cloudvariant=)(.*?)(?=[-\\W])", "none");
                    }
                    return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), property);
                }
            };
            ModelLoader.setCustomStateMapper((Block)Values.blockTypeCloud, (IStateMapper)stateMapperBase);
        }
        if (Values.blockTypeEarth != null) {
            stateMapperBase = new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    String property = this.func_178131_a((Map)state.func_177228_b());
                    if (property.contains("colored")) {
                        property = property.replaceFirst("(?<=treevariant=)(.*?)(?=[-\\W])", "none");
                    }
                    return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), property);
                }
            };
            ModelLoader.setCustomStateMapper((Block)Values.blockTypeEarth, (IStateMapper)stateMapperBase);
        }
        this.unlist(Values.blockTreeFoliage1, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        this.unlist(Values.blockTreeFoliage2, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        this.unlist(Values.blockTreeFoliage3, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        this.unlist(Values.blockTreeFoliage4, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
        this.unlist(Values.blockTreeFoliageCB, new IProperty[]{BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
    }

    private void unlist(Block block, final IProperty ... properties) {
        if (block != null) {
            StateMapperBase mapper = new StateMapperBase(){

                protected ModelResourceLocation func_178132_a(IBlockState state) {
                    LinkedHashMap map = new LinkedHashMap(state.func_177228_b());
                    for (IProperty iprop : properties) {
                        map.remove(iprop);
                    }
                    String property = this.func_178131_a(map);
                    if (property.contains("treevariant=coconut")) {
                        property = property.replace("=flower", "=normal").replace("=fruit", "=normal").replace("=stalk_bare", "=normal").replace("=stalk_grow", "=normal");
                    }
                    return new ModelResourceLocation((ResourceLocation)Block.field_149771_c.func_177774_c((Object)state.func_177230_c()), property);
                }
            };
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
        }
    }

    private void registerItemModels() {
        this.registerItemModels(Values.blockCloudFancy, "BlockCloudFancy");
        this.registerItemModels(Values.blockClouds, "BlockClouds");
        this.registerItemModels(Values.blockCrafting, "BlockCrafting");
        this.registerItemModels(Values.blockDoodad, "BlockDoodad");
        this.registerItemModels(Values.blockEarthOre, "BlockEarthOre");
        this.registerItemModels(Values.blockEnderTable, "BlockEnderTable");
        this.registerItemModels(Values.blockFlowerCluster, "BlockFlowerCluster");
        this.registerItemModels(Values.blockFlowerPot, "BlockFlowerPot");
        this.registerItemModels(Values.blockFlowerSingle, "BlockFlowerSingle");
        this.registerItemModels(Values.blockHay, "BlockHay");
        this.registerItemModels(Values.blockPergola, "BlockPergola");
        this.registerItemModels(Values.blockPlants, "BlockPlants");
        this.registerItemModels(Values.blockTallGrass, "BlockTallGrass");
        this.registerItemModels(Values.blockPlanks, "BlockPlanks");
        this.registerItemModels(Values.blockSapling, "BlockSapling");
        this.registerItemModels(Values.blockTreeTrunk1, "BlockTreeTrunk1");
        this.registerItemModels(Values.blockTreeTrunk2, "BlockTreeTrunk2");
        this.registerItemModels(Values.blockTreeFoliage1, "BlockTreeFoliage1");
        this.registerItemModels(Values.blockTreeFoliage2, "BlockTreeFoliage2");
        this.registerItemModels(Values.blockTreeFoliage3, "BlockTreeFoliage3");
        this.registerItemModels(Values.blockTreeFoliage4, "BlockTreeFoliage4");
        this.registerItemModels(Values.blockTreeFoliageCB, "BlockTreeFoliageCB");
        this.registerItemModels(Values.blockTypeCloud, "BlockTypeCloud");
        this.registerItemModels(Values.blockTypeEarth, "BlockTypeEarth");
        this.registerItemModels(Values.itemCloudTalisman, "ItemCloudTalisman");
        this.registerItemModels(Values.itemColorizer, "ItemColorizer");
        this.registerItemModels(Values.itemEnderMonocle, "ItemEnderMonocle");
        this.registerItemModels(Values.itemMain, "ItemMain");
        this.registerItemModels(Values.itemMultiFood, "ItemMultiFood");
        this.registerCustomModel(Values.itemHammer, 0, new ModelResourceLocation("terraqueous:tool_hammer", "inventory"));
        this.registerCustomModel(Values.itemHammer, 1, new ModelResourceLocation("terraqueous:tool_hammer", "inventory"));
        this.registerCustomModel(Values.itemMultiTool, 0, new ModelResourceLocation("terraqueous:builtin/tool", "inventory"));
        this.registerCustomModel(Values.itemScythe, 0, new ModelResourceLocation("terraqueous:builtin/tool", "inventory"));
        ModelTool.registerModels();
        this.registerItemModels(Values.blockTallGrass, "BlockTallGrass");
    }

    private void registerItemModels(Block block, String key) {
        if (block != null) {
            this.registerItemModels(Item.func_150898_a((Block)block), key);
        }
    }

    private void registerItemModels(Item item, String key) {
        if (item != null) {
            for (Map.Entry entry : Values.nameMapper.getAllDataFor(key).entrySet()) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)((Integer)entry.getKey()), (ModelResourceLocation)((NameMapper.NameData)entry.getValue()).getResource());
            }
        }
    }

    private void registerCustomModel(Item item, int meta, ModelResourceLocation resource) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)resource);
        }
    }

    private void registerColorize() {
        ClientFunction.registerColorize((Block)Values.blockCrafting);
        ClientFunction.registerColorize((Block)Values.blockFlowerPot);
        ClientFunction.registerColorize((Block)Values.blockHay);
        ClientFunction.registerColorize((Block)Values.blockPergola);
        ClientFunction.registerColorize((Block)Values.blockTallGrass);
        ClientFunction.registerColorize((Block)Values.blockTreeFoliage1);
        ClientFunction.registerColorize((Block)Values.blockTreeFoliage2);
        ClientFunction.registerColorize((Block)Values.blockTreeFoliage3);
        ClientFunction.registerColorize((Block)Values.blockTreeFoliage4);
        ClientFunction.registerColorize((Block)Values.blockTreeFoliageCB);
        ClientFunction.registerColorize((Block)Values.blockTypeCloud);
        ClientFunction.registerColorize((Block)Values.blockTypeEarth);
    }

    private void loadFoliageColors() {
        if (Settings.INSTANCE.setup().addTrees) {
            this.loadFoliageColorBuffer(0, "lightvibrant");
            this.loadFoliageColorBuffer(1, "darkmedium");
            this.loadFoliageColorBuffer(2, "plumcherry");
        } else if (Values.blockPlants != null) {
            this.loadFoliageColorBuffer(0, "lightvibrant");
        }
        if (Values.blockPergola != null) {
            this.loadFoliageColorBuffer(3, "lifedeath");
        }
    }

    private void loadFoliageColorBuffer(int buffer, String image) {
        try {
            FoliageColor.colorBuffer[buffer] = TextureUtil.func_110986_a((IResourceManager)this.mc.func_110442_L(), (ResourceLocation)new ResourceLocation("terraqueous", "textures/colormap/" + image + ".png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerEntityRendering() {
        if (Values.itemMain != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityEarthPainting.class, (IRenderFactory)RenderPaintings.INSTANCE);
            RenderingRegistry.registerEntityRenderingHandler(EntityCloudPainting.class, (IRenderFactory)RenderPaintings.INSTANCE);
        }
        if (Values.itemMultiFood != null) {
            RenderingRegistry.registerEntityRenderingHandler(EntityCoconut.class, (IRenderFactory)RenderCoconut.INSTANCE);
        }
    }

    private void registerTileEntityRendering() {
        if (Values.blockCrafting != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySFController.class, (TileEntitySpecialRenderer)new RenderStormForge());
        }
        if (Values.blockEnderTable != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityEnderTable.class, (TileEntitySpecialRenderer)new RenderEnderTable());
        }
        if (Values.blockFlowerPot != null) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFlowerPot.class, (TileEntitySpecialRenderer)new RenderFlowerPot());
        }
    }
}

