/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.asm.Hooks;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ParticleHelper;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.common.block.BlockTypeEarth;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeBase;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeColored;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeDoor;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFence;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeGate;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeSlab;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeStairs;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeTrapdoor;

public abstract class BlockTypeBase
extends Block
implements IColored,
Hooks.IParticleOverride {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    protected BlockTypeBase(Material material) {
        super(material);
        this.field_149783_u = true;
    }

    protected abstract BlockStateContainer func_180661_e();

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockTypeBase.getEnumType(state).getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityTypeBase tile = this.getTile(world, pos);
        return tile != null ? tile.getActualState(state) : state;
    }

    public abstract IBlockState getBlockType(IBlockState var1, byte var2);

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (BlockTypeBase.getEnumType(state).getValue()) {
            case 0: {
                return new TileEntityTypeDoor();
            }
            case 1: {
                return new TileEntityTypeTrapdoor();
            }
            case 2: {
                return new TileEntityTypeGate();
            }
            case 3: {
                return new TileEntityTypeFence();
            }
            case 4: {
                return new TileEntityTypeStairs();
            }
            case 5: {
                return new TileEntityTypeSlab();
            }
            case 11: 
            case 12: {
                return new TileEntityTypeColored();
            }
        }
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    private TileEntityTypeBase getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityTypeBase ? (TileEntityTypeBase)tile : null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityTypeBase tile = this.getTile(world, pos);
        return tile != null ? tile.getBoxBounds() : Block.field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        return tile != null && tile.getCollisionBoxes() == null ? Block.field_185506_k : super.func_180646_a(state, world, pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            for (AxisAlignedBB box : tile.getCollisionBoxes()) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)box);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        return tile != null ? tile.blockActivated(player, heldItem) : super.func_180639_a(world, pos, state, player, hand, heldItem, facing, hitX, hitY, hitZ);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d startVec, Vec3d endVec) {
        RayTraceResult original = super.func_180636_a(state, world, pos, startVec, endVec);
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        return tile != null ? tile.collisionRayTrace(state, startVec, endVec, original) : original;
    }

    public RayTraceResult preformRayTrace(BlockPos pos, Vec3d startVec, Vec3d endVec, AxisAlignedBB aabb) {
        return this.func_185503_a(pos, startVec, endVec, aabb);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor) {
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.neighborChanged(neighbor);
        }
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        TileEntityTypeBase tile = this.getTile(world, pos);
        return tile != null ? tile.blockMovementAI() : super.func_176205_b(world, pos);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityTypeBase tile = this.getTile(world, pos);
        return tile != null ? tile.isSideSolid(side) : super.isSideSolid(state, world, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityTypeBase tile = this.getTile(world, pos);
        if (tile != null) {
            return MathHelper.func_76125_a((int)tile.providedPower(side.func_176734_d(), tile.func_145831_w().func_175676_y(pos)), (int)0, (int)15);
        }
        return super.func_180656_a(state, world, pos, side);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && !tile.removeBlock(player, willHarvest)) {
            return false;
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityTypeBase tile = this.getTile(world, pos);
        if (tile != null) {
            ret.addAll(tile.getDrops(fortune));
        }
        return ret;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) * 10;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        return tile != null && tile.rotateBlock(axis);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        TileEntityTypeBase tile = this.getTile(world, pos);
        return tile != null && tile.isLadder(entity);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityTypeBase tile = this.getTile(world, pos);
        if (tile != null) {
            return tile.getLightValue();
        }
        return 0;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta / 10);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        EnumType type = BlockTypeBase.getEnumType(state);
        if (type.getValue() < 2) {
            return layer == BlockRenderLayer.CUTOUT;
        }
        if (type.getValue() == 11) {
            return this instanceof BlockTypeEarth ? layer == BlockRenderLayer.SOLID : layer == BlockRenderLayer.TRANSLUCENT;
        }
        if (type.getValue() == 12) {
            return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.SOLID && this instanceof BlockTypeEarth;
        }
        return layer == BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityTypeBase tile;
        if (data.world != null && data.pos != null && (tile = this.getTile(data.world, data.pos)) != null) {
            return tile.colorMultiplier(index);
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean original = super.func_176225_a(state, world, pos, side);
        TileEntityTypeBase tile = this.getTile(world, pos);
        return tile != null ? tile.renderSide(side, original) : original;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState state2, EntityLivingBase entity, int numberOfParticles) {
        return ParticleHelper.addLandingEffects((WorldServer)world, (BlockPos)pos, (EntityLivingBase)entity, (int)numberOfParticles, (int)this.getParticleStateId(state, (World)world, pos, (Entity)entity));
    }

    public boolean overrideRunningEffects(World world, BlockPos pos, IBlockState state, Entity entity) {
        return ParticleHelper.addRunningEffects((World)world, (BlockPos)pos, (Entity)entity, (int)this.getParticleStateId(state, world, pos, entity));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        BlockPos pos = target.func_178782_a();
        return ParticleHelper.addHitEffects((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b, (ParticleManager)effectRenderer, (int)this.getParticleStateId(state, world, pos, null));
    }

    private int getParticleStateId(IBlockState state, World world, BlockPos pos, Entity entity) {
        EnumType type = BlockTypeBase.getEnumType(state);
        if (type == EnumType.COLORED || type == EnumType.COLORED_LIGHT) {
            return BlockTypeBase.func_176210_f((IBlockState)state);
        }
        TileEntityTypeBase tileEntity = this.getTile((IBlockAccess)world, pos);
        int stateId = tileEntity instanceof TileEntityTypeSlab ? this.getParticleStateId(((TileEntityTypeSlab)tileEntity).styleTop) : (entity != null ? this.getParticleStateId(ParticleHelper.getStateForParticle((Entity)entity, (BlockPos)pos, (IBlockState)state, BlockTypeBase.class)) : this.getParticleStateId(ParticleHelper.getStateForParticle((IBlockState)state, (World)world, (BlockPos)pos)));
        return stateId;
    }

    protected abstract int getParticleStateId(IBlockState var1);

    protected abstract int getParticleStateId(int var1);

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityTypeBase tile = this.getTile((IBlockAccess)world, pos);
        ItemStack stack = tile != null ? tile.pickBlock(target, player) : null;
        return stack != null ? stack : super.getPickBlock(state, target, world, pos, player);
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.DOOR_BOTTOM_NORTH;
            Terraqueous.errorPropertyNotFound("BlockTypeBase.VARIANT", "DOOR_BOTTOM_NORTH", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        DOOR_BOTTOM_NORTH(0),
        DOOR_BOTTOM_EAST(0),
        DOOR_BOTTOM_SOUTH(0),
        DOOR_BOTTOM_WEST(0),
        DOOR_TOP_NORTH(0),
        DOOR_TOP_EAST(0),
        DOOR_TOP_SOUTH(0),
        DOOR_TOP_WEST(0),
        DOOR_INVERT_BOTTOM_NORTH(0),
        DOOR_INVERT_BOTTOM_EAST(0),
        DOOR_INVERT_BOTTOM_SOUTH(0),
        DOOR_INVERT_BOTTOM_WEST(0),
        DOOR_INVERT_TOP_NORTH(0),
        DOOR_INVERT_TOP_EAST(0),
        DOOR_INVERT_TOP_SOUTH(0),
        DOOR_INVERT_TOP_WEST(0),
        TRAPDOOR_NORTH(1),
        TRAPDOOR_EAST(1),
        TRAPDOOR_SOUTH(1),
        TRAPDOOR_WEST(1),
        TRAPDOOR_INVERT_NORTH(1),
        TRAPDOOR_INVERT_EAST(1),
        TRAPDOOR_INVERT_SOUTH(1),
        TRAPDOOR_INVERT_WEST(1),
        TRAPDOOR_OPEN_NORTH(1),
        TRAPDOOR_OPEN_EAST(1),
        TRAPDOOR_OPEN_SOUTH(1),
        TRAPDOOR_OPEN_WEST(1),
        GATE_NORTH(2),
        GATE_EAST(2),
        GATE_SOUTH(2),
        GATE_WEST(2),
        GATE_OPEN_NORTH(2),
        GATE_OPEN_EAST(2),
        GATE_OPEN_SOUTH(2),
        GATE_OPEN_WEST(2),
        GATE_WALL_NORTH(2),
        GATE_WALL_EAST(2),
        GATE_WALL_SOUTH(2),
        GATE_WALL_WEST(2),
        GATE_WALL_OPEN_NORTH(2),
        GATE_WALL_OPEN_EAST(2),
        GATE_WALL_OPEN_SOUTH(2),
        GATE_WALL_OPEN_WEST(2),
        FENCE(3),
        FENCE_N(3),
        FENCE_E(3),
        FENCE_S(3),
        FENCE_W(3),
        FENCE_NE(3),
        FENCE_ES(3),
        FENCE_SW(3),
        FENCE_NW(3),
        FENCE_NS(3),
        FENCE_EW(3),
        FENCE_NES(3),
        FENCE_ESW(3),
        FENCE_NSW(3),
        FENCE_NEW(3),
        FENCE_NESW(3),
        FENCE_UNS(3),
        FENCE_UEW(3),
        FENCE_V(3),
        FENCE_VN(3),
        FENCE_VE(3),
        FENCE_VS(3),
        FENCE_VW(3),
        FENCE_VNE(3),
        FENCE_VES(3),
        FENCE_VSW(3),
        FENCE_VNW(3),
        FENCE_VNS(3),
        FENCE_VEW(3),
        FENCE_VNES(3),
        FENCE_VESW(3),
        FENCE_VNSW(3),
        FENCE_VNEW(3),
        FENCE_VNESW(3),
        STAIRS_NORTH(4),
        STAIRS_EAST(4),
        STAIRS_SOUTH(4),
        STAIRS_WEST(4),
        STAIRS_INSIDE_RIGHT_NORTH(4),
        STAIRS_INSIDE_RIGHT_EAST(4),
        STAIRS_INSIDE_RIGHT_SOUTH(4),
        STAIRS_INSIDE_RIGHT_WEST(4),
        STAIRS_INSIDE_LEFT_NORTH(4),
        STAIRS_INSIDE_LEFT_EAST(4),
        STAIRS_INSIDE_LEFT_SOUTH(4),
        STAIRS_INSIDE_LEFT_WEST(4),
        STAIRS_OUTSIDE_RIGHT_NORTH(4),
        STAIRS_OUTSIDE_RIGHT_EAST(4),
        STAIRS_OUTSIDE_RIGHT_SOUTH(4),
        STAIRS_OUTSIDE_RIGHT_WEST(4),
        STAIRS_OUTSIDE_LEFT_NORTH(4),
        STAIRS_OUTSIDE_LEFT_EAST(4),
        STAIRS_OUTSIDE_LEFT_SOUTH(4),
        STAIRS_OUTSIDE_LEFT_WEST(4),
        STAIRS_INVERT_NORTH(4),
        STAIRS_INVERT_EAST(4),
        STAIRS_INVERT_SOUTH(4),
        STAIRS_INVERT_WEST(4),
        STAIRS_INVERT_INSIDE_RIGHT_NORTH(4),
        STAIRS_INVERT_INSIDE_RIGHT_EAST(4),
        STAIRS_INVERT_INSIDE_RIGHT_SOUTH(4),
        STAIRS_INVERT_INSIDE_RIGHT_WEST(4),
        STAIRS_INVERT_INSIDE_LEFT_NORTH(4),
        STAIRS_INVERT_INSIDE_LEFT_EAST(4),
        STAIRS_INVERT_INSIDE_LEFT_SOUTH(4),
        STAIRS_INVERT_INSIDE_LEFT_WEST(4),
        STAIRS_INVERT_OUTSIDE_RIGHT_NORTH(4),
        STAIRS_INVERT_OUTSIDE_RIGHT_EAST(4),
        STAIRS_INVERT_OUTSIDE_RIGHT_SOUTH(4),
        STAIRS_INVERT_OUTSIDE_RIGHT_WEST(4),
        STAIRS_INVERT_OUTSIDE_LEFT_NORTH(4),
        STAIRS_INVERT_OUTSIDE_LEFT_EAST(4),
        STAIRS_INVERT_OUTSIDE_LEFT_SOUTH(4),
        STAIRS_INVERT_OUTSIDE_LEFT_WEST(4),
        SLAB(5),
        SLAB_INVERT(5),
        SLAB_DOUBLE0(5),
        SLAB_DOUBLE1(5),
        SLAB_DOUBLE2(5),
        SLAB_DOUBLE3(5),
        SLAB_DOUBLE4(5),
        SLAB_DOUBLE5(5),
        SLAB_DOUBLE6(5),
        SLAB_DOUBLE7(5),
        SLAB_DOUBLE8(5),
        SLAB_DOUBLE9(5),
        COLORED(11),
        COLORED_LIGHT(12);

        private static final EnumType[] array;
        private static final Map<String, EnumType> map;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? DOOR_BOTTOM_NORTH : type;
        }

        public static EnumType byName(String name) {
            return map.containsKey(name = name.toLowerCase().trim()) ? map.get(name) : DOOR_BOTTOM_NORTH;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            map = new HashMap<String, EnumType>();
            map.clear();
            for (EnumType value : EnumType.values()) {
                if (array[value.getValue()] == null) {
                    EnumType.array[value.getValue()] = value;
                }
                map.put(value.func_176610_l(), value);
            }
        }
    }
}

