/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.common.block.BlockTypeBase;

public class BlockTypeCloud
extends BlockTypeBase {
    public BlockTypeCloud() {
        super(CloudAPI.materialCloud);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(CloudAPI.soundTypeCloud);
        this.func_149711_c(0.7f);
        this.func_149752_b(0.5f);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockTypeBase.VARIANT, CloudAPI.VARIANT});
    }

    @Override
    public IBlockState getBlockType(IBlockState state, byte typeId) {
        return state.func_177226_a(CloudAPI.VARIANT, (Comparable)((Object)CloudAPI.CloudType.byID(typeId)));
    }

    @Override
    protected int getParticleStateId(IBlockState state) {
        if (Values.blockClouds != null) {
            state = Values.blockClouds.func_176223_P().func_177226_a(CloudAPI.VARIANT, (Comparable)((Object)CloudAPI.getCloudType(state)));
        }
        return Block.func_176210_f((IBlockState)state);
    }

    @Override
    protected int getParticleStateId(int typeId) {
        if (Values.blockClouds != null) {
            return Block.func_176210_f((IBlockState)Values.blockClouds.func_176223_P().func_177226_a(CloudAPI.VARIANT, (Comparable)((Object)CloudAPI.CloudType.byID(typeId))));
        }
        return -1;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return CloudPresets.getCollisionBoundingBox(world, pos, state, super.func_180646_a(state, world, pos));
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor) {
        CloudPresets.onNeighborBlockChange(state, world, pos);
        super.func_189540_a(state, world, pos, neighbor);
    }

    public boolean isFoliage(IBlockAccess world, BlockPos pos) {
        return CloudPresets.isFoliage();
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        CloudPresets.onEntityWalking(world, pos, entity);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        CloudPresets.onEntityCollidedWithBlock(state, world, pos, entity);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        CloudPresets.onFallenUpon(world, pos, entity);
    }
}

