/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.inventory;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.IGhostSlots;
import shetiphian.core.common.inventory.IOutputSlot;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftBench;

public class ContainerCraftBench
extends Container {
    private TileEntityCraftBench bench;
    private InventoryPlayer invPlayer;
    private GhostMatrixCrafting craftMatrix;
    private IInventory craftResult = new InventoryCraftResult();
    private ItemStack lastStackInSlot;

    public ContainerCraftBench(InventoryPlayer invPlayer, TileEntityCraftBench tile) {
        int col;
        int row;
        this.bench = tile;
        this.invPlayer = invPlayer;
        this.craftMatrix = new GhostMatrixCrafting((IInventory)this.bench.ghostMatrix);
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.func_75146_a((Slot)new IGhostSlots.SlotGhost((IInventory)this.craftMatrix, col + row * 3, 38 + col * 18, 11 + row * 18));
            }
        }
        this.func_75146_a((Slot)new SlotGhostCrafting(this, 0, 128, 16));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.bench.inventory, col + row * 9 + 1, 11 + col * 18, 70 + row * 18));
            }
        }
        this.func_75146_a((Slot)new IOutputSlot.SlotOutput((IInventory)this.bench.inventory, 28, 119, 40, null));
        this.func_75146_a((Slot)new IOutputSlot.SlotOutput((IInventory)this.bench.inventory, 29, 137, 40, null));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)invPlayer, col + row * 9 + 9, 11 + col * 18, 146 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)invPlayer, col, 11 + col * 18, 204));
        }
        this.func_75130_a((IInventory)this.craftMatrix);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.bench.inventory.func_70300_a(player);
    }

    public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.field_75151_b.get(slotId);
        if (slot instanceof IGhostSlots && mouseButton != 2) {
            ItemStack stack;
            if (mouseButton == 0 && clickType == ClickType.PICKUP_ALL) {
                stack = null;
                try {
                    stack = player.field_71071_by.func_70445_o().func_77946_l();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (stack != null && stack.field_77994_a > 1) {
                    stack.field_77994_a = 1;
                }
                if (this.lastStackInSlot != null) {
                    for (int index = 0; index < this.craftMatrix.func_70302_i_(); index = (int)((byte)(index + 1))) {
                        if (!Function.areItemStacksEqual((ItemStack)this.craftMatrix.func_70301_a(index), (ItemStack)this.lastStackInSlot)) continue;
                        this.craftMatrix.func_70299_a(index, stack);
                    }
                }
            }
            if (mouseButton == 0 || mouseButton == 1 || clickType == ClickType.QUICK_CRAFT) {
                this.lastStackInSlot = slot.func_75211_c();
                stack = null;
                try {
                    stack = player.field_71071_by.func_70445_o().func_77946_l();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (stack != null && stack.field_77994_a > 1) {
                    stack.field_77994_a = 1;
                }
                slot.func_75215_d(stack);
            }
            this.func_75130_a(null);
            return slot.func_75211_c();
        }
        return super.func_184996_a(slotId, mouseButton, clickType, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotId) {
        Slot clickedSlot = (Slot)this.field_75151_b.get(slotId);
        if (clickedSlot == null || !clickedSlot.func_75216_d()) {
            return null;
        }
        ItemStack itemInSlot = clickedSlot.func_75211_c();
        if (itemInSlot == null) {
            return null;
        }
        ItemStack returnStack = itemInSlot.func_77946_l();
        if (slotId > 9 && slotId < 39 ? !this.func_75135_a(itemInSlot, 39, this.field_75151_b.size(), true) : slotId > 38 && slotId < this.field_75151_b.size() && !this.func_75135_a(itemInSlot, 10, 37, false)) {
            return null;
        }
        if (itemInSlot.field_77994_a == 0) {
            clickedSlot.func_75215_d(null);
        } else {
            clickedSlot.func_75218_e();
        }
        if (itemInSlot.field_77994_a == returnStack.field_77994_a) {
            return null;
        }
        return returnStack;
    }

    public void func_75130_a(IInventory inventory) {
        IRecipe recipe = this.bench.findMatchingRecipe(this.craftMatrix, this.bench.func_145831_w());
        this.craftResult.func_70299_a(0, recipe != null ? recipe.func_77572_b((InventoryCrafting)this.craftMatrix) : null);
        this.bench.setCraftResult(this.craftResult.func_70301_a(0));
    }

    public List<IContainerListener> getCrafters() {
        return this.field_75149_d;
    }

    private static class ContainerNoInteract
    extends Container {
        private ContainerNoInteract() {
        }

        public boolean func_75145_c(EntityPlayer player) {
            return false;
        }
    }

    public static class GhostMatrixCrafting
    extends InventoryCrafting {
        private IInventory inventory;

        public GhostMatrixCrafting(IInventory inventory) {
            super((Container)new ContainerNoInteract(), 3, 3);
            this.inventory = inventory;
        }

        public int func_70297_j_() {
            return 1;
        }

        public ItemStack func_70301_a(int slotId) {
            return this.inventory.func_70301_a(slotId);
        }

        public void func_70299_a(int slotId, ItemStack itemStack) {
            this.inventory.func_70299_a(slotId, itemStack);
        }

        public ItemStack func_70298_a(int slotId, int amount) {
            return this.inventory.func_70298_a(slotId, amount);
        }
    }

    public static class SlotGhostCrafting
    extends SlotCrafting {
        private ContainerCraftBench container;

        public SlotGhostCrafting(EntityPlayer player) {
            super(player, null, null, 0, 0, 0);
        }

        SlotGhostCrafting(ContainerCraftBench container, int slotId, int posX, int posY) {
            super(((ContainerCraftBench)container).invPlayer.field_70458_d, (InventoryCrafting)container.craftMatrix, container.craftResult, slotId, posX, posY);
            this.container = container;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.container.bench.ghostCraftCanTakeStack();
        }

        public void func_82870_a(EntityPlayer player, ItemStack itemStack) {
            this.container.bench.ghostCraftOnPickupFromSlot(player, itemStack);
            this.container.func_75142_b();
            this.container.func_75130_a((IInventory)this.container.craftMatrix);
        }

        public void onPlayerCrafting(ItemStack itemStack) {
            this.func_75210_a(itemStack, itemStack.field_77994_a);
        }
    }
}

