/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.inventory;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.items.wrapper.InvWrapper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.core.common.inventory.InventoryShifted;
import shetiphian.terraqueous.common.tileentity.TileEntityCraftFurnace;

public class InventoryCraftFurnace
extends InventoryInternal {
    private final TileEntityCraftFurnace craftFurnace;
    public final int[] SLOTS_OUTPUT = new int[]{0, 1, 2, 11, 12, 13, 14, 15, 16};
    public final int[] SLOTS_FUEL = new int[]{0, 1, 2};
    public final int[] SLOTS_ITEMS = new int[]{3, 4, 5, 6, 7, 8};
    public final int[] SLOTS_INPUTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public final int[] SLOTS_BASIC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 11, 12, 13, 14, 15, 16};
    public final int[] CLOUD_SLOTS_OUTPUT = new int[]{11, 12, 13, 14, 15, 16};
    public final int[] CLOUD_SLOTS_BASIC = new int[]{3, 4, 5, 6, 7, 8, 11, 12, 13, 14, 15, 16};

    public InventoryCraftFurnace(TileEntityCraftFurnace invOwner) {
        super((TileEntity)invOwner, "internal", 17, "inv.craftfurnace");
        this.craftFurnace = invOwner;
    }

    public void setContents(ItemStack[] contents) {
        if (contents.length >= this.contents.length) {
            System.arraycopy(contents, 0, this.contents, 0, contents.length);
        }
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        if (slotId < 3) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }
        return slotId < 11 && this.craftFurnace.isItemSmeltable(stack);
    }

    public InvWrapper getWrapperBasic(boolean cloud) {
        return new WrapperBasic((IInventory)(cloud ? new CloudBasic((IInventory)this) : new Basic((IInventory)this)));
    }

    public InvWrapper getWrapperInputs() {
        return new WrapperInputs((IInventory)new InputAll((IInventory)this));
    }

    public InvWrapper getWrapperFuel() {
        return new WrapperInputs((IInventory)new InputFuel((IInventory)this));
    }

    public InvWrapper getWrapperItems() {
        return new WrapperInputs((IInventory)new InputItems((IInventory)this));
    }

    public InvWrapper getWrapperOutput(boolean cloud) {
        return new WrapperOutput((IInventory)(cloud ? new CloudOutput((IInventory)this) : new Output((IInventory)this)));
    }

    private class CloudOutput
    extends Output {
        private CloudOutput(IInventory parent) {
            super(parent);
        }

        @Override
        protected int shiftId(int slotId) {
            return slotId + 8;
        }

        @Override
        public int func_70302_i_() {
            return 6;
        }
    }

    private class Output
    extends InventoryShifted {
        private Output(IInventory parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId > 2 ? slotId + 8 : slotId;
        }

        public int func_70302_i_() {
            return 9;
        }

        public String func_70005_c_() {
            return "inv.craftfurnace.output";
        }
    }

    private class InputItems
    extends InventoryShifted {
        private InputItems(IInventory parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId + 3;
        }

        public int func_70302_i_() {
            return 6;
        }

        public String func_70005_c_() {
            return "inv.craftfurnace.input.items";
        }
    }

    private class InputFuel
    extends InventoryShifted {
        private InputFuel(IInventory parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId;
        }

        public int func_70302_i_() {
            return 3;
        }

        public String func_70005_c_() {
            return "inv.craftfurnace.input.fuel";
        }
    }

    private class InputAll
    extends InventoryShifted {
        private InputAll(IInventory parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId;
        }

        public int func_70302_i_() {
            return 9;
        }

        public String func_70005_c_() {
            return "inv.craftfurnace.input.all";
        }
    }

    private class CloudBasic
    extends Basic {
        private CloudBasic(IInventory parent) {
            super(parent);
        }

        @Override
        protected int shiftId(int slotId) {
            return slotId > 5 ? slotId + 5 : slotId + 3;
        }

        @Override
        public int func_70302_i_() {
            return 12;
        }
    }

    private class Basic
    extends InventoryShifted {
        private Basic(IInventory parent) {
            super(parent);
        }

        protected int shiftId(int slotId) {
            return slotId > 8 ? slotId + 2 : slotId;
        }

        public int func_70302_i_() {
            return 15;
        }

        public String func_70005_c_() {
            return "inv.craftfurnace";
        }
    }

    private class WrapperOutput
    extends WrapperBasic {
        private WrapperOutput(IInventory inv) {
            super(inv);
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }
    }

    private class WrapperInputs
    extends WrapperBasic {
        private WrapperInputs(IInventory inv) {
            super(inv);
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return null;
        }
    }

    private class WrapperBasic
    extends InvWrapper {
        private WrapperBasic(IInventory inv) {
            super(inv);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return slot < 9 ? super.insertItem(slot, stack, simulate) : stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return slot > 10 || !this.getInv().func_94041_b(slot, this.getStackInSlot(slot)) ? super.extractItem(slot, amount, simulate) : null;
        }
    }
}

