/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.item;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerTryUseItemOnBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.client.Localization;
import shetiphian.core.common.Function;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;

public class ItemColorizer
extends ItemTool
implements IRGB16_Item {
    public static char[] colorcode = new char[]{'8', '4', '2', '6', '9', '5', '3', '7', '8', 'd', 'a', 'e', 'b', '5', '6', 'f'};
    private static Item.ToolMaterial dyeTool = EnumHelper.addToolMaterial((String)"DYETOOL", (int)0, (int)255, (float)0.0f, (float)0.0f, (int)0).setRepairItem(new ItemStack(Items.field_151137_ax));

    public ItemColorizer() {
        super(dyeTool, (Set)Sets.newHashSet((Object[])new Block[0]));
        this.func_77637_a((CreativeTabs)Values.tabTerraqueous);
        this.addToNameMap();
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{CreativeTabs.field_78040_i, Values.tabTerraqueous};
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Item)this, 1, 0));
        list.add(new ItemStack((Item)this, 1, 255));
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        ItemStack dye;
        if (stack.func_77952_i() < stack.func_77958_k() && (dye = new ItemStack(Items.field_151100_aR, 1, 15 - this.getMinecraftColor(stack))).func_77973_b().func_111207_a(dye, player, target, hand)) {
            stack.func_77972_a(1, (EntityLivingBase)player);
            return true;
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player != null) {
            player.func_184609_a(hand);
            RayTraceResult mop = this.func_77621_a(world, player, false);
            if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (player.func_70093_af()) {
                player.openGui((Object)Terraqueous.INSTANCE, 7, world, 0, 0, 0);
            } else if (!player.field_71075_bZ.field_75098_d && stack.func_77952_i() > 0) {
                stack.func_77964_b(stack.func_77952_i() - 1);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        boolean success;
        boolean bl = success = this.func_180614_a(stack, player, world, pos, hand, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS;
        if (success && world.field_72995_K && player instanceof EntityPlayerSP) {
            ((EntityPlayerSP)player).field_71174_a.func_147297_a((Packet)new CPacketPlayerTryUseItemOnBlock(pos, side, hand, hitX, hitY, hitZ));
        }
        return success ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
            return EnumActionResult.FAIL;
        }
        int used = 0;
        if (player.func_70093_af()) {
            short index;
            if ((stack.func_77952_i() + 2 <= stack.func_77958_k() || player.field_71075_bZ.field_75098_d) && this.setRGB16(stack, index = ItemColorizer.getBlockColorIndex(world, pos, player))) {
                used = 2;
            }
        } else if ((stack.func_77952_i() + 4 <= stack.func_77958_k() || player.field_71075_bZ.field_75098_d) && ItemColorizer.setBlockColor(world, pos, player, facing, this.getRGB16(stack))) {
            used = 4;
        }
        if (used > 0 && !player.field_71075_bZ.field_75098_d) {
            stack.func_77972_a(used, (EntityLivingBase)player);
        }
        return used > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public static boolean setBlockColor(World world, BlockPos pos, EntityPlayer player, EnumFacing side, short index) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRGB16_Tile) {
            return ((IRGB16_Tile)tile).setRGB16(index, player);
        }
        Block block = state.func_177230_c();
        byte color = RGB16Helper.getSimpleColor((short)index);
        if (block == Blocks.field_150405_ch || block == Blocks.field_150359_w || block == Blocks.field_150410_aZ) {
            block = block == Blocks.field_150359_w ? Blocks.field_150399_cn : (block == Blocks.field_150410_aZ ? Blocks.field_150397_co : Blocks.field_150406_ce);
            return Function.setBlock((World)world, (BlockPos)pos, (IBlockState)block.func_176203_a((int)color), (boolean)true);
        }
        return block.recolorBlock(world, pos, side, EnumDyeColor.func_176764_b((int)color));
    }

    public static short getBlockColorIndex(World world, BlockPos pos, EntityPlayer player) {
        RGB16 rgb16;
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockColored || block == Blocks.field_150399_cn || block == Blocks.field_150397_co) {
            return RGB16Helper.getIndexFor((String)EnumDyeColor.func_176764_b((int)block.func_176201_c(state)).func_176762_d());
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRGB16_Tile && (rgb16 = ((IRGB16_Tile)tile).getRGB16(player)) != null) {
            return rgb16.getIndex();
        }
        return -1;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advancedTooltips) {
        tooltip.add(Localization.get((String)"info.terraqueous.shakepowered.txt"));
        String colorInfo = RGB16Helper.getTooltip((short)this.getRGB16(stack)) + "\u00a77 - ";
        byte dye = (byte)(15 - this.getMinecraftColor(stack));
        String dyename = EnumDyeColor.func_176766_a((int)dye).func_176762_d();
        colorInfo = colorInfo + "\u00a7" + colorcode[dye] + dyename.substring(0, 1).toUpperCase() + dyename.substring(1);
        tooltip.add(colorInfo);
    }

    public short getRGB16(ItemStack stack) {
        return RGB16StackHelper.readColorTag((ItemStack)stack);
    }

    public boolean setRGB16(ItemStack stack, short rgbIndex) {
        return RGB16StackHelper.writeColorTags((ItemStack)stack, (short)rgbIndex);
    }

    private byte getMinecraftColor(ItemStack stack) {
        return RGB16StackHelper.readSimpleColorTag((ItemStack)stack);
    }

    public void setRGB16Preset(ItemStack stack, int preset, short rgbIndex, String name) {
        preset = MathHelper.func_76125_a((int)preset, (int)0, (int)17);
        NBTTagCompound nbt = this.getNBTTag(stack);
        NBTTagList tagList = this.getNBTTagList(stack);
        NBTTagCompound tagPresets = new NBTTagCompound();
        tagPresets.func_74777_a("rgb16", rgbIndex);
        tagPresets.func_74778_a("name", name);
        tagList.func_150304_a(preset, (NBTBase)tagPresets);
        nbt.func_74782_a("rgb16presets", (NBTBase)tagList);
        stack.func_77982_d(nbt);
    }

    private NBTTagCompound getNBTTag(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
    }

    public NBTTagList getNBTTagList(ItemStack stack) {
        NBTTagCompound nbt = this.getNBTTag(stack);
        if (!nbt.func_74764_b("rgb16presets")) {
            NBTTagList tagList = new NBTTagList();
            short white = RGB16Helper.getIndexFor((String)"white");
            for (int index = 0; index < 18; index = (int)((byte)(index + 1))) {
                NBTTagCompound tagPresets = new NBTTagCompound();
                tagPresets.func_74777_a("rgb16", white);
                tagPresets.func_74778_a("name", "\u00a7o<not set>");
                tagList.func_74742_a((NBTBase)tagPresets);
            }
            nbt.func_74782_a("rgb16presets", (NBTBase)tagList);
            stack.func_77982_d(nbt);
        }
        return nbt.func_150295_c("rgb16presets", 10);
    }

    private void addToNameMap() {
        Values.nameMapper.add("ItemColorizer", 0, "tools/", "colorizer", "colorizer");
    }
}

