/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import com.google.common.base.Strings;
import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import shetiphian.core.common.SPConfig;
import shetiphian.terraqueous.Settings;
import shetiphian.terraqueous.common.worldgen.Component_Vineyard;
import shetiphian.terraqueous.common.worldgen.GenClouds;
import shetiphian.terraqueous.common.worldgen.GenDoodads;
import shetiphian.terraqueous.common.worldgen.GenFlowers;
import shetiphian.terraqueous.common.worldgen.GenPlants;
import shetiphian.terraqueous.common.worldgen.GenTrees;

public class ConfigHandler {
    public static ConfigHandler INSTANCE = new ConfigHandler();
    public SPConfig config;

    void setupConfig(File file) {
        this.config = new SPConfig(file);
        this.config.load();
        this.syncConfig();
    }

    public void syncConfig() {
        Settings settings = Settings.INSTANCE;
        Settings.Setup setup = settings.setupDone() ? Settings.INSTANCE.new Settings.Setup() : Settings.INSTANCE.setup();
        this.config.addCustomCategoryComment("BLOCKS", "Controls what blocks are added by Terraqueous\nDisabling a block after it was added will remove it from the world");
        this.config.setCategoryRequiresWorldRestart("BLOCKS", true);
        this.config.setCategoryRequiresMcRestart("BLOCKS", true);
        setup.addClouds = this.config.getBoolean("addClouds", "BLOCKS", true, "IDs: blockClouds, blockCloudFancy, itemCloudTalisman\nNOTE: enables addEnderTable because it is needed to craft the Talisman used to walk-on/place clouds");
        setup.addCraftables = this.config.getBoolean("addCraftables", "BLOCKS", true, "Adds: Wood & Cloud Doors, TrapDoors, Fences, FenceGates\nIDs: blockTypeCloud, blockTypeWood");
        setup.addCrafting = this.config.getBoolean("addCrafting", "BLOCKS", true, "Adds: CloudWorkbench, CloudFurnace, Cloud&Earth CraftBench, Cloud&Earth CraftFurnace, StormForge\nIDs: blockCrafting");
        setup.addDoodads = this.config.getBoolean("addDoodads", "BLOCKS", true, "Adds: Breakable ground objects\nIDs: blockDoodad");
        setup.addEnderTable = this.config.getBoolean("addEnderTable", "BLOCKS", true, "Adds: An Enchanting Table that uses EnderPowder, and an EnderMonocle to read from it\nIDs: blockEnderTable, itemEnderMonocle");
        setup.addFlowerPots = this.config.getBoolean("addFlowerPots", "BLOCKS", true, "Adds: Two types of flower pots\nChanges: default Flower Pot recipe\nIDs: blockFlowerPot");
        setup.addFlowers = this.config.getBoolean("addFlowers", "BLOCKS", true, "Adds: 16 new flowers that can spread and grow (see TWEAKS.enableFlowerSpread)\nIDs: blockFlowerCluster, blockFlowerSingle");
        setup.addHay = this.config.getBoolean("addHayBlocks", "BLOCKS", true, "Adds: Hay blocks, thresh, loose hay\nChanges: Hay Bail recipe\nIDs: blockHay");
        setup.addOres = this.config.getBoolean("addOres", "BLOCKS", true, "IDs: blockEarthOre");
        setup.addPlants = this.config.getBoolean("addPlants", "BLOCKS", true, "Adds: Pineapple, Cactus Pear, & Grapes\nIDs: blockPlants");
        setup.addTrees = this.config.getBoolean("addTrees", "BLOCKS", true, "Adds: Apple, Chery, Orange, Coconut, & Banana Trees\nIDs: blockTreesFoliage, itemTreesSapling, blockTreesTrunk, blockTreesWood");
        this.config.addCustomCategoryComment("ITEMS", "Controls what items are added by Terraqueous\nDisabling an item after it was added will remove it from the world");
        this.config.setCategoryRequiresWorldRestart("ITEMS", true);
        this.config.setCategoryRequiresMcRestart("ITEMS", true);
        setup.addFood = this.config.getBoolean("addFood", "ITEMS", true, "IDs: itemMultiFood, EntityCoconut");
        setup.addTools = this.config.getBoolean("addTools", "ITEMS", true, "IDs: itemScythe, itemColorCopy, itemMultiTool");
        this.config.addCustomCategoryComment("TWEAKS", " ");
        this.config.setCategoryRequiresWorldRestart("TWEAKS", false);
        this.config.setCategoryRequiresMcRestart("TWEAKS", false);
        settings.enableMobDropTweaks = this.config.getBoolean("enableMobDropTweaks", "TWEAKS", true, "Adds additional drops to some mobs");
        settings.enableFlowerSpread = this.config.getBoolean("enableFlowerSpread", "TWEAKS", false, "");
        setup.enableGrassSpread = this.config.getBoolean("enableGrassSpread", "TWEAKS", true, "Tall grass will spread\nNote: this needs to replace the default tall grass, if another mod has already done so it will not work");
        settings.enableGlassShardDrops = this.config.getBoolean("enableGlassShardDrops", "TWEAKS", true, "Glass will drop shards when broken, if it would otherwise drop nothing");
        settings.fruitStaysOnTrees = this.config.getBoolean("fruitStaysOnTrees", "TWEAKS", false, "Controls if the fruit stays on the trees or randomly falls off");
        settings.fenceConnectionCutoff = this.config.getFloat("fenceConnectionCutoff", "TWEAKS", 0.6f, -1.0f, 20.0f, "Stops Terraqueous fences from visually connecting to blocks with a hardness at or less then this number.\n to disable set to -1");
        settings.sfPowerMultiplierEU = this.config.getFloat("sfPowerMultiplierEU", "TWEAKS", 1.0f, 0.001f, 1000.0f, "When the StormForge is charging an item with Energy Units, it multiplies sfPowerPerTickBase by this value to get the base EU/t\nhttp://ftbwiki.org/Power_Systems");
        settings.sfPowerMultiplierFU = this.config.getFloat("sfPowerMultiplierFU", "TWEAKS", 4.0f, 0.001f, 1000.0f, "When the StormForge is charging an item with Forge Units, it multiplies sfPowerPerTickBase by this value to get the base FU/t\nhttp://ftbwiki.org/Power_Systems");
        settings.sfPowerMultiplierIF = this.config.getFloat("sfPowerMultiplierIF", "TWEAKS", 4.0f, 0.001f, 1000.0f, "When the StormForge is charging an item with Immersive Flux, it multiplies sfPowerPerTickBase by this value to get the base IF/t\nhttp://ftbwiki.org/Power_Systems");
        settings.sfPowerMultiplierJ = this.config.getFloat("sfPowerMultiplierJ", "TWEAKS", 10.0f, 0.001f, 1000.0f, "When the StormForge is charging an item with Joules, it multiplies sfPowerPerTickBase by this value to get the base J/t\nhttp://ftbwiki.org/Power_Systems");
        settings.sfPowerMultiplierRF = this.config.getFloat("sfPowerMultiplierRF", "TWEAKS", 4.0f, 0.001f, 1000.0f, "When the StormForge is charging an item with Redstone Flux, it multiplies sfPowerPerTickBase by this value to get the base RF/t\nhttp://ftbwiki.org/Power_Systems");
        settings.sfPowerMultiplierTesla = this.config.getFloat("sfPowerMultiplierTesla", "TWEAKS", 4.0f, 0.001f, 1000.0f, "When the StormForge is charging an item with Tesla, it multiplies sfPowerPerTickBase by this value to get the base Tesla/t\nhttp://ftbwiki.org/Power_Systems");
        settings.sfPowerPerTickBase = this.config.getInt("sfPowerPerTickBase", "TWEAKS", 64, 1, 2048, "The base amount of energy the StormForge charges item per tick\nThis value is multiplied by the PowerMultiplier that matches the items requirements\nNote: The StormForge charges faster in the rain, even faster during a storm, and has a chance to bring an item to full charge when struck by lightning");
        settings.sfTicksPerRepairPoint = this.config.getInt("sfTicksPerRepairPoint", "TWEAKS", 100, 20, 6000, "The number of ticks needed for the StormForge to repair an item by one point\nNote: The StormForge works faster in the rain, even faster during a storm, and has a chance to instantly complete when struck by lightning");
        settings.sfTicksToSmelt = this.config.getInt("sfTicksToSmelt", "TWEAKS", 400, 20, 6000, "The number of ticks needed for the StormForge to smelt an item, a furnace takes 200\nNote: The StormForge works faster in the rain, even faster during a storm, and has a chance to instantly complete when struck by lightning");
        settings.flowerpotOverrides.clear();
        this.processRenderList(0, this.config.getStringList("FlowerPot-ForceCrossRender", "TWEAKS", new String[0], "Items Listed will render in flower pots using the Cross render style"));
        this.processRenderList(1, this.config.getStringList("FlowerPot-ForceBlockRender", "TWEAKS", new String[0], "Items Listed will render in flower pots using the Block render style"));
        this.processRenderList(2, this.config.getStringList("FlowerPot-ForcePaneRender", "TWEAKS", new String[]{"minecraft:golden_rail", "minecraft:detector_rail", "minecraft:ladder", "minecraft:rail", "minecraft:iron_bars", "minecraft:glass_pane", "minecraft:vine", "minecraft:waterlily", "minecraft:activator_rail", "minecraft:stained_glass_pane", "terraqueous:blockFlowerPot"}, "Items Listed will render in flower pots using the Pane render style"));
        this.processRenderList(3, this.config.getStringList("FlowerPot-ForceTallRender", "TWEAKS", new String[]{"minecraft:cactus"}, "Items Listed will render in flower pots using the Tall render style"));
        settings.dustWhiteList = this.config.getStringList("DoodadDustWhiteList", "TWEAKS", new String[0], "Dusts listed here have a chance to drop when breaking stones\nFormats: Dust Type: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>'");
        settings.dustBlackList = this.config.getStringList("DoodadDustBlackList", "TWEAKS", new String[0], "Dusts listed here can never drop when breaking stones\nFormats: Dust Type: 'ore:<dictionary name>', Mod Item: '<modId>:<itemId>', Exact Mod Item: '<modId>:<itemId>@<meta>'");
        settings.dropLumps = this.config.getBoolean("DoodadDropLumps", "TWEAKS", true, "Stone doodads will drop lumps of gravel/sandstone");
        this.config.addCustomCategoryComment("PERMISSIONS", " ");
        this.config.setCategoryRequiresWorldRestart("PERMISSIONS", false);
        this.config.setCategoryRequiresMcRestart("PERMISSIONS", false);
        settings.permissionStormForge = (byte)this.config.getInt("createStormForge", "PERMISSIONS", 3, 0, 3, "Controls who has permission to create a StormForge.\n0 = No One, 1 = OP's Only, 2 = OP's and Creative Players, 3 = Everyone\nNOTE: Does not disable/remove existing StormForges\nNOTE: StormForges require addCraftables");
        this.config.addCustomCategoryComment("GENERATOR", "Options used by the world generator");
        this.config.setCategoryRequiresWorldRestart("GENERATOR", false);
        this.config.setCategoryRequiresMcRestart("GENERATOR", false);
        GenClouds.generateCloud_Light = this.config.getBoolean("generateCloud_Light", "GENERATOR", true, "");
        GenClouds.generateCloud_Dense = this.config.getBoolean("generateCloud_Dense", "GENERATOR", true, "");
        GenClouds.generateCloud_Storm = this.config.getBoolean("generateCloud_Storm", "GENERATOR", true, "");
        GenDoodads.generateDoodad_Stick = this.config.getBoolean("generateDoodad_Stick", "GENERATOR", true, "");
        GenDoodads.generateDoodad_Stone = this.config.getBoolean("generateDoodad_Stone", "GENERATOR", true, "");
        GenDoodads.generateDoodad_Bone = this.config.getBoolean("generateDoodad_Bone", "GENERATOR", true, "");
        GenDoodads.generateDoodad_Sandstone = this.config.getBoolean("generateDoodad_Sandstone", "GENERATOR", true, "");
        GenDoodads.generateDoodad_Endimium = this.config.getBoolean("generateDoodad_Endimium", "GENERATOR", true, "");
        GenDoodads.generateDoodad_Burnium = this.config.getBoolean("generateDoodad_Burnium", "GENERATOR", true, "");
        GenPlants.generatePlant_Pineapple = this.config.getBoolean("generatePlant_Pineapple", "GENERATOR", true, "");
        GenPlants.generatePlant_CactusPear = this.config.getBoolean("generatePlant_CactusPear", "GENERATOR", true, "");
        Component_Vineyard.generateVillage_Vineyard = this.config.getBoolean("generateVillage_Vineyard", "GENERATOR", true, "");
        GenFlowers.generateFlowers = this.config.getBoolean("generateFlowers", "GENERATOR", true, "");
        GenTrees.generateTree_Apple = this.config.getBoolean("generateTree_Apple", "GENERATOR", true, "");
        GenTrees.generateTree_Cherry = this.config.getBoolean("generateTree_Cherry", "GENERATOR", true, "");
        GenTrees.generateTree_Orange = this.config.getBoolean("generateTree_Orange", "GENERATOR", true, "");
        GenTrees.generateTree_Pear = this.config.getBoolean("generateTree_Pear", "GENERATOR", true, "");
        GenTrees.generateTree_Peach = this.config.getBoolean("generateTree_Peach", "GENERATOR", true, "");
        GenTrees.generateTree_Mango = this.config.getBoolean("generateTree_Mango", "GENERATOR", true, "");
        GenTrees.generateTree_Lemon = this.config.getBoolean("generateTree_Lemon", "GENERATOR", true, "");
        GenTrees.generateTree_Plum = this.config.getBoolean("generateTree_Plum", "GENERATOR", true, "");
        GenTrees.generateTree_Coconut = this.config.getBoolean("generateTree_Coconut", "GENERATOR", true, "");
        GenTrees.generateTree_Banana = this.config.getBoolean("generateTree_Banana", "GENERATOR", true, "");
        this.config.addCustomCategoryComment("CRAFTING", "Disable DustCrafting if another mod add the same recipes and these override them.\nDisable CraftToDust if unneeded and/or another mod adds a machine that does this.");
        this.config.setCategoryRequiresWorldRestart("CRAFTING", true);
        this.config.setCategoryRequiresMcRestart("CRAFTING", true);
        setup.enableWoolToString = this.config.getBoolean("enableWoolToString", "CRAFTING", true, "Craft Wool into String");
        setup.replaceHayBaleRecipes = this.config.getBoolean("replaceHayBaleRecipes", "CRAFTING", true, "Replaces the 9xWheat<>1xHayBale recipes with 4xHayBlock<>1xHayBale recipes");
        setup.enableCrafting_TinyDustToEnderDust = this.config.getBoolean("enableCrafting_TinyDustToEnderDust", "CRAFTING", true, "Craft tiny piles of Ender Dust into piles");
        setup.enableCrafting_TinyDustToIronDust = this.config.getBoolean("enableCrafting_TinyDustToIronDust", "CRAFTING", true, "Craft tiny piles of Iron Dust into piles");
        setup.enableCrafting_TinyDustToGoldDust = this.config.getBoolean("enableCrafting_TinyDustToGoldDust", "CRAFTING", true, "Craft tiny piles of Gold Dust into piles");
        setup.enableCrafting_TinyDustToCoalDust = this.config.getBoolean("enableCrafting_TinyDustToCoalDust", "CRAFTING", true, "Craft tiny piles of Coal Dust into piles");
        setup.enableCrafting_TinyDustToDiamondDust = this.config.getBoolean("enableCrafting_TinyDustToDiamondDust", "CRAFTING", true, "Craft tiny piles of Diamond Dust into piles");
        setup.enableCrafting_TinyDustToEmeraldDust = this.config.getBoolean("enableCrafting_TinyDustToEmeraldDust", "CRAFTING", true, "Craft tiny piles of Emerald Dust into piles");
        setup.enableCrafting_TinyDustToLapis = this.config.getBoolean("enableCrafting_TinyDustToLapis", "CRAFTING", true, "Craft tiny piles of Lapis Dust into Lapis");
        setup.enableCrafting_TinyDustToRedstone = this.config.getBoolean("enableCrafting_TinyDustToRedstone", "CRAFTING", true, "Craft tiny piles of Redstone Dust into Redstone Dust");
        setup.enableCrafting_LumpToSandstone = this.config.getBoolean("enableCrafting_LumpToSandstone", "CRAFTING", true, "Craft lumps of Sandstone into a block");
        setup.enableCrafting_LumpToGravel = this.config.getBoolean("enableCrafting_LumpToGravel", "CRAFTING", true, "Craft lumps of Gravel into a block");
        setup.enableCrafting_LumpToRedSandstone = this.config.getBoolean("enableCrafting_LumpToRedSandstone", "CRAFTING", true, "Craft lumps of Red Sandstone into a block");
        setup.enableSmashing_EnderPearlsToDust = this.config.getBoolean("enableSmashing_EnderPearlsToDust", "CRAFTING", true, "Smash Ender Pearls into Dust");
        setup.enableSmashing_CoalToDust = this.config.getBoolean("enableSmashing_CoalToDust", "CRAFTING", true, "Smash Coal into Dust");
        setup.enableSmashing_DiamondToDust = this.config.getBoolean("enableSmashing_DiamondToDust", "CRAFTING", true, "Smash Diamonds into Dust");
        this.config.addCustomCategoryComment("INTEGRATION", "Mod integration can be disabled to solve compatibility issues, remove unwanted/unneeded features, etc.");
        this.config.setCategoryRequiresWorldRestart("INTEGRATION", true);
        this.config.setCategoryRequiresMcRestart("INTEGRATION", true);
        setup.enableBuildCraft = this.config.getBoolean("BuildCraft", "INTEGRATION", true, "Facade changes, adds missing blocks and removes blocks that look bad");
        setup.enableComputerCraft = this.config.getBoolean("ComputerCraft", "INTEGRATION", true, "Add Colorizer add-on for Turtles");
        setup.enableEE3 = this.config.getBoolean("EE3", "INTEGRATION", true, "Adds/Alters EMC Values");
        setup.enableForestry = this.config.getBoolean("Forestry", "INTEGRATION", true, "Adds: fruit to squeezer, saplings to fermenter, and various items to backpacks");
        setup.enableForgeMultiPart = this.config.getBoolean("ForgeMultiPart", "INTEGRATION", true, "Enables some blocks to be cut");
        setup.enableOpenComputers = this.config.getBoolean("OpenComputers", "INTEGRATION", true, "Adds Colorizer Module for Robots");
        setup.enableThaumcraft = this.config.getBoolean("Thaumcraft", "INTEGRATION", true, "Adds/Alters Aspects");
        setup.enableTropicraft = this.config.getBoolean("Tropicraft", "INTEGRATION", true, "Adds two recipes,\n Terraqueous:Coconut to 3xTropicraft:CoconutChunk\n Terraqueous:Pineapple to 3xTropicraft:PineappleCubes");
        setup.enableWAILA = this.config.getBoolean("WAILA", "INTEGRATION", true, "Adds color data to tooltips");
        if (this.config.hasKey("INTEGRATION", "CoFH")) {
            ConfigCategory category = this.config.getCategory("INTEGRATION");
            category.remove((Object)"CoFH");
            category.remove((Object)"IC2");
            category.remove((Object)"Mekanism");
        }
        if (this.config.hasChanged()) {
            this.config.save();
            settings.rebuildDustList = true;
        }
    }

    private void processRenderList(int style, String[] items) {
        for (String item : items) {
            if (Strings.isNullOrEmpty((String)item)) continue;
            String[] split = item.split("@");
            int damage = split.length > 1 ? Integer.getInteger(split[1]) : -1;
            Settings.INSTANCE.flowerpotOverrides.put((Object)split[0], (Object)damage, (Object)((byte)style));
        }
    }
}

