/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.misc;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.terraqueous.Values;

public class DeathFruitHelper {
    public static DeathFruitHelper INSTANCE = new DeathFruitHelper();
    public static IAttribute dfAddiction;
    public static IAttribute dfTimer;
    public static Potion countdown;
    public static Potion withdraw;
    private static ItemStack cacheStack;

    public void register() {
        dfAddiction = new RangedAttribute(null, "terraqueous.deathfruit.addiction", 0.0, 0.0, 200.0).func_111117_a("Death Fruit Addiction");
        dfTimer = new RangedAttribute(null, "terraqueous.deathfruit.timer", 0.0, 0.0, 180.0).func_111117_a("Death Fruit Timer");
        countdown = new PotionDeathFruit(0x3B1313).func_76390_b("potion.terraqueous.deathfruit.countdown");
        GameRegistry.register((IForgeRegistryEntry)countdown, (ResourceLocation)new ResourceLocation("terraqueous:deathfruit_countdown"));
        withdraw = new PotionDeathFruit(0x3B1313).func_76390_b("potion.terraqueous.deathfruit.withdraw");
        GameRegistry.register((IForgeRegistryEntry)withdraw, (ResourceLocation)new ResourceLocation("terraqueous:deathfruit_withdraw"));
    }

    public void onPlayerEat(EntityPlayer player) {
        if (player == null) {
            return;
        }
        ArrayList<PotionEffect> tobeRemoved = new ArrayList<PotionEffect>();
        for (PotionEffect effect : player.func_70651_bq()) {
            Potion potion = effect.func_188419_a();
            if (potion == countdown || potion == withdraw) {
                tobeRemoved.add(effect);
                continue;
            }
            if (effect.func_76459_b() > 300 || !potion.func_76398_f()) continue;
            tobeRemoved.add(effect);
        }
        player.func_70651_bq().removeAll(tobeRemoved);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        double value = this.getAddiction(player, 2);
        IAttributeInstance attTimer = player.func_110148_a(dfTimer);
        if (attTimer == null) {
            player.func_110140_aT().func_111150_b(dfTimer);
            attTimer = player.func_110148_a(dfTimer);
        }
        if (attTimer != null) {
            attTimer.func_111128_a(180.0);
        }
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:night_vision"), (int)(6000.0 * value), 0, false, false));
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:speed"), (int)(4800.0 * value), 1, false, false));
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:jump_boost"), (int)(4800.0 * value), 0, false, false));
        player.func_70690_d(new PotionEffect(Potion.func_180142_b((String)"minecraft:strength"), (int)(3600.0 * value), 2, false, false));
    }

    private double getAddiction(EntityPlayer player, int adjustment) {
        IAttributeInstance attAddiction = player.func_110148_a(dfAddiction);
        double value = 1.0;
        if (attAddiction != null) {
            double addiction = attAddiction.func_111126_e() + (double)adjustment;
            if (addiction < 0.0) {
                return 1.0;
            }
            attAddiction.func_111128_a(MathHelper.func_151237_a((double)addiction, (double)0.0, (double)200.0));
            value = 1.0 - addiction / 200.0;
        } else {
            player.func_110140_aT().func_111150_b(dfAddiction);
        }
        return value;
    }

    public void onPlayerUpdate(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        int ticks = player.field_70173_aa;
        if (ticks % 100 != 0) {
            return;
        }
        IAttributeInstance attTimer = player.func_110148_a(dfTimer);
        if (attTimer == null || attTimer.func_111126_e() < 1.0) {
            this.getAddiction(player, -1);
            return;
        }
        double remaining = attTimer.func_111126_e();
        attTimer.func_111128_a(Math.max(remaining - 1.0, 0.0));
        if (remaining > 120.0) {
            return;
        }
        Random random = player.field_70170_p.field_73012_v;
        double value = this.getAddiction(player, 1);
        if (remaining > 60.0 && remaining <= 120.0) {
            if (player.func_70660_b(countdown) == null) {
                player.func_70690_d(new PotionEffect(countdown, (int)((remaining - 60.0) * 100.0), 0, false, false));
            }
            this.addPotion(player, this.getPotion(random, false), (int)(100.0 / value), value < 0.75 ? random.nextInt(2) : 0);
        }
        if (remaining > 0.0 && remaining <= 60.0) {
            if (player.func_70660_b(withdraw) == null) {
                player.func_70690_d(new PotionEffect(withdraw, (int)(remaining * 100.0), 0, false, false));
            }
            Potion firstPotion = this.getPotion(random, false);
            this.addPotion(player, firstPotion, (int)(100.0 / value), random.nextInt(value < 0.75 ? 3 : 2));
            Potion secondPotion = firstPotion;
            while (secondPotion == firstPotion) {
                secondPotion = this.getPotion(random, true);
            }
            this.addPotion(player, secondPotion, (int)(100.0 / value), value < 0.75 ? random.nextInt(2) : 0);
        }
    }

    private void addPotion(EntityPlayer player, Potion potion, int time, int severity) {
        if (potion != null) {
            player.func_70690_d(new PotionEffect(potion, time, severity, false, false));
        }
    }

    private Potion getPotion(Random random, boolean withdraw) {
        switch (random.nextInt(withdraw ? 7 : 5)) {
            case 0: {
                return Potion.func_180142_b((String)"minecraft:hunger");
            }
            case 1: {
                return Potion.func_180142_b((String)"minecraft:slowness");
            }
            case 2: {
                return Potion.func_180142_b((String)"minecraft:weakness");
            }
            case 3: {
                return Potion.func_180142_b((String)"minecraft:mining_fatigue");
            }
            case 4: {
                return Potion.func_180142_b((String)"minecraft:blindness");
            }
            case 5: {
                return Potion.func_180142_b((String)"minecraft:wither");
            }
            case 6: {
                return Potion.func_180142_b((String)"minecraft:nausea");
            }
        }
        return null;
    }

    public static class PotionDeathFruit
    extends Potion {
        public PotionDeathFruit(int potionColor) {
            super(false, potionColor);
        }

        public boolean func_76397_a(int remaining, int var) {
            return true;
        }

        public void func_76394_a(EntityLivingBase entity, int var) {
            if (entity.field_70170_p.field_72995_K || !(entity instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)entity;
            IAttributeInstance attTimer = player.func_110148_a(dfTimer);
            if (attTimer == null) {
                int timer = player.func_70660_b((Potion)this).func_76459_b() / 100 + (this == countdown ? 60 : 0);
                player.func_110140_aT().func_111150_b(dfTimer);
                attTimer = player.func_110148_a(dfTimer);
                attTimer.func_111128_a((double)timer);
                INSTANCE.getAddiction(player, 0);
                INSTANCE.getAddiction(player, this == countdown ? 25 : 50);
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
            if (cacheStack == null) {
                cacheStack = Values.stacks.get("deathfruit", new int[0]);
            }
            mc.func_175599_af().func_175042_a(cacheStack, x + 8, y + 8);
        }
    }
}

